/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.exceptions.BranchAlreadyExistsException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBranchCommand
extends Command<String> {
    public static final Logger logger = LoggerFactory.getLogger(CreateBranchCommand.class);
    private static String BRANCH_EXISTS_ERROR = "An error occurred: The item %s already exists.";
    private final String workingFolder;
    private final boolean recursive;
    private final String comment;
    private final String author;
    private final String existingItem;
    private final String newBranchedItem;

    public CreateBranchCommand(ServerContext context, String workingFolder, boolean recursive, String comment, String author, String existingItem, String newBranchedItem) {
        super("branch", context);
        ArgumentHelper.checkNotEmptyString((String)workingFolder, (String)"workingFolder");
        ArgumentHelper.checkNotEmptyString((String)existingItem, (String)"existingItem");
        ArgumentHelper.checkNotEmptyString((String)newBranchedItem, (String)"newBranchedItem");
        this.workingFolder = workingFolder;
        this.recursive = recursive;
        this.comment = comment;
        this.author = author;
        this.existingItem = existingItem;
        this.newBranchedItem = newBranchedItem;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().setWorkingDirectory(this.workingFolder).addSwitch("checkin");
        if (this.recursive) {
            builder.addSwitch("recursive");
        }
        if (StringUtils.isNotEmpty((String)this.comment)) {
            builder.addSwitch("comment", this.comment);
        }
        if (StringUtils.isNotEmpty((String)this.author)) {
            builder.addSwitch("author", this.author);
        }
        builder.add(this.existingItem);
        builder.add(this.newBranchedItem);
        return builder;
    }

    @Override
    public String parseOutput(String stdout, String stderr) {
        this.throwIfError(stderr);
        return this.getChangesetNumber(stdout);
    }

    @Override
    protected void throwIfError(String stderr) {
        if (StringUtils.isNotEmpty((String)stderr)) {
            String[] errors;
            for (String line : errors = this.getLines(stderr)) {
                if (!StringUtils.equalsIgnoreCase((String)String.format(BRANCH_EXISTS_ERROR, this.newBranchedItem), (String)line)) continue;
                throw new BranchAlreadyExistsException(this.newBranchedItem);
            }
        }
        super.throwIfError(stderr);
    }
}

