/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import org.apache.commons.lang.StringUtils;

public class DeleteWorkspaceCommand
extends Command<String> {
    private final String workspaceName;

    public DeleteWorkspaceCommand(ServerContext context, String workspaceName) {
        super("workspace", context);
        ArgumentHelper.checkNotEmptyString((String)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().addSwitch("delete").add(this.workspaceName);
        return builder;
    }

    @Override
    public String parseOutput(String stdout, String stderr) {
        if (StringUtils.containsIgnoreCase((String)stderr, (String)"could not be found")) {
            return "";
        }
        super.throwIfError(stderr);
        return "";
    }

    @Override
    public int interpretReturnCode(int returnCode) {
        if (returnCode == 100) {
            return 0;
        }
        return returnCode;
    }
}

