/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.exceptions.ToolParseFailureException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class DownloadCommand
extends Command<String> {
    private static final String FILE_NOT_FOUND_ERROR = "The specified file does not exist at the specified version";
    private final String localPath;
    private final int version;
    private final String destination;
    private final boolean ignoreFileNotFound;

    public DownloadCommand(ServerContext context, String localPath, int version, String destination, boolean ignoreFileNotFound) {
        super("print", context);
        ArgumentHelper.checkNotEmptyString((String)localPath, (String)"localPath");
        ArgumentHelper.checkNotEmptyString((String)destination, (String)"destination");
        this.localPath = localPath;
        this.version = version;
        this.destination = destination;
        this.ignoreFileNotFound = ignoreFileNotFound;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().add(this.localPath);
        if (this.version > 0) {
            builder.addSwitch("version", Integer.toString(this.version));
        }
        return builder;
    }

    @Override
    public String parseOutput(String stdout, String stderr) {
        StringBuilder fileContents = new StringBuilder();
        if (this.ignoreFileNotFound && StringUtils.containsIgnoreCase((String)stderr, (String)FILE_NOT_FOUND_ERROR)) {
            fileContents.append("");
        } else {
            super.throwIfError(stderr);
            for (String line : this.getLines(stdout, true)) {
                fileContents.append(line);
                fileContents.append(System.lineSeparator());
            }
        }
        File file = new File(this.destination);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileUtils.writeStringToFile((File)file, (String)fileContents.toString());
        }
        catch (IOException e) {
            throw new ToolParseFailureException(e);
        }
        return this.destination;
    }
}

