/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.exceptions.ToolAuthenticationException;
import com.microsoft.alm.plugin.external.models.Workspace;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindWorkspaceCommand
extends Command<Workspace> {
    protected static final Logger logger = LoggerFactory.getLogger(FindWorkspaceCommand.class);
    protected static final String AUTH_ERROR_SERVER = "An error occurred: Access denied connecting to TFS server";
    protected static final String AUTH_ERROR_FEDERATED = "Federated authentication to this server requires a username and password.";
    private final String localPath;
    private final String collection;
    private final String workspace;
    private final AuthenticationInfo authInfo;

    public FindWorkspaceCommand(String localPath) {
        super("workfold", null);
        ArgumentHelper.checkNotEmptyString((String)localPath, (String)"localPath");
        this.localPath = localPath;
        this.collection = "";
        this.workspace = "";
        this.authInfo = null;
    }

    public FindWorkspaceCommand(String collection, String workspace, AuthenticationInfo authInfo) {
        super("workfold", null);
        ArgumentHelper.checkNotEmptyString((String)collection, (String)"collection");
        ArgumentHelper.checkNotEmptyString((String)workspace, (String)"workspace");
        this.collection = collection;
        this.workspace = workspace;
        this.authInfo = authInfo;
        this.localPath = "";
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder();
        if (StringUtils.isNotEmpty((String)this.localPath)) {
            builder.setWorkingDirectory(this.localPath);
            builder.addSwitch("login", "username,pw", true);
        } else if (StringUtils.isNotEmpty((String)this.collection) && StringUtils.isNotEmpty((String)this.workspace)) {
            builder.addSwitch("collection", this.collection);
            builder.addSwitch("workspace", this.workspace);
        }
        if (this.authInfo != null) {
            builder.addAuthInfo(this.authInfo);
        }
        return builder;
    }

    @Override
    public Workspace parseOutput(String stdout, String stderr) {
        this.throwIfError(stderr);
        String[] lines = this.getLines(stdout);
        for (int x = 0; x < lines.length; ++x) {
            if (lines.length <= x + 2 || !lines[x].contains("==========")) continue;
            String workspaceName = this.getValue(lines[x + 1]);
            String collectionURL = this.getValue(lines[x + 2]);
            ArrayList<Workspace.Mapping> mappings = new ArrayList<Workspace.Mapping>(10);
            for (int i = x + 3; i < lines.length; ++i) {
                Workspace.Mapping mapping = this.getMapping(lines[i]);
                if (mapping == null) continue;
                mappings.add(mapping);
            }
            return new Workspace(collectionURL, workspaceName, "", "", "", mappings);
        }
        return null;
    }

    private String getValue(String line) {
        int index = line.indexOf(": ");
        return line.substring(index + 2).trim();
    }

    @Override
    protected void throwIfError(String stderr) {
        if (StringUtils.startsWith((String)stderr, (String)AUTH_ERROR_SERVER) || StringUtils.contains((String)stderr, (String)AUTH_ERROR_FEDERATED)) {
            logger.warn("Authentication exception hit when running 'tf workfold'");
            throw new ToolAuthenticationException();
        }
        super.throwIfError(stderr);
    }
}

