/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.external.utils.WorkspaceHelper;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class GetWorkspaceCommand
extends Command<Workspace> {
    private final String workspaceName;

    public GetWorkspaceCommand(ServerContext context, String workspaceName) {
        super("workspaces", context);
        ArgumentHelper.checkNotEmptyString((String)workspaceName, (String)"workspaceName");
        this.workspaceName = workspaceName;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().add(this.workspaceName).addSwitch("format", "xml");
        return builder;
    }

    @Override
    public Workspace parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        NodeList workspaceNodeList = super.evaluateXPath(stdout, "/workspaces/workspace");
        if (workspaceNodeList != null && workspaceNodeList.getLength() == 1) {
            NamedNodeMap workspaceAttributes = workspaceNodeList.item(0).getAttributes();
            NodeList mappingsNodeList = super.evaluateXPath(stdout, "/workspaces/workspace/working-folder");
            ArrayList<Workspace.Mapping> mappings = new ArrayList<Workspace.Mapping>(mappingsNodeList.getLength());
            for (int i = 0; i < mappingsNodeList.getLength(); ++i) {
                NamedNodeMap mappingAttributes = mappingsNodeList.item(i).getAttributes();
                String localPath = this.getXPathAttributeValue(mappingAttributes, "local-item");
                String depth = this.getXPathAttributeValue(mappingAttributes, "depth");
                boolean isCloaked = !StringUtils.equals((String)this.getXPathAttributeValue(mappingAttributes, "type"), (String)"map");
                String serverPath = this.getXPathAttributeValue(mappingAttributes, "server-item");
                if (!StringUtils.equals((String)depth, (String)"full")) {
                    serverPath = WorkspaceHelper.getOneLevelServerPath(serverPath);
                }
                mappings.add(new Workspace.Mapping(serverPath, localPath, isCloaked));
            }
            String owner = this.getXPathAttributeValue(workspaceAttributes, "owner-display-name");
            if (StringUtils.isEmpty((String)owner)) {
                owner = this.getXPathAttributeValue(workspaceAttributes, "owner");
            }
            Workspace workspace = new Workspace(this.getXPathAttributeValue(workspaceAttributes, "server"), this.getXPathAttributeValue(workspaceAttributes, "name"), this.getXPathAttributeValue(workspaceAttributes, "computer"), owner, this.getXPathAttributeValue(workspaceAttributes, "comment"), mappings);
            return workspace;
        }
        return null;
    }
}

