/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.ChangeSet;
import com.microsoft.alm.plugin.external.models.CheckedInChange;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HistoryCommand
extends Command<List<ChangeSet>> {
    private final String itemPath;
    private final String version;
    private final String user;
    private final int stopAfter;
    private final boolean recursive;
    private final boolean itemMode;

    public HistoryCommand(ServerContext context, String itemPath, String version, int stopAfter, boolean recursive, String user) {
        this(context, itemPath, version, stopAfter, recursive, user, false);
    }

    public HistoryCommand(ServerContext context, String itemPath, String version, int stopAfter, boolean recursive, String user, boolean itemMode) {
        super("history", context);
        ArgumentHelper.checkNotEmptyString((String)itemPath, (String)"itemPath");
        this.itemPath = itemPath;
        this.version = version;
        this.user = user;
        this.stopAfter = stopAfter;
        this.recursive = recursive;
        this.itemMode = itemMode;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().addSwitch("format", "xml");
        if (this.recursive) {
            builder.addSwitch("recursive");
        }
        if (this.stopAfter > 0) {
            builder.addSwitch("stopafter", Integer.toString(this.stopAfter));
        }
        if (StringUtils.isNotEmpty((String)this.user)) {
            builder.addSwitch("user", this.user);
        }
        if (StringUtils.isNotEmpty((String)this.version)) {
            builder.addSwitch("version", this.version);
        }
        if (this.itemMode) {
            builder.addSwitch("itemmode");
        }
        builder.add(this.itemPath);
        return builder;
    }

    @Override
    public List<ChangeSet> parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>(100);
        NodeList nodes = super.evaluateXPath(stdout, "/history/changeset");
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element changeset = (Element)nodes.item(i);
                NodeList commentNodes = changeset.getElementsByTagName("comment");
                String comment = commentNodes.getLength() == 1 ? commentNodes.item(0).getTextContent() : "";
                ArrayList<CheckedInChange> changes = new ArrayList<CheckedInChange>(100);
                NodeList childNodes = changeset.getElementsByTagName("item");
                NamedNodeMap changesetAttributes = changeset.getAttributes();
                String id = changesetAttributes.getNamedItem("id").getNodeValue();
                String date = changesetAttributes.getNamedItem("date").getNodeValue();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node child = childNodes.item(j);
                    NamedNodeMap attributes = child.getAttributes();
                    CheckedInChange newchange = new CheckedInChange(attributes.getNamedItem("server-item").getNodeValue(), attributes.getNamedItem("change-type").getNodeValue(), id, date);
                    changes.add(newchange);
                }
                changeSets.add(new ChangeSet(id, changesetAttributes.getNamedItem("owner").getNodeValue(), changesetAttributes.getNamedItem("committer").getNodeValue(), date, comment, changes));
            }
        }
        return changeSets;
    }
}

