/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class InfoCommand
extends Command<List<ItemInfo>> {
    private final List<String> itemPaths;
    private final String workingFolder;

    public InfoCommand(ServerContext context, List<String> itemPaths) {
        this(context, null, itemPaths);
    }

    public InfoCommand(ServerContext context, String workingFolder, List<String> itemPaths) {
        super("info", context);
        ArgumentHelper.checkNotNullOrEmpty(itemPaths, (String)"itemPaths");
        this.itemPaths = itemPaths;
        this.workingFolder = workingFolder;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().setWorkingDirectory(this.workingFolder);
        for (String file : this.itemPaths) {
            builder.add(file);
        }
        return builder;
    }

    @Override
    public List<ItemInfo> parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        ArrayList<ItemInfo> itemInfos = new ArrayList<ItemInfo>(this.itemPaths.size());
        HashMap<String, String> propertyMap = new HashMap<String, String>(15);
        String[] output = this.getLines(stdout);
        String prefix = "";
        for (String line : output) {
            int colonPos;
            if (StringUtils.startsWithIgnoreCase((String)line, (String)"local information:")) {
                prefix = "";
                if (!propertyMap.isEmpty()) {
                    itemInfos.add(this.getItemInfo(propertyMap));
                }
                propertyMap.clear();
                continue;
            }
            if (StringUtils.startsWithIgnoreCase((String)line, (String)"server information:")) {
                prefix = "server ";
                continue;
            }
            if (!StringUtils.isNotBlank((String)line) || (colonPos = line.indexOf(":")) <= 0) continue;
            String key = prefix + line.substring(0, colonPos).trim().toLowerCase();
            String value = colonPos + 1 < line.length() ? line.substring(colonPos + 1).trim() : "";
            propertyMap.put(key, value);
        }
        if (!propertyMap.isEmpty()) {
            itemInfos.add(this.getItemInfo(propertyMap));
        }
        return itemInfos;
    }

    private ItemInfo getItemInfo(Map<String, String> propertyMap) {
        return new ItemInfo(propertyMap.get("server path"), propertyMap.get("local path"), propertyMap.get("server changeset"), propertyMap.get("changeset"), propertyMap.get("change"), propertyMap.get("type"), propertyMap.get("server lock"), propertyMap.get("server lock owner"), propertyMap.get("server deletion id"), propertyMap.get("server last modified"), propertyMap.get("server file type"), propertyMap.get("server size"));
    }
}

