/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.Conflict;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ResolveConflictsCommand
extends Command<List<Conflict>> {
    private static final String RESOLVED_PREFIX = "Resolved ";
    private static final String RESOLVED_POST_MSG = " as ";
    private final List<String> filesToResolve;
    private final AutoResolveType resolveType;

    public ResolveConflictsCommand(ServerContext context, List<String> filesToResolve, AutoResolveType resolveType) {
        super("resolve", context);
        ArgumentHelper.checkNotNull(filesToResolve, (String)"filesToResolve");
        ArgumentHelper.checkNotNull((Object)((Object)resolveType), (String)"resolveType");
        this.filesToResolve = filesToResolve;
        this.resolveType = resolveType;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder();
        for (String file : this.filesToResolve) {
            builder.add(file);
        }
        builder.addSwitch("auto", this.resolveType.name());
        return builder;
    }

    @Override
    public List<Conflict> parseOutput(String stdout, String stderr) {
        String[] lines;
        this.throwIfError(stderr);
        ArrayList<Conflict> resolved = new ArrayList<Conflict>();
        for (String line : lines = this.getLines(stdout)) {
            int index;
            if (!StringUtils.startsWith((String)line, (String)RESOLVED_PREFIX) || (index = (line = StringUtils.removeStart((String)line, (String)RESOLVED_PREFIX)).indexOf(RESOLVED_POST_MSG)) == -1) continue;
            resolved.add(new Conflict(line.substring(0, index), Conflict.ConflictType.RESOLVED));
        }
        return resolved;
    }

    public static enum AutoResolveType {
        AutoMerge,
        TakeTheirs,
        KeepYours,
        OverwriteLocal,
        DeleteConflict,
        KeepYoursRenameTheirs;

    }
}

