/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoCommand
extends Command<List<String>> {
    public static final Logger logger = LoggerFactory.getLogger(UndoCommand.class);
    private static final String UNDO_LINE_PREFIX = "Undoing edit:";
    private final List<String> files;

    public UndoCommand(ServerContext context, List<String> files) {
        super("undo", context);
        ArgumentHelper.checkNotNullOrEmpty(files, (String)"files");
        this.files = files;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder();
        for (String file : this.files) {
            builder.add(file);
        }
        return builder;
    }

    @Override
    public List<String> parseOutput(String stdout, String stderr) {
        String[] output = this.getLines(stdout);
        if (StringUtils.isNotEmpty((String)stderr)) {
            logger.error("Undo failed with the following stderr: " + stderr);
            for (int i = 0; i < output.length; ++i) {
                if (!this.isOutputLineExpected(output[i], new String[]{UNDO_LINE_PREFIX}, true)) continue;
                throw new RuntimeException(output[i]);
            }
            logger.error("Parsing of the stdout failed to get the error message");
            throw new TeamServicesException(TeamServicesException.KEY_ERROR_UNKNOWN);
        }
        ArrayList<String> filesUndone = new ArrayList<String>();
        String path = "";
        for (int i = 0; i < output.length; ++i) {
            if (this.isFilePath(output[i])) {
                path = output[i];
                continue;
            }
            if (!StringUtils.isNotEmpty((String)output[i])) continue;
            filesUndone.add(this.getFilePath(path, output[i], ""));
        }
        return filesUndone;
    }
}

