/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.commands;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.ToolRunner;
import com.microsoft.alm.plugin.external.commands.Command;
import com.microsoft.alm.plugin.external.models.Workspace;
import org.apache.commons.lang.StringUtils;

public class UpdateWorkspaceCommand
extends Command<String> {
    private final String currentWorkspaceName;
    private final String newName;
    private final String newComment;
    private final Workspace.FileTime newFileTime;
    private final Workspace.Permission newPermission;

    public UpdateWorkspaceCommand(ServerContext context, String currentWorkspaceName, String newName, String newComment, Workspace.FileTime newFileTime, Workspace.Permission newPermission) {
        super("workspace", context);
        ArgumentHelper.checkNotEmptyString((String)currentWorkspaceName, (String)"currentWorkspaceName");
        this.currentWorkspaceName = currentWorkspaceName;
        this.newName = newName;
        this.newComment = newComment;
        this.newFileTime = newFileTime;
        this.newPermission = newPermission;
    }

    @Override
    public ToolRunner.ArgumentBuilder getArgumentBuilder() {
        ToolRunner.ArgumentBuilder builder = super.getArgumentBuilder().add(this.currentWorkspaceName);
        if (StringUtils.isNotEmpty((String)this.newName)) {
            builder.addSwitch("newname", this.newName);
        }
        if (StringUtils.isNotEmpty((String)this.newComment)) {
            builder.addSwitch("comment", this.newComment);
        }
        if (this.newFileTime != null) {
            builder.addSwitch("filetime", this.newFileTime.toString());
        }
        if (this.newPermission != null) {
            builder.addSwitch("permission", this.newPermission.toString());
        }
        return builder;
    }

    @Override
    public String parseOutput(String stdout, String stderr) {
        super.throwIfError(stderr);
        return "";
    }
}

