/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.models;

import org.apache.commons.lang.StringUtils;

public class ToolVersion {
    public static final ToolVersion UNKNOWN = new ToolVersion("");
    private final int major;
    private final int minor;
    private final int revision;
    private final String build;

    public ToolVersion(String versionString) {
        String[] parts = StringUtils.split((String)versionString, (char)'.');
        this.major = this.getIntegerPart(parts, 0, 0);
        this.minor = this.getIntegerPart(parts, 1, 0);
        this.revision = this.getIntegerPart(parts, 2, 0);
        this.build = parts.length > 3 ? parts[3] : "";
    }

    public ToolVersion(int major, int minor, int revision, String build) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.build = build;
    }

    public int compare(ToolVersion other) {
        if (this.getMajor() == other.getMajor()) {
            if (this.getMinor() == other.getMinor()) {
                if (this.getRevision() == other.getRevision()) {
                    return 0;
                }
                return this.getRevision() - other.getRevision();
            }
            return this.getMinor() - other.getMinor();
        }
        return this.getMajor() - other.getMajor();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getBuild() {
        return this.build;
    }

    public String toString() {
        String version = String.format("%d.%d.%d", this.getMajor(), this.getMinor(), this.getRevision());
        if (StringUtils.isNotEmpty((String)this.getBuild())) {
            return version + "." + this.getBuild();
        }
        return version;
    }

    private int getIntegerPart(String[] parts, int index, int defaultValue) {
        if (parts == null || index >= parts.length) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(parts[index]);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }
}

