/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jersey.repackaged.com.google.common.base.Objects;
import org.apache.commons.lang.StringUtils;

public class Workspace {
    private final String name;
    private final String computer;
    private final String owner;
    private final String comment;
    private final String server;
    private final List<Mapping> mappings;
    private final Location location;

    public Workspace(String server, String name, String computer, String owner, String comment, List<Mapping> mappings) {
        this(server, name, computer, owner, comment, mappings, Location.LOCAL);
    }

    public Workspace(String server, String name, String computer, String owner, String comment, List<Mapping> mappings, Location location) {
        this.server = server;
        this.name = name;
        this.computer = computer;
        this.owner = owner;
        this.comment = comment;
        this.mappings = new ArrayList<Mapping>(mappings);
        this.location = location;
    }

    public String getServer() {
        return this.server;
    }

    public String getName() {
        return this.name;
    }

    public String getComputer() {
        return this.computer;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getComment() {
        return this.comment;
    }

    public List<Mapping> getMappings() {
        return Collections.unmodifiableList(this.mappings);
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Workspace)) {
            return false;
        }
        Workspace workspace = (Workspace)object;
        if (!StringUtils.equals((String)this.name, (String)workspace.getName())) {
            return false;
        }
        if (!StringUtils.equals((String)this.computer, (String)workspace.getComputer())) {
            return false;
        }
        if (!StringUtils.equals((String)this.owner, (String)workspace.getOwner())) {
            return false;
        }
        return StringUtils.equals((String)this.server, (String)workspace.getServer());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.computer, this.owner, this.server});
    }

    public static enum Location {
        LOCAL,
        SERVER,
        UNKNOWN;


        public static Location fromString(String location) {
            if (StringUtils.equalsIgnoreCase((String)location, (String)LOCAL.name())) {
                return LOCAL;
            }
            if (StringUtils.equalsIgnoreCase((String)location, (String)SERVER.name())) {
                return SERVER;
            }
            return UNKNOWN;
        }
    }

    public static class Mapping {
        private final String serverPath;
        private final String localPath;
        private final boolean cloaked;

        public Mapping(String serverPath, String localPath, boolean isCloaked) {
            this.serverPath = serverPath;
            this.localPath = localPath;
            this.cloaked = isCloaked;
        }

        public String getLocalPath() {
            return this.localPath;
        }

        public String getServerPath() {
            return this.serverPath;
        }

        public boolean isCloaked() {
            return this.cloaked;
        }
    }

    public static enum Permission {
        PRIVATE,
        PUBLIC_LIMITED,
        PUBLIC;


        public String toString() {
            if (this == PRIVATE) {
                return "Private";
            }
            if (this == PUBLIC) {
                return "Public";
            }
            return "PublicLimited";
        }
    }

    public static enum FileTime {
        CURRENT,
        CHECKIN;


        public String toString() {
            if (this == CHECKIN) {
                return "checkin";
            }
            return "current";
        }
    }
}

