/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.external.utils;

import com.intellij.openapi.project.Project;
import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.common.utils.SystemHelper;
import com.microsoft.alm.helpers.Path;
import com.microsoft.alm.plugin.authentication.AuthenticationInfo;
import com.microsoft.alm.plugin.context.ServerContext;
import com.microsoft.alm.plugin.external.commands.AddCommand;
import com.microsoft.alm.plugin.external.commands.CheckinCommand;
import com.microsoft.alm.plugin.external.commands.CreateBranchCommand;
import com.microsoft.alm.plugin.external.commands.CreateLabelCommand;
import com.microsoft.alm.plugin.external.commands.DeleteCommand;
import com.microsoft.alm.plugin.external.commands.DeleteWorkspaceCommand;
import com.microsoft.alm.plugin.external.commands.FindConflictsCommand;
import com.microsoft.alm.plugin.external.commands.FindWorkspaceCommand;
import com.microsoft.alm.plugin.external.commands.GetAllWorkspacesCommand;
import com.microsoft.alm.plugin.external.commands.GetBaseVersionCommand;
import com.microsoft.alm.plugin.external.commands.GetBranchesCommand;
import com.microsoft.alm.plugin.external.commands.GetDetailedWorkspaceCommand;
import com.microsoft.alm.plugin.external.commands.GetLabelsCommand;
import com.microsoft.alm.plugin.external.commands.GetLocalPathCommand;
import com.microsoft.alm.plugin.external.commands.GetWorkspaceCommand;
import com.microsoft.alm.plugin.external.commands.HistoryCommand;
import com.microsoft.alm.plugin.external.commands.InfoCommand;
import com.microsoft.alm.plugin.external.commands.LockCommand;
import com.microsoft.alm.plugin.external.commands.MergeCommand;
import com.microsoft.alm.plugin.external.commands.RenameCommand;
import com.microsoft.alm.plugin.external.commands.ResolveConflictsCommand;
import com.microsoft.alm.plugin.external.commands.StatusCommand;
import com.microsoft.alm.plugin.external.commands.SyncCommand;
import com.microsoft.alm.plugin.external.commands.UndoCommand;
import com.microsoft.alm.plugin.external.commands.UpdateWorkspaceCommand;
import com.microsoft.alm.plugin.external.commands.UpdateWorkspaceMappingCommand;
import com.microsoft.alm.plugin.external.models.ChangeSet;
import com.microsoft.alm.plugin.external.models.Conflict;
import com.microsoft.alm.plugin.external.models.ConflictResults;
import com.microsoft.alm.plugin.external.models.ItemInfo;
import com.microsoft.alm.plugin.external.models.MergeConflict;
import com.microsoft.alm.plugin.external.models.MergeMapping;
import com.microsoft.alm.plugin.external.models.MergeResults;
import com.microsoft.alm.plugin.external.models.PendingChange;
import com.microsoft.alm.plugin.external.models.RenameConflict;
import com.microsoft.alm.plugin.external.models.Server;
import com.microsoft.alm.plugin.external.models.ServerStatusType;
import com.microsoft.alm.plugin.external.models.SyncResults;
import com.microsoft.alm.plugin.external.models.TfvcLabel;
import com.microsoft.alm.plugin.external.models.VersionSpec;
import com.microsoft.alm.plugin.external.models.Workspace;
import com.microsoft.alm.plugin.external.utils.WorkspaceHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandUtils {
    protected static final Logger logger = LoggerFactory.getLogger(CommandUtils.class);

    public static String getWorkspaceName(Project project) {
        Workspace workspace = CommandUtils.getPartialWorkspace(project);
        if (workspace != null) {
            return workspace.getName();
        }
        return "";
    }

    public static Workspace getPartialWorkspace(Project project) {
        ArgumentHelper.checkNotNull((Object)project, (String)"project");
        FindWorkspaceCommand command = new FindWorkspaceCommand(project.getBasePath());
        return (Workspace)command.runSynchronously();
    }

    public static Workspace getPartialWorkspace(String collectionName, String workspaceName) {
        return CommandUtils.getPartialWorkspace(collectionName, workspaceName, null);
    }

    public static Workspace getPartialWorkspace(String collectionName, String workspaceName, AuthenticationInfo authInfo) {
        ArgumentHelper.checkNotNull((Object)collectionName, (String)"collectionName");
        ArgumentHelper.checkNotNull((Object)workspaceName, (String)"workspaceName");
        FindWorkspaceCommand command = new FindWorkspaceCommand(collectionName, workspaceName, authInfo);
        return (Workspace)command.runSynchronously();
    }

    public static Workspace getDetailedWorkspace(String collectionName, String workspaceName, AuthenticationInfo authInfo) {
        ArgumentHelper.checkNotNull((Object)workspaceName, (String)"workspaceName");
        ArgumentHelper.checkNotNull((Object)authInfo, (String)"authInfo");
        GetDetailedWorkspaceCommand command = new GetDetailedWorkspaceCommand(collectionName, workspaceName, authInfo);
        return (Workspace)command.runSynchronously();
    }

    public static Workspace getWorkspace(ServerContext context, Project project) {
        String workspaceName = CommandUtils.getWorkspaceName(project);
        return CommandUtils.getWorkspace(context, workspaceName);
    }

    public static Workspace getWorkspace(ServerContext context, String workspaceName) {
        GetWorkspaceCommand command = new GetWorkspaceCommand(context, workspaceName);
        return (Workspace)command.runSynchronously();
    }

    public static List<Server> getAllWorkspaces(ServerContext context) {
        GetAllWorkspacesCommand command = new GetAllWorkspacesCommand(context);
        return (List)command.runSynchronously();
    }

    public static void refreshWorkspacesForServer(AuthenticationInfo authInfo, String serverUrl) {
        GetAllWorkspacesCommand command = new GetAllWorkspacesCommand(authInfo, serverUrl);
        command.runSynchronously();
    }

    public static void deleteWorkspace(ServerContext context, String workspaceName) {
        DeleteWorkspaceCommand command = new DeleteWorkspaceCommand(context, workspaceName);
        command.runSynchronously();
    }

    public static String getLocalPathSynchronously(ServerContext context, String serverPath, String workspace) {
        GetLocalPathCommand getLocalPathCommand = new GetLocalPathCommand(context, serverPath, workspace);
        return (String)getLocalPathCommand.runSynchronously();
    }

    public static String tryGetLocalPath(ServerContext context, String serverPath, String workspace) {
        GetLocalPathCommand getLocalPathCommand = new GetLocalPathCommand(context, serverPath, workspace);
        try {
            String result = (String)getLocalPathCommand.runSynchronously();
            if (StringUtils.startsWithIgnoreCase((String)result, (String)"ERROR [main] Application - Unexpected exception:")) {
                return null;
            }
            return result;
        }
        catch (Throwable t) {
            logger.warn("Failed to find local path for server path " + serverPath, t);
            return null;
        }
    }

    public static List<ChangeSet> getHistoryCommand(ServerContext context, String itemPath, String version, int stopAfter, boolean recursive, String user) {
        return CommandUtils.getHistoryCommand(context, itemPath, version, stopAfter, recursive, user, false);
    }

    public static List<ChangeSet> getHistoryCommand(ServerContext context, String itemPath, String version, int stopAfter, boolean recursive, String user, boolean itemMode) {
        HistoryCommand historyCommand = new HistoryCommand(context, itemPath, version, stopAfter, recursive, user, itemMode);
        return (List)historyCommand.runSynchronously();
    }

    public static ChangeSet getLastHistoryEntryForAnyUser(ServerContext context, String localPath) {
        List<ChangeSet> results = CommandUtils.getHistoryCommand(context, localPath, null, 1, false, "");
        return results.isEmpty() ? null : results.get(0);
    }

    public static String addWorkspaceMapping(ServerContext serverContext, String workspaceName, String serverPath, String localPath) {
        UpdateWorkspaceMappingCommand updateMappingCommand = new UpdateWorkspaceMappingCommand(serverContext, workspaceName, new Workspace.Mapping(serverPath, localPath, false), false);
        return (String)updateMappingCommand.runSynchronously();
    }

    public static String updateWorkspace(ServerContext context, Workspace oldWorkspace, Workspace newWorkspace) {
        if (WorkspaceHelper.areMappingsDifferent(oldWorkspace, newWorkspace)) {
            UpdateWorkspaceMappingCommand command;
            for (Workspace.Mapping m : WorkspaceHelper.getMappingsToRemove(oldWorkspace, newWorkspace)) {
                command = new UpdateWorkspaceMappingCommand(context, oldWorkspace.getName(), m, true);
                command.runSynchronously();
            }
            for (Workspace.Mapping m : WorkspaceHelper.getMappingsToChange(oldWorkspace, newWorkspace)) {
                command = new UpdateWorkspaceMappingCommand(context, oldWorkspace.getName(), m, false);
                command.runSynchronously();
            }
        }
        UpdateWorkspaceCommand updateWorkspaceCommand = new UpdateWorkspaceCommand(context, oldWorkspace.getName(), newWorkspace.getName(), newWorkspace.getComment(), null, null);
        return (String)updateWorkspaceCommand.runSynchronously();
    }

    public static SyncResults syncWorkspace(ServerContext context, String rootPath) {
        return CommandUtils.syncWorkspace(context, Collections.singletonList(rootPath), true, true);
    }

    public static SyncResults syncWorkspace(ServerContext context, List<String> filesUpdatePaths, boolean needRecursion, boolean shouldThrowBadExitCode) {
        SyncCommand command = new SyncCommand(context, filesUpdatePaths, needRecursion, shouldThrowBadExitCode);
        return (SyncResults)command.runSynchronously();
    }

    public static void forceGetFile(ServerContext context, String filePath) {
        SyncCommand command = new SyncCommand(context, Collections.singletonList(filePath), false, false, true);
        command.runSynchronously();
    }

    public static List<String> undoLocalFiles(ServerContext context, List<String> files) {
        UndoCommand command = new UndoCommand(context, files);
        return (List)command.runSynchronously();
    }

    public static PendingChange getStatusForFile(ServerContext context, String file) {
        StatusCommand command = new StatusCommand(context, file);
        List results = (List)command.runSynchronously();
        return results.isEmpty() ? null : (PendingChange)results.get(0);
    }

    public static List<PendingChange> getStatusForFiles(ServerContext context, List<String> files) {
        StatusCommand command = new StatusCommand(context, files);
        return (List)command.runSynchronously();
    }

    public static void renameFile(ServerContext context, String oldName, String newName) {
        RenameCommand command = new RenameCommand(context, oldName, newName);
        command.runSynchronously();
    }

    public static List<Conflict> resolveConflictsByPath(ServerContext context, List<String> conflicts, ResolveConflictsCommand.AutoResolveType type) {
        ResolveConflictsCommand conflictsCommand = new ResolveConflictsCommand(context, conflicts, type);
        return (List)conflictsCommand.runSynchronously();
    }

    public static List<Conflict> resolveConflictsByConflict(ServerContext context, List<Conflict> conflicts, ResolveConflictsCommand.AutoResolveType type) {
        ArrayList<String> conflictFiles = new ArrayList<String>();
        for (Conflict conflict : conflicts) {
            conflictFiles.add(conflict.getLocalPath());
        }
        return CommandUtils.resolveConflictsByPath(context, conflictFiles, type);
    }

    public static List<Conflict> getConflicts(ServerContext context, String root, MergeResults mergeResults) {
        FindConflictsCommand conflictsCommand = new FindConflictsCommand(context, root);
        ConflictResults conflictResults = (ConflictResults)conflictsCommand.runSynchronously();
        ArrayList<Conflict> conflicts = new ArrayList<Conflict>(conflictResults.getConflicts().size());
        for (Conflict conflict : conflictResults.getConflicts()) {
            Conflict newConflict = null;
            if (conflict.getType() == Conflict.ConflictType.CONTENT || conflict.getType() == Conflict.ConflictType.DELETE || conflict.getType() == Conflict.ConflictType.DELETE_TARGET) {
                newConflict = conflict;
            } else if (conflict.getType() == Conflict.ConflictType.RENAME || conflict.getType() == Conflict.ConflictType.NAME_AND_CONTENT) {
                newConflict = CommandUtils.findLocalRename(context, conflict.getLocalPath(), root, Conflict.ConflictType.RENAME);
                if (newConflict == null) {
                    newConflict = CommandUtils.findMergeConflict(context, conflict, mergeResults, root);
                }
            } else if (conflict.getType() == Conflict.ConflictType.MERGE) {
                newConflict = CommandUtils.findMergeConflict(context, conflict, mergeResults, root);
            } else {
                logger.warn("Unable to determine conflict type from: " + (Object)((Object)conflict.getType()));
            }
            if (newConflict != null) {
                conflicts.add(newConflict);
                continue;
            }
            logger.warn("Unable to convert Merge conflict in getConflicts");
        }
        return conflicts;
    }

    private static MergeConflict findMergeConflict(ServerContext context, Conflict originalConflict, MergeResults mergeResults, String workingFolder) {
        ItemInfo conflictInfo = CommandUtils.getItemInfo(context, workingFolder, originalConflict.getLocalPath());
        if (mergeResults == null || conflictInfo == null) {
            return null;
        }
        MergeMapping conflictMapping = null;
        String localPath = originalConflict.getLocalPath();
        if (StringUtils.isEmpty((String)conflictInfo.getServerItem())) {
            for (MergeMapping mapping : mergeResults.getMappings()) {
                Conflict mappingConflict;
                String mappingLocalPath;
                FindConflictsCommand conflictsCommand;
                ConflictResults conflictResults;
                if (!mapping.getChangeTypes().contains((Object)ServerStatusType.RENAME) || (conflictResults = (ConflictResults)(conflictsCommand = new FindConflictsCommand(context, workingFolder, mapping.getToServerItem())).runSynchronously()).getConflicts().size() != 1 || !StringUtils.equalsIgnoreCase((String)(mappingLocalPath = Path.combine((String)workingFolder, (String)(mappingConflict = conflictResults.getConflicts().get(0)).getLocalPath())), (String)originalConflict.getLocalPath())) continue;
                ItemInfo info = CommandUtils.getItemInfo(context, workingFolder, mapping.getToServerItem());
                localPath = info.getLocalItem();
                conflictMapping = mapping;
                break;
            }
        } else {
            String serverPath = conflictInfo.getServerItem();
            for (MergeMapping mapping : mergeResults.getMappings()) {
                if (!StringUtils.equalsIgnoreCase((String)mapping.getToServerItem(), (String)serverPath)) continue;
                conflictMapping = mapping;
                break;
            }
        }
        if (conflictMapping != null) {
            return new MergeConflict(localPath, conflictMapping);
        }
        return null;
    }

    private static RenameConflict findLocalRename(ServerContext context, String serverName, String root, Conflict.ConflictType type) {
        RenameConflict conflict = CommandUtils.searchChangeSetForRename(context, serverName, root, type, 50);
        return conflict != null ? conflict : CommandUtils.searchChangeSetForRename(context, serverName, root, type, -1);
    }

    private static RenameConflict searchChangeSetForRename(ServerContext context, String serverName, String root, Conflict.ConflictType type, int stopAfter) {
        List<ChangeSet> changeSets = CommandUtils.getHistoryCommand(context, serverName, "", stopAfter, false, "", true);
        for (int index = 0; index < changeSets.size(); ++index) {
            ChangeSet changeSet = changeSets.get(index);
            if (!CommandUtils.doesChangeSetHaveChanges(changeSets, index) || !changeSet.getChanges().get(0).getChangeTypes().contains((Object)ServerStatusType.RENAME) || !CommandUtils.doesChangeSetHaveChanges(changeSets, index + 1)) continue;
            String oldName = changeSets.get(index + 1).getChanges().get(0).getServerItem();
            StatusCommand command = new StatusCommand(context, root);
            List results = (List)command.runSynchronously();
            for (PendingChange change : results) {
                if (!SystemHelper.areFilePathsSame((String)change.getSourceItem(), (String)oldName)) continue;
                return new RenameConflict(change.getLocalItem(), serverName, oldName, type);
            }
        }
        return null;
    }

    private static boolean doesChangeSetHaveChanges(List<ChangeSet> changeSets, int index) {
        return changeSets != null && index < changeSets.size() && changeSets.get(index).getChanges() != null && !changeSets.get(index).getChanges().isEmpty();
    }

    public static List<String> addFiles(ServerContext context, List<String> filesToAddPaths) {
        AddCommand addCommand = new AddCommand(context, filesToAddPaths);
        return (List)addCommand.runSynchronously();
    }

    public static String checkinFiles(ServerContext context, List<String> files, String preparedComment, List<Integer> workItemsToAssociate) {
        CheckinCommand checkinCommand = new CheckinCommand(context, files, preparedComment, workItemsToAssociate);
        return (String)checkinCommand.runSynchronously();
    }

    public static ItemInfo getItemInfo(ServerContext context, String itemPath) {
        return CommandUtils.getItemInfo(context, null, itemPath);
    }

    public static ItemInfo getItemInfo(ServerContext context, String workingFolder, String itemPath) {
        InfoCommand infoCommand = new InfoCommand(context, workingFolder, Collections.singletonList(itemPath));
        List items = (List)infoCommand.runSynchronously();
        if (items != null && items.size() > 0) {
            return (ItemInfo)items.get(0);
        }
        throw new RuntimeException("No items match " + itemPath);
    }

    public static List<ItemInfo> getItemInfos(ServerContext context, String workingFolder, List<String> itemPaths) {
        InfoCommand infoCommand = new InfoCommand(context, workingFolder, itemPaths);
        return (List)infoCommand.runSynchronously();
    }

    public static String createBranch(ServerContext context, String workingFolder, boolean recursive, String comment, String author, String existingItem, String newBranchedItem) {
        CreateBranchCommand createBranchCommand = new CreateBranchCommand(context, workingFolder, recursive, comment, author, existingItem, newBranchedItem);
        return (String)createBranchCommand.runSynchronously();
    }

    public static MergeResults merge(ServerContext context, String workingFolder, String source, String destination, VersionSpec versionSpec, boolean recursive) {
        MergeCommand mergeCommand = new MergeCommand(context, workingFolder, source, destination, versionSpec, recursive);
        return (MergeResults)mergeCommand.runSynchronously();
    }

    public static List<String> getBranches(ServerContext context, String workingFolder, String sourceItem) {
        GetBranchesCommand getBranchesCommand = new GetBranchesCommand(context, workingFolder, sourceItem);
        return (List)getBranchesCommand.runSynchronously();
    }

    public static VersionSpec getBaseVersion(ServerContext context, String workingFolder, String source, String destination) {
        GetBaseVersionCommand getBaseVersionCommand = new GetBaseVersionCommand(context, workingFolder, source, destination);
        return (VersionSpec)getBaseVersionCommand.runSynchronously();
    }

    public static boolean createLabel(ServerContext context, String workingFolder, String name, String comment, boolean recursive, List<String> itemSpecs) {
        CreateLabelCommand createLabelCommand = new CreateLabelCommand(context, workingFolder, name, comment, recursive, itemSpecs);
        String result = (String)createLabelCommand.runSynchronously();
        return StringUtils.equalsIgnoreCase((String)result, (String)"CREATED");
    }

    public static List<TfvcLabel> getLabels(ServerContext context, String workingFolder, String nameFilter) {
        GetLabelsCommand getLabelsCommand = new GetLabelsCommand(context, workingFolder, nameFilter);
        return (List)getLabelsCommand.runSynchronously();
    }

    public static List<String> deleteFiles(ServerContext context, List<String> filePaths, String workingFolder, boolean recursive) {
        DeleteCommand deleteCommand = new DeleteCommand(context, filePaths, workingFolder, recursive);
        return (List)deleteCommand.runSynchronously();
    }

    public static void lock(ServerContext context, String workingFolder, LockCommand.LockLevel lockLevel, boolean recursive, List<String> itemSpecs) {
        LockCommand lockCommand = new LockCommand(context, workingFolder, lockLevel, recursive, itemSpecs);
        lockCommand.runSynchronously();
    }
}

