/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.operations;

import com.microsoft.alm.plugin.exceptions.TeamServicesException;
import com.microsoft.alm.plugin.operations.Operation;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationExecutor {
    private static final Logger logger = LoggerFactory.getLogger(OperationExecutor.class);
    final int THREAD_RECOVERY_TIMEOUT_SECONDS = 5;
    final int MAX_THREADS = 5;
    final int CORE_THREADS = 5;
    final long TASK_TIMEOUT_SECONDS = 120L;
    final BlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(50);
    final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 5, 5L, TimeUnit.SECONDS, this.queue);

    public static OperationExecutor getInstance() {
        return Holder.INSTANCE;
    }

    public UUID executeAsync(Operation operation, Operation.Inputs inputs) {
        this.execute(operation, inputs);
        return operation.getId();
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    private synchronized void execute(final Operation operation, final Operation.Inputs inputs) {
        this.threadPoolExecutor.execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        operation.doWork(inputs);
                    }
                    catch (Throwable t) {
                        logger.warn("Operation failed", t);
                        if (operation.isFinished()) break block2;
                        operation.terminate(t);
                    }
                }
            }
        });
    }

    public Future submitOperationTask(Runnable task) {
        return this.threadPoolExecutor.submit(task);
    }

    public void wait(List<Future> futures) {
        Exception t = null;
        for (Future f : futures) {
            try {
                f.get(120L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                t = e;
                logger.warn("wait: InterruptedException", (Throwable)e);
            }
            catch (TimeoutException te) {
                t = te;
                logger.warn("wait: TimeoutException", (Throwable)te);
            }
            catch (ExecutionException ee) {
                logger.warn("wait: ExecutionException", (Throwable)ee);
                t = ee;
            }
        }
        if (t != null) {
            throw new TeamServicesException(TeamServicesException.KEY_OPERATION_ERRORS, t);
        }
    }

    private static class Holder {
        public static final OperationExecutor INSTANCE = new OperationExecutor();

        private Holder() {
        }
    }
}

