/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.plugin.versioncontrol.path;

import com.microsoft.alm.common.utils.ArgumentHelper;
import com.microsoft.alm.common.utils.FileHelper;
import com.microsoft.alm.plugin.exceptions.ServerPathFormatException;
import com.microsoft.alm.plugin.versioncontrol.path.LocalPath;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerPath {
    private static final Logger logger = LoggerFactory.getLogger(ServerPath.class);
    public static final String ROOT_NAME_ONLY = "$";
    public static final String ROOT = "$/";
    public static final char[] SEPARATOR_CHARACTERS = new char[]{'/', '\\'};
    public static final char PREFERRED_SEPARATOR_CHARACTER = '/';
    public static final int MAX_SERVER_PATH_SIZE = 399;
    public static final int MAXIMUM_COMPONENT_LENGTH = 256;

    public static final boolean isChild(String parentPath, String possibleChild) throws ServerPathFormatException {
        ArgumentHelper.checkNotNull((Object)parentPath, (String)"parentPath");
        ArgumentHelper.checkNotNull((Object)possibleChild, (String)"possibleChild");
        parentPath = ServerPath.canonicalize(parentPath);
        possibleChild = ServerPath.canonicalize(possibleChild);
        if (parentPath.regionMatches(true, 0, possibleChild, 0, parentPath.length())) {
            if (parentPath.length() == possibleChild.length()) {
                return true;
            }
            if (ServerPath.isSeparator(parentPath.charAt(parentPath.length() - 1))) {
                return true;
            }
            if (ServerPath.isSeparator(possibleChild.charAt(parentPath.length()))) {
                return true;
            }
        }
        return false;
    }

    public static final String canonicalize(String serverPath) throws ServerPathFormatException {
        ArgumentHelper.checkNotNull((Object)serverPath, (String)"serverPath");
        int serverPathLength = serverPath.length();
        if (serverPathLength == 0) {
            logger.warn("Server path is empty");
            throw new ServerPathFormatException(serverPath);
        }
        if (ServerPath.isCanonicalizedPath(serverPath, true)) {
            return serverPath;
        }
        ArrayList<String> newComponents = new ArrayList<String>();
        StringBuilder currentComponent = new StringBuilder(serverPathLength);
        int position = 0;
        if (serverPath.equals(ROOT_NAME_ONLY)) {
            serverPath = ROOT;
            serverPathLength = 2;
        }
        if (serverPath.charAt(0) == '$') {
            ++position;
        }
        newComponents.add(ROOT_NAME_ONLY);
        if (position >= serverPathLength || !ServerPath.isSeparator(serverPath.charAt(position))) {
            logger.warn("The server path is not absolute: " + serverPath);
            throw new ServerPathFormatException(serverPath);
        }
        boolean illegalDollarInPath = false;
        while (position <= serverPathLength) {
            if (position == serverPathLength || ServerPath.isSeparator(serverPath.charAt(position))) {
                if (currentComponent.length() != 0 && !currentComponent.toString().equals(".")) {
                    if (currentComponent.toString().equals("..")) {
                        if (newComponents.size() <= 1) {
                            logger.warn(String.format("Server path %s refers to invalid path outside %s", serverPath, ROOT));
                            throw new ServerPathFormatException(serverPath);
                        }
                        newComponents.remove(newComponents.size() - 1);
                    } else {
                        String cleaned = ServerPath.cleanupComponent(currentComponent).toString();
                        if (cleaned.length() != 0) {
                            if (cleaned.length() > 256) {
                                logger.warn(String.format("Server path component %s is longer than the maximum character length %s", cleaned, 256));
                                throw new ServerPathFormatException(cleaned);
                            }
                            if (FileHelper.isReservedName((String)cleaned)) {
                                logger.warn(String.format("Server path %s contains an invalid directory component: %s", serverPath, cleaned));
                                throw new ServerPathFormatException(cleaned);
                            }
                            if (cleaned.charAt(0) == '$') {
                                illegalDollarInPath = true;
                            }
                            newComponents.add(cleaned);
                        }
                    }
                }
                currentComponent.setLength(0);
            } else if (ServerPath.isValidPathCharacter(serverPath.charAt(position))) {
                currentComponent.append(serverPath.charAt(position));
            } else {
                char c = serverPath.charAt(position);
                char c_safe = c < ' ' ? (char)'?' : (char)c;
                logger.warn(String.format("The character (%s) is not permitted in server paths %s.", Character.valueOf(c_safe), serverPath.replace(c, c_safe)));
                throw new ServerPathFormatException(serverPath.replace(c, c_safe));
            }
            ++position;
        }
        if (newComponents.size() == 1) {
            return ROOT;
        }
        StringBuilder newPath = new StringBuilder();
        for (int i = 0; i < newComponents.size(); ++i) {
            if (i > 0) {
                newPath.append('/');
            }
            newPath.append((String)newComponents.get(i));
        }
        if (illegalDollarInPath) {
            logger.warn(String.format("TF10122: The path %s contains a $ at the beginning of a path component.", newPath.toString()));
            throw new ServerPathFormatException(newPath.toString());
        }
        return newPath.toString();
    }

    public static boolean isCanonicalizedPath(String serverItem, boolean allowSemicolon) {
        if (serverItem.length() > 399) {
            return false;
        }
        if (!serverItem.startsWith(ROOT)) {
            return false;
        }
        if (2 == serverItem.length()) {
            return true;
        }
        if (serverItem.length() > 2 && serverItem.charAt(serverItem.length() - 1) == '/') {
            return false;
        }
        int pathPartLength = 0;
        for (int i = 2; i < serverItem.length(); ++i) {
            char c = serverItem.charAt(i);
            if (c == '/') {
                if (!ServerPath.isCanonicalizedPathPart(serverItem, i, pathPartLength)) {
                    return false;
                }
                pathPartLength = 0;
                continue;
            }
            if (0 == pathPartLength && c == ROOT.charAt(0)) {
                return false;
            }
            if (!FileHelper.isValidNTFSFileNameCharacter((char)c)) {
                return false;
            }
            if (!allowSemicolon && c == ';') {
                return false;
            }
            if (c == '*' || c == '?') {
                return false;
            }
            ++pathPartLength;
        }
        return ServerPath.isCanonicalizedPathPart(serverItem, serverItem.length(), pathPartLength);
    }

    private static boolean isCanonicalizedPathPart(String serverItem, int i, int pathPartLength) {
        if (0 == pathPartLength) {
            return false;
        }
        if (2 == pathPartLength ? serverItem.charAt(i - 1) == '.' && serverItem.charAt(i - 2) == '.' : (3 == pathPartLength || 4 == pathPartLength ? FileHelper.isReservedName((String)serverItem.substring(i - pathPartLength, i)) : pathPartLength > 256)) {
            return false;
        }
        return serverItem.charAt(i - 1) != '.' && !Character.isWhitespace(serverItem.charAt(i - 1));
    }

    public static String makeRelative(String serverPath, String relativeTo) {
        ArgumentHelper.checkNotNull((Object)serverPath, (String)"serverPath");
        ArgumentHelper.checkNotNull((Object)relativeTo, (String)"relativeTo");
        if (serverPath.regionMatches(true, 0, relativeTo, 0, relativeTo.length())) {
            if (serverPath.length() == relativeTo.length()) {
                return "";
            }
            if (relativeTo.length() > 0 && ServerPath.isSeparator(relativeTo.charAt(relativeTo.length() - 1))) {
                return serverPath.substring(relativeTo.length());
            }
            if (ServerPath.isSeparator(serverPath.charAt(relativeTo.length()))) {
                return serverPath.substring(relativeTo.length() + 1);
            }
        }
        return serverPath;
    }

    public static String makeLocal(String serverPath, String relativeToServerPath, String localRoot) {
        ArgumentHelper.checkNotNull((Object)serverPath, (String)"serverPath");
        ArgumentHelper.checkNotNull((Object)relativeToServerPath, (String)"relativeToServerPath");
        ArgumentHelper.checkNotNull((Object)localRoot, (String)"localRoot");
        String relativePart = ServerPath.makeRelative(ServerPath.canonicalize(serverPath), relativeToServerPath);
        StringBuilder relativeBuffer = new StringBuilder(relativePart);
        for (int j = 0; j < SEPARATOR_CHARACTERS.length; ++j) {
            for (int k = 0; k < relativeBuffer.length(); ++k) {
                if (relativeBuffer.charAt(k) != SEPARATOR_CHARACTERS[j]) continue;
                relativeBuffer.setCharAt(k, File.separatorChar);
            }
        }
        return LocalPath.combine(localRoot, relativeBuffer.toString());
    }

    private static final StringBuilder cleanupComponent(StringBuilder s) {
        while (s.length() > 0 && (s.charAt(s.length() - 1) == '.' || Character.isWhitespace(s.charAt(s.length() - 1)))) {
            s.setLength(s.length() - 1);
        }
        return s;
    }

    public static final boolean isValidPathCharacter(char c) {
        char[] invalidCharacters = new char[]{'\"', '/', ':', '<', '>', '\\', '|'};
        if (c <= '\u001f') {
            return false;
        }
        for (int i = 0; i < invalidCharacters.length; ++i) {
            if (invalidCharacters[i] != c) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSeparator(char c) {
        for (int i = 0; i < SEPARATOR_CHARACTERS.length; ++i) {
            if (SEPARATOR_CHARACTERS[i] != c) continue;
            return true;
        }
        return false;
    }
}

