/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.config.ui;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FakeFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.plugins.watcher.BackgroundTaskBundle;
import com.intellij.plugins.watcher.config.BackgroundTaskConsumer;
import com.intellij.plugins.watcher.config.FileTypeBackgroundTaskConsumer;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.util.TaskUtils;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.tools.FilterInfo;
import com.intellij.ui.AbstractTitledSeparatorWithIcon;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewWatcherDialog
extends DialogWrapper {
    private static final String ADVANCED_OPTIONS_OPEN_KEY = "NewWatcherDialog.advanced.open";
    private static final String[] WINDOWS_EXTENSIONS = new String[]{".com", ".exe", ".bat", ".cmd"};
    private final Project myProject;
    private final boolean myDefaultProject;
    private JPanel myMainPanel;
    private JBTextField myNameField;
    private JComboBox<FileType> myFileTypesCombo;
    private ScopeChooserCombo myScopeCombo;
    private ComboBox<String> myScopeForDefaultProjectCombo;
    private JBLabel myNoSuchFilesInScopeErrorLabel;
    private JCheckBox myTrackOnlyRootFilesCheckBox;
    private TextFieldWithBrowseButton myProgramField;
    private JButton myProgramInsertMacroButton;
    private RawCommandLineEditor myArgumentsField;
    private JButton myArgumentsInsertMacroBtn;
    private JBTextField myOutputField;
    private JButton myOutputInsertMacroBtn;
    private AbstractTitledSeparatorWithIcon myWorkDirAndEnvSeparator;
    private JPanel myWorkDirAndEnvPanel;
    private TextFieldWithBrowseButton myWorkingDirField;
    private JButton myDirInsertMacroButton;
    private EnvironmentVariablesComponent myEnvComponent;
    private AbstractTitledSeparatorWithIcon myAdvancedOptionsSeparator;
    private JPanel myAdvancedOptionsPanel;
    private JCheckBox myImmediateFileSynchronizationCheckBox;
    private JCheckBox myRunOnExternalChangesCheckBox;
    private JCheckBox myTriggerWatcherRegardlessSyntaxErrorsCheckBox;
    private JCheckBox myOutputFromStdout;
    private JComboBox<TaskOptions.ExitCodeBehavior> myBehaviourComboBox;
    private ExpandableTextField myOutputFilterField;

    public NewWatcherDialog(@NotNull Project project, @NotNull TaskOptions options, String title) {
        String trackOnlyRootFilesTitle;
        if (project == null) {
            NewWatcherDialog.$$$reportNull$$$0(0);
        }
        if (options == null) {
            NewWatcherDialog.$$$reportNull$$$0(1);
        }
        super(true);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myDefaultProject = this.myProject.isDefault();
        this.setTitle(title);
        this.myProgramInsertMacroButton.addActionListener(new InsertMacroActionListener(this.myProgramField.getTextField()));
        this.myArgumentsInsertMacroBtn.addActionListener(new InsertMacroActionListener(this.myArgumentsField.getTextField()));
        this.myDirInsertMacroButton.addActionListener(new InsertMacroActionListener(this.myWorkingDirField.getTextField()));
        this.myOutputInsertMacroBtn.addActionListener(new InsertMacroActionListener((JTextField)this.myOutputField));
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, true, true, true, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                return super.isFileSelectable(file) || SystemInfo.isMac && file.isDirectory() && "app".equals(file.getExtension());
            }
        };
        this.myProgramField.addBrowseFolderListener(new TextBrowseFolderListener(fileChooserDescriptor, project){

            @NotNull
            protected String expandPath(@NotNull String path) {
                File ioFile;
                if (path == null) {
                    2.$$$reportNull$$$0(0);
                }
                String string = (ioFile = NewWatcherDialog.findProgramFile(NewWatcherDialog.this.myProgramField.getText().trim(), TaskUtils.getContext(NewWatcherDialog.this.myProject, null), NewWatcherDialog.this.myEnvComponent.getEnvData())) != null ? FileUtil.toSystemIndependentName((String)ioFile.getAbsolutePath()) : path;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/plugins/watcher/config/ui/NewWatcherDialog$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/plugins/watcher/config/ui/NewWatcherDialog$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expandPath";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "expandPath";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        JTextField programTextField = this.myProgramField.getTextField();
        if (programTextField instanceof JBTextField) {
            ((JBTextField)programTextField).getEmptyText().setText("[program path not set]", SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
        this.myWorkingDirField.addBrowseFolderListener(null, null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        for (TaskOptions.ExitCodeBehavior behavior : TaskOptions.ExitCodeBehavior.values()) {
            ((DefaultComboBoxModel)this.myBehaviourComboBox.getModel()).addElement(behavior);
        }
        this.myBehaviourComboBox.setRenderer((ListCellRenderer<TaskOptions.ExitCodeBehavior>)new ListCellRendererWrapper<TaskOptions.ExitCodeBehavior>(){

            public void customize(JList list, TaskOptions.ExitCodeBehavior value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getDisplayName());
            }
        });
        if (this.myDefaultProject) {
            this.myScopeCombo.setVisible(false);
        } else {
            this.myScopeForDefaultProjectCombo.setVisible(false);
            this.myScopeCombo.setShowEmptyScopes(true);
            this.myScopeCombo.setCurrentSelection(false);
            ((JComboBox)this.myScopeCombo.getChildComponent()).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    NewWatcherDialog.this.updateMatchedFilesInfo();
                }
            });
        }
        this.myEnvComponent.remove((Component)this.myEnvComponent.getLabel());
        this.myFileTypesCombo.setRenderer((ListCellRenderer<FileType>)new FileTypeRenderer());
        FileType[] fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes();
        Arrays.sort(fileTypes, Comparator.comparing(FileType::getName));
        ((DefaultComboBoxModel)this.myFileTypesCombo.getModel()).addElement(TaskUtils.FAKE_ANY_FILE_TYPE);
        for (FileType type : fileTypes) {
            if (type instanceof InternalFileType || type instanceof FakeFileType) continue;
            ((DefaultComboBoxModel)this.myFileTypesCombo.getModel()).addElement(type);
        }
        new ComboboxSpeedSearch(this.myFileTypesCombo){

            protected String getElementText(Object element) {
                return ((FileType)element).getName();
            }
        };
        FileTypeBackgroundTaskConsumer consumer = BackgroundTaskConsumer.findConsumerByFileType(options.getFileType());
        if (consumer != null && (trackOnlyRootFilesTitle = consumer.getTrackOnlyRootFilesLabel()) != null) {
            this.myTrackOnlyRootFilesCheckBox.setText(trackOnlyRootFilesTitle);
        }
        this.myFileTypesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileType fileType = (FileType)NewWatcherDialog.this.myFileTypesCombo.getSelectedItem();
                boolean enabled = fileType != null && TaskUtils.findDependencyFinderForExtension(fileType.getDefaultExtension()) != null;
                NewWatcherDialog.this.myTrackOnlyRootFilesCheckBox.setEnabled(enabled);
            }
        });
        this.myFileTypesCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NewWatcherDialog.this.updateMatchedFilesInfo();
            }
        });
        this.myProgramField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                NewWatcherDialog.this.updateProgramNotFoundErrorLabel();
            }
        });
        this.myNoSuchFilesInScopeErrorLabel.setIcon(AllIcons.General.BalloonWarning);
        this.myWorkDirAndEnvSeparator.off();
        this.myEnvComponent.addChangeListener(e -> this.updateProgramNotFoundErrorLabel());
        boolean on = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(ADVANCED_OPTIONS_OPEN_KEY, false);
        if (on) {
            this.myAdvancedOptionsSeparator.on();
        } else {
            this.myAdvancedOptionsSeparator.off();
        }
        this.myArgumentsField.setDialogCaption("Program Arguments");
        this.setTaskOptions(options);
        this.updateMatchedFilesInfo();
        this.updateProgramNotFoundErrorLabel();
        this.init();
    }

    private void updateMatchedFilesInfo() {
        FileType fileType = (FileType)this.myFileTypesCombo.getSelectedItem();
        if (fileType == UnknownFileType.INSTANCE) {
            this.myNoSuchFilesInScopeErrorLabel.setText(BackgroundTaskBundle.message("unknown.file.type", new Object[0]));
            this.myNoSuchFilesInScopeErrorLabel.setVisible(true);
            return;
        }
        if (this.myDefaultProject) {
            this.myNoSuchFilesInScopeErrorLabel.setVisible(false);
            return;
        }
        SearchScope selectedScope = this.myScopeCombo.getSelectedScope();
        if (selectedScope == null) {
            this.myNoSuchFilesInScopeErrorLabel.setText(BackgroundTaskBundle.message("unknown.scope", new Object[0]));
            this.myNoSuchFilesInScopeErrorLabel.setVisible(true);
            return;
        }
        if (fileType != null && fileType != TaskUtils.FAKE_ANY_FILE_TYPE && selectedScope instanceof GlobalSearchScope && !(selectedScope instanceof ScratchesSearchScope) && !FileTypeIndex.containsFileOfType((FileType)fileType, (GlobalSearchScope)((GlobalSearchScope)selectedScope))) {
            this.myNoSuchFilesInScopeErrorLabel.setText(BackgroundTaskBundle.message("no.such.files.in.scope", new Object[0]));
            this.myNoSuchFilesInScopeErrorLabel.setVisible(true);
            return;
        }
        this.myNoSuchFilesInScopeErrorLabel.setVisible(false);
    }

    private void updateProgramNotFoundErrorLabel() {
        String program = this.myProgramField.getText().trim();
        if (!(program.isEmpty() || this.myDefaultProject && MacroManager.containsMacros((String)program) || NewWatcherDialog.findProgramFile(program, TaskUtils.getContext(this.myProject, null), this.myEnvComponent.getEnvData()) != null)) {
            this.myProgramField.getTextField().setForeground((Color)JBColor.RED);
        } else {
            this.myProgramField.getTextField().setForeground(UIUtil.getLabelForeground());
        }
    }

    private void createUIComponents() {
        this.myOutputFilterField = new ExpandableTextField(text -> StringUtil.split((String)text, (String)"\n"), strings -> StringUtil.join((Collection)strings, (String)"\n"));
        this.myOutputFilterField.getDocument().putProperty("filterNewlines", Boolean.FALSE);
        this.myOutputFilterField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                NewWatcherDialog.this.myAdvancedOptionsPanel.revalidate();
            }
        });
        this.myWorkDirAndEnvSeparator = new AbstractTitledSeparatorWithIcon(AllIcons.General.SplitRight, AllIcons.General.SplitDown, "Working Directory and Environment Variables"){

            protected RefreshablePanel createPanel() {
                return new RefreshablePanel(){

                    public void refresh() {
                    }

                    public JPanel getPanel() {
                        return new JPanel();
                    }
                };
            }

            protected void initOnImpl() {
            }

            protected void onImpl() {
                NewWatcherDialog.this.myWorkDirAndEnvPanel.setVisible(true);
                NewWatcherDialog.this.myWorkDirAndEnvSeparator.setVisible(false);
            }

            protected void offImpl() {
                NewWatcherDialog.this.myWorkDirAndEnvPanel.setVisible(false);
            }
        };
        this.myAdvancedOptionsSeparator = new AbstractTitledSeparatorWithIcon(AllIcons.General.SplitRight, AllIcons.General.SplitDown, "Advanced Options"){

            protected RefreshablePanel createPanel() {
                return new RefreshablePanel(){

                    public void refresh() {
                    }

                    public JPanel getPanel() {
                        return new JPanel();
                    }
                };
            }

            protected void initOnImpl() {
            }

            protected void onImpl() {
                NewWatcherDialog.this.myAdvancedOptionsPanel.setVisible(true);
                PropertiesComponent.getInstance((Project)NewWatcherDialog.this.myProject).setValue(NewWatcherDialog.ADVANCED_OPTIONS_OPEN_KEY, true);
            }

            protected void offImpl() {
                NewWatcherDialog.this.myAdvancedOptionsPanel.setVisible(false);
                PropertiesComponent.getInstance((Project)NewWatcherDialog.this.myProject).setValue(NewWatcherDialog.ADVANCED_OPTIONS_OPEN_KEY, false);
            }
        };
    }

    @Nullable
    public static File findProgramFile(@NotNull String program, @Nullable DataContext dataContext, @NotNull EnvironmentVariablesData envData) {
        String path;
        if (program == null) {
            NewWatcherDialog.$$$reportNull$$$0(2);
        }
        if (envData == null) {
            NewWatcherDialog.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)program)) {
            return null;
        }
        if ((program = NewWatcherDialog.expandMacrosIfNeeded(program, dataContext)) == null) {
            return null;
        }
        if (FileUtil.isAbsolutePlatformIndependent((String)program)) {
            File file = new File(program);
            boolean exists = file.exists();
            if (exists && file.isDirectory() && SystemInfo.isMac && program.endsWith(".app")) {
                return file;
            }
            if (!(!SystemInfo.isWindows || exists && NewWatcherDialog.hasWindowsExecutableExtension(file.getName()))) {
                for (String ext : WINDOWS_EXTENSIONS) {
                    File file1 = new File(program + ext);
                    if (!file1.exists() || file1.isDirectory()) continue;
                    return file1;
                }
            }
            return exists ? file : null;
        }
        String customPath = (String)envData.getEnvs().get("PATH");
        String string = path = StringUtil.isEmpty((String)customPath) ? EnvironmentUtil.getValue((String)"PATH") : NewWatcherDialog.expandMacrosIfNeeded(customPath, dataContext);
        if (path == null) {
            return null;
        }
        File file = PathEnvironmentVariableUtil.findInPath((String)program, (String)path, null);
        if (SystemInfo.isWindows && (file == null || !NewWatcherDialog.hasWindowsExecutableExtension(file.getName()))) {
            for (String ext : WINDOWS_EXTENSIONS) {
                File file1 = PathEnvironmentVariableUtil.findInPath((String)(program + ext), (String)path, null);
                if (file1 == null || file1.isDirectory()) continue;
                return file1;
            }
        }
        return file;
    }

    private static boolean hasWindowsExecutableExtension(@NotNull String _fileName) {
        if (_fileName == null) {
            NewWatcherDialog.$$$reportNull$$$0(4);
        }
        String fileName = _fileName.toLowerCase(Locale.US);
        for (String ext : WINDOWS_EXTENSIONS) {
            if (!fileName.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String expandMacrosIfNeeded(@NotNull String str, @Nullable DataContext dataContext) {
        if (str == null) {
            NewWatcherDialog.$$$reportNull$$$0(5);
        }
        if (!MacroManager.containsMacros((String)str)) {
            return str;
        }
        MacroManager macroManager = MacroManager.getInstance();
        try {
            return macroManager.expandSilentMacros(str, true, dataContext);
        }
        catch (Macro.ExecutionCancelledException e) {
            return null;
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "EditFileWatcherDialog";
    }

    public TaskOptions getTaskOptions() {
        TaskOptions options = new TaskOptions();
        options.setName(this.myNameField.getText().trim());
        FileType fileType = (FileType)this.myFileTypesCombo.getSelectedItem();
        String defaultExtension = fileType.getDefaultExtension();
        options.setFileExtension(StringUtil.isEmpty((String)defaultExtension) ? fileType.getName() : defaultExtension);
        if (this.myDefaultProject) {
            Object scope = this.myScopeForDefaultProjectCombo.getSelectedItem();
            options.setScopeName(scope == null ? "" : scope.toString());
        } else {
            options.setScopeName(this.myScopeCombo.getSelectedScopeName());
        }
        options.setProgram(this.myProgramField.getText().trim());
        options.setArguments(this.myArgumentsField.getText().trim());
        options.setWorkingDir(this.myWorkingDirField.getText().trim());
        options.setOutput(this.myOutputField.getText().trim());
        options.setTrackOnlyRoot(this.myTrackOnlyRootFilesCheckBox.isSelected());
        options.setImmediateSync(this.myImmediateFileSynchronizationCheckBox.isSelected());
        options.setRunOnExternalChanges(this.myRunOnExternalChangesCheckBox.isSelected());
        options.setCheckSyntaxErrors(!this.myTriggerWatcherRegardlessSyntaxErrorsCheckBox.isSelected());
        options.setOutputFromStdout(this.myOutputFromStdout.isSelected());
        options.setEnvData(this.myEnvComponent.getEnvData());
        String filtersText = this.myOutputFilterField.getText().trim();
        FilterInfo[] filters = filtersText.isEmpty() ? new FilterInfo[]{} : (FilterInfo[])Arrays.stream(StringUtil.splitByLines((String)filtersText)).map(s -> new FilterInfo(s, "", "")).toArray(FilterInfo[]::new);
        options.setOutputFilters(filters);
        options.setExitCodeBehavior((TaskOptions.ExitCodeBehavior)((Object)this.myBehaviourComboBox.getSelectedItem()));
        return options;
    }

    private void setTaskOptions(@NotNull TaskOptions options) {
        if (options == null) {
            NewWatcherDialog.$$$reportNull$$$0(6);
        }
        this.myNameField.setText(StringUtil.notNullize((String)options.getName()));
        this.myFileTypesCombo.setSelectedItem(options.getFileType());
        final String scopeName = options.getScopeName();
        if (this.myDefaultProject) {
            String[] items = new String[]{PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]), PsiBundle.message((String)"psi.search.scope.production.files", (Object[])new Object[0]), PsiBundle.message((String)"psi.search.scope.test.files", (Object[])new Object[0])};
            this.myScopeForDefaultProjectCombo.setModel(new DefaultComboBoxModel<String>(items));
            if (!ArrayUtil.contains((String)scopeName, (String[])items)) {
                this.myScopeForDefaultProjectCombo.insertItemAt((Object)scopeName, 0);
            }
            this.myScopeForDefaultProjectCombo.setSelectedItem((Object)scopeName);
        } else {
            this.myScopeCombo.init(this.myProject, scopeName);
            if (!StringUtil.isEmpty((String)scopeName) && !scopeName.equals(this.myScopeCombo.getSelectedScopeName())) {
                this.myScopeCombo.getComboBox().insertItemAt(new ScopeDescriptor(null){

                    public String getDisplay() {
                        return scopeName;
                    }

                    public Icon getDisplayIcon() {
                        return AllIcons.General.BalloonWarning;
                    }
                }, 0);
                this.myScopeCombo.getComboBox().setSelectedIndex(0);
            }
        }
        this.myProgramField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)options.getProgram())));
        this.myArgumentsField.setText(options.getArguments());
        this.myWorkingDirField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)options.getWorkingDir())));
        this.myOutputField.setText(options.getOutput());
        this.myTrackOnlyRootFilesCheckBox.setSelected(options.isTrackOnlyRoot());
        this.myTriggerWatcherRegardlessSyntaxErrorsCheckBox.setSelected(!options.isCheckSyntaxErrors());
        this.myImmediateFileSynchronizationCheckBox.setSelected(options.isImmediateSync());
        this.myRunOnExternalChangesCheckBox.setSelected(options.isRunOnExternalChanges());
        this.myOutputFromStdout.setSelected(options.isOutputFromStdout());
        this.myEnvComponent.setEnvData(options.getEnvData());
        this.myOutputFilterField.setText(Arrays.stream(options.getOutputFilters()).map(f -> f.getRegExp()).collect(Collectors.joining("\n")));
        this.myBehaviourComboBox.setSelectedItem((Object)options.getExitCodeBehavior());
    }

    @Nullable
    protected String getHelpId() {
        return "settings.project.settings.file.watchers.new.watcher";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "program";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/watcher/config/ui/NewWatcherDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findProgramFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasWindowsExecutableExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "expandMacrosIfNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setTaskOptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        EnvironmentVariablesComponent environmentVariablesComponent;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JButton jButton2;
        JPanel jPanel;
        JButton jButton3;
        JBTextField jBTextField;
        JButton jButton4;
        RawCommandLineEditor rawCommandLineEditor;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel2;
        ComboBox comboBox;
        ScopeChooserCombo scopeChooserCombo;
        JCheckBox jCheckBox5;
        JBLabel jBLabel;
        JBTextField jBTextField2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(5, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jBTextField2 = new JBTextField();
        jPanel3.add((Component)jBTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, new Dimension(250, -1), null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Files to Watch", (int)0, (int)0, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("File type:");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(5);
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Scope:");
        jLabel3.setDisplayedMnemonic('S');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myNoSuchFilesInScopeErrorLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("no.such.files.in.scope"));
        jPanel4.add((Component)jBLabel, new GridConstraints(1, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myFileTypesCombo = jComboBox;
        jPanel5.add(jComboBox, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myTrackOnlyRootFilesCheckBox = jCheckBox5 = new JCheckBox();
        ((Component)jCheckBox5).setEnabled(false);
        jCheckBox5.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("settings.track.only.root.files"));
        jPanel4.add((Component)jCheckBox5, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myScopeCombo = scopeChooserCombo = new ScopeChooserCombo();
        jPanel6.add((Component)scopeChooserCombo, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 3, null, null, null));
        this.myScopeForDefaultProjectCombo = comboBox = new ComboBox();
        jPanel6.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myAdvancedOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Output filters:");
        jPanel2.add((Component)jLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myTriggerWatcherRegardlessSyntaxErrorsCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("check.syntax.errors"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null, 2));
        this.myOutputFromStdout = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Create output file from stdout");
        jPanel2.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null, 2));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Show console: ");
        jPanel2.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        JComboBox jComboBox2 = new JComboBox();
        this.myBehaviourComboBox = jComboBox2;
        jPanel2.add(jComboBox2, new GridConstraints(4, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myImmediateFileSynchronizationCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("immediate.synchronization"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null, 2));
        ExpandableTextField expandableTextField = this.myOutputFilterField;
        jPanel2.add((Component)expandableTextField, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(6, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setForeground(new Color(-8882056));
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("output.filters.regexp.hint"));
        jPanel7.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, new Dimension(0, -1), null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(5, 2, 1, 1, 0, 0, 0, 1, null, null, null));
        this.myRunOnExternalChangesCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("run.on.external.changes"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null, 2));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel8, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Tool to Run on Changes", (int)0, (int)0, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Program:");
        jLabel6.setDisplayedMnemonic('P');
        jLabel6.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myProgramField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Arguments:");
        jLabel7.setDisplayedMnemonic('A');
        jLabel7.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myArgumentsField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel8.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myArgumentsInsertMacroBtn = jButton4 = new JButton();
        this.$$$loadButtonText$$$(jButton4, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("settings.insert.macro"));
        jPanel8.add((Component)jButton4, new GridConstraints(1, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Output paths to refresh:");
        jLabel8.setDisplayedMnemonic('O');
        jLabel8.setDisplayedMnemonicIndex(0);
        jLabel8.setToolTipText("Files where the program stores its output. Used by the IDE to detect generated files. ");
        jPanel8.add((Component)jLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myOutputField = jBTextField = new JBTextField();
        jPanel8.add((Component)jBTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 7, 0, null, null, null));
        this.myOutputInsertMacroBtn = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("settings.insert.macro"));
        jPanel8.add((Component)jButton3, new GridConstraints(2, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        AbstractTitledSeparatorWithIcon abstractTitledSeparatorWithIcon = this.myWorkDirAndEnvSeparator;
        jPanel8.add((Component)abstractTitledSeparatorWithIcon, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null, 2));
        this.myWorkDirAndEnvPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        this.myDirInsertMacroButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("settings.insert.macro"));
        jPanel.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myWorkingDirField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Working directory:");
        jLabel9.setDisplayedMnemonic('W');
        jLabel9.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Environment variables:");
        jLabel10.setDisplayedMnemonic('E');
        jLabel10.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel10, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myEnvComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("East");
        environmentVariablesComponent.setText("");
        jPanel.add((Component)environmentVariablesComponent, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myProgramInsertMacroButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/plugins/watcher/BackgroundTaskBundle").getString("settings.insert.macro"));
        jPanel8.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 1, null, null, null));
        AbstractTitledSeparatorWithIcon abstractTitledSeparatorWithIcon2 = this.myAdvancedOptionsSeparator;
        jPanel3.add((Component)abstractTitledSeparatorWithIcon2, new GridConstraints(3, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        jLabel.setLabelFor((Component)jBTextField2);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor((Component)scopeChooserCombo);
        jLabel4.setLabelFor((Component)environmentVariablesComponent);
        jLabel6.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel7.setLabelFor((Component)rawCommandLineEditor);
        jLabel8.setLabelFor((Component)jBTextField);
        jLabel9.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel10.setLabelFor((Component)environmentVariablesComponent);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class InsertMacroActionListener
    implements ActionListener {
        private final JTextField myTextField;

        public InsertMacroActionListener(JTextField textField) {
            this.myTextField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MacrosDialog dialog = new MacrosDialog(NewWatcherDialog.this.myDefaultProject ? null : NewWatcherDialog.this.myProject);
            if (dialog.showAndGet() && dialog.getSelectedMacro() != null) {
                String macro = dialog.getSelectedMacro().getName();
                int position = this.myTextField.getCaretPosition();
                try {
                    this.myTextField.getDocument().insertString(position, "$" + macro + "$", null);
                    this.myTextField.setCaretPosition(position + macro.length() + 2);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            IdeFocusManager.findInstance().requestFocus((Component)this.myTextField, true);
        }
    }
}

