/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.plugins.watcher.config.FileDependencyFinder;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskUtils {
    private static final FileAttribute CREATED_BY_ATTRIBUTE = new FileAttribute("file.watcher", 1, false);
    public static final FileType FAKE_ANY_FILE_TYPE = new FileType(){

        @NotNull
        public String getName() {
            if ("Any" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "Any";
        }

        @NotNull
        public String getDescription() {
            String string = this.getName();
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getDefaultExtension() {
            if ("*" == null) {
                1.$$$reportNull$$$0(2);
            }
            return "*";
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.FileTypes.Any_type;
            if (icon == null) {
                1.$$$reportNull$$$0(3);
            }
            return icon;
        }

        public boolean isBinary() {
            return false;
        }

        public boolean isReadOnly() {
            return true;
        }

        @Nullable
        public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
            if (file == null) {
                1.$$$reportNull$$$0(4);
            }
            if (content == null) {
                1.$$$reportNull$$$0(5);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/plugins/watcher/util/TaskUtils$1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultExtension";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/plugins/watcher/util/TaskUtils$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCharset";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    public static boolean isGenerated(@Nullable VirtualFile file) {
        return !StringUtil.isEmpty((String)TaskUtils.extractCreatedTaskName(file));
    }

    @Nullable
    public static String extractCreatedTaskName(@Nullable VirtualFile file) {
        Pair<String, String> taskInfo = TaskUtils.extractTaskInfo(file);
        return taskInfo != null ? (String)taskInfo.getFirst() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Pair<String, String> extractTaskInfo(@Nullable VirtualFile file) {
        Pair pair;
        block7: {
            if (!(file instanceof NewVirtualFile) || !file.isValid()) {
                return null;
            }
            DataInputStream inputStream = CREATED_BY_ATTRIBUTE.readAttribute(file);
            try {
                String watcherName = inputStream != null ? inputStream.readUTF() : null;
                String originalFileName = inputStream != null ? inputStream.readUTF() : null;
                Pair pair2 = pair = StringUtil.isEmpty((String)watcherName) ? null : Pair.create((Object)watcherName, (Object)originalFileName);
                if (inputStream == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            inputStream.close();
        }
        return pair;
    }

    public static void saveOutputFileInfo(@NotNull VirtualFile outputFile, @Nullable String watcherName, @NotNull VirtualFile sourceFile) {
        if (outputFile == null) {
            TaskUtils.$$$reportNull$$$0(0);
        }
        if (sourceFile == null) {
            TaskUtils.$$$reportNull$$$0(1);
        }
        if (!(outputFile instanceof NewVirtualFile)) {
            return;
        }
        if (sourceFile.equals(outputFile)) {
            return;
        }
        boolean sameParent = sourceFile.getParent() != null && sourceFile.getParent().equals(outputFile.getParent());
        String sourceFileName = sameParent ? sourceFile.getName() : null;
        try (DataOutputStream outputStream = CREATED_BY_ATTRIBUTE.writeAttribute(outputFile);){
            outputStream.writeUTF(StringUtil.notNullize((String)watcherName));
            outputStream.writeUTF(StringUtil.notNullize((String)sourceFileName));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public static DataContext getContext(final @NotNull Project project, final @Nullable VirtualFile file) {
        DataContext parentContext;
        if (project == null) {
            TaskUtils.$$$reportNull$$$0(2);
        }
        THashMap dataId2data = new THashMap();
        dataId2data.put(CommonDataKeys.PROJECT.getName(), project);
        dataId2data.put(PlatformDataKeys.PROJECT_FILE_DIRECTORY.getName(), project.getBaseDir());
        if (file != null) {
            dataId2data.put(CommonDataKeys.VIRTUAL_FILE.getName(), file);
            parentContext = new DataContext(){

                @Nullable
                public Object getData(@NonNls String dataId) {
                    if (dataId.equals(LangDataKeys.MODULE.getName())) {
                        return ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
                    }
                    return null;
                }
            };
        } else {
            parentContext = null;
        }
        DataContext dataContext = SimpleDataContext.getSimpleContext((Map)dataId2data, parentContext);
        if (dataContext == null) {
            TaskUtils.$$$reportNull$$$0(3);
        }
        return dataContext;
    }

    public static String getPathByRelativePath(String basePath, String relativePath, String separator) {
        LinkedList<String> path = new LinkedList<String>(Arrays.asList(basePath.split(separator)));
        for (String step : relativePath.split(separator)) {
            if ("..".equals(step)) {
                if (path.isEmpty()) {
                    return null;
                }
                path.removeLast();
                continue;
            }
            path.add(step);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < path.size(); ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(path.get(i));
        }
        return result.toString();
    }

    public static String getPresentableNames(List<TaskOptions> tasks) {
        return Arrays.toString(ContainerUtil.map(tasks, TaskOptions::getName).toArray());
    }

    @NotNull
    public static List<VirtualFile> findRoots(VirtualFile file, @NotNull Project project, TaskOptions option) {
        if (project == null) {
            TaskUtils.$$$reportNull$$$0(4);
        }
        ArrayList result = new ArrayList();
        GlobalSearchScope scope = option.getFileScope(project);
        String extension = file.getExtension();
        boolean trackOnlyRoots = option.isTrackOnlyRoot();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                TaskUtils.$$$reportNull$$$0(11);
            }
            for (FileDependencyFinder dependencyFinder : (FileDependencyFinder[])FileDependencyFinder.EP_NAME.getExtensions()) {
                if (!dependencyFinder.accept(extension) || !trackOnlyRoots && !dependencyFinder.trackAllDependentFiles()) continue;
                List<VirtualFile> files = TaskUtils.findDependentFiles(project, file, dependencyFinder, scope, trackOnlyRoots);
                result.addAll(files);
            }
        });
        List<Object> list = result.isEmpty() ? Collections.singletonList(file) : result;
        if (list == null) {
            TaskUtils.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public static FileDependencyFinder findDependencyFinderForExtension(@Nullable String extension) {
        for (FileDependencyFinder dependencyFinder : (FileDependencyFinder[])FileDependencyFinder.EP_NAME.getExtensions()) {
            if (!dependencyFinder.accept(extension)) continue;
            return dependencyFinder;
        }
        return null;
    }

    @NotNull
    private static List<VirtualFile> findDependentFiles(@NotNull Project project, @NotNull VirtualFile file, @NotNull FileDependencyFinder finder, @NotNull GlobalSearchScope scope, boolean trackOnlyRoots) {
        if (project == null) {
            TaskUtils.$$$reportNull$$$0(6);
        }
        if (file == null) {
            TaskUtils.$$$reportNull$$$0(7);
        }
        if (finder == null) {
            TaskUtils.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            TaskUtils.$$$reportNull$$$0(9);
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        THashSet visited = new THashSet();
        LinkedList<VirtualFile> queue = new LinkedList<VirtualFile>();
        queue.add(file);
        while (!queue.isEmpty()) {
            VirtualFile currentFile = (VirtualFile)queue.removeFirst();
            if (!visited.add(currentFile)) continue;
            Set<VirtualFile> dependentFiles = finder.findDependentFiles(project, currentFile, scope);
            if (dependentFiles.isEmpty()) {
                roots.add(currentFile);
                continue;
            }
            queue.addAll(dependentFiles);
        }
        ArrayList<VirtualFile> arrayList = trackOnlyRoots ? roots : new ArrayList<VirtualFile>((Collection<VirtualFile>)visited);
        if (arrayList == null) {
            TaskUtils.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/plugins/watcher/util/TaskUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/plugins/watcher/util/TaskUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findDependentFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveOutputFileInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findRoots";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDependentFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findRoots$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

