/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util;

import com.jetbrains.rider.util.ILoggerFactory;
import com.jetbrains.rider.util.LogLevel;
import com.jetbrains.rider.util.Logger;
import com.jetbrains.rider.util.LoggerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/util/ConsoleLoggerFactory;", "Lcom/jetbrains/rider/util/ILoggerFactory;", "()V", "level", "Lcom/jetbrains/rider/util/LogLevel;", "getLevel", "()Lcom/jetbrains/rider/util/LogLevel;", "setLevel", "(Lcom/jetbrains/rider/util/LogLevel;)V", "getLogger", "Lcom/jetbrains/rider/util/Logger;", "category", "", "rd-core-jvm"})
public final class ConsoleLoggerFactory
implements ILoggerFactory {
    @NotNull
    private static LogLevel level;
    public static final ConsoleLoggerFactory INSTANCE;

    @NotNull
    public final LogLevel getLevel() {
        return level;
    }

    public final void setLevel(@NotNull LogLevel logLevel) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)logLevel), (String)"<set-?>");
        level = logLevel;
    }

    @Override
    @NotNull
    public Logger getLogger(@NotNull String category) {
        Intrinsics.checkParameterIsNotNull((Object)category, (String)"category");
        return new Logger(category){
            final /* synthetic */ String $category;

            public void log(@NotNull LogLevel level, @Nullable Object message, @Nullable Throwable throwable) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
                if (!this.isEnabled(level)) {
                    return;
                }
                String string = LoggerKt.defaultLogFormat(this.$category, level, message, throwable);
                System.out.println((Object)string);
            }

            public boolean isEnabled(@NotNull LogLevel level) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
                return level.compareTo((Enum)ConsoleLoggerFactory.INSTANCE.getLevel()) >= 0;
            }
            {
                this.$category = $captured_local_variable$0;
            }
        };
    }

    private ConsoleLoggerFactory() {
    }

    static {
        ConsoleLoggerFactory consoleLoggerFactory;
        INSTANCE = consoleLoggerFactory = new ConsoleLoggerFactory();
        level = LogLevel.Debug;
    }
}

