/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.threading;

import com.jetbrains.rider.util.LogLevel;
import com.jetbrains.rider.util.Logger;
import com.jetbrains.rider.util.LoggerKt;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.threading.ByteArraySlice;
import com.jetbrains.rider.util.time.DurationKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 ?2\u00020\u0001:\u0003>?@B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010*\u001a\u00020\tH\u0002J\b\u0010+\u001a\u00020\tH\u0002J\u0016\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0003J\"\u00100\u001a\u00020\t2\u0006\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u00020\u00052\b\b\u0002\u00104\u001a\u00020\u0005J\u0006\u00105\u001a\u00020\tJ\u0010\u00106\u001a\u0002072\b\b\u0002\u00108\u001a\u000209J\u0010\u0010:\u001a\u0002072\b\b\u0002\u00108\u001a\u000209J \u0010;\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020\u0003H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u001bj\b\u0012\u0004\u0012\u00020\u0003`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u000e\"\u0004\b!\u0010\"R$\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020$@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006A"}, d2={"Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor;", "", "id", "", "chunkSize", "", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/rider/util/threading/ByteArraySlice;", "", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "asyncProcessingThread", "Ljava/lang/Thread;", "getChunkSize", "()I", "firstChunkToProcess", "Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;", "freeChunk", "getId", "()Ljava/lang/String;", "lastShrinkOrGrowTimeMs", "", "lock", "Ljava/lang/Object;", "log", "Lcom/jetbrains/rider/util/Logger;", "pauseReasons", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getProcessor", "()Lkotlin/jvm/functions/Function1;", "shrinkIntervalMs", "getShrinkIntervalMs", "setShrinkIntervalMs", "(I)V", "<set-?>", "Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$StateKind;", "state", "getState", "()Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$StateKind;", "setState", "(Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$StateKind;)V", "ThreadProc", "cleanup0", "pause", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "reason", "put", "newData", "", "offset", "count", "start", "stop", "", "timeout", "Ljava/time/Duration;", "terminate", "terminate0", "stateToSet", "action", "Chunk", "Companion", "StateKind", "rd-core-jvm"})
public final class ByteBufferAsyncProcessor {
    private final Logger log;
    private final Object lock;
    private long lastShrinkOrGrowTimeMs;
    private Thread asyncProcessingThread;
    private Chunk freeChunk;
    private Chunk firstChunkToProcess;
    private final ArrayList<String> pauseReasons;
    private int shrinkIntervalMs;
    @NotNull
    private StateKind state;
    @NotNull
    private final String id;
    private final int chunkSize;
    @NotNull
    private final Function1<ByteArraySlice, Unit> processor;
    private static final int DefaultChunkSize = 16380;
    private static final int DefaultShrinkIntervalMs = 30000;
    public static final Companion Companion = new Companion(null);

    public final int getShrinkIntervalMs() {
        return this.shrinkIntervalMs;
    }

    public final void setShrinkIntervalMs(int n) {
        this.shrinkIntervalMs = n;
    }

    @NotNull
    public final StateKind getState() {
        return this.state;
    }

    private final void setState(StateKind stateKind) {
        this.state = stateKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanup0() {
        Object object = this.lock;
        synchronized (object) {
            this.state = StateKind.Terminated;
            this.freeChunk = Chunk.Companion.getEmpty();
            this.firstChunkToProcess = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean terminate0(Duration timeout, StateKind stateToSet, String action2) {
        boolean res;
        Object object = this.lock;
        synchronized (object) {
            block14: {
                block13: {
                    void $receiver$iv$iv;
                    Logger $receiver$iv;
                    if (this.state != StateKind.Initialized) break block13;
                    Logger logger = $receiver$iv = this.log;
                    LogLevel level$iv$iv = LogLevel.Debug;
                    if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                        LogLevel logLevel = level$iv$iv;
                        void var9_19 = $receiver$iv$iv;
                        String string = "Can't " + action2 + " '" + this.id + "', because it hasn't been started yet";
                        var9_19.log(logLevel, string, null);
                    }
                    this.cleanup0();
                    boolean bl = true;
                    return bl;
                }
                if (this.state.compareTo((Enum)stateToSet) < 0) break block14;
                Logger $receiver$iv = this.log;
                Logger $receiver$iv$iv = $receiver$iv;
                LogLevel level$iv$iv = LogLevel.Debug;
                if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    Logger logger = $receiver$iv$iv;
                    String string = "Trying to " + action2 + " async processor '" + this.id + "' but it's in state '" + (Object)((Object)this.state) + '\'';
                    logger.log(logLevel, string, null);
                }
                boolean bl = true;
                return bl;
            }
            this.state = stateToSet;
            this.lock.notifyAll();
            Unit $receiver$iv$iv = Unit.INSTANCE;
        }
        Thread thread = this.asyncProcessingThread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"asyncProcessingThread");
        }
        thread.join(timeout.toMillis());
        Thread thread2 = this.asyncProcessingThread;
        if (thread2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"asyncProcessingThread");
        }
        if (!(res = thread2.isAlive())) {
            Object comment$iv$iv = null;
            try {
                Thread thread3 = this.asyncProcessingThread;
                if (thread3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"asyncProcessingThread");
                }
                thread3.stop();
            }
            catch (Throwable e$iv$iv) {
                CharSequence charSequence = comment$iv$iv;
                String sfx$iv$iv = "";
                LoggerKt.getLogger("Default-Error-Logger").log(LogLevel.Error, "Catch" + sfx$iv$iv, e$iv$iv);
            }
        }
        this.cleanup0();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ThreadProc() {
        Chunk chunk = this.firstChunkToProcess;
        if (chunk == null) {
            Intrinsics.throwNpe();
        }
        Chunk chunk2 = chunk;
        this.firstChunkToProcess = null;
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                long now;
                Object object2;
                if (this.state.compareTo((Enum)StateKind.Terminated) >= 0) {
                    return;
                }
                while (chunk2.getPtr() == 0 || !(object2 = (Collection)this.pauseReasons).isEmpty()) {
                    if (this.state.compareTo((Enum)StateKind.Stopping) >= 0) {
                        return;
                    }
                    this.lock.wait();
                    if (this.state.compareTo((Enum)StateKind.Terminating) < 0) continue;
                    return;
                }
                if (Intrinsics.areEqual((Object)this.freeChunk, (Object)chunk2)) {
                    this.freeChunk = chunk2.getNext();
                }
                if ((now = System.currentTimeMillis()) - this.lastShrinkOrGrowTimeMs > (long)this.shrinkIntervalMs) {
                    this.lastShrinkOrGrowTimeMs = now;
                    while (Intrinsics.areEqual((Object)this.freeChunk.getNext(), (Object)chunk2) ^ true && this.freeChunk.getPtr() == 0) {
                        String string;
                        Logger logger;
                        LogLevel logLevel;
                        Logger $receiver$iv$iv;
                        Logger $receiver$iv;
                        Logger logger2 = $receiver$iv = this.log;
                        LogLevel level$iv$iv = LogLevel.Debug;
                        if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                            logLevel = level$iv$iv;
                            logger = $receiver$iv$iv;
                            string = "Shrink: " + this.chunkSize + " bytes";
                            logger.log(logLevel, string, null);
                        }
                        if (this.freeChunk.getNext().getPtr() != 0 && ($receiver$iv$iv = ($receiver$iv = this.log)).isEnabled(level$iv$iv = LogLevel.Debug)) {
                            logLevel = level$iv$iv;
                            logger = $receiver$iv$iv;
                            string = "freeChunk.next.ptr != 0";
                            logger.log(logLevel, string, null);
                        }
                        this.freeChunk.setNext(this.freeChunk.getNext().getNext());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            try {
                this.processor.invoke((Object)new ByteArraySlice(chunk2.getData(), 0, chunk2.getPtr()));
                continue;
            }
            catch (Exception e) {
                LoggerKt.error(this.log, "Exception while processing byte queue", e);
                continue;
            }
            finally {
                object = this.lock;
                synchronized (object) {
                    chunk2.setPtr(0);
                    chunk2 = chunk2.getNext();
                    Unit now = Unit.INSTANCE;
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void start() {
        Object object = this.lock;
        synchronized (object) {
            Thread thread;
            if (this.state != StateKind.Initialized) {
                void $receiver$iv$iv;
                Logger $receiver$iv;
                Logger logger = $receiver$iv = this.log;
                LogLevel level$iv$iv = LogLevel.Debug;
                if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                    LogLevel logLevel = level$iv$iv;
                    void var6_10 = $receiver$iv$iv;
                    String string = "Trying to START async processor '" + this.id + "' but it's in state '" + (Object)((Object)this.state) + '\'';
                    var6_10.log(logLevel, string, null);
                }
                return;
            }
            this.state = StateKind.AsyncProcessing;
            Thread thread2 = new Thread(new Runnable(this){
                final /* synthetic */ ByteBufferAsyncProcessor this$0;
                {
                    this.this$0 = byteBufferAsyncProcessor;
                }

                public final void run() {
                    ByteBufferAsyncProcessor.access$ThreadProc(this.this$0);
                }
            }, this.id);
            ByteBufferAsyncProcessor byteBufferAsyncProcessor = this;
            Thread $receiver = thread2;
            $receiver.setDaemon(true);
            byteBufferAsyncProcessor.asyncProcessingThread = thread = thread2;
            Thread thread3 = this.asyncProcessingThread;
            if (thread3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"asyncProcessingThread");
            }
            thread3.start();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void pause(@NotNull Lifetime lifetime, @NotNull String reason) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        Lifetime lifetime2 = lifetime;
        Function0 function0 = (Function0)new Function0<Unit>(this, reason){
            final /* synthetic */ ByteBufferAsyncProcessor this$0;
            final /* synthetic */ String $reason;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                Object object = ByteBufferAsyncProcessor.access$getLock$p(this.this$0);
                synchronized (object) {
                    ByteBufferAsyncProcessor.access$getPauseReasons$p(this.this$0).remove(this.$reason);
                    ByteBufferAsyncProcessor.access$getLock$p(this.this$0).notify();
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = byteBufferAsyncProcessor;
                this.$reason = string;
                super(0);
            }
        };
        if (!this_$iv.isTerminated()) {
            void closing$iv;
            Object object = this.lock;
            synchronized (object) {
                boolean bl = this.pauseReasons.add(reason);
            }
            this_$iv.add((Function0<Unit>)closing$iv);
        }
    }

    public final boolean stop(@NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        return this.terminate0(timeout, StateKind.Stopping, "STOP");
    }

    public static /* bridge */ /* synthetic */ boolean stop$default(ByteBufferAsyncProcessor byteBufferAsyncProcessor, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = DurationKt.getInfiniteDuration();
        }
        return byteBufferAsyncProcessor.stop(duration);
    }

    public final boolean terminate(@NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        return this.terminate0(timeout, StateKind.Terminating, "TERMINATE");
    }

    public static /* bridge */ /* synthetic */ boolean terminate$default(ByteBufferAsyncProcessor byteBufferAsyncProcessor, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = DurationKt.getInfiniteDuration();
        }
        return byteBufferAsyncProcessor.terminate(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void put(@NotNull byte[] newData, int offset, int count) {
        Intrinsics.checkParameterIsNotNull((Object)newData, (String)"newData");
        Object object = this.lock;
        synchronized (object) {
            boolean shouldNotify;
            if (this.state.compareTo((Enum)StateKind.Stopping) >= 0) {
                return;
            }
            int ptr = 0;
            boolean bl = shouldNotify = this.freeChunk.getPtr() == 0;
            while (ptr < count) {
                int rest = count - ptr;
                int available = this.chunkSize - this.freeChunk.getPtr();
                if (available > 0) {
                    int copylen = Math.min(rest, available);
                    System.arraycopy(newData, ptr + offset, this.freeChunk.getData(), this.freeChunk.getPtr(), copylen);
                    Chunk chunk = this.freeChunk;
                    chunk.setPtr(chunk.getPtr() + copylen);
                    ptr += copylen;
                    continue;
                }
                if (this.freeChunk.getNext().getPtr() != 0) {
                    Chunk chunk;
                    Object object2;
                    void $receiver$iv$iv;
                    Logger $receiver$iv;
                    Logger logger = $receiver$iv = this.log;
                    LogLevel level$iv$iv = LogLevel.Debug;
                    if ($receiver$iv$iv.isEnabled(level$iv$iv)) {
                        object2 = level$iv$iv;
                        chunk = $receiver$iv$iv;
                        String string = "Grow: " + this.chunkSize + " bytes";
                        chunk.log((LogLevel)((Object)object2), string, null);
                    }
                    Chunk chunk2 = new Chunk(this.chunkSize);
                    chunk = this.freeChunk;
                    Chunk $receiver = chunk2;
                    $receiver.setNext(this.freeChunk.getNext());
                    object2 = chunk2;
                    chunk.setNext((Chunk)object2);
                    this.lastShrinkOrGrowTimeMs = System.currentTimeMillis();
                }
                this.freeChunk = this.freeChunk.getNext();
            }
            if (shouldNotify) {
                this.lock.notify();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* bridge */ /* synthetic */ void put$default(ByteBufferAsyncProcessor byteBufferAsyncProcessor, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        byteBufferAsyncProcessor.put(byArray, n, n2);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final int getChunkSize() {
        return this.chunkSize;
    }

    @NotNull
    public final Function1<ByteArraySlice, Unit> getProcessor() {
        return this.processor;
    }

    public ByteBufferAsyncProcessor(@NotNull String id, int chunkSize, @NotNull Function1<? super ByteArraySlice, Unit> processor) {
        Chunk chunk;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
        this.id = id;
        this.chunkSize = chunkSize;
        this.processor = processor;
        this.log = LoggerKt.getLogger(Reflection.getOrCreateKotlinClass(this.getClass()));
        this.lock = new Object();
        this.lastShrinkOrGrowTimeMs = System.currentTimeMillis();
        this.pauseReasons = new ArrayList();
        this.shrinkIntervalMs = 30000;
        this.state = StateKind.Initialized;
        this.freeChunk = chunk = Chunk.Companion.createCycledPair(this.chunkSize);
        this.firstChunkToProcess = chunk;
    }

    public /* synthetic */ ByteBufferAsyncProcessor(String string, int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 16380;
        }
        this(string, n, (Function1<? super ByteArraySlice, Unit>)function1);
    }

    public static final /* synthetic */ void access$ThreadProc(ByteBufferAsyncProcessor $this) {
        $this.ThreadProc();
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(ByteBufferAsyncProcessor $this) {
        return $this.lock;
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getPauseReasons$p(ByteBufferAsyncProcessor $this) {
        return $this.pauseReasons;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$StateKind;", "", "(Ljava/lang/String;I)V", "Initialized", "AsyncProcessing", "Stopping", "Terminating", "Terminated", "rd-core-jvm"})
    public static final class StateKind
    extends Enum<StateKind> {
        public static final /* enum */ StateKind Initialized;
        public static final /* enum */ StateKind AsyncProcessing;
        public static final /* enum */ StateKind Stopping;
        public static final /* enum */ StateKind Terminating;
        public static final /* enum */ StateKind Terminated;
        private static final /* synthetic */ StateKind[] $VALUES;

        static {
            StateKind[] stateKindArray = new StateKind[5];
            StateKind[] stateKindArray2 = stateKindArray;
            stateKindArray[0] = Initialized = new StateKind();
            stateKindArray[1] = AsyncProcessing = new StateKind();
            stateKindArray[2] = Stopping = new StateKind();
            stateKindArray[3] = Terminating = new StateKind();
            stateKindArray[4] = Terminated = new StateKind();
            $VALUES = stateKindArray;
        }

        public static StateKind[] values() {
            return (StateKind[])$VALUES.clone();
        }

        public static StateKind valueOf(String string) {
            return Enum.valueOf(StateKind.class, string);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\r\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0000X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0004\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;", "", "chunkSize", "", "(I)V", "data", "", "getData", "()[B", "next", "getNext", "()Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;", "setNext", "(Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;)V", "ptr", "getPtr", "()I", "setPtr", "Companion", "rd-core-jvm"})
    private static final class Chunk {
        @NotNull
        public Chunk next;
        private int ptr;
        @NotNull
        private final byte[] data;
        @NotNull
        private static final Chunk empty;
        public static final Companion Companion;

        @NotNull
        public final Chunk getNext() {
            Chunk chunk = this.next;
            if (chunk == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"next");
            }
            return chunk;
        }

        public final void setNext(@NotNull Chunk chunk) {
            Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"<set-?>");
            this.next = chunk;
        }

        public final int getPtr() {
            return this.ptr;
        }

        public final void setPtr(int n) {
            this.ptr = n;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }

        public Chunk(int chunkSize) {
            this.data = new byte[chunkSize];
        }

        static {
            Companion = new Companion(null);
            empty = new Chunk(0);
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk$Companion;", "", "()V", "empty", "Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;", "getEmpty", "()Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Chunk;", "createCycledPair", "chunkSize", "", "rd-core-jvm"})
        public static final class Companion {
            @NotNull
            public final Chunk createCycledPair(int chunkSize) {
                Chunk chunk;
                Chunk chunk1 = new Chunk(chunkSize);
                Chunk $receiver = chunk = new Chunk(chunkSize);
                $receiver.setNext(chunk1);
                Chunk chunk2 = chunk;
                chunk1.setNext(chunk2);
                return chunk1;
            }

            @NotNull
            public final Chunk getEmpty() {
                return empty;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/util/threading/ByteBufferAsyncProcessor$Companion;", "", "()V", "DefaultChunkSize", "", "DefaultShrinkIntervalMs", "rd-core-jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

