/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiEquivalenceUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.PsiEquivalenceUtil");

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @Nullable Comparator<PsiElement> resolvedElementsComparator, boolean areCommentsSignificant) {
        if (element1 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(1);
        }
        return PsiEquivalenceUtil.areElementsEquivalent(element1, element2, new ReferenceComparator(resolvedElementsComparator), null, null, areCommentsSignificant);
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2, @NotNull Comparator<PsiReference> referenceComparator, @Nullable Comparator<PsiElement> leafElementsComparator, @Nullable Condition<PsiElement> isElementSignificantCondition, boolean areCommentsSignificant) {
        PsiElement[] children2;
        if (element1 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(4);
        }
        if (element2 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(5);
        }
        if (referenceComparator == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(6);
        }
        if (element1 == element2) {
            return true;
        }
        ASTNode node1 = element1.getNode();
        ASTNode node2 = element2.getNode();
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getElementType() != node2.getElementType()) {
            return false;
        }
        PsiElement[] children1 = PsiEquivalenceUtil.getFilteredChildren(element1, isElementSignificantCondition, areCommentsSignificant);
        if (children1.length != (children2 = PsiEquivalenceUtil.getFilteredChildren(element2, isElementSignificantCondition, areCommentsSignificant)).length) {
            return false;
        }
        for (int i = 0; i < children1.length; ++i) {
            PsiElement child1 = children1[i];
            PsiElement child2 = children2[i];
            if (PsiEquivalenceUtil.areElementsEquivalent(child1, child2, referenceComparator, leafElementsComparator, isElementSignificantCondition, areCommentsSignificant)) continue;
            return false;
        }
        if (children1.length == 0 && (leafElementsComparator != null ? leafElementsComparator.compare(element1, element2) != 0 : !element1.textMatches(element2))) {
            return false;
        }
        PsiReference ref1 = element1.getReference();
        if (ref1 != null) {
            PsiReference ref2 = element2.getReference();
            if (ref2 == null) {
                return false;
            }
            if (referenceComparator.compare(ref1, ref2) != 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean areElementsEquivalent(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(7);
        }
        if (element2 == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(8);
        }
        return PsiEquivalenceUtil.areElementsEquivalent(element1, element2, null, false);
    }

    @NotNull
    public static PsiElement[] getFilteredChildren(@NotNull PsiElement element, @Nullable Condition<PsiElement> isElementSignificantCondition, boolean areCommentsSignificant) {
        if (element == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(9);
        }
        ASTNode[] children1 = element.getNode().getChildren(null);
        ArrayList<PsiElement> array2 = new ArrayList<PsiElement>();
        for (ASTNode node : children1) {
            PsiElement child = node.getPsi();
            if (child instanceof PsiWhiteSpace || !areCommentsSignificant && child instanceof PsiComment || isElementSignificantCondition != null && !isElementSignificantCondition.value(child)) continue;
            array2.add(child);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array2);
        if (psiElementArray == null) {
            PsiEquivalenceUtil.$$$reportNull$$$0(10);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceComparator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/PsiEquivalenceUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/PsiEquivalenceUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areElementsEquivalent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredChildren";
                break;
            }
            case 10: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReferenceComparator
    implements Comparator<PsiReference> {
        @Nullable
        private final Comparator<PsiElement> myResolvedElementsComparator;

        ReferenceComparator(@Nullable Comparator<PsiElement> resolvedElementsComparator) {
            this.myResolvedElementsComparator = resolvedElementsComparator;
        }

        @Override
        public int compare(PsiReference ref1, PsiReference ref2) {
            PsiElement resolved2;
            PsiElement resolved1 = ref1.resolve();
            return Comparing.equal(resolved1, resolved2 = ref2.resolve()) || this.myResolvedElementsComparator != null && this.myResolvedElementsComparator.compare(resolved1, resolved2) == 0 ? 0 : 1;
        }
    }
}

