/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.CharsetUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoadTextUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.fileEditor.impl.LoadTextUtil");
    private static final Charset INTERNAL_SEVEN_BIT_UTF8 = new SevenBitCharset(CharsetToolkit.UTF8_CHARSET);
    private static final Charset INTERNAL_SEVEN_BIT_ISO_8859_1 = new SevenBitCharset(CharsetToolkit.ISO_8859_1_CHARSET);
    private static final Charset INTERNAL_SEVEN_BIT_WIN_1251 = new SevenBitCharset(CharsetToolkit.WIN_1251_CHARSET);
    private static final boolean GUESS_UTF = Boolean.parseBoolean(System.getProperty("idea.guess.utf.encoding", "true"));
    private static final Key<AutoDetectionReason> CHARSET_WAS_DETECTED_FROM_BYTES = Key.create("CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    @NotNull
    private static ConvertResult convertLineSeparatorsToSlashN(@NotNull CharBuffer buffer) {
        if (buffer == null) {
            LoadTextUtil.$$$reportNull$$$0(0);
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        for (int src = 0; src < length; ++src) {
            int c = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++lfCount;
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c;
                        break;
                    }
                    buffer.put(dst++, (char)c);
                }
            }
            prev = c;
        }
        String detectedLineSeparator = LoadTextUtil.guessLineSeparator(crCount, lfCount, crlfCount);
        CharBuffer result2 = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        ConvertResult convertResult = new ConvertResult(result2, detectedLineSeparator);
        if (convertResult == null) {
            LoadTextUtil.$$$reportNull$$$0(1);
        }
        return convertResult;
    }

    @NotNull
    private static ConvertResult convertLineSeparatorsToSlashN(@NotNull byte[] charsAsBytes, int startOffset, int endOffset) {
        int index2;
        if (charsAsBytes == null) {
            LoadTextUtil.$$$reportNull$$$0(2);
        }
        if ((index2 = ArrayUtil.indexOf(charsAsBytes, (byte)13, startOffset, endOffset)) == -1) {
            ByteArrayCharSequence sequence2 = new ByteArrayCharSequence(charsAsBytes, startOffset, endOffset);
            String detectedLineSeparator = ArrayUtil.indexOf(charsAsBytes, (byte)10, startOffset, endOffset) == -1 ? null : "\n";
            ConvertResult convertResult = new ConvertResult(sequence2, detectedLineSeparator);
            if (convertResult == null) {
                LoadTextUtil.$$$reportNull$$$0(3);
            }
            return convertResult;
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        byte[] result2 = new byte[endOffset - startOffset];
        for (int src = startOffset; src < endOffset; ++src) {
            char c = (char)charsAsBytes[src];
            switch (c) {
                case '\r': {
                    result2[dst++] = 10;
                    ++crCount;
                    break;
                }
                case '\n': {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    result2[dst++] = 10;
                    ++lfCount;
                    break;
                }
                default: {
                    result2[dst++] = (byte)c;
                }
            }
            prev = c;
        }
        String detectedLineSeparator = LoadTextUtil.guessLineSeparator(crCount, lfCount, crlfCount);
        ByteArrayCharSequence sequence3 = new ByteArrayCharSequence(result2, 0, dst);
        ConvertResult convertResult = new ConvertResult(sequence3, detectedLineSeparator);
        if (convertResult == null) {
            LoadTextUtil.$$$reportNull$$$0(4);
        }
        return convertResult;
    }

    @Nullable
    private static String guessLineSeparator(int crCount, int lfCount, int crlfCount) {
        String detectedLineSeparator = null;
        if (crlfCount > crCount && crlfCount > lfCount) {
            detectedLineSeparator = "\r\n";
        } else if (crCount > lfCount) {
            detectedLineSeparator = "\r";
        } else if (lfCount > 0) {
            detectedLineSeparator = "\n";
        }
        return detectedLineSeparator;
    }

    @NotNull
    private static DetectResult detectHardCharset(@NotNull VirtualFile virtualFile2, @NotNull byte[] content, int length, @NotNull FileType fileType) {
        Charset hardCodedCharset;
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(5);
        }
        if (content == null) {
            LoadTextUtil.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            LoadTextUtil.$$$reportNull$$$0(7);
        }
        String charsetName = fileType.getCharset(virtualFile2, content);
        DetectResult guessed = LoadTextUtil.guessFromContent(virtualFile2, content, length);
        Charset charset = hardCodedCharset = charsetName == null ? guessed.hardCodedCharset : CharsetToolkit.forName(charsetName);
        if (hardCodedCharset == null && guessed.guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
            DetectResult detectResult = new DetectResult(CharsetToolkit.UTF8_CHARSET, guessed.guessed, guessed.BOM);
            if (detectResult == null) {
                LoadTextUtil.$$$reportNull$$$0(8);
            }
            return detectResult;
        }
        DetectResult detectResult = new DetectResult(hardCodedCharset, guessed.guessed, guessed.BOM);
        if (detectResult == null) {
            LoadTextUtil.$$$reportNull$$$0(9);
        }
        return detectResult;
    }

    @NotNull
    private static Charset getDefaultCharsetFromEncodingManager(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(14);
        }
        Charset result2 = null;
        Charset specifiedExplicitly = EncodingRegistry.getInstance().getEncoding(virtualFile2, true);
        if (specifiedExplicitly != null) {
            result2 = specifiedExplicitly;
        }
        if (result2 == null) {
            result2 = EncodingRegistry.getInstance().getDefaultCharset();
        }
        Charset charset = result2;
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(15);
        }
        return charset;
    }

    @NotNull
    private static DetectResult detectInternalCharsetAndSetBOM(@NotNull VirtualFile file2, @NotNull byte[] content, int length, boolean saveBOM, @NotNull FileType fileType) {
        if (file2 == null) {
            LoadTextUtil.$$$reportNull$$$0(16);
        }
        if (content == null) {
            LoadTextUtil.$$$reportNull$$$0(17);
        }
        if (fileType == null) {
            LoadTextUtil.$$$reportNull$$$0(18);
        }
        DetectResult info = LoadTextUtil.detectHardCharset(file2, content, length, fileType);
        Charset charset = info.hardCodedCharset == null ? (file2.isCharsetSet() ? file2.getCharset() : LoadTextUtil.getDefaultCharsetFromEncodingManager(file2)) : info.hardCodedCharset;
        byte[] bom = info.BOM;
        if (saveBOM && bom != null && bom.length != 0) {
            file2.setBOM(bom);
            LoadTextUtil.setCharsetAutoDetectionReason(file2, AutoDetectionReason.FROM_BOM);
        }
        file2.setCharset(charset);
        Charset result2 = charset;
        if (info.guessed == CharsetToolkit.GuessedEncoding.SEVEN_BIT) {
            if (charset == CharsetToolkit.UTF8_CHARSET) {
                result2 = INTERNAL_SEVEN_BIT_UTF8;
            } else if (charset == CharsetToolkit.ISO_8859_1_CHARSET) {
                result2 = INTERNAL_SEVEN_BIT_ISO_8859_1;
            } else if (charset == CharsetToolkit.WIN_1251_CHARSET) {
                result2 = INTERNAL_SEVEN_BIT_WIN_1251;
            }
        }
        DetectResult detectResult = new DetectResult(result2, info.guessed, bom);
        if (detectResult == null) {
            LoadTextUtil.$$$reportNull$$$0(19);
        }
        return detectResult;
    }

    @NotNull
    public static DetectResult guessFromContent(@NotNull VirtualFile virtualFile2, @NotNull byte[] content) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(20);
        }
        if (content == null) {
            LoadTextUtil.$$$reportNull$$$0(21);
        }
        DetectResult detectResult = LoadTextUtil.guessFromContent(virtualFile2, content, content.length);
        if (detectResult == null) {
            LoadTextUtil.$$$reportNull$$$0(22);
        }
        return detectResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static DetectResult guessFromContent(@NotNull VirtualFile virtualFile2, @NotNull byte[] content, int length) {
        DetectResult detectResult;
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(23);
        }
        if (content == null) {
            LoadTextUtil.$$$reportNull$$$0(24);
        }
        AutoDetectionReason detectedFromBytes = null;
        try {
            DetectResult info;
            if (GUESS_UTF) {
                info = LoadTextUtil.guessFromBytes(content, 0, length, LoadTextUtil.getDefaultCharsetFromEncodingManager(virtualFile2));
                if (info.BOM != null) {
                    detectedFromBytes = AutoDetectionReason.FROM_BOM;
                } else if (info.guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
                    detectedFromBytes = AutoDetectionReason.FROM_BYTES;
                }
            } else {
                info = new DetectResult(null, null, null);
            }
            detectResult = info;
        }
        catch (Throwable throwable) {
            LoadTextUtil.setCharsetAutoDetectionReason(virtualFile2, detectedFromBytes);
            throw throwable;
        }
        LoadTextUtil.setCharsetAutoDetectionReason(virtualFile2, detectedFromBytes);
        DetectResult detectResult2 = detectResult;
        if (detectResult2 == null) {
            LoadTextUtil.$$$reportNull$$$0(25);
        }
        return detectResult2;
    }

    @NotNull
    private static DetectResult guessFromBytes(@NotNull byte[] content, int startOffset, int endOffset, @NotNull Charset defaultCharset) {
        if (content == null) {
            LoadTextUtil.$$$reportNull$$$0(26);
        }
        if (defaultCharset == null) {
            LoadTextUtil.$$$reportNull$$$0(27);
        }
        CharsetToolkit toolkit = new CharsetToolkit(content, defaultCharset);
        toolkit.setEnforce8Bit(true);
        Charset charset = toolkit.guessFromBOM();
        if (charset != null) {
            byte[] bom = ObjectUtils.notNull(CharsetToolkit.getMandatoryBom(charset), CharsetToolkit.UTF8_BOM);
            DetectResult detectResult = new DetectResult(charset, null, bom);
            if (detectResult == null) {
                LoadTextUtil.$$$reportNull$$$0(28);
            }
            return detectResult;
        }
        CharsetToolkit.GuessedEncoding guessed = toolkit.guessFromContent(startOffset, endOffset);
        if (guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
            DetectResult detectResult = new DetectResult(CharsetToolkit.UTF8_CHARSET, CharsetToolkit.GuessedEncoding.VALID_UTF8, null);
            if (detectResult == null) {
                LoadTextUtil.$$$reportNull$$$0(29);
            }
            return detectResult;
        }
        DetectResult detectResult = new DetectResult(null, guessed, null);
        if (detectResult == null) {
            LoadTextUtil.$$$reportNull$$$0(30);
        }
        return detectResult;
    }

    public static void write(@Nullable Project project, @NotNull VirtualFile virtualFile2, @NotNull Object requestor, @NotNull String text2, long newModificationStamp) throws IOException {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(40);
        }
        if (requestor == null) {
            LoadTextUtil.$$$reportNull$$$0(41);
        }
        if (text2 == null) {
            LoadTextUtil.$$$reportNull$$$0(42);
        }
        Charset existing = virtualFile2.getCharset();
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.charsetForWriting(project, virtualFile2, text2, existing);
        Charset charset = (Charset)chosen.first;
        byte[] buffer = (byte[])chosen.second;
        if (!charset.equals(existing)) {
            virtualFile2.setCharset(charset);
        }
        LoadTextUtil.setDetectedFromBytesFlagBack(virtualFile2, buffer);
        virtualFile2.setBinaryContent(buffer, newModificationStamp, -1L, requestor);
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> charsetForWriting(@Nullable Project project, @NotNull VirtualFile virtualFile2, @NotNull String text2, @NotNull Charset existing) {
        Charset fromBom;
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(43);
        }
        if (text2 == null) {
            LoadTextUtil.$$$reportNull$$$0(44);
        }
        if (existing == null) {
            LoadTextUtil.$$$reportNull$$$0(45);
        }
        Charset specified = LoadTextUtil.extractCharsetFromFileContent(project, virtualFile2, text2);
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified, text2);
        Charset charset = (Charset)chosen.first;
        byte[] bom = virtualFile2.getBOM();
        Charset charset2 = fromBom = bom == null ? null : CharsetToolkit.guessFromBOM(bom);
        if (fromBom != null && !fromBom.equals(charset)) {
            chosen = Pair.createNonNull(fromBom, text2.getBytes(fromBom));
        }
        Pair.NonNull<Charset, byte[]> nonNull = chosen;
        if (nonNull == null) {
            LoadTextUtil.$$$reportNull$$$0(46);
        }
        return nonNull;
    }

    private static void setDetectedFromBytesFlagBack(@NotNull VirtualFile virtualFile2, @NotNull byte[] content) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(47);
        }
        if (content == null) {
            LoadTextUtil.$$$reportNull$$$0(48);
        }
        if (virtualFile2.getBOM() == null) {
            LoadTextUtil.guessFromContent(virtualFile2, content);
        } else {
            LoadTextUtil.setCharsetAutoDetectionReason(virtualFile2, AutoDetectionReason.FROM_BOM);
        }
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> chooseMostlyHarmlessCharset(@NotNull Charset existing, @NotNull Charset specified, @NotNull String text2) {
        block15: {
            byte[] out;
            block14: {
                block13: {
                    Pair.NonNull<Charset, byte[]> nonNull;
                    if (existing == null) {
                        LoadTextUtil.$$$reportNull$$$0(49);
                    }
                    if (specified == null) {
                        LoadTextUtil.$$$reportNull$$$0(50);
                    }
                    if (text2 == null) {
                        LoadTextUtil.$$$reportNull$$$0(51);
                    }
                    try {
                        if (!specified.equals(existing)) break block13;
                        nonNull = Pair.createNonNull(specified, text2.getBytes(existing));
                    }
                    catch (RuntimeException e) {
                        Charset defaultCharset = Charset.defaultCharset();
                        Pair.NonNull<Charset, byte[]> nonNull2 = Pair.createNonNull(defaultCharset, text2.getBytes(defaultCharset));
                        if (nonNull2 == null) {
                            LoadTextUtil.$$$reportNull$$$0(56);
                        }
                        return nonNull2;
                    }
                    if (nonNull == null) {
                        LoadTextUtil.$$$reportNull$$$0(52);
                    }
                    return nonNull;
                }
                out = LoadTextUtil.isSupported(specified, text2);
                if (out == null) break block14;
                Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, out);
                if (nonNull == null) {
                    LoadTextUtil.$$$reportNull$$$0(53);
                }
                return nonNull;
            }
            out = LoadTextUtil.isSupported(existing, text2);
            if (out == null) break block15;
            Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(existing, out);
            if (nonNull == null) {
                LoadTextUtil.$$$reportNull$$$0(54);
            }
            return nonNull;
        }
        Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, text2.getBytes(specified));
        if (nonNull == null) {
            LoadTextUtil.$$$reportNull$$$0(55);
        }
        return nonNull;
    }

    @Nullable(value="null means not supported, otherwise it is converted byte stream")
    private static byte[] isSupported(@NotNull Charset charset, @NotNull String str) {
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(57);
        }
        if (str == null) {
            LoadTextUtil.$$$reportNull$$$0(58);
        }
        try {
            if (!charset.canEncode()) {
                return null;
            }
            byte[] bytes = str.getBytes(charset);
            if (!str.equals(new String(bytes, charset))) {
                return null;
            }
            return bytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Charset extractCharsetFromFileContent(@Nullable Project project, @NotNull VirtualFile virtualFile2, @NotNull CharSequence text2) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(59);
        }
        if (text2 == null) {
            LoadTextUtil.$$$reportNull$$$0(60);
        }
        Charset charset = ObjectUtils.notNull(LoadTextUtil.charsetFromContentOrNull(project, virtualFile2, text2), virtualFile2.getCharset());
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(61);
        }
        return charset;
    }

    @Nullable(value="returns null if cannot determine from content")
    public static Charset charsetFromContentOrNull(@Nullable Project project, @NotNull VirtualFile virtualFile2, @NotNull CharSequence text2) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(62);
        }
        if (text2 == null) {
            LoadTextUtil.$$$reportNull$$$0(63);
        }
        return CharsetUtil.extractCharsetFromFileContent(project, virtualFile2, virtualFile2.getFileType(), text2);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file2) {
        FileType type2;
        if (file2 == null) {
            LoadTextUtil.$$$reportNull$$$0(64);
        }
        if ((type2 = file2.getFileType()).isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.INSTANCE.forFileType(type2);
            if (decompiler != null) {
                CharSequence text2 = decompiler.decompile(file2);
                try {
                    StringUtil.assertValidSeparators(text2);
                }
                catch (AssertionError e) {
                    LOG.error((Throwable)((Object)e));
                }
                CharSequence charSequence = text2;
                if (charSequence == null) {
                    LoadTextUtil.$$$reportNull$$$0(65);
                }
                return charSequence;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file which doesn't have a decompiler plugged in: " + file2.getPresentableUrl() + ". File type: " + type2.getName());
        }
        CharSequence charSequence = LoadTextUtil.loadText(file2, -1);
        if (charSequence == null) {
            LoadTextUtil.$$$reportNull$$$0(66);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file2, int limit) {
        CharSequence charSequence;
        FileType type2;
        if (file2 == null) {
            LoadTextUtil.$$$reportNull$$$0(67);
        }
        if ((type2 = file2.getFileType()).isBinary()) {
            throw new IllegalArgumentException("Attempt to load truncated text for binary file: " + file2.getPresentableUrl() + ". File type: " + type2.getName());
        }
        if (file2 instanceof LightVirtualFile) {
            CharSequence charSequence2 = LoadTextUtil.limitCharSequence(((LightVirtualFile)file2).getContent(), limit);
            if (charSequence2 == null) {
                LoadTextUtil.$$$reportNull$$$0(68);
            }
            return charSequence2;
        }
        if (file2.isDirectory()) {
            throw new AssertionError((Object)("'" + file2.getPresentableUrl() + "' is a directory"));
        }
        try {
            byte[] bytes = limit == -1 ? file2.contentsToByteArray() : FileUtil.loadFirstAndClose(file2.getInputStream(), limit);
            charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, file2);
        }
        catch (IOException e) {
            CharSequence charSequence3 = ArrayUtil.EMPTY_CHAR_SEQUENCE;
            if (charSequence3 == null) {
                LoadTextUtil.$$$reportNull$$$0(70);
            }
            return charSequence3;
        }
        if (charSequence == null) {
            LoadTextUtil.$$$reportNull$$$0(69);
        }
        return charSequence;
    }

    @NotNull
    private static CharSequence limitCharSequence(@NotNull CharSequence sequence2, int limit) {
        if (sequence2 == null) {
            LoadTextUtil.$$$reportNull$$$0(71);
        }
        CharSequence charSequence = limit == -1 ? sequence2 : sequence2.subSequence(0, Math.min(limit, sequence2.length()));
        if (charSequence == null) {
            LoadTextUtil.$$$reportNull$$$0(72);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile2) {
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(73);
        }
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(74);
        }
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile2, true, true);
        if (charSequence == null) {
            LoadTextUtil.$$$reportNull$$$0(75);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(@NotNull byte[] bytes, @NotNull VirtualFile virtualFile2, boolean saveDetectedSeparators, boolean saveBOM) {
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(76);
        }
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(77);
        }
        DetectResult info = LoadTextUtil.detectInternalCharsetAndSetBOM(virtualFile2, bytes, bytes.length, saveBOM, virtualFile2.getFileType());
        byte[] bom = info.BOM;
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, Math.min(bom == null ? 0 : bom.length, bytes.length), bytes.length, info.hardCodedCharset);
        if (saveDetectedSeparators) {
            virtualFile2.setDetectedLineSeparator(result2.lineSeparator);
        }
        CharSequence charSequence = result2.text;
        if (charSequence == null) {
            LoadTextUtil.$$$reportNull$$$0(78);
        }
        return charSequence;
    }

    @NotNull
    private static ConvertResult convertBytes(@NotNull byte[] bytes, int startOffset, int endOffset, @NotNull Charset internalCharset) {
        CharBuffer charBuffer;
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(89);
        }
        if (internalCharset == null) {
            LoadTextUtil.$$$reportNull$$$0(90);
        }
        assert (startOffset >= 0 && startOffset <= endOffset && endOffset <= bytes.length) : startOffset + "," + endOffset + ": " + bytes.length;
        if (internalCharset instanceof SevenBitCharset || internalCharset == CharsetToolkit.US_ASCII_CHARSET) {
            ConvertResult convertResult = LoadTextUtil.convertLineSeparatorsToSlashN(bytes, startOffset, endOffset);
            if (convertResult == null) {
                LoadTextUtil.$$$reportNull$$$0(91);
            }
            return convertResult;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, endOffset - startOffset);
        try {
            charBuffer = internalCharset.decode(byteBuffer);
        }
        catch (Exception e) {
            charBuffer = CharBuffer.wrap(ArrayUtil.EMPTY_CHAR_ARRAY);
        }
        ConvertResult convertResult = LoadTextUtil.convertLineSeparatorsToSlashN(charBuffer);
        if (convertResult == null) {
            LoadTextUtil.$$$reportNull$$$0(92);
        }
        return convertResult;
    }

    private static void setCharsetAutoDetectionReason(@NotNull VirtualFile virtualFile2, @Nullable(value="null if was not detected, otherwise the reason it was") AutoDetectionReason reason) {
        if (virtualFile2 == null) {
            LoadTextUtil.$$$reportNull$$$0(94);
        }
        virtualFile2.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, reason);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 46: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 61: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 78: 
            case 83: 
            case 88: 
            case 91: 
            case 92: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 46: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 61: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 78: 
            case 83: 
            case 88: 
            case 91: 
            case 92: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 46: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 61: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 78: 
            case 83: 
            case 88: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/LoadTextUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsAsBytes";
                break;
            }
            case 5: 
            case 10: 
            case 14: 
            case 20: 
            case 23: 
            case 40: 
            case 43: 
            case 47: 
            case 59: 
            case 62: 
            case 74: 
            case 77: 
            case 80: 
            case 93: 
            case 94: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: 
            case 11: 
            case 17: 
            case 21: 
            case 24: 
            case 26: 
            case 32: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: 
            case 12: 
            case 18: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 16: 
            case 37: 
            case 64: 
            case 67: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
            case 31: 
            case 73: 
            case 76: 
            case 79: 
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 33: 
            case 57: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 42: 
            case 44: 
            case 51: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specified";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTextProcessor";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/LoadTextUtil";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparatorsToSlashN";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "detectHardCharset";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "detectCharsetAndSetBOM";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharsetFromEncodingManager";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "detectInternalCharsetAndSetBOM";
                break;
            }
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "guessFromContent";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "guessFromBytes";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenCharsetByBOM";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "charsetForWriting";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseMostlyHarmlessCharset";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCharsetFromFileContent";
                break;
            }
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "limitCharSequence";
                break;
            }
            case 75: 
            case 78: 
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextByBinaryPresentation";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "processTextFromBinaryPresentationOrNull";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "convertBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparatorsToSlashN";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 46: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 61: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 78: 
            case 83: 
            case 88: 
            case 91: 
            case 92: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectHardCharset";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "detectCharsetAndSetBOM";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCharsetFromEncodingManager";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "detectInternalCharsetAndSetBOM";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "guessFromContent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "guessFromBytes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromBytesOrNull";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenCharsetByBOM";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "changeLineSeparators";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "charsetForWriting";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setDetectedFromBytesFlagBack";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "chooseMostlyHarmlessCharset";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "extractCharsetFromFileContent";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "charsetFromContentOrNull";
                break;
            }
            case 64: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "limitCharSequence";
                break;
            }
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getTextByBinaryPresentation";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "processTextFromBinaryPresentationOrNull";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "detectLineSeparator";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getDetectedLineSeparator";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "convertBytes";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "getCharsetAutoDetectionReason";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "setCharsetAutoDetectionReason";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "clearCharsetAutoDetectionReason";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 46: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 61: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 75: 
            case 78: 
            case 83: 
            case 88: 
            case 91: 
            case 92: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertResult {
        @NotNull
        private final CharSequence text;
        @Nullable
        private final String lineSeparator;

        ConvertResult(@NotNull CharSequence text2, @Nullable String lineSeparator) {
            if (text2 == null) {
                ConvertResult.$$$reportNull$$$0(0);
            }
            this.text = text2;
            this.lineSeparator = lineSeparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/fileEditor/impl/LoadTextUtil$ConvertResult", "<init>"));
        }
    }

    public static class DetectResult {
        public final Charset hardCodedCharset;
        public final CharsetToolkit.GuessedEncoding guessed;
        @Nullable
        public final byte[] BOM;

        DetectResult(Charset hardCodedCharset, CharsetToolkit.GuessedEncoding guessed, @Nullable byte[] BOM) {
            this.hardCodedCharset = hardCodedCharset;
            this.guessed = guessed;
            this.BOM = BOM;
        }
    }

    private static class SevenBitCharset
    extends Charset {
        private final Charset myBaseCharset;

        SevenBitCharset(Charset baseCharset) {
            super("IJ__7BIT_" + baseCharset.name(), ArrayUtil.EMPTY_STRING_ARRAY);
            this.myBaseCharset = baseCharset;
        }

        @Override
        public boolean contains(Charset cs) {
            throw new IllegalStateException();
        }

        @Override
        public CharsetDecoder newDecoder() {
            throw new IllegalStateException();
        }

        @Override
        public CharsetEncoder newEncoder() {
            throw new IllegalStateException();
        }
    }

    public static enum AutoDetectionReason {
        FROM_BOM,
        FROM_BYTES;

    }
}

