/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.google.common.collect.ConcurrentHashMultiset;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.NonCancelableSection;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.impl.NonCancelableIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreProgressManager
extends ProgressManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.progress.impl.CoreProgressManager");
    final AtomicInteger myCurrentUnsafeProgressCount = new AtomicInteger(0);
    private final AtomicInteger myCurrentModalProgressCount = new AtomicInteger(0);
    public static final boolean ENABLED = !"disabled".equals(System.getProperty("idea.ProcessCanceledException"));
    private static CheckCanceledHook ourCheckCanceledHook;
    private ScheduledFuture<?> myCheckCancelledFuture;
    static final Map<ProgressIndicator, Set<Thread>> threadsUnderIndicator;
    private static final ConcurrentLongObjectMap<ProgressIndicator> currentIndicators;
    private static final ConcurrentLongObjectMap<ProgressIndicator> threadTopLevelIndicators;
    static final Set<Thread> threadsUnderCanceledIndicator;
    private static volatile boolean shouldCheckCanceled;
    private static final Collection<ProgressIndicator> nonStandardIndicators;
    private static final ThreadLocal<Boolean> isInNonCancelableSection;

    private void startBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture == null) {
            this.myCheckCancelledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
                for (ProgressIndicator indicator : nonStandardIndicators) {
                    try {
                        indicator.checkCanceled();
                    }
                    catch (ProcessCanceledException e) {
                        this.indicatorCanceled(indicator);
                    }
                }
            }, 0L, 10L, TimeUnit.MILLISECONDS);
        }
    }

    private void stopBackgroundNonStandardIndicatorsPing() {
        if (this.myCheckCancelledFuture != null) {
            this.myCheckCancelledFuture.cancel(true);
            this.myCheckCancelledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            this.stopBackgroundNonStandardIndicatorsPing();
        }
    }

    public static boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator) {
        CheckCanceledHook hook = ourCheckCanceledHook;
        return hook != null && hook.runHook(indicator);
    }

    @Override
    protected void doCheckCanceled() throws ProcessCanceledException {
        if (!shouldCheckCanceled) {
            return;
        }
        ProgressIndicator progress = this.getProgressIndicator();
        if (progress != null && ENABLED) {
            progress.checkCanceled();
        } else {
            CoreProgressManager.runCheckCanceledHooks(progress);
        }
    }

    @Override
    public boolean hasProgressIndicator() {
        return this.getProgressIndicator() != null;
    }

    @Override
    public boolean hasUnsafeProgressIndicator() {
        return this.myCurrentUnsafeProgressCount.get() > 0;
    }

    @Override
    public boolean hasModalProgressIndicator() {
        return this.myCurrentModalProgressCount.get() > 0;
    }

    @Override
    public void runProcess(@NotNull Runnable process2, @Nullable ProgressIndicator progress) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(2);
        }
        this.executeProcessUnderProgress(() -> {
            if (process2 == null) {
                CoreProgressManager.$$$reportNull$$$0(56);
            }
            try {
                try {
                    if (progress != null && !progress.isRunning()) {
                        progress.start();
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                process2.run();
            }
            finally {
                if (progress != null && progress.isRunning()) {
                    progress.stop();
                    if (progress instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)progress).processFinish();
                    }
                }
            }
        }, progress);
    }

    @Override
    public <T> T runProcess(@NotNull Computable<T> process2, ProgressIndicator progress) throws ProcessCanceledException {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(3);
        }
        Ref ref = new Ref();
        this.runProcess(() -> {
            if (process2 == null) {
                CoreProgressManager.$$$reportNull$$$0(55);
            }
            ref.set(process2.compute());
        }, progress);
        return ref.get();
    }

    @Override
    public void executeNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            CoreProgressManager.$$$reportNull$$$0(4);
        }
        if (this.isInNonCancelableSection()) {
            runnable.run();
        } else {
            try {
                isInNonCancelableSection.set(Boolean.TRUE);
                this.executeProcessUnderProgress(runnable, NonCancelableIndicator.INSTANCE);
            }
            finally {
                isInNonCancelableSection.remove();
            }
        }
    }

    @Override
    public void setCancelButtonText(String cancelButtonText) {
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Runnable process2, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(5);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(6);
        }
        return this.runProcessWithProgressSynchronously(process2, progressTitle, canBeCanceled, project, null);
    }

    @Override
    public <T, E extends Exception> T runProcessWithProgressSynchronously(final @NotNull ThrowableComputable<T, E> process2, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project) throws E {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(7);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(8);
        }
        final AtomicReference result2 = new AtomicReference();
        final AtomicReference exception = new AtomicReference();
        this.runProcessWithProgressSynchronously(new Task.Modal(project, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    Object compute = process2.compute();
                    result2.set(compute);
                }
                catch (Throwable t) {
                    exception.set(t);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$1", "run"));
            }
        }, null);
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            ExceptionUtil.rethrowUnchecked(t);
            Exception e = (Exception)t;
            throw e;
        }
        return (T)result2.get();
    }

    @Override
    public boolean runProcessWithProgressSynchronously(final @NotNull Runnable process2, @NotNull @Nls String progressTitle, boolean canBeCanceled, @Nullable Project project, @Nullable JComponent parentComponent) {
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(9);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(10);
        }
        Task.Modal task = new Task.Modal(project, progressTitle, canBeCanceled){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                process2.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$2", "run"));
            }
        };
        return this.runProcessWithProgressSynchronously(task, parentComponent);
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, @NotNull Runnable process2, @Nullable Runnable successRunnable, @Nullable Runnable canceledRunnable) {
        if (project == null) {
            CoreProgressManager.$$$reportNull$$$0(11);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(12);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(13);
        }
        this.runProcessWithProgressAsynchronously(project, progressTitle, process2, successRunnable, canceledRunnable, PerformInBackgroundOption.DEAF);
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Project project, @NotNull @Nls String progressTitle, final @NotNull Runnable process2, final @Nullable Runnable successRunnable, final @Nullable Runnable canceledRunnable, @NotNull PerformInBackgroundOption option) {
        if (project == null) {
            CoreProgressManager.$$$reportNull$$$0(14);
        }
        if (progressTitle == null) {
            CoreProgressManager.$$$reportNull$$$0(15);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(16);
        }
        if (option == null) {
            CoreProgressManager.$$$reportNull$$$0(17);
        }
        this.runProcessWithProgressAsynchronously(new Task.Backgroundable(project, progressTitle, true, option){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                process2.run();
            }

            @Override
            public void onCancel() {
                if (canceledRunnable != null) {
                    canceledRunnable.run();
                }
            }

            @Override
            public void onSuccess() {
                if (successRunnable != null) {
                    successRunnable.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$3", "run"));
            }
        });
    }

    @Override
    public void run(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(18);
        }
        if (task.isHeadless()) {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.runProcessWithProgressSynchronously(task, null);
            } else {
                this.runProcessWithProgressInCurrentThread(task, new EmptyProgressIndicator(), ModalityState.defaultModalityState());
            }
        } else if (task.isModal()) {
            this.runSynchronously(task.asModal());
        } else {
            Task.Backgroundable backgroundable = task.asBackgroundable();
            if (backgroundable.isConditionalModal() && !backgroundable.shouldStartInBackground()) {
                this.runSynchronously(task);
            } else {
                this.runAsynchronously(backgroundable);
            }
        }
    }

    private void runSynchronously(@NotNull Task task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(19);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.runProcessWithProgressSynchronously(task, null);
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (task == null) {
                    CoreProgressManager.$$$reportNull$$$0(54);
                }
                this.runProcessWithProgressSynchronously(task, null);
            });
        }
    }

    private void runAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(20);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.runProcessWithProgressAsynchronously(task);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                Project project;
                if (task == null) {
                    CoreProgressManager.$$$reportNull$$$0(53);
                }
                if ((project = task.getProject()) != null && project.isDisposed()) {
                    LOG.info("Task canceled because of project disposal: " + task);
                    CoreProgressManager.finishTask(task, true, null);
                    return;
                }
                this.runProcessWithProgressAsynchronously(task);
            }, ModalityState.defaultModalityState());
        }
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(21);
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, new EmptyProgressIndicator(), null);
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(22);
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation2) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(23);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(24);
        }
        Future<?> future = this.runProcessWithProgressAsynchronously(task, progressIndicator, continuation2, progressIndicator.getModalityState());
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(25);
        }
        return future;
    }

    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation2, final @NotNull ModalityState modalityState) {
        IndicatorDisposable indicatorDisposable;
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(26);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(27);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(28);
        }
        if (progressIndicator instanceof Disposable) {
            indicatorDisposable = new IndicatorDisposable(progressIndicator);
            Disposer.register(ApplicationManager.getApplication(), indicatorDisposable);
        } else {
            indicatorDisposable = null;
        }
        final TaskRunnable process2 = new TaskRunnable(task, progressIndicator, continuation2);
        TaskContainer action2 = new TaskContainer(task){

            @Override
            public void run() {
                boolean processCanceled = false;
                Throwable exception = null;
                long start = System.currentTimeMillis();
                try {
                    CoreProgressManager.this.runProcess(process2, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    processCanceled = true;
                }
                catch (Throwable e) {
                    exception = e;
                }
                long elapsed = System.currentTimeMillis() - start;
                boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
                Throwable finalException = exception;
                if (!finalCanceled) {
                    CoreProgressManager.this.notifyTaskFinished(task, elapsed);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (task == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    CoreProgressManager.finishTask(task, finalCanceled, finalException);
                    if (indicatorDisposable != null) {
                        Disposer.dispose(indicatorDisposable);
                    }
                }, modalityState);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/CoreProgressManager$4", "lambda$run$0"));
            }
        };
        Future<?> future = ApplicationManager.getApplication().executeOnPooledThread(action2);
        if (future == null) {
            CoreProgressManager.$$$reportNull$$$0(29);
        }
        return future;
    }

    void notifyTaskFinished(@NotNull Task.Backgroundable task, long elapsed) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(30);
        }
    }

    public boolean runProcessWithProgressSynchronously(final @NotNull Task task, @Nullable JComponent parentComponent) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(31);
        }
        final Ref exceptionRef = new Ref();
        TaskContainer taskContainer = new TaskContainer(task){

            @Override
            public void run() {
                try {
                    new TaskRunnable(task, CoreProgressManager.this.getProgressIndicator()).run();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    exceptionRef.set(e);
                }
            }
        };
        ApplicationEx application = (ApplicationEx)ApplicationManager.getApplication();
        boolean result2 = application.runProcessWithProgressSynchronously(taskContainer, task.getTitle(), task.isCancellable(), task.getProject(), parentComponent, task.getCancelText());
        CoreProgressManager.finishTask(task, !result2, (Throwable)exceptionRef.get());
        return result2;
    }

    public void runProcessWithProgressInCurrentThread(@NotNull Task task, @NotNull ProgressIndicator progressIndicator, @NotNull ModalityState modalityState) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(32);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(33);
        }
        if (modalityState == null) {
            CoreProgressManager.$$$reportNull$$$0(34);
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register(ApplicationManager.getApplication(), (Disposable)((Object)progressIndicator));
        }
        TaskRunnable process2 = new TaskRunnable(task, progressIndicator);
        boolean processCanceled = false;
        Throwable exception = null;
        try {
            this.runProcess(process2, progressIndicator);
        }
        catch (ProcessCanceledException e) {
            processCanceled = true;
        }
        catch (Throwable e) {
            exception = e;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            CoreProgressManager.finishTask(task, processCanceled || progressIndicator.isCanceled(), exception);
        } else {
            boolean finalCanceled = processCanceled;
            Throwable finalException = exception;
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (task == null) {
                    CoreProgressManager.$$$reportNull$$$0(51);
                }
                if (progressIndicator == null) {
                    CoreProgressManager.$$$reportNull$$$0(52);
                }
                CoreProgressManager.finishTask(task, finalCanceled || progressIndicator.isCanceled(), finalException);
            }, modalityState);
        }
    }

    private static void finishTask(@NotNull Task task, boolean canceled, @Nullable Throwable error) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(35);
        }
        try {
            if (error != null) {
                task.onThrowable(error);
            } else if (canceled) {
                task.onCancel();
            } else {
                task.onSuccess();
            }
        }
        finally {
            task.onFinished();
        }
    }

    @Override
    public void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task, @NotNull ProgressIndicator progressIndicator) {
        if (task == null) {
            CoreProgressManager.$$$reportNull$$$0(36);
        }
        if (progressIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(37);
        }
        this.runProcessWithProgressAsynchronously(task, progressIndicator, null);
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return CoreProgressManager.getCurrentIndicator(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress) throws ProcessCanceledException {
        block12: {
            boolean modal;
            if (process2 == null) {
                CoreProgressManager.$$$reportNull$$$0(38);
            }
            boolean bl = modal = progress != null && progress.isModal();
            if (modal) {
                this.myCurrentModalProgressCount.incrementAndGet();
            }
            if (progress == null) {
                this.myCurrentUnsafeProgressCount.incrementAndGet();
            }
            try {
                boolean set2;
                ProgressIndicator oldIndicator = null;
                boolean bl2 = set2 = progress != null && progress != (oldIndicator = this.getProgressIndicator());
                if (set2) {
                    Thread currentThread = Thread.currentThread();
                    CoreProgressManager.setCurrentIndicator(currentThread, progress);
                    try {
                        this.registerIndicatorAndRun(progress, currentThread, oldIndicator, process2);
                        break block12;
                    }
                    finally {
                        CoreProgressManager.setCurrentIndicator(currentThread, oldIndicator);
                    }
                }
                process2.run();
            }
            finally {
                if (progress == null) {
                    this.myCurrentUnsafeProgressCount.decrementAndGet();
                }
                if (modal) {
                    this.myCurrentModalProgressCount.decrementAndGet();
                }
            }
        }
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action2, @Nullable ProgressIndicator indicator) {
        if (action2 == null) {
            CoreProgressManager.$$$reportNull$$$0(39);
        }
        ApplicationManager.getApplication().runReadAction(action2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerIndicatorAndRun(@NotNull ProgressIndicator indicator, @NotNull Thread currentThread, ProgressIndicator oldIndicator, @NotNull Runnable process2) {
        ProgressIndicator thisIndicator;
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(40);
        }
        if (currentThread == null) {
            CoreProgressManager.$$$reportNull$$$0(41);
        }
        if (process2 == null) {
            CoreProgressManager.$$$reportNull$$$0(42);
        }
        ArrayList<Set<Thread>> threadsUnderThisIndicator = new ArrayList<Set<Thread>>();
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            thisIndicator = indicator;
            while (thisIndicator != null) {
                Set<Thread> underIndicator = threadsUnderIndicator.get(thisIndicator);
                if (underIndicator == null) {
                    underIndicator = new SmartHashSet<Thread>();
                    threadsUnderIndicator.put(thisIndicator, underIndicator);
                }
                boolean alreadyUnder = !underIndicator.add(currentThread);
                threadsUnderThisIndicator.add(alreadyUnder ? null : underIndicator);
                boolean isStandard = thisIndicator instanceof StandardProgressIndicator;
                if (!isStandard) {
                    nonStandardIndicators.add(thisIndicator);
                    this.startBackgroundNonStandardIndicatorsPing();
                }
                if (thisIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                } else {
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
                thisIndicator = thisIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator() : null;
            }
            this.updateShouldCheckCanceled();
        }
        try {
            process2.run();
            map2 = threadsUnderIndicator;
        }
        catch (Throwable throwable) {
            Map<ProgressIndicator, Set<Thread>> map3 = threadsUnderIndicator;
            synchronized (map3) {
                ProgressIndicator thisIndicator2 = null;
                for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                    boolean isStandard;
                    boolean removed2;
                    thisIndicator2 = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator2).getOriginalProgressIndicator();
                    Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                    boolean bl = removed2 = underIndicator != null && underIndicator.remove(currentThread);
                    if (removed2 && underIndicator.isEmpty()) {
                        threadsUnderIndicator.remove(thisIndicator2);
                    }
                    if (!(isStandard = thisIndicator2 instanceof StandardProgressIndicator)) {
                        nonStandardIndicators.remove(thisIndicator2);
                        if (nonStandardIndicators.isEmpty()) {
                            this.stopBackgroundNonStandardIndicatorsPing();
                        }
                    }
                    if (oldIndicator != null && oldIndicator.isCanceled()) {
                        threadsUnderCanceledIndicator.add(currentThread);
                        continue;
                    }
                    threadsUnderCanceledIndicator.remove(currentThread);
                }
                this.updateShouldCheckCanceled();
            }
            throw throwable;
        }
        synchronized (map2) {
            thisIndicator = null;
            for (int i = 0; i < threadsUnderThisIndicator.size(); ++i) {
                boolean isStandard;
                boolean removed3;
                thisIndicator = i == 0 ? indicator : ((WrappedProgressIndicator)thisIndicator).getOriginalProgressIndicator();
                Set underIndicator = (Set)threadsUnderThisIndicator.get(i);
                boolean bl = removed3 = underIndicator != null && underIndicator.remove(currentThread);
                if (removed3 && underIndicator.isEmpty()) {
                    threadsUnderIndicator.remove(thisIndicator);
                }
                if (!(isStandard = thisIndicator instanceof StandardProgressIndicator)) {
                    nonStandardIndicators.remove(thisIndicator);
                    if (nonStandardIndicators.isEmpty()) {
                        this.stopBackgroundNonStandardIndicatorsPing();
                    }
                }
                if (oldIndicator != null && oldIndicator.isCanceled()) {
                    threadsUnderCanceledIndicator.add(currentThread);
                    continue;
                }
                threadsUnderCanceledIndicator.remove(currentThread);
            }
            this.updateShouldCheckCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateShouldCheckCanceled() {
        ourCheckCanceledHook = this.createCheckCanceledHook();
        if (ourCheckCanceledHook != null) {
            shouldCheckCanceled = true;
            return;
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            shouldCheckCanceled = !threadsUnderCanceledIndicator.isEmpty();
        }
    }

    @Nullable
    protected CheckCanceledHook createCheckCanceledHook() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            CoreProgressManager.$$$reportNull$$$0(43);
        }
        Map<ProgressIndicator, Set<Thread>> map2 = threadsUnderIndicator;
        synchronized (map2) {
            Set<Thread> threads = threadsUnderIndicator.get(indicator);
            if (threads != null) {
                for (Thread thread2 : threads) {
                    boolean underCancelledIndicator = false;
                    ProgressIndicator currentIndicator = CoreProgressManager.getCurrentIndicator(thread2);
                    while (currentIndicator != null) {
                        if (currentIndicator == indicator) {
                            underCancelledIndicator = true;
                            break;
                        }
                        currentIndicator = currentIndicator instanceof WrappedProgressIndicator ? ((WrappedProgressIndicator)currentIndicator).getOriginalProgressIndicator() : null;
                    }
                    if (!underCancelledIndicator) continue;
                    threadsUnderCanceledIndicator.add(thread2);
                    shouldCheckCanceled = true;
                }
            }
        }
    }

    @Override
    @NotNull
    public final NonCancelableSection startNonCancelableSection() {
        LOG.warn("Use executeNonCancelableSection() instead");
        if (this.isInNonCancelableSection()) {
            NonCancelableSection nonCancelableSection = NonCancelableSection.EMPTY;
            if (nonCancelableSection == null) {
                CoreProgressManager.$$$reportNull$$$0(45);
            }
            return nonCancelableSection;
        }
        final ProgressIndicator myOld = this.getProgressIndicator();
        final Thread currentThread = Thread.currentThread();
        NonCancelableIndicator nonCancelor = new NonCancelableIndicator(){};
        isInNonCancelableSection.set(Boolean.TRUE);
        CoreProgressManager.setCurrentIndicator(currentThread, nonCancelor);
        NonCancelableIndicator nonCancelableIndicator = nonCancelor;
        if (nonCancelableIndicator == null) {
            CoreProgressManager.$$$reportNull$$$0(46);
        }
        return nonCancelableIndicator;
    }

    @Override
    public boolean isInNonCancelableSection() {
        return isInNonCancelableSection.get() != null;
    }

    private static void setCurrentIndicator(@NotNull Thread currentThread, ProgressIndicator indicator) {
        if (currentThread == null) {
            CoreProgressManager.$$$reportNull$$$0(48);
        }
        long id = currentThread.getId();
        if (indicator == null) {
            currentIndicators.remove(id);
            threadTopLevelIndicators.remove(id);
        } else {
            currentIndicators.put(id, indicator);
            if (!threadTopLevelIndicators.containsKey(id)) {
                threadTopLevelIndicators.put(id, indicator);
            }
        }
    }

    private static ProgressIndicator getCurrentIndicator(@NotNull Thread thread2) {
        if (thread2 == null) {
            CoreProgressManager.$$$reportNull$$$0(49);
        }
        return currentIndicators.get(thread2.getId());
    }

    static {
        threadsUnderIndicator = new HashMap<ProgressIndicator, Set<Thread>>();
        currentIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadTopLevelIndicators = ContainerUtil.createConcurrentLongObjectMap();
        threadsUnderCanceledIndicator = new HashSet<Thread>();
        nonStandardIndicators = ConcurrentHashMultiset.create();
        isInNonCancelableSection = new ThreadLocal();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 25: 
            case 29: 
            case 45: 
            case 46: 
            case 47: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 25: 
            case 29: 
            case 45: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 16: 
            case 38: 
            case 42: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 51: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 22: 
            case 25: 
            case 29: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 24: 
            case 27: 
            case 33: 
            case 37: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/CoreProgressManager";
                break;
            }
            case 22: 
            case 25: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "startNonCancelableSection";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentThreadProgressModality";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isThreadUnderIndicator";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeNonCancelableSection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runSynchronously";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "runAsynchronously";
                break;
            }
            case 22: 
            case 25: 
            case 29: 
            case 45: 
            case 46: 
            case 47: {
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notifyTaskFinished";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressInCurrentThread";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "finishTask";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "executeProcessUnderProgress";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "registerIndicatorAndRun";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "indicatorCanceled";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isCanceledThread";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentIndicator";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentIndicator";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "assertUnderProgress";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runProcessWithProgressInCurrentThread$5";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runAsynchronously$4";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runSynchronously$3";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runProcess$2";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runProcess$1";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 22: 
            case 25: 
            case 29: 
            case 45: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    protected static interface CheckCanceledHook {
        public boolean runHook(@Nullable ProgressIndicator var1);
    }

    static class TaskRunnable
    extends TaskContainer {
        private final ProgressIndicator myIndicator;
        private final Runnable myContinuation;

        TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator) {
            if (task == null) {
                TaskRunnable.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                TaskRunnable.$$$reportNull$$$0(1);
            }
            this(task, indicator, null);
        }

        TaskRunnable(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation2) {
            if (task == null) {
                TaskRunnable.$$$reportNull$$$0(2);
            }
            if (indicator == null) {
                TaskRunnable.$$$reportNull$$$0(3);
            }
            super(task);
            this.myIndicator = indicator;
            this.myContinuation = continuation2;
        }

        @Override
        public void run() {
            try {
                this.getTask().run(this.myIndicator);
            }
            finally {
                try {
                    if (this.myIndicator instanceof ProgressIndicatorEx) {
                        ((ProgressIndicatorEx)this.myIndicator).finish(this.getTask());
                    }
                }
                finally {
                    if (this.myContinuation != null) {
                        this.myContinuation.run();
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "task";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indicator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/progress/impl/CoreProgressManager$TaskRunnable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class TaskContainer
    implements Runnable {
        private final Task myTask;

        protected TaskContainer(@NotNull Task task) {
            if (task == null) {
                TaskContainer.$$$reportNull$$$0(0);
            }
            this.myTask = task;
        }

        @NotNull
        public Task getTask() {
            Task task = this.myTask;
            if (task == null) {
                TaskContainer.$$$reportNull$$$0(1);
            }
            return task;
        }

        public String toString() {
            return this.myTask.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/progress/impl/CoreProgressManager$TaskContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IndicatorDisposable
    implements Disposable {
        @NotNull
        private final ProgressIndicator myIndicator;

        IndicatorDisposable(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndicatorDisposable.$$$reportNull$$$0(0);
            }
            this.myIndicator = indicator;
        }

        @Override
        public void dispose() {
            Disposer.dispose((Disposable)((Object)this.myIndicator), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/impl/CoreProgressManager$IndicatorDisposable", "<init>"));
        }
    }
}

