/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageDirectoryCache {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.PackageDirectoryCache");
    private final MultiMap<String, VirtualFile> myRootsByPackagePrefix;
    private final Map<String, PackageInfo> myDirectoriesByPackageNameCache;
    private final Set<String> myNonExistentPackages;

    public PackageDirectoryCache(@NotNull MultiMap<String, VirtualFile> rootsByPackagePrefix) {
        if (rootsByPackagePrefix == null) {
            PackageDirectoryCache.$$$reportNull$$$0(0);
        }
        this.myRootsByPackagePrefix = MultiMap.create();
        this.myDirectoriesByPackageNameCache = ContainerUtil.newConcurrentMap();
        this.myNonExistentPackages = ContainerUtil.newConcurrentSet();
        for (String prefix : rootsByPackagePrefix.keySet()) {
            for (VirtualFile file2 : rootsByPackagePrefix.get(prefix)) {
                if (!file2.isValid()) {
                    LOG.error("Invalid root: " + file2);
                    continue;
                }
                this.myRootsByPackagePrefix.putValue(prefix, file2);
            }
        }
    }

    @NotNull
    public List<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(1);
        }
        List<Object> list2 = (info = this.getPackageInfo(packageName)) == null ? Collections.emptyList() : info.myPackageDirectories;
        if (list2 == null) {
            PackageDirectoryCache.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Nullable
    private PackageInfo getPackageInfo(@NotNull String packageName) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(3);
        }
        if ((info = this.myDirectoriesByPackageNameCache.get(packageName)) == null) {
            if (this.myNonExistentPackages.contains(packageName)) {
                return null;
            }
            if (packageName.length() > Registry.intValue("java.max.package.name.length") || StringUtil.containsAnyChar(packageName, ";[/")) {
                return null;
            }
            List<VirtualFile> result2 = ContainerUtil.newSmartList();
            if (StringUtil.isNotEmpty(packageName) && !StringUtil.startsWithChar(packageName, '.')) {
                int i = packageName.lastIndexOf(46);
                while (true) {
                    PackageInfo parentInfo;
                    if ((parentInfo = this.getPackageInfo(i > 0 ? packageName.substring(0, i) : "")) != null) {
                        result2.addAll(parentInfo.getSubPackageDirectories(packageName.substring(i + 1)));
                    }
                    if (i < 0) break;
                    i = packageName.lastIndexOf(46, i - 1);
                    ProgressManager.checkCanceled();
                }
            }
            for (VirtualFile file2 : this.myRootsByPackagePrefix.get(packageName)) {
                if (!file2.isDirectory()) continue;
                result2.add(file2);
            }
            if (!result2.isEmpty()) {
                info = new PackageInfo(packageName, result2);
                this.myDirectoriesByPackageNameCache.put(packageName, info);
            } else {
                this.myNonExistentPackages.add(packageName);
            }
        }
        return info;
    }

    public Set<String> getSubpackageNames(@NotNull String packageName) {
        PackageInfo info;
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(4);
        }
        return (info = this.getPackageInfo(packageName)) == null ? Collections.emptySet() : Collections.unmodifiableSet(info.mySubPackages.getValue().keySet());
    }

    protected boolean isPackageDirectory(@NotNull VirtualFile dir, @NotNull String packageName) {
        if (dir == null) {
            PackageDirectoryCache.$$$reportNull$$$0(7);
        }
        if (packageName == null) {
            PackageDirectoryCache.$$$reportNull$$$0(8);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsByPackagePrefix";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/PackageDirectoryCache";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/PackageDirectoryCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPackageInfo";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSubpackageNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDirectory";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class PackageInfo {
        final String myQname;
        final List<VirtualFile> myPackageDirectories;
        final NotNullLazyValue<MultiMap<String, VirtualFile>> mySubPackages = new VolatileNotNullLazyValue<MultiMap<String, VirtualFile>>(){

            @Override
            @NotNull
            protected MultiMap<String, VirtualFile> compute() {
                MultiMap<String, VirtualFile> result2 = MultiMap.createLinked();
                for (VirtualFile directory : PackageInfo.this.myPackageDirectories) {
                    for (VirtualFile child : directory.getChildren()) {
                        String packageName;
                        String childName = child.getName();
                        String string2 = packageName = PackageInfo.this.myQname.isEmpty() ? childName : PackageInfo.this.myQname + "." + childName;
                        if (!child.isDirectory() || !PackageDirectoryCache.this.isPackageDirectory(child, packageName)) continue;
                        result2.putValue(childName, child);
                    }
                }
                MultiMap<String, VirtualFile> multiMap = result2;
                if (multiMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return multiMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo$1", "compute"));
            }
        };

        PackageInfo(String qname, List<VirtualFile> packageDirectories) {
            this.myQname = qname;
            this.myPackageDirectories = packageDirectories;
        }

        @NotNull
        Collection<VirtualFile> getSubPackageDirectories(String shortName) {
            Collection<VirtualFile> collection = this.mySubPackages.getValue().get(shortName);
            if (collection == null) {
                PackageInfo.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/PackageDirectoryCache$PackageInfo", "getSubPackageDirectories"));
        }
    }
}

