/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecursionManager {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.RecursionManager");
    private static final Object NULL = new Object();
    private static final ThreadLocal<CalculationStack> ourStack = new ThreadLocal<CalculationStack>(){

        @Override
        protected CalculationStack initialValue() {
            return new CalculationStack();
        }
    };
    private static boolean ourAssertOnPrevention;

    @Nullable
    public static <T> T doPreventingRecursion(@NotNull Object key, boolean memoize, Computable<T> computation) {
        if (key == null) {
            RecursionManager.$$$reportNull$$$0(0);
        }
        return RecursionManager.createGuard(computation.getClass().getName()).doPreventingRecursion(key, memoize, computation);
    }

    @NotNull
    public static RecursionGuard createGuard(final @NonNls String id) {
        RecursionGuard recursionGuard = new RecursionGuard(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> T doPreventingRecursion(@NotNull Object key, boolean memoize, @NotNull Computable<T> computation) {
                Object o;
                if (key == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (computation == null) {
                    2.$$$reportNull$$$0(1);
                }
                MyKey realKey = new MyKey(id, key, true);
                CalculationStack stack = (CalculationStack)ourStack.get();
                if (stack.checkReentrancy(realKey)) {
                    if (ourAssertOnPrevention) {
                        throw new AssertionError((Object)"Endless recursion prevention occurred");
                    }
                    return null;
                }
                if (memoize && (o = stack.getMemoizedValue(realKey)) != null) {
                    Map map2 = (Map)stack.intermediateCache.get(realKey);
                    if (map2 != null) {
                        for (MyKey noCacheUntil : map2.keySet()) {
                            stack.prohibitResultCaching(noCacheUntil);
                        }
                    }
                    return (T)(o == NULL ? null : o);
                }
                realKey = new MyKey(id, key, false);
                int sizeBefore = stack.progressMap.size();
                stack.beforeComputation(realKey);
                int sizeAfter = stack.progressMap.size();
                int startStamp = stack.memoizationStamp;
                try {
                    T result2 = computation.compute();
                    if (memoize) {
                        stack.maybeMemoize(realKey, result2 == null ? NULL : result2, startStamp);
                    }
                    T t = result2;
                    return t;
                }
                finally {
                    try {
                        stack.afterComputation(realKey, sizeBefore, sizeAfter);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Throwable in afterComputation", e);
                    }
                    stack.checkDepth("4");
                }
            }

            @Override
            @NotNull
            public RecursionGuard.StackStamp markStack() {
                final int stamp = ((CalculationStack)ourStack.get()).reentrancyCount;
                RecursionGuard.StackStamp stackStamp = new RecursionGuard.StackStamp(){

                    @Override
                    public boolean mayCacheNow() {
                        return stamp == ((CalculationStack)ourStack.get()).reentrancyCount;
                    }
                };
                if (stackStamp == null) {
                    2.$$$reportNull$$$0(2);
                }
                return stackStamp;
            }

            @Override
            @NotNull
            public List<Object> currentStack() {
                ArrayList<Object> result2 = new ArrayList<Object>();
                LinkedHashMap map2 = ((CalculationStack)ourStack.get()).progressMap;
                for (MyKey pair : map2.keySet()) {
                    if (!pair.guardId.equals(id)) continue;
                    result2.add(pair.userObject);
                }
                ArrayList<Object> arrayList = result2;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "computation";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/util/RecursionManager$2";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "since";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/util/RecursionManager$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "markStack";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "currentStack";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doPreventingRecursion";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "prohibitResultCaching";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (recursionGuard == null) {
            RecursionManager.$$$reportNull$$$0(1);
        }
        return recursionGuard;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/RecursionManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/RecursionManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doPreventingRecursion";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertOnRecursionPrevention";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CalculationStack {
        private int reentrancyCount;
        private int memoizationStamp;
        private int depth;
        private final LinkedHashMap<MyKey, Integer> progressMap = new LinkedHashMap();
        private final Set<MyKey> toMemoize = new THashSet<MyKey>();
        private final THashMap<MyKey, MyKey> key2ReentrancyDuringItsCalculation = new THashMap();
        private final Map<MyKey, Map<MyKey, Object>> intermediateCache = ContainerUtil.createSoftMap();
        private int enters;
        private int exits;

        private CalculationStack() {
        }

        boolean checkReentrancy(MyKey realKey) {
            if (this.progressMap.containsKey(realKey)) {
                this.enableMemoization(realKey, this.prohibitResultCaching(realKey));
                return true;
            }
            return false;
        }

        @Nullable
        Object getMemoizedValue(MyKey realKey) {
            Map<MyKey, Object> map2 = this.intermediateCache.get(realKey);
            if (map2 == null) {
                return null;
            }
            if (this.depth == 0) {
                throw new AssertionError((Object)"Memoized values with empty stack");
            }
            for (MyKey key : map2.keySet()) {
                Object result2 = map2.get(key);
                if (result2 == null) continue;
                return result2;
            }
            return null;
        }

        final void beforeComputation(MyKey realKey) {
            ++this.enters;
            if (this.progressMap.isEmpty()) assert (this.reentrancyCount == 0) : "Non-zero stamp with empty stack: " + this.reentrancyCount;
            this.checkDepth("1");
            int sizeBefore = this.progressMap.size();
            this.progressMap.put(realKey, this.reentrancyCount);
            ++this.depth;
            this.checkDepth("2");
            int sizeAfter = this.progressMap.size();
            if (sizeAfter != sizeBefore + 1) {
                LOG.error("Key doesn't lead to the map size increase: " + sizeBefore + " " + sizeAfter + " " + realKey.userObject);
            }
        }

        final void maybeMemoize(MyKey realKey, @NotNull Object result2, int startStamp) {
            if (result2 == null) {
                CalculationStack.$$$reportNull$$$0(0);
            }
            if (this.memoizationStamp == startStamp && this.toMemoize.contains(realKey)) {
                Map<MyKey, Object> map2 = this.intermediateCache.get(realKey);
                if (map2 == null) {
                    map2 = ContainerUtil.createSoftKeySoftValueMap();
                    this.intermediateCache.put(realKey, map2);
                }
                MyKey reentered = this.key2ReentrancyDuringItsCalculation.get(realKey);
                assert (reentered != null);
                map2.put(reentered, result2);
            }
        }

        final void afterComputation(MyKey realKey, int sizeBefore, int sizeAfter) {
            ++this.exits;
            if (sizeAfter != this.progressMap.size()) {
                LOG.error("Map size changed: " + this.progressMap.size() + " " + sizeAfter + " " + realKey.userObject);
            }
            if (this.depth != this.progressMap.size()) {
                LOG.error("Inconsistent depth after computation; depth=" + this.depth + "; map=" + this.progressMap);
            }
            Integer value2 = (Integer)this.progressMap.remove(realKey);
            --this.depth;
            this.toMemoize.remove(realKey);
            this.key2ReentrancyDuringItsCalculation.remove(realKey);
            if (this.depth == 0) {
                this.intermediateCache.clear();
                if (!this.key2ReentrancyDuringItsCalculation.isEmpty()) {
                    LOG.error("non-empty key2ReentrancyDuringItsCalculation: " + new HashMap<MyKey, MyKey>(this.key2ReentrancyDuringItsCalculation));
                }
                if (!this.toMemoize.isEmpty()) {
                    LOG.error("non-empty toMemoize: " + new HashSet<MyKey>(this.toMemoize));
                }
            }
            if (sizeBefore != this.progressMap.size()) {
                LOG.error("Map size doesn't decrease: " + this.progressMap.size() + " " + sizeBefore + " " + realKey.userObject);
            }
            this.reentrancyCount = value2;
            this.checkZero();
        }

        private void enableMemoization(MyKey realKey, Set<MyKey> loop) {
            this.toMemoize.addAll(loop);
            ArrayList<MyKey> stack = new ArrayList<MyKey>(this.progressMap.keySet());
            for (MyKey key : loop) {
                MyKey existing = this.key2ReentrancyDuringItsCalculation.get(key);
                if (existing != null && stack.indexOf(realKey) < stack.indexOf(key)) continue;
                this.key2ReentrancyDuringItsCalculation.put(key, realKey);
            }
        }

        private Set<MyKey> prohibitResultCaching(MyKey realKey) {
            ++this.reentrancyCount;
            if (!this.checkZero()) {
                throw new AssertionError((Object)"zero1");
            }
            THashSet<MyKey> loop = new THashSet<MyKey>();
            boolean inLoop = false;
            for (Map.Entry<MyKey, Integer> entry : new ArrayList<Map.Entry<MyKey, Integer>>(this.progressMap.entrySet())) {
                if (inLoop) {
                    entry.setValue(this.reentrancyCount);
                    loop.add(entry.getKey());
                    continue;
                }
                if (!entry.getKey().equals(realKey)) continue;
                inLoop = true;
            }
            if (!this.checkZero()) {
                throw new AssertionError((Object)"zero2");
            }
            return loop;
        }

        private void checkDepth(String s) {
            int oldDepth = this.depth;
            if (oldDepth != this.progressMap.size()) {
                this.depth = this.progressMap.size();
                throw new AssertionError((Object)("_Inconsistent depth " + s + "; depth=" + oldDepth + "; enters=" + this.enters + "; exits=" + this.exits + "; map=" + this.progressMap));
            }
        }

        private boolean checkZero() {
            if (!this.progressMap.isEmpty() && !new Integer(0).equals(this.progressMap.get(this.progressMap.keySet().iterator().next()))) {
                LOG.error("Prisoner Zero has escaped: " + this.progressMap + "; value=" + this.progressMap.get(this.progressMap.keySet().iterator().next()));
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/util/RecursionManager$CalculationStack", "maybeMemoize"));
        }
    }

    private static class MyKey {
        final String guardId;
        final Object userObject;
        private final int myHashCode;
        private final boolean myCallEquals;

        public MyKey(String guardId, @NotNull Object userObject, boolean mayCallEquals) {
            if (userObject == null) {
                MyKey.$$$reportNull$$$0(0);
            }
            this.guardId = guardId;
            this.userObject = userObject;
            this.myHashCode = guardId.hashCode() * 31 + userObject.hashCode();
            this.myCallEquals = mayCallEquals;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyKey) || !this.guardId.equals(((MyKey)obj).guardId)) {
                return false;
            }
            if (this.userObject == ((MyKey)obj).userObject) {
                return true;
            }
            if (this.myCallEquals || ((MyKey)obj).myCallEquals) {
                return this.userObject.equals(((MyKey)obj).userObject);
            }
            return false;
        }

        public int hashCode() {
            return this.myHashCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/intellij/openapi/util/RecursionManager$MyKey", "<init>"));
        }
    }
}

