/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.openapi.util.objectTree.ObjectTreeListener;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectTree<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.objectTree.ObjectTree");
    private final List<ObjectTreeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<T> myRootObjects = ContainerUtil.newIdentityTroveSet();
    private final Map<T, ObjectNode<T>> myObject2NodeMap = ContainerUtil.newIdentityTroveMap();
    private final Map<Object, Object> myDisposedObjects = ContainerUtil.createWeakMap(100, 0.5f, ContainerUtil.identityStrategy());
    private final List<ObjectNode<T>> myExecutedNodes = new ArrayList<ObjectNode<T>>();
    private final List<T> myExecutedUnregisteredNodes = new ArrayList<T>();
    final Object treeLock = new Object();
    private final AtomicLong myModification = new AtomicLong(0L);

    ObjectNode<T> getNode(@NotNull T object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(0);
        }
        return this.myObject2NodeMap.get(object);
    }

    void putNode(@NotNull T object, @Nullable(value="null means remove") ObjectNode<T> node) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(1);
        }
        if (node == null) {
            this.myObject2NodeMap.remove(object);
        } else {
            this.myObject2NodeMap.put(object, node);
        }
    }

    @NotNull
    final List<ObjectNode<T>> getNodesInExecution() {
        List<ObjectNode<T>> list2 = this.myExecutedNodes;
        if (list2 == null) {
            ObjectTree.$$$reportNull$$$0(2);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(@NotNull T parent2, @NotNull T child) {
        if (parent2 == null) {
            ObjectTree.$$$reportNull$$$0(3);
        }
        if (child == null) {
            ObjectTree.$$$reportNull$$$0(4);
        }
        if (parent2 == child) {
            throw new IllegalArgumentException("Cannot register to itself: " + parent2);
        }
        Object object = this.treeLock;
        synchronized (object) {
            ObjectNode<T> childNode;
            Object wasDisposed = this.getDisposalInfo(parent2);
            if (wasDisposed != null) {
                throw new IncorrectOperationException("Sorry but parent: " + parent2 + " has already been disposed (see the cause for stacktrace) so the child: " + child + " will never be disposed", wasDisposed instanceof Throwable ? (Throwable)wasDisposed : null);
            }
            if (this.isDisposing(parent2)) {
                throw new IncorrectOperationException("Sorry but parent: " + parent2 + " is being disposed so the child: " + child + " will never be disposed");
            }
            this.myDisposedObjects.remove(child);
            ObjectNode<T> parentNode = this.getNode(parent2);
            if (parentNode == null) {
                parentNode = this.createNodeFor(parent2, null);
            }
            if ((childNode = this.getNode(child)) == null) {
                childNode = this.createNodeFor(child, parentNode);
            } else {
                ObjectNode<T> oldParent = childNode.getParent();
                if (oldParent != null) {
                    oldParent.removeChild(childNode);
                }
            }
            this.myRootObjects.remove(child);
            this.checkWasNotAddedAlready(parentNode, childNode);
            parentNode.addChild(childNode);
            this.fireRegistered(childNode.getObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDisposalInfo(@NotNull T parent2) {
        if (parent2 == null) {
            ObjectTree.$$$reportNull$$$0(5);
        }
        Object object = this.treeLock;
        synchronized (object) {
            return this.myDisposedObjects.get(parent2);
        }
    }

    private void checkWasNotAddedAlready(ObjectNode<T> childNode, @NotNull ObjectNode<T> parentNode) {
        if (parentNode == null) {
            ObjectTree.$$$reportNull$$$0(6);
        }
        for (ObjectNode<T> node = childNode; node != null; node = node.getParent()) {
            if (node != parentNode) continue;
            throw new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
        }
    }

    @NotNull
    private ObjectNode<T> createNodeFor(@NotNull T object, @Nullable ObjectNode<T> parentNode) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(7);
        }
        ObjectNode<T> newNode = new ObjectNode<T>(this, parentNode, object, this.getNextModification());
        if (parentNode == null) {
            this.myRootObjects.add(object);
        }
        this.putNode(object, newNode);
        ObjectNode<T> objectNode = newNode;
        if (objectNode == null) {
            ObjectTree.$$$reportNull$$$0(8);
        }
        return objectNode;
    }

    private long getNextModification() {
        return this.myModification.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeAll(@NotNull T object, @NotNull ObjectTreeAction<T> action2, boolean processUnregistered) {
        ObjectNode<T> node;
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(9);
        }
        if (action2 == null) {
            ObjectTree.$$$reportNull$$$0(10);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            node = this.getNode(object);
        }
        if (node == null) {
            if (processUnregistered) {
                this.rememberDisposedTrace(object);
                this.executeUnregistered(object, action2);
            }
        } else {
            node.execute(action2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposing(@NotNull T disposable) {
        List<ObjectNode<T>> guard;
        if (disposable == null) {
            ObjectTree.$$$reportNull$$$0(11);
        }
        List<ObjectNode<T>> list2 = guard = this.getNodesInExecution();
        synchronized (list2) {
            for (ObjectNode<T> node : guard) {
                if (node.getObject() != disposable) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> void executeActionWithRecursiveGuard(@NotNull T object, @NotNull List<T> recursiveGuard, @NotNull ObjectTreeAction<T> action2) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(12);
        }
        if (recursiveGuard == null) {
            ObjectTree.$$$reportNull$$$0(13);
        }
        if (action2 == null) {
            ObjectTree.$$$reportNull$$$0(14);
        }
        List<T> list2 = recursiveGuard;
        synchronized (list2) {
            if (ArrayUtil.indexOf(recursiveGuard, object, ContainerUtil.identityStrategy()) != -1) {
                return;
            }
            recursiveGuard.add(object);
        }
        try {
            action2.execute(object);
        }
        finally {
            list2 = recursiveGuard;
            synchronized (list2) {
                int i = ArrayUtil.lastIndexOf(recursiveGuard, object, ContainerUtil.identityStrategy());
                assert (i != -1);
                recursiveGuard.remove(i);
            }
        }
    }

    private void executeUnregistered(@NotNull T object, @NotNull ObjectTreeAction<T> action2) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(15);
        }
        if (action2 == null) {
            ObjectTree.$$$reportNull$$$0(16);
        }
        ObjectTree.executeActionWithRecursiveGuard(object, this.myExecutedUnregisteredNodes, action2);
    }

    void removeRootObject(@NotNull T object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(22);
        }
        this.myRootObjects.remove(object);
    }

    private void fireRegistered(@NotNull Object object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(26);
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectRegistered(object);
        }
    }

    void fireExecuted(@NotNull Object object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(27);
        }
        for (ObjectTreeListener each : this.myListeners) {
            each.objectExecuted(object);
        }
        this.rememberDisposedTrace(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberDisposedTrace(@NotNull Object object) {
        if (object == null) {
            ObjectTree.$$$reportNull$$$0(28);
        }
        Object object2 = this.treeLock;
        synchronized (object2) {
            this.myDisposedObjects.put(object, Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : Boolean.TRUE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/objectTree/ObjectTree";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursiveGuard";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExecute";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReplace";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/objectTree/ObjectTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodesInExecution";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeFor";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putNode";
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkWasNotAddedAlready";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNodeFor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeAll";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDisposing";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeActionWithRecursiveGuard";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeUnregistered";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "executeChildAndReplace";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferenceKeptInTree";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeRootObject";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fireRegistered";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fireExecuted";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "rememberDisposedTrace";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredObject";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 8: 
            case 23: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

