/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiNameHelper {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?:\\s)|(?:/\\*.*\\*/)|(?://[^\\n]*)");

    public static PsiNameHelper getInstance(Project project) {
        return ServiceManager.getService(project, PsiNameHelper.class);
    }

    public abstract boolean isIdentifier(@Nullable String var1);

    public abstract boolean isIdentifier(@Nullable String var1, @NotNull LanguageLevel var2);

    public abstract boolean isKeyword(@Nullable String var1);

    public abstract boolean isQualifiedName(@Nullable String var1);

    @NotNull
    public static String getShortClassName(@NotNull String referenceText) {
        int i;
        if (referenceText == null) {
            PsiNameHelper.$$$reportNull$$$0(0);
        }
        int lessPos = referenceText.length();
        int bracesBalance = 0;
        block5: for (i = referenceText.length() - 1; i >= 0; --i) {
            char ch = referenceText.charAt(i);
            switch (ch) {
                case ')': 
                case '>': {
                    ++bracesBalance;
                    continue block5;
                }
                case '(': 
                case '<': {
                    --bracesBalance;
                    lessPos = i;
                    continue block5;
                }
                case '.': 
                case '@': {
                    if (bracesBalance > 0) continue block5;
                    break block5;
                }
                default: {
                    if (!Character.isWhitespace(ch) || bracesBalance > 0) continue block5;
                    for (int j = i + 1; j < lessPos; ++j) {
                        if (!Character.isWhitespace(referenceText.charAt(j))) break block5;
                    }
                    lessPos = i;
                }
            }
        }
        String string2 = referenceText.substring(i + 1, lessPos).trim();
        if (string2 == null) {
            PsiNameHelper.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static String getPresentableText(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            PsiNameHelper.$$$reportNull$$$0(2);
        }
        String name2 = ref.getReferenceName();
        PsiAnnotation[] annotations2 = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)ref, PsiAnnotation.class);
        String string2 = PsiNameHelper.getPresentableText(name2, ObjectUtils.notNull(annotations2, PsiAnnotation.EMPTY_ARRAY), ref.getTypeParameters());
        if (string2 == null) {
            PsiNameHelper.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @NotNull
    public static String getPresentableText(@Nullable String refName, @NotNull PsiAnnotation[] annotations2, @NotNull PsiType[] types) {
        if (annotations2 == null) {
            PsiNameHelper.$$$reportNull$$$0(4);
        }
        if (types == null) {
            PsiNameHelper.$$$reportNull$$$0(5);
        }
        if (types.length == 0 && annotations2.length == 0) {
            String string2 = refName != null ? refName : "";
            if (string2 == null) {
                PsiNameHelper.$$$reportNull$$$0(6);
            }
            return string2;
        }
        StringBuilder buffer = new StringBuilder();
        PsiNameHelper.appendAnnotations(buffer, annotations2, false);
        buffer.append(refName);
        PsiNameHelper.appendTypeArgs(buffer, types, false, true);
        String string3 = buffer.toString();
        if (string3 == null) {
            PsiNameHelper.$$$reportNull$$$0(7);
        }
        return string3;
    }

    @NotNull
    public static String getQualifiedClassName(@NotNull String referenceText, boolean removeWhitespace) {
        if (referenceText == null) {
            PsiNameHelper.$$$reportNull$$$0(8);
        }
        if (removeWhitespace) {
            referenceText = PsiNameHelper.removeWhitespace(referenceText);
        }
        if (referenceText.indexOf(60) < 0) {
            String string2 = referenceText;
            if (string2 == null) {
                PsiNameHelper.$$$reportNull$$$0(9);
            }
            return string2;
        }
        StringBuilder buffer = new StringBuilder(referenceText.length());
        char[] chars = referenceText.toCharArray();
        int gtPos = 0;
        int count2 = 0;
        block4: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++count2 != 1) continue block4;
                    buffer.append(new String(chars, gtPos, i - gtPos));
                    continue block4;
                }
                case '>': {
                    --count2;
                    gtPos = i + 1;
                }
            }
        }
        if (count2 == 0) {
            buffer.append(new String(chars, gtPos, chars.length - gtPos));
        }
        String string3 = buffer.toString();
        if (string3 == null) {
            PsiNameHelper.$$$reportNull$$$0(10);
        }
        return string3;
    }

    private static String removeWhitespace(@NotNull String referenceText) {
        if (referenceText == null) {
            PsiNameHelper.$$$reportNull$$$0(11);
        }
        boolean needsChange = false;
        for (int i = 0; i < referenceText.length(); ++i) {
            char c = referenceText.charAt(i);
            if (c != '/' && !Character.isWhitespace(c)) continue;
            needsChange = true;
            break;
        }
        if (!needsChange) {
            return referenceText;
        }
        return WHITESPACE_PATTERN.matcher(referenceText).replaceAll("");
    }

    @NotNull
    public static String[] getClassParametersText(@NotNull String referenceText) {
        if (referenceText == null) {
            PsiNameHelper.$$$reportNull$$$0(12);
        }
        if (referenceText.indexOf(60) < 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                PsiNameHelper.$$$reportNull$$$0(13);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        char[] chars = referenceText.toCharArray();
        int afterLastDotIndex = 0;
        int level = 0;
        block15: for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    ++level;
                    continue block15;
                }
                case '.': {
                    if (level != 0) continue block15;
                    afterLastDotIndex = i + 1;
                    continue block15;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                PsiNameHelper.$$$reportNull$$$0(14);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        int dim = 0;
        block16: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case ',': {
                    if (level != 1) continue block16;
                    ++dim;
                    continue block16;
                }
                case '>': {
                    --level;
                }
            }
        }
        if (level != 0 || dim == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                PsiNameHelper.$$$reportNull$$$0(15);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] result2 = new String[dim];
        dim = 0;
        int ltPos = 0;
        block17: for (int i = afterLastDotIndex; i < chars.length; ++i) {
            char aChar = chars[i];
            switch (aChar) {
                case '<': {
                    if (++level != 1) continue block17;
                    ltPos = i;
                    continue block17;
                }
                case ',': {
                    if (level != 1) continue block17;
                    result2[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                    ltPos = i;
                    continue block17;
                }
                case '>': {
                    if (--level != 0) continue block17;
                    result2[dim++] = new String(chars, ltPos + 1, i - ltPos - 1);
                }
            }
        }
        if (result2 == null) {
            PsiNameHelper.$$$reportNull$$$0(16);
        }
        return result2;
    }

    public static boolean isSubpackageOf(@NotNull String subpackageName, @NotNull String packageName) {
        if (subpackageName == null) {
            PsiNameHelper.$$$reportNull$$$0(17);
        }
        if (packageName == null) {
            PsiNameHelper.$$$reportNull$$$0(18);
        }
        return subpackageName.equals(packageName) || subpackageName.startsWith(packageName) && subpackageName.charAt(packageName.length()) == '.';
    }

    public static void appendTypeArgs(@NotNull StringBuilder sb, @NotNull PsiType[] types, boolean canonical, boolean annotated) {
        if (sb == null) {
            PsiNameHelper.$$$reportNull$$$0(19);
        }
        if (types == null) {
            PsiNameHelper.$$$reportNull$$$0(20);
        }
        if (types.length == 0) {
            return;
        }
        sb.append('<');
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                sb.append(canonical ? "," : ", ");
            }
            PsiType type2 = types[i];
            if (canonical) {
                sb.append(type2.getCanonicalText(annotated));
                continue;
            }
            sb.append(type2.getPresentableText());
        }
        sb.append('>');
    }

    public static boolean appendAnnotations(@NotNull StringBuilder sb, @NotNull PsiAnnotation[] annotations2, boolean canonical) {
        if (sb == null) {
            PsiNameHelper.$$$reportNull$$$0(21);
        }
        if (annotations2 == null) {
            PsiNameHelper.$$$reportNull$$$0(22);
        }
        return PsiNameHelper.appendAnnotations(sb, Arrays.asList(annotations2), canonical);
    }

    public static boolean appendAnnotations(@NotNull StringBuilder sb, @NotNull List<PsiAnnotation> annotations2, boolean canonical) {
        if (sb == null) {
            PsiNameHelper.$$$reportNull$$$0(23);
        }
        if (annotations2 == null) {
            PsiNameHelper.$$$reportNull$$$0(24);
        }
        boolean updated = false;
        for (PsiAnnotation annotation2 : annotations2) {
            if (canonical) {
                String name2 = annotation2.getQualifiedName();
                if (name2 == null) continue;
                sb.append('@').append(name2).append(annotation2.getParameterList().getText()).append(' ');
                updated = true;
                continue;
            }
            PsiJavaCodeReferenceElement refElement = annotation2.getNameReferenceElement();
            if (refElement == null) continue;
            sb.append('@').append(refElement.getText()).append(' ');
            updated = true;
        }
        return updated;
    }

    public static boolean isValidModuleName(@NotNull String name2, @NotNull PsiElement context) {
        if (name2 == null) {
            PsiNameHelper.$$$reportNull$$$0(25);
        }
        if (context == null) {
            PsiNameHelper.$$$reportNull$$$0(26);
        }
        PsiNameHelper helper = PsiNameHelper.getInstance(context.getProject());
        LanguageLevel level = PsiUtil.getLanguageLevel(context);
        return StringUtil.split(name2, ".", true, false).stream().allMatch(part -> helper.isIdentifier((String)part, level));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiNameHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subpackageName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiNameHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortClassName";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedClassName";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassParametersText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShortClassName";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedClassName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeWhitespace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClassParametersText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSubpackageOf";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendTypeArgs";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "appendAnnotations";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isValidModuleName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

