/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCodeStyleManager {
    public static final int DO_NOT_ADD_IMPORTS = 4096;
    public static final int INCOMPLETE_CODE = 8192;
    public static final int UNCOMPLETE_CODE = 8192;

    public static JavaCodeStyleManager getInstance(Project project) {
        return ServiceManager.getService(project, JavaCodeStyleManager.class);
    }

    public abstract boolean addImport(@NotNull PsiJavaFile var1, @NotNull PsiClass var2);

    @NotNull
    public abstract PsiElement shortenClassReferences(@NotNull PsiElement var1, int var2) throws IncorrectOperationException;

    @NotNull
    public abstract String getPrefixByVariableKind(@NotNull VariableKind var1);

    @NotNull
    public abstract String getSuffixByVariableKind(@NotNull VariableKind var1);

    public abstract int findEntryIndex(@NotNull PsiImportStatementBase var1);

    @NotNull
    public abstract PsiElement shortenClassReferences(@NotNull PsiElement var1) throws IncorrectOperationException;

    public abstract void shortenClassReferences(@NotNull PsiElement var1, int var2, int var3) throws IncorrectOperationException;

    public abstract void optimizeImports(@NotNull PsiFile var1) throws IncorrectOperationException;

    public abstract PsiImportList prepareOptimizeImportsResult(@NotNull PsiJavaFile var1);

    public boolean hasConflictingOnDemandImport(@NotNull PsiJavaFile file2, @NotNull PsiClass psiClass, @NotNull String referenceName) {
        if (file2 == null) {
            JavaCodeStyleManager.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            JavaCodeStyleManager.$$$reportNull$$$0(1);
        }
        if (referenceName == null) {
            JavaCodeStyleManager.$$$reportNull$$$0(2);
        }
        return false;
    }

    @NotNull
    public VariableKind getVariableKind(@NotNull PsiVariable variable2) {
        if (variable2 == null) {
            JavaCodeStyleManager.$$$reportNull$$$0(3);
        }
        if (variable2 instanceof PsiField) {
            if (variable2.hasModifierProperty("static")) {
                if (variable2.hasModifierProperty("final")) {
                    VariableKind variableKind = VariableKind.STATIC_FINAL_FIELD;
                    if (variableKind == null) {
                        JavaCodeStyleManager.$$$reportNull$$$0(4);
                    }
                    return variableKind;
                }
                VariableKind variableKind = VariableKind.STATIC_FIELD;
                if (variableKind == null) {
                    JavaCodeStyleManager.$$$reportNull$$$0(5);
                }
                return variableKind;
            }
            VariableKind variableKind = VariableKind.FIELD;
            if (variableKind == null) {
                JavaCodeStyleManager.$$$reportNull$$$0(6);
            }
            return variableKind;
        }
        if (variable2 instanceof PsiParameter) {
            if (((PsiParameter)variable2).getDeclarationScope() instanceof PsiForeachStatement) {
                VariableKind variableKind = VariableKind.LOCAL_VARIABLE;
                if (variableKind == null) {
                    JavaCodeStyleManager.$$$reportNull$$$0(7);
                }
                return variableKind;
            }
            VariableKind variableKind = VariableKind.PARAMETER;
            if (variableKind == null) {
                JavaCodeStyleManager.$$$reportNull$$$0(8);
            }
            return variableKind;
        }
        VariableKind variableKind = VariableKind.LOCAL_VARIABLE;
        if (variableKind == null) {
            JavaCodeStyleManager.$$$reportNull$$$0(9);
        }
        return variableKind;
    }

    public SuggestedNameInfo suggestVariableName(@NotNull VariableKind kind, @Nullable String propertyName, @Nullable PsiExpression expr, @Nullable PsiType type2) {
        if (kind == null) {
            JavaCodeStyleManager.$$$reportNull$$$0(10);
        }
        return this.suggestVariableName(kind, propertyName, expr, type2, true);
    }

    @NotNull
    public SuggestedNameInfo suggestCompiledParameterName(@NotNull PsiType type2) {
        if (type2 == null) {
            JavaCodeStyleManager.$$$reportNull$$$0(11);
        }
        SuggestedNameInfo suggestedNameInfo = this.suggestVariableName(VariableKind.PARAMETER, null, null, type2, true);
        if (suggestedNameInfo == null) {
            JavaCodeStyleManager.$$$reportNull$$$0(12);
        }
        return suggestedNameInfo;
    }

    @NotNull
    public abstract SuggestedNameInfo suggestVariableName(@NotNull VariableKind var1, @Nullable String var2, @Nullable PsiExpression var3, @Nullable PsiType var4, boolean var5);

    @NotNull
    public abstract String variableNameToPropertyName(@NonNls @NotNull String var1, @NotNull VariableKind var2);

    @NotNull
    public abstract String propertyNameToVariableName(@NonNls @NotNull String var1, @NotNull VariableKind var2);

    @NotNull
    public abstract String suggestUniqueVariableName(@NonNls @NotNull String var1, PsiElement var2, boolean var3);

    @NotNull
    public SuggestedNameInfo suggestUniqueVariableName(@NotNull SuggestedNameInfo baseNameInfo, PsiElement place, boolean lookForward) {
        if (baseNameInfo == null) {
            JavaCodeStyleManager.$$$reportNull$$$0(13);
        }
        SuggestedNameInfo suggestedNameInfo = this.suggestUniqueVariableName(baseNameInfo, place, false, lookForward);
        if (suggestedNameInfo == null) {
            JavaCodeStyleManager.$$$reportNull$$$0(14);
        }
        return suggestedNameInfo;
    }

    @NotNull
    public abstract String suggestUniqueVariableName(@NotNull String var1, PsiElement var2, Predicate<PsiVariable> var3);

    @NotNull
    public abstract SuggestedNameInfo suggestUniqueVariableName(@NotNull SuggestedNameInfo var1, PsiElement var2, boolean var3, boolean var4);

    @NotNull
    public abstract PsiElement qualifyClassReferences(@NotNull PsiElement var1);

    public abstract void removeRedundantImports(@NotNull PsiJavaFile var1) throws IncorrectOperationException;

    @Nullable
    public abstract Collection<PsiImportStatementBase> findRedundantImports(@NotNull PsiJavaFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/JavaCodeStyleManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseNameInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/JavaCodeStyleManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableKind";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestCompiledParameterName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestUniqueVariableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasConflictingOnDemandImport";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariableKind";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestVariableName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "suggestCompiledParameterName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suggestUniqueVariableName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

