/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.Matcher;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinusculeMatcher
implements Matcher {
    private final char[] myPattern;
    private final String myHardSeparators;
    private final NameUtil.MatchingCaseSensitivity myOptions;
    private final boolean myHasHumps;
    private final boolean myHasSeparators;
    private final boolean myHasDots;
    private final boolean[] isLowerCase;
    private final boolean[] isUpperCase;
    private final boolean[] isWordSeparator;
    private final char[] toUpperCase;
    private final char[] toLowerCase;
    private final char[] myMeaningfulCharacters;
    private final int myMinNameLength;

    MinusculeMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, @NotNull String hardSeparators) {
        if (pattern == null) {
            MinusculeMatcher.$$$reportNull$$$0(0);
        }
        if (options == null) {
            MinusculeMatcher.$$$reportNull$$$0(1);
        }
        if (hardSeparators == null) {
            MinusculeMatcher.$$$reportNull$$$0(2);
        }
        this.myOptions = options;
        this.myPattern = StringUtil.trimEnd(pattern, "* ").toCharArray();
        this.myHardSeparators = hardSeparators;
        this.isLowerCase = new boolean[this.myPattern.length];
        this.isUpperCase = new boolean[this.myPattern.length];
        this.isWordSeparator = new boolean[this.myPattern.length];
        this.toUpperCase = new char[this.myPattern.length];
        this.toLowerCase = new char[this.myPattern.length];
        StringBuilder meaningful = new StringBuilder();
        for (int k = 0; k < this.myPattern.length; ++k) {
            char c = this.myPattern[k];
            this.isLowerCase[k] = Character.isLowerCase(c);
            this.isUpperCase[k] = Character.isUpperCase(c);
            this.isWordSeparator[k] = MinusculeMatcher.isWordSeparator(c);
            this.toUpperCase[k] = StringUtil.toUpperCase(c);
            this.toLowerCase[k] = StringUtil.toLowerCase(c);
            if (this.isWildcard(k)) continue;
            meaningful.append(this.toLowerCase[k]);
            meaningful.append(this.toUpperCase[k]);
        }
        int i = 0;
        while (this.isWildcard(i)) {
            ++i;
        }
        this.myHasHumps = this.hasFlag(i + 1, this.isUpperCase) && this.hasFlag(i, this.isLowerCase);
        this.myHasSeparators = this.hasFlag(i, this.isWordSeparator);
        this.myHasDots = this.hasDots(i);
        this.myMeaningfulCharacters = meaningful.toString().toCharArray();
        this.myMinNameLength = this.myMeaningfulCharacters.length / 2;
    }

    private static boolean isWordSeparator(char c) {
        return Character.isWhitespace(c) || c == '_' || c == '-' || c == ':' || c == '+' || c == '.';
    }

    private static int nextWord(@NotNull String name2, int start) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(3);
        }
        if (start < name2.length() && Character.isDigit(name2.charAt(start))) {
            return start + 1;
        }
        return NameUtil.nextWord(name2, start);
    }

    private boolean hasFlag(int start, boolean[] flags) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (!flags[i]) continue;
            return true;
        }
        return false;
    }

    private boolean hasDots(int start) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (this.myPattern[i] != '.') continue;
            return true;
        }
        return false;
    }

    private static FList<TextRange> prependRange(@NotNull FList<TextRange> ranges2, int from, int length) {
        TextRange head;
        if (ranges2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(4);
        }
        if ((head = ranges2.getHead()) != null && head.getStartOffset() == from + length) {
            return ranges2.getTail().prepend(new TextRange(from, head.getEndOffset()));
        }
        return ranges2.prepend(TextRange.from(from, length));
    }

    public int matchingDegree(@NotNull String name2) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(5);
        }
        return this.matchingDegree(name2, false);
    }

    public int matchingDegree(@NotNull String name2, boolean valueStartCaseMatch) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(6);
        }
        return this.matchingDegree(name2, valueStartCaseMatch, this.matchingFragments(name2));
    }

    public int matchingDegree(@NotNull String name2, boolean valueStartCaseMatch, @Nullable FList<TextRange> fragments2) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(7);
        }
        if (fragments2 == null) {
            return Integer.MIN_VALUE;
        }
        if (fragments2.isEmpty()) {
            return 0;
        }
        TextRange first2 = fragments2.getHead();
        boolean startMatch = first2.getStartOffset() == 0;
        boolean valuedStartMatch = startMatch && valueStartCaseMatch;
        int matchingCase = 0;
        int p = -1;
        int skippedHumps = 0;
        int nextHumpStart = 0;
        boolean humpStartMatchedUpperCase = false;
        block0: for (TextRange range : fragments2) {
            for (int i = range.getStartOffset(); i < range.getEndOffset(); ++i) {
                boolean afterGap = i == range.getStartOffset() && first2 != range;
                boolean isHumpStart = false;
                while (nextHumpStart <= i) {
                    if (nextHumpStart == i) {
                        isHumpStart = true;
                    } else if (afterGap) {
                        ++skippedHumps;
                    }
                    nextHumpStart = MinusculeMatcher.nextWord(name2, nextHumpStart);
                }
                char c = name2.charAt(i);
                p = StringUtil.indexOf(this.myPattern, c, p + 1, this.myPattern.length, false);
                if (p < 0) continue block0;
                if (isHumpStart) {
                    humpStartMatchedUpperCase = c == this.myPattern[p] && this.isUpperCase[p];
                }
                matchingCase += this.evaluateCaseMatching(valuedStartMatch, p, humpStartMatchedUpperCase, i, afterGap, isHumpStart, c);
            }
        }
        int startIndex = first2.getStartOffset();
        boolean afterSeparator = StringUtil.indexOfAny(name2, this.myHardSeparators, 0, startIndex) >= 0;
        boolean wordStart = startIndex == 0 || NameUtil.isWordStart(name2, startIndex) && !NameUtil.isWordStart(name2, startIndex - 1);
        boolean finalMatch = fragments2.get(fragments2.size() - 1).getEndOffset() == name2.length();
        return (wordStart ? 1000 : 0) + matchingCase + (-fragments2.size() - skippedHumps * 10) + (afterSeparator ? 0 : 2) + (startMatch ? 1 : 0) + (finalMatch ? 1 : 0);
    }

    private int evaluateCaseMatching(boolean valuedStartMatch, int patternIndex, boolean humpStartMatchedUpperCase, int nameIndex, boolean afterGap, boolean isHumpStart, char nameChar) {
        if (afterGap && isHumpStart && this.isLowerCase[patternIndex]) {
            return -10;
        }
        if (nameChar == this.myPattern[patternIndex]) {
            if (this.isUpperCase[patternIndex]) {
                return 50;
            }
            if (nameIndex == 0 && valuedStartMatch) {
                return 150;
            }
            if (isHumpStart) {
                return 1;
            }
        } else {
            if (isHumpStart) {
                return -1;
            }
            if (this.isLowerCase[patternIndex] && humpStartMatchedUpperCase) {
                return -1;
            }
        }
        return 0;
    }

    public boolean isStartMatch(@NotNull String name2) {
        FList<TextRange> fragments2;
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(8);
        }
        return (fragments2 = this.matchingFragments(name2)) != null && MinusculeMatcher.isStartMatch(fragments2);
    }

    public static boolean isStartMatch(@NotNull Iterable<TextRange> fragments2) {
        Iterator<TextRange> iterator2;
        if (fragments2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(9);
        }
        return !(iterator2 = fragments2.iterator()).hasNext() || iterator2.next().getStartOffset() == 0;
    }

    @Override
    public boolean matches(@NotNull String name2) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(10);
        }
        return this.matchingFragments(name2) != null;
    }

    @NotNull
    public String getPattern() {
        String string2 = new String(this.myPattern);
        if (string2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name2) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(12);
        }
        if (name2.length() < this.myMinNameLength) {
            return null;
        }
        int length = name2.length();
        int patternIndex = 0;
        boolean isAscii = true;
        for (int i = 0; i < length; ++i) {
            char c = name2.charAt(i);
            if (c >= '\u0080') {
                isAscii = false;
            }
            if (patternIndex >= this.myMeaningfulCharacters.length || c != this.myMeaningfulCharacters[patternIndex] && c != this.myMeaningfulCharacters[patternIndex + 1]) continue;
            patternIndex += 2;
        }
        if (patternIndex < this.myMinNameLength * 2) {
            return null;
        }
        return this.matchWildcards(name2, 0, 0, isAscii);
    }

    @Nullable
    private FList<TextRange> matchWildcards(@NotNull String name2, int patternIndex, int nameIndex, boolean isAsciiName) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(13);
        }
        if (nameIndex < 0) {
            return null;
        }
        if (!this.isWildcard(patternIndex)) {
            if (patternIndex == this.myPattern.length) {
                return FList.emptyList();
            }
            return this.matchFragment(name2, patternIndex, nameIndex, isAsciiName);
        }
        while (this.isWildcard(++patternIndex)) {
        }
        if (patternIndex == this.myPattern.length) {
            boolean space = this.isPatternChar(patternIndex - 1, ' ');
            if (space && nameIndex != name2.length() && (patternIndex < 2 || !MinusculeMatcher.isUpperCaseOrDigit(this.myPattern[patternIndex - 2]))) {
                int spaceIndex = name2.indexOf(32, nameIndex);
                if (spaceIndex >= 0) {
                    return FList.emptyList().prepend(TextRange.from(spaceIndex, 1));
                }
                return null;
            }
            return FList.emptyList();
        }
        FList<TextRange> ranges2 = this.matchFragment(name2, patternIndex, nameIndex, isAsciiName);
        if (ranges2 != null) {
            return ranges2;
        }
        return this.matchSkippingWords(name2, patternIndex, nameIndex, true, isAsciiName);
    }

    private static boolean isUpperCaseOrDigit(char p) {
        return Character.isUpperCase(p) || Character.isDigit(p);
    }

    @Nullable
    private FList<TextRange> matchSkippingWords(@NotNull String name2, int patternIndex, int nameIndex, boolean allowSpecialChars, boolean isAsciiName) {
        FList<TextRange> ranges2;
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(14);
        }
        boolean wordStartsOnly = !this.isPatternChar(patternIndex - 1, '*') && !this.isWordSeparator[patternIndex];
        int maxFoundLength = 0;
        while (true) {
            if ((nameIndex = this.findNextPatternCharOccurrence(name2, nameIndex, patternIndex, isAsciiName, allowSpecialChars, wordStartsOnly)) < 0) {
                return null;
            }
            int fragmentLength = this.seemsLikeFragmentStart(name2, patternIndex, nameIndex) ? this.maxMatchingFragment(name2, patternIndex, nameIndex) : 0;
            if (fragmentLength <= maxFoundLength) continue;
            if (!this.isMiddleMatch(name2, patternIndex, nameIndex)) {
                maxFoundLength = fragmentLength;
            }
            if ((ranges2 = this.matchInsideFragment(name2, patternIndex, nameIndex, isAsciiName, fragmentLength)) != null) break;
        }
        return ranges2;
    }

    private int findNextPatternCharOccurrence(@NotNull String name2, int startAt, int patternIndex, boolean isAsciiName, boolean allowSpecialChars, boolean wordStartsOnly) {
        int next;
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(15);
        }
        int n = next = wordStartsOnly ? this.indexOfWordStart(name2, patternIndex, startAt) : this.indexOfIgnoreCase(name2, startAt + 1, this.myPattern[patternIndex], patternIndex, isAsciiName);
        if (!allowSpecialChars && !this.myHasSeparators && !this.myHasHumps && StringUtil.containsAnyChar(name2, this.myHardSeparators, startAt, next)) {
            return -1;
        }
        if (!allowSpecialChars && this.myHasDots && !this.isPatternChar(patternIndex - 1, '.') && StringUtil.contains(name2, startAt, next, '.')) {
            return -1;
        }
        return next;
    }

    private boolean seemsLikeFragmentStart(@NotNull String name2, int patternIndex, int nextOccurrence) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(16);
        }
        return !this.isUpperCase[patternIndex] || Character.isUpperCase(name2.charAt(nextOccurrence)) || NameUtil.isWordStart(name2, nextOccurrence) || !this.myHasHumps && this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
    }

    private boolean charEquals(char patternChar, int patternIndex, char c, boolean isIgnoreCase) {
        return patternChar == c || isIgnoreCase && (this.toLowerCase[patternIndex] == c || this.toUpperCase[patternIndex] == c);
    }

    @Nullable
    private FList<TextRange> matchFragment(@NotNull String name2, int patternIndex, int nameIndex, boolean isAsciiName) {
        int fragmentLength;
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(17);
        }
        return (fragmentLength = this.maxMatchingFragment(name2, patternIndex, nameIndex)) == 0 ? null : this.matchInsideFragment(name2, patternIndex, nameIndex, isAsciiName, fragmentLength);
    }

    private int maxMatchingFragment(@NotNull String name2, int patternIndex, int nameIndex) {
        boolean ignoreCase;
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(18);
        }
        if (!this.isFirstCharMatching(name2, nameIndex, patternIndex)) {
            return 0;
        }
        int i = 1;
        boolean bl = ignoreCase = this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        while (!(nameIndex + i >= name2.length() || patternIndex + i >= this.myPattern.length || !this.charEquals(this.myPattern[patternIndex + i], patternIndex + i, name2.charAt(nameIndex + i), ignoreCase) || this.isUppercasePatternVsLowercaseNameChar(name2, patternIndex + i, nameIndex + i) && this.shouldProhibitCaseMismatch(name2, patternIndex + i, nameIndex + i))) {
            ++i;
        }
        return i;
    }

    @Nullable
    private FList<TextRange> matchInsideFragment(@NotNull String name2, int patternIndex, int nameIndex, boolean isAsciiName, int fragmentLength) {
        int minFragment;
        FList<TextRange> camelHumpRanges;
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(19);
        }
        if ((camelHumpRanges = this.improveCamelHumps(name2, patternIndex, nameIndex, isAsciiName, fragmentLength, minFragment = this.isMiddleMatch(name2, patternIndex, nameIndex) ? 3 : 1)) != null) {
            return camelHumpRanges;
        }
        return this.findLongestMatchingPrefix(name2, patternIndex, nameIndex, isAsciiName, fragmentLength, minFragment);
    }

    private boolean isMiddleMatch(@NotNull String name2, int patternIndex, int nameIndex) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(20);
        }
        return this.isPatternChar(patternIndex - 1, '*') && !this.isWildcard(patternIndex + 1) && Character.isLetterOrDigit(name2.charAt(nameIndex)) && !NameUtil.isWordStart(name2, nameIndex);
    }

    @Nullable
    private FList<TextRange> findLongestMatchingPrefix(@NotNull String name2, int patternIndex, int nameIndex, boolean isAsciiName, int fragmentLength, int minFragment) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(21);
        }
        if (patternIndex + fragmentLength >= this.myPattern.length) {
            return FList.emptyList().prepend(TextRange.from(nameIndex, fragmentLength));
        }
        for (int i = fragmentLength; i >= minFragment || this.isWildcard(patternIndex + i); --i) {
            FList<TextRange> ranges2;
            FList<TextRange> fList = ranges2 = this.isWildcard(patternIndex + i) ? this.matchWildcards(name2, patternIndex + i, nameIndex + i, isAsciiName) : this.matchSkippingWords(name2, patternIndex + i, nameIndex + i, false, isAsciiName);
            if (ranges2 == null) continue;
            return MinusculeMatcher.prependRange(ranges2, nameIndex, i);
        }
        return null;
    }

    private FList<TextRange> improveCamelHumps(@NotNull String name2, int patternIndex, int nameIndex, boolean isAsciiName, int maxFragment, int minFragment) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(22);
        }
        for (int i = minFragment; i < maxFragment; ++i) {
            FList<TextRange> ranges2;
            if (!this.isUppercasePatternVsLowercaseNameChar(name2, patternIndex + i, nameIndex + i) || (ranges2 = this.findUppercaseMatchFurther(name2, patternIndex + i, nameIndex + i, isAsciiName)) == null) continue;
            return MinusculeMatcher.prependRange(ranges2, nameIndex, i);
        }
        return null;
    }

    private boolean isUppercasePatternVsLowercaseNameChar(String name2, int patternIndex, int nameIndex) {
        return this.isUpperCase[patternIndex] && this.myPattern[patternIndex] != name2.charAt(nameIndex);
    }

    private FList<TextRange> findUppercaseMatchFurther(String name2, int patternIndex, int nameIndex, boolean isAsciiName) {
        int nextWordStart = this.indexOfWordStart(name2, patternIndex, nameIndex);
        return this.matchWildcards(name2, patternIndex, nextWordStart, isAsciiName);
    }

    private boolean shouldProhibitCaseMismatch(String name2, int patternIndex, int nameIndex) {
        return this.myHasHumps && patternIndex >= 2 && this.isUpperCase[patternIndex - 1] && this.isUpperCase[patternIndex - 2] && (nameIndex + 1 == name2.length() || patternIndex + 1 < this.myPattern.length && !this.isLowerCase[patternIndex + 1]);
    }

    private boolean isFirstCharMatching(@NotNull String name2, int nameIndex, int patternIndex) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(23);
        }
        if (nameIndex >= name2.length()) {
            return false;
        }
        boolean ignoreCase = this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        char patternChar = this.myPattern[patternIndex];
        if (!this.charEquals(patternChar, patternIndex, name2.charAt(nameIndex), ignoreCase)) {
            return false;
        }
        return this.myOptions != NameUtil.MatchingCaseSensitivity.FIRST_LETTER || patternIndex != 0 && (patternIndex != 1 || !this.isWildcard(0)) || !MinusculeMatcher.hasCase(patternChar) || Character.isUpperCase(patternChar) == Character.isUpperCase(name2.charAt(0));
    }

    private static boolean hasCase(char patternChar) {
        return Character.isUpperCase(patternChar) || Character.isLowerCase(patternChar);
    }

    private boolean isWildcard(int patternIndex) {
        if (patternIndex >= 0 && patternIndex < this.myPattern.length) {
            char pc = this.myPattern[patternIndex];
            return pc == ' ' || pc == '*';
        }
        return false;
    }

    private boolean isPatternChar(int patternIndex, char c) {
        return patternIndex >= 0 && patternIndex < this.myPattern.length && this.myPattern[patternIndex] == c;
    }

    private int indexOfWordStart(@NotNull String name2, int patternIndex, int startFrom) {
        if (name2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(24);
        }
        char p = this.myPattern[patternIndex];
        if (startFrom >= name2.length() || this.myHasHumps && this.isLowerCase[patternIndex] && (patternIndex <= 0 || !this.isWordSeparator[patternIndex - 1])) {
            return -1;
        }
        int nextWordStart = startFrom;
        do {
            if ((nextWordStart = MinusculeMatcher.nextWord(name2, nextWordStart)) < name2.length()) continue;
            return -1;
        } while (!this.charEquals(p, patternIndex, name2.charAt(nextWordStart), true));
        return nextWordStart;
    }

    private int indexOfIgnoreCase(String name2, int fromIndex, char p, int patternIndex, boolean isAsciiName) {
        if (isAsciiName && IOUtil.isAscii(p)) {
            char pUpper = this.toUpperCase[patternIndex];
            char pLower = this.toLowerCase[patternIndex];
            for (int i = fromIndex; i < name2.length(); ++i) {
                char c = name2.charAt(i);
                if (c != p && MinusculeMatcher.toUpperAscii(c) != pUpper && MinusculeMatcher.toLowerAscii(c) != pLower) continue;
                return i;
            }
            return -1;
        }
        return StringUtil.indexOfIgnoreCase(name2, p, fromIndex);
    }

    private static char toUpperAscii(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c + -32);
        }
        return c;
    }

    private static char toLowerAscii(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c - -32);
        }
        return c;
    }

    @NonNls
    public String toString() {
        return "MinusculeMatcher{myPattern=" + new String(this.myPattern) + ", myOptions=" + (Object)((Object)this.myOptions) + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardSeparators";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/MinusculeMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/MinusculeMatcher";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nextWord";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prependRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchingDegree";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isStartMatch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchingFragments";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchWildcards";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchSkippingWords";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findNextPatternCharOccurrence";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "seemsLikeFragmentStart";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "matchFragment";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "maxMatchingFragment";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "matchInsideFragment";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isMiddleMatch";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findLongestMatchingPrefix";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "improveCamelHumps";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isFirstCharMatching";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "indexOfWordStart";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

