/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Nullable;

class ConstantExpressionVisitor
extends JavaElementVisitor
implements PsiConstantEvaluationHelper.AuxEvaluator {
    private final StringInterner myInterner = new StringInterner();
    private Set<PsiVariable> myVisitedVars;
    private final Map<PsiElement, Object> myCachedValues = new HashMap<PsiElement, Object>();
    private final boolean myThrowExceptionOnOverflow;
    private Object myResult;
    private final PsiConstantEvaluationHelper.AuxEvaluator myAuxEvaluator;

    ConstantExpressionVisitor(Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        this.myVisitedVars = visitedVars;
        this.myThrowExceptionOnOverflow = throwExceptionOnOverflow;
        this.myAuxEvaluator = auxEvaluator;
    }

    Object handle(PsiElement element) {
        this.myResult = null;
        element.accept(this);
        this.store(element, this.myResult);
        return this.myResult;
    }

    private Object getStoredValue(PsiElement element) {
        return this.myCachedValues.remove(element);
    }

    void store(PsiElement element, Object value2) {
        this.myCachedValues.put(element, value2);
    }

    @Override
    public void visitLiteralExpression(PsiLiteralExpression expression2) {
        Object value2 = expression2.getValue();
        this.myResult = value2 instanceof String ? this.myInterner.intern((String)value2) : value2;
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression expression2) {
        PsiTypeElement castTypeElement = expression2.getCastType();
        PsiExpression operand = expression2.getOperand();
        Object opValue = this.getStoredValue(operand);
        if (castTypeElement == null || opValue == null) {
            this.myResult = null;
            return;
        }
        PsiType castType = castTypeElement.getType();
        this.myResult = ConstantExpressionUtil.computeCastTo(opValue, castType);
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression2) {
        Object then2 = this.getStoredValue(expression2.getThenExpression());
        Object els = this.getStoredValue(expression2.getElseExpression());
        Object condition = this.getStoredValue(expression2.getCondition());
        if (then2 == null || els == null) {
            this.myResult = null;
            return;
        }
        Object value2 = null;
        if (condition instanceof Boolean) {
            value2 = (Boolean)condition != false ? then2 : els;
        }
        this.myResult = value2;
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
        PsiExpression[] operands = expression2.getOperands();
        Object lValue = this.getStoredValue(operands[0]);
        if (lValue == null) {
            this.myResult = null;
            return;
        }
        IElementType tokenType = expression2.getOperationTokenType();
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            Object rValue = this.getStoredValue(operand);
            if (rValue == null) {
                this.myResult = null;
                break;
            }
            this.myResult = this.compute(lValue, rValue, tokenType, expression2);
            if (this.myResult == null) break;
            lValue = this.myResult;
        }
        if (this.myResult instanceof String) {
            this.myResult = this.myInterner.intern((String)this.myResult);
        }
    }

    private Object compute(Object lOperandValue, Object rOperandValue, IElementType tokenType, PsiPolyadicExpression expression2) {
        Object value2 = null;
        if (tokenType == JavaTokenType.PLUS) {
            if (lOperandValue instanceof String || rOperandValue instanceof String) {
                String l = lOperandValue.toString();
                String r = rOperandValue.toString();
                value2 = l + r;
            } else {
                if (lOperandValue instanceof Character) {
                    lOperandValue = (int)((Character)lOperandValue).charValue();
                }
                if (rOperandValue instanceof Character) {
                    rOperandValue = (int)((Character)rOperandValue).charValue();
                }
                if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                    if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                        value2 = new Double(((Number)lOperandValue).doubleValue() + ((Number)rOperandValue).doubleValue());
                        this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                    } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                        value2 = new Float(((Number)lOperandValue).floatValue() + ((Number)rOperandValue).floatValue());
                        this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                    } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                        long r;
                        long l = ((Number)lOperandValue).longValue();
                        value2 = l + (r = ((Number)rOperandValue).longValue());
                        this.checkAdditionOverflow((Long)value2 >= 0L, l >= 0L, r >= 0L, expression2);
                    } else {
                        int r;
                        int l = ((Number)lOperandValue).intValue();
                        value2 = l + (r = ((Number)rOperandValue).intValue());
                        this.checkAdditionOverflow((Integer)value2 >= 0, l >= 0, r >= 0, expression2);
                    }
                }
            }
        } else if (tokenType == JavaTokenType.MINUS) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = new Double(((Number)lOperandValue).doubleValue() - ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = new Float(((Number)lOperandValue).floatValue() - ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long r;
                    long l = ((Number)lOperandValue).longValue();
                    value2 = l - (r = ((Number)rOperandValue).longValue());
                    this.checkAdditionOverflow((Long)value2 >= 0L, l >= 0L, r < 0L, expression2);
                } else {
                    int r;
                    int l = ((Number)lOperandValue).intValue();
                    value2 = l - (r = ((Number)rOperandValue).intValue());
                    this.checkAdditionOverflow((Integer)value2 >= 0, l >= 0, r < 0, expression2);
                }
            }
        } else if (tokenType == JavaTokenType.ANDAND) {
            if (lOperandValue instanceof Boolean && !((Boolean)lOperandValue).booleanValue() || rOperandValue instanceof Boolean && !((Boolean)rOperandValue).booleanValue()) {
                value2 = Boolean.FALSE;
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false && (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.OROR) {
            if (lOperandValue instanceof Boolean && ((Boolean)lOperandValue).booleanValue() || rOperandValue instanceof Boolean && ((Boolean)rOperandValue).booleanValue()) {
                value2 = Boolean.TRUE;
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false || (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.LT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                value2 = ((Number)lOperandValue).doubleValue() < ((Number)rOperandValue).doubleValue();
            }
        } else if (tokenType == JavaTokenType.LE) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                value2 = ((Number)lOperandValue).doubleValue() <= ((Number)rOperandValue).doubleValue();
            }
        } else if (tokenType == JavaTokenType.GT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                value2 = ((Number)lOperandValue).doubleValue() > ((Number)rOperandValue).doubleValue();
            }
        } else if (tokenType == JavaTokenType.GE) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                value2 = ((Number)lOperandValue).doubleValue() >= ((Number)rOperandValue).doubleValue();
            }
        } else if (tokenType == JavaTokenType.EQEQ) {
            value2 = ConstantExpressionVisitor.areValuesEqual(lOperandValue, rOperandValue, expression2);
        } else if (tokenType == JavaTokenType.NE) {
            Boolean eq = ConstantExpressionVisitor.areValuesEqual(lOperandValue, rOperandValue, expression2);
            if (eq != null) {
                value2 = eq == false;
            }
        } else if (tokenType == JavaTokenType.ASTERISK) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = new Double(((Number)lOperandValue).doubleValue() * ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = new Float(((Number)lOperandValue).floatValue() * ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    value2 = l * r;
                    this.checkMultiplicationOverflow((Long)value2, l, r, expression2);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    value2 = l * r;
                    this.checkMultiplicationOverflow(((Integer)value2).intValue(), l, r, expression2);
                }
            }
        } else if (tokenType == JavaTokenType.DIV) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = new Double(((Number)lOperandValue).doubleValue() / ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = new Float(((Number)lOperandValue).floatValue() / ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long r = ((Number)rOperandValue).longValue();
                    long l = ((Number)lOperandValue).longValue();
                    this.checkDivisionOverflow(l, r, Long.MIN_VALUE, expression2);
                    value2 = r == 0L ? null : Long.valueOf(l / r);
                } else {
                    int r = ((Number)rOperandValue).intValue();
                    int l = ((Number)lOperandValue).intValue();
                    this.checkDivisionOverflow(l, r, Integer.MIN_VALUE, expression2);
                    value2 = r == 0 ? null : Integer.valueOf(l / r);
                }
            }
        } else if (tokenType == JavaTokenType.PERC) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                double rVal = ((Number)rOperandValue).doubleValue();
                if (this.myThrowExceptionOnOverflow && rVal == 0.0) {
                    throw new ConstantEvaluationOverflowException(expression2);
                }
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = new Double(((Number)lOperandValue).doubleValue() % ((Number)rOperandValue).doubleValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = new Float(((Number)lOperandValue).floatValue() % ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    this.checkDivisionOverflow(l, r, Long.MIN_VALUE, expression2);
                    value2 = r == 0L ? null : Long.valueOf(l % r);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    this.checkDivisionOverflow(l, r, Integer.MIN_VALUE, expression2);
                    value2 = r == 0 ? null : Integer.valueOf(l % r);
                }
            }
        } else if (tokenType == JavaTokenType.LTLT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                if (lOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    value2 = l << (int)r;
                    this.checkMultiplicationOverflow((Long)value2, l, (long)Math.pow(2.0, r & 0x3FL), expression2);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    value2 = l << r;
                    this.checkMultiplicationOverflow(((Integer)value2).intValue(), l, (long)Math.pow(2.0, r & 0x1F), expression2);
                }
            }
        } else if (tokenType == JavaTokenType.GTGT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() >> (int)((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() >> ((Number)rOperandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.GTGTGT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() >>> (int)((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() >>> ((Number)rOperandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.AND) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() & ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() & ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false && (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.OR) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() | ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() | ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false || (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.XOR) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() ^ ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() ^ ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue ^ (Boolean)rOperandValue;
            }
        }
        return value2;
    }

    @Nullable
    private static Boolean areValuesEqual(Object lOperandValue, Object rOperandValue, PsiPolyadicExpression expression2) {
        if (lOperandValue instanceof Character) {
            lOperandValue = (int)((Character)lOperandValue).charValue();
        }
        if (rOperandValue instanceof Character) {
            rOperandValue = (int)((Character)rOperandValue).charValue();
        }
        if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
            return ConstantExpressionVisitor.isBoxedComparison(expression2) ? lOperandValue == rOperandValue : ((Number)lOperandValue).doubleValue() == ((Number)rOperandValue).doubleValue();
        }
        if (lOperandValue instanceof String && rOperandValue instanceof String || lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
            return lOperandValue.equals(rOperandValue);
        }
        return null;
    }

    private static boolean isBoxedComparison(PsiPolyadicExpression expression2) {
        return Arrays.stream(expression2.getOperands()).anyMatch(op -> op.getType() instanceof PsiClassType);
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression2) {
        PsiExpression operand = expression2.getOperand();
        Object operandValue = this.getStoredValue(operand);
        if (operandValue == null) {
            this.myResult = null;
            return;
        }
        IElementType tokenType = expression2.getOperationTokenType();
        Object value2 = null;
        if (tokenType == JavaTokenType.MINUS) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (operandValue instanceof Number) {
                if (operandValue instanceof Double) {
                    value2 = new Double(-((Number)operandValue).doubleValue());
                } else if (operandValue instanceof Float) {
                    value2 = new Float(-((Number)operandValue).floatValue());
                } else if (operandValue instanceof Long) {
                    value2 = -((Number)operandValue).longValue();
                    if (this.myThrowExceptionOnOverflow && !(operand instanceof PsiLiteralExpression) && ((Number)operandValue).longValue() == Long.MIN_VALUE) {
                        throw new ConstantEvaluationOverflowException(expression2);
                    }
                } else {
                    value2 = -((Number)operandValue).intValue();
                    if (this.myThrowExceptionOnOverflow && !(operand instanceof PsiLiteralExpression) && ((Number)operandValue).intValue() == Integer.MIN_VALUE) {
                        throw new ConstantEvaluationOverflowException(expression2);
                    }
                }
            }
        } else if (tokenType == JavaTokenType.PLUS) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (operandValue instanceof Number) {
                value2 = operandValue;
            }
        } else if (tokenType == JavaTokenType.TILDE) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(operandValue)) {
                value2 = operandValue instanceof Long ? (Number)(((Number)operandValue).longValue() ^ 0xFFFFFFFFFFFFFFFFL) : (Number)(~((Number)operandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.EXCL && operandValue instanceof Boolean) {
            value2 = (Boolean)operandValue == false;
        }
        this.myResult = value2;
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression2) {
        this.myResult = this.getStoredValue(expression2.getExpression());
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
        this.myResult = this.myAuxEvaluator != null ? this.myAuxEvaluator.computeExpression(expression2, this) : null;
    }

    @Override
    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression2) {
        this.myResult = expression2.getOperand().getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression2) {
        PsiElement resolvedExpression;
        PsiExpression qualifierExpression = expression2.getQualifierExpression();
        while (qualifierExpression != null) {
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                this.myResult = null;
                return;
            }
            PsiReferenceExpression qualifier = (PsiReferenceExpression)qualifierExpression;
            PsiElement resolved = qualifier.resolve();
            if (resolved instanceof PsiPackage) break;
            if (!(resolved instanceof PsiClass)) {
                this.myResult = null;
                return;
            }
            qualifierExpression = ((PsiReferenceExpression)qualifierExpression).getQualifierExpression();
        }
        if ((resolvedExpression = expression2.resolve()) instanceof PsiEnumConstant) {
            String constant = ((PsiEnumConstant)resolvedExpression).getName();
            if (constant == null) {
                return;
            }
            PsiReferenceExpression qualifier = (PsiReferenceExpression)expression2.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement element = qualifier.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            String name2 = ClassUtil.getJVMClassName((PsiClass)element);
            try {
                Class<?> aClass2 = Class.forName(name2);
                this.myResult = Enum.valueOf(aClass2, constant);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (resolvedExpression instanceof PsiVariable) {
            PsiVariable variable2 = (PsiVariable)resolvedExpression;
            if (this.myVisitedVars != null && this.myVisitedVars.contains(variable2)) {
                this.myResult = null;
                return;
            }
            Set<PsiVariable> oldVisitedVars = this.myVisitedVars;
            if (this.myVisitedVars == null) {
                this.myVisitedVars = new THashSet<PsiVariable>();
            }
            this.myVisitedVars.add(variable2);
            try {
                Object object = this.myResult = variable2 instanceof PsiVariableEx ? ((PsiVariableEx)variable2).computeConstantValue(this.myVisitedVars) : null;
                if (this.myResult == null && this.myAuxEvaluator != null) {
                    this.myResult = this.myAuxEvaluator.computeExpression(expression2, this);
                }
                return;
            }
            finally {
                this.myVisitedVars.remove(variable2);
                this.myVisitedVars = oldVisitedVars;
            }
        }
        this.myResult = null;
    }

    private static boolean isIntegral(Object o) {
        return o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte || o instanceof Character;
    }

    private void checkDivisionOverflow(long l, long r, long minValue, PsiElement expression2) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (r == 0L) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
        if (r == -1L && l == minValue) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    private void checkMultiplicationOverflow(long result2, long l, long r, PsiElement expression2) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (r == 0L || l == 0L) {
            return;
        }
        if (result2 / r != l || l < 0L ^ r < 0L != result2 < 0L) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    private void checkAdditionOverflow(boolean resultPositive, boolean lPositive, boolean rPositive, PsiElement expression2) {
        boolean overflow;
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        boolean bl = overflow = lPositive == rPositive && lPositive != resultPositive;
        if (overflow) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    private void checkRealNumberOverflow(Object result2, Object lOperandValue, Object rOperandValue, PsiElement expression2) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (lOperandValue instanceof Float && ((Float)lOperandValue).isInfinite()) {
            return;
        }
        if (lOperandValue instanceof Double && ((Double)lOperandValue).isInfinite()) {
            return;
        }
        if (rOperandValue instanceof Float && ((Float)rOperandValue).isInfinite()) {
            return;
        }
        if (rOperandValue instanceof Double && ((Double)rOperandValue).isInfinite()) {
            return;
        }
        if (result2 instanceof Float && ((Float)result2).isInfinite()) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
        if (result2 instanceof Double && ((Double)result2).isInfinite()) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    @Override
    public Object computeExpression(PsiExpression expression2, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression2, this.myVisitedVars, this.myThrowExceptionOnOverflow, auxEvaluator);
    }

    @Override
    public ConcurrentMap<PsiElement, Object> getCacheMap(boolean overflow) {
        throw new AssertionError((Object)"should not be called");
    }
}

