/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionElementType;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.PsiLambdaExpressionImpl;
import com.intellij.psi.impl.source.tree.java.ReplaceExpressionUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LambdaExpressionElementType
extends FunctionalExpressionElementType<PsiLambdaExpression> {
    public LambdaExpressionElementType() {
        super("LAMBDA_EXPRESSION");
    }

    @Override
    public PsiLambdaExpression createPsi(@NotNull ASTNode node) {
        if (node == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(0);
        }
        return new PsiLambdaExpressionImpl(node);
    }

    @Override
    public PsiLambdaExpression createPsi(@NotNull FunctionalExpressionStub<PsiLambdaExpression> stub) {
        if (stub == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(1);
        }
        return new PsiLambdaExpressionImpl(stub);
    }

    @Override
    @NotNull
    public ASTNode createCompositeNode() {
        CompositeElement compositeElement = new CompositeElement(this){

            @Override
            public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
                boolean needParenth;
                if (child == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (newElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType()) && ElementType.EXPRESSION_BIT_SET.contains(newElement.getElementType()) && (needParenth = ReplaceExpressionUtil.isNeedParenthesis(child, newElement))) {
                    newElement = JavaSourceUtil.addParenthToReplacedChild(JavaElementType.PARENTH_EXPRESSION, newElement, this.getManager());
                }
                super.replaceChildInternal(child, newElement);
            }

            @Override
            public int getChildRole(ASTNode child) {
                IElementType elType = child.getElementType();
                if (elType == JavaTokenType.ARROW) {
                    return 252;
                }
                if (elType == JavaElementType.PARAMETER_LIST) {
                    return 14;
                }
                if (elType == JavaElementType.CODE_BLOCK) {
                    return 18;
                }
                return 64;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "child";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "newElement";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/java/stubs/LambdaExpressionElementType$1";
                objectArray[2] = "replaceChildInternal";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (compositeElement == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(2);
        }
        return compositeElement;
    }

    @Override
    @NotNull
    protected String getPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode funExpr) {
        if (tree == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(3);
        }
        if (funExpr == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(4);
        }
        LighterASTNode parameterList = ObjectUtils.notNull(LightTreeUtil.firstChildOfType(tree, funExpr, JavaStubElementTypes.PARAMETER_LIST));
        String string2 = LambdaExpressionElementType.getLambdaPresentableText(tree, parameterList);
        if (string2 == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(5);
        }
        return string2;
    }

    private static String getLambdaPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode parameterList) {
        if (tree == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(6);
        }
        if (parameterList == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(7);
        }
        StringBuilder buf = new StringBuilder(parameterList.getEndOffset() - parameterList.getStartOffset());
        LambdaExpressionElementType.formatParameterList(tree, parameterList, buf);
        buf.append(" -> {...}");
        return buf.toString();
    }

    private static void formatParameterList(@NotNull LighterAST tree, @NotNull LighterASTNode parameterList, StringBuilder buf) {
        if (tree == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(8);
        }
        if (parameterList == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(9);
        }
        List<LighterASTNode> children2 = tree.getChildren(parameterList);
        boolean isFirstParameter = true;
        boolean appendCloseBracket = false;
        for (LighterASTNode node : children2) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaTokenType.LPARENTH) {
                buf.append('(');
                appendCloseBracket = true;
                continue;
            }
            if (tokenType != JavaStubElementTypes.PARAMETER) continue;
            if (!isFirstParameter) {
                buf.append(", ");
            }
            LambdaExpressionElementType.formatParameter(tree, node, buf);
            if (!isFirstParameter) continue;
            isFirstParameter = false;
        }
        if (appendCloseBracket) {
            buf.append(')');
        }
    }

    private static void formatParameter(@NotNull LighterAST tree, @NotNull LighterASTNode parameter, StringBuilder buf) {
        if (tree == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(10);
        }
        if (parameter == null) {
            LambdaExpressionElementType.$$$reportNull$$$0(11);
        }
        List<LighterASTNode> children2 = tree.getChildren(parameter);
        for (LighterASTNode node : children2) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.TYPE) {
                LambdaExpressionElementType.formatType(tree, node, buf);
                buf.append(' ');
                continue;
            }
            if (tokenType != JavaTokenType.IDENTIFIER) continue;
            buf.append(RecordUtil.intern(tree.getCharTable(), node));
        }
    }

    private static void formatType(LighterAST tree, LighterASTNode typeElement, StringBuilder buf) {
        for (LighterASTNode node : tree.getChildren(typeElement)) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.JAVA_CODE_REFERENCE) {
                LambdaExpressionElementType.formatCodeReference(tree, node, buf);
                continue;
            }
            if (tokenType == JavaElementType.TYPE) {
                LambdaExpressionElementType.formatType(tree, node, buf);
                continue;
            }
            if (tokenType == JavaTokenType.QUEST) {
                buf.append("? ");
                continue;
            }
            if (ElementType.KEYWORD_BIT_SET.contains(tokenType)) {
                buf.append(RecordUtil.intern(tree.getCharTable(), node));
                if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) continue;
                buf.append(" ");
                continue;
            }
            if (tokenType == JavaTokenType.ELLIPSIS) {
                buf.append("...");
                continue;
            }
            if (tokenType == JavaTokenType.RBRACKET) {
                buf.append("]");
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) continue;
            buf.append("[");
        }
    }

    private static void formatCodeReference(LighterAST tree, LighterASTNode codeRef, StringBuilder buf) {
        for (LighterASTNode node : tree.getChildren(codeRef)) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER) {
                buf.append(RecordUtil.intern(tree.getCharTable(), node));
                continue;
            }
            if (tokenType != JavaElementType.REFERENCE_PARAMETER_LIST) continue;
            LambdaExpressionElementType.formatTypeParameters(tree, node, buf);
        }
    }

    private static void formatTypeParameters(LighterAST tree, LighterASTNode typeParameters2, StringBuilder buf) {
        List<LighterASTNode> children2 = LightTreeUtil.getChildrenOfType(tree, typeParameters2, JavaElementType.TYPE);
        if (children2.isEmpty()) {
            return;
        }
        buf.append('<');
        for (int i = 0; i < children2.size(); ++i) {
            LighterASTNode child = children2.get(i);
            LambdaExpressionElementType.formatType(tree, child, buf);
            if (i == children2.size() - 1) continue;
            buf.append(", ");
        }
        buf.append('>');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/LambdaExpressionElementType";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funExpr";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/LambdaExpressionElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaPresentableText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatParameterList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatParameter";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

