/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.indexing.IndexingDataKeys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiJavaFileBaseImpl");
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private volatile String myPackageName;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.create("LANGUAGE_LEVEL", file2 -> file2.getLanguageLevelInner());

    protected PsiJavaFileBaseImpl(IElementType elementType, IElementType contentElementType, FileViewProvider viewProvider) {
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new MyCacheBuilder(this), false);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myPackageName = null;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            PsiClass[] psiClassArray = (PsiClass[])stub.getChildrenByType(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
            if (psiClassArray == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(0);
            }
            return psiClassArray;
        }
        PsiClass[] psiClassArray = (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(1);
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getGreenStub();
        if (stub != null) {
            String string2 = stub.getPackageName();
            if (string2 == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(2);
            }
            return string2;
        }
        String name2 = this.myPackageName;
        if (name2 == null) {
            PsiPackageStatement statement2 = this.getPackageStatement();
            name2 = statement2 == null ? "" : statement2.getPackageName();
            this.myPackageName = name2;
        }
        String string3 = name2;
        if (string3 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(3);
        }
        return string3;
    }

    @Override
    public void setPackageName(String packageName) throws IncorrectOperationException {
        if (PsiUtil.isModuleFile(this)) {
            throw new IncorrectOperationException("Cannot set package name for module declarations");
        }
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(this.getProject());
        if (packageStatement != null) {
            if (!packageName.isEmpty()) {
                PsiJavaCodeReferenceElement reference = packageStatement.getPackageReference();
                reference.replace(factory2.createReferenceFromText(packageName, packageStatement));
            } else {
                packageStatement.delete();
            }
        } else if (!packageName.isEmpty()) {
            PsiElement anchor2 = this.getFirstChild();
            if ("package-info.java".equals(this.getName())) {
                while (anchor2 instanceof PsiWhiteSpace || anchor2 instanceof PsiComment) {
                    anchor2 = anchor2.getNextSibling();
                }
            }
            this.addBefore(factory2.createPackageStatement(packageName), anchor2);
        }
    }

    @Override
    public PsiImportList getImportList() {
        StubElement stub = this.getGreenStub();
        if (stub != null) {
            PsiImportList[] nodes = (PsiImportList[])stub.getChildrenByType(JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            if (nodes.length == 1) {
                return nodes[0];
            }
            if (nodes.length == 0) {
                return null;
            }
            this.reportStubAstMismatch(stub + "; " + stub.getChildrenStubs(), this.getStubTree());
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        return (PsiImportList)SourceTreeToPsiMap.treeElementToPsi(node);
    }

    @Override
    @NotNull
    public PsiElement[] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (EMPTY_ARRAY == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(4);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array2 = new ArrayList<PsiElement>();
        for (PsiImportStatement statement2 : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement2.isOnDemand() || (resolved = statement2.resolve()) == null) continue;
            array2.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array2.add(resolved);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array2);
        if (psiElementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(5);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiClass[] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(6);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> array2 = new ArrayList<PsiClass>();
        for (PsiImportStatement statement2 : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement2.isOnDemand() || !((ref = statement2.resolve()) instanceof PsiClass)) continue;
            array2.add((PsiClass)ref);
        }
        PsiClass[] psiClassArray = array2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(7);
        }
        return psiClassArray;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(PsiClass aClass2) {
        PsiImportList importList = this.getImportList();
        if (importList != null) {
            PsiImportStatement[] statements;
            for (PsiImportStatement statement2 : statements = importList.getImportStatements()) {
                PsiElement ref;
                if (statement2.isOnDemand() || (ref = statement2.resolve()) == null || !this.getManager().areElementsEquivalent(ref, aClass2)) continue;
                return statement2.getImportReference();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getImplicitlyImportedPackages() {
        if (IMPLICIT_IMPORTS == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(8);
        }
        return IMPLICIT_IMPORTS;
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement[] getImplicitlyImportedPackageReferences() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = PsiImplUtil.namesToPackageReferences(this.myManager, IMPLICIT_IMPORTS);
        if (psiJavaCodeReferenceElementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(9);
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(10);
        }
        if (state2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(11);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(12);
        }
        assert (this.isValid());
        if (processor2 instanceof ClassResolverProcessor && this.isPhysical() && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue())) {
            ClassResolverProcessor hint = (ClassResolverProcessor)processor2;
            String name2 = hint.getName(state2);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> cache2 = this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(processor2, state2);
            return name2 != null ? cache2.processForKey(name2, cacheProcessor) : cache2.processAllValues(cacheProcessor);
        }
        return this.processDeclarationsNoGuess(processor2, state2, lastParent, place);
    }

    /*
     * WARNING - void declaration
     */
    private boolean processDeclarationsNoGuess(PsiScopeProcessor processor2, @NotNull ResolveState state2, PsiElement lastParent, PsiElement place) {
        PsiImportStaticStatement[] importStaticStatements;
        PsiElement resolved;
        if (state2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(13);
        }
        processor2.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor2.getHint(ElementClassHint.KEY);
        NameHint nameHint = processor2.getHint(NameHint.KEY);
        String name2 = nameHint != null ? nameHint.getName(state2) : null;
        PsiImportList importList = this.getImportList();
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            void var14_21;
            PsiClass[] classes2;
            for (PsiClass aClass2 : classes2 = this.getClasses()) {
                if (processor2.execute(aClass2, state2)) continue;
                return false;
            }
            PsiImportStatement[] importStatements = importList != null ? importList.getImportStatements() : PsiImportStatement.EMPTY_ARRAY;
            for (PsiElement psiElement : importStatements) {
                String refText;
                if (psiElement.isOnDemand() || name2 != null && ((refText = psiElement.getQualifiedName()) == null || !refText.endsWith(name2)) || !((resolved = psiElement.resolve()) instanceof PsiClass)) continue;
                processor2.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiElement);
                PsiClass containingClass = ((PsiClass)resolved).getContainingClass();
                if (!(containingClass != null && containingClass.hasTypeParameters() ? !processor2.execute(resolved, state2.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor(containingClass))) : !processor2.execute(resolved, state2))) continue;
                return false;
            }
            processor2.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiPackage aPackage = JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.getPackageName());
            if (aPackage != null && !PsiJavaFileBaseImpl.processPackageDeclarations(processor2, state2, place, aPackage)) {
                return false;
            }
            PsiImportStatement[] psiImportStatementArray = importStatements;
            int n = psiImportStatementArray.length;
            boolean bl = false;
            while (var14_21 < n) {
                PsiElement resolved2;
                PsiImportStatement statement3 = psiImportStatementArray[var14_21];
                if (statement3.isOnDemand() && (resolved2 = statement3.resolve()) != null) {
                    processor2.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, statement3);
                    PsiJavaFileBaseImpl.processOnDemandTarget(resolved2, processor2, state2, place);
                }
                ++var14_21;
            }
        }
        PsiImportStaticStatement[] psiImportStaticStatementArray = importStaticStatements = importList != null ? importList.getImportStaticStatements() : PsiImportStaticStatement.EMPTY_ARRAY;
        if (importStaticStatements.length > 0) {
            StaticImportFilteringProcessor staticImportProcessor = new StaticImportFilteringProcessor(processor2);
            for (PsiElement psiElement : importStaticStatements) {
                JavaResolveResult[] results;
                PsiJavaCodeReferenceElement reference;
                if (psiElement.isOnDemand() || (reference = psiElement.getImportReference()) == null || (results = reference.multiResolve(false)).length <= 0) continue;
                staticImportProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiElement);
                String referenceName = psiElement.getReferenceName();
                for (JavaResolveResult result2 : results) {
                    staticImportProcessor.registerSingleStaticImportHiding(result2, referenceName);
                    PsiElement element = result2.getElement();
                    if (element == null || staticImportProcessor.execute(element, state2)) continue;
                    return false;
                }
            }
            for (PsiElement psiElement : importStaticStatements) {
                PsiClass targetElement;
                if (!psiElement.isOnDemand() || (targetElement = psiElement.resolveTargetClass()) == null) continue;
                staticImportProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, psiElement);
                if (targetElement.processDeclarations(staticImportProcessor, state2, lastParent, place)) continue;
                return false;
            }
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            processor2.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
            PsiJavaCodeReferenceElement[] implicitlyImported = this.getImplicitlyImportedPackageReferences();
            for (PsiElement psiElement : implicitlyImported) {
                resolved = psiElement.resolve();
                if (resolved == null || PsiJavaFileBaseImpl.processOnDemandTarget(resolved, processor2, state2, place)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processPackageDeclarations(PsiScopeProcessor processor2, @NotNull ResolveState state2, PsiElement place, @NotNull PsiPackage aPackage) {
        if (state2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(14);
        }
        if (aPackage == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(15);
        }
        if (!aPackage.getQualifiedName().isEmpty()) {
            processor2 = new DelegatingScopeProcessor(processor2){

                @Override
                @Nullable
                public <T> T getHint(@NotNull Key<T> hintKey) {
                    if (hintKey == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (hintKey == ElementClassHint.KEY) {
                        return (T)new ElementClassHint(){

                            @Override
                            public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
                                return kind == ElementClassHint.DeclarationKind.CLASS;
                            }
                        };
                    }
                    return super.getHint(hintKey);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$1", "getHint"));
                }
            };
        }
        return aPackage.processDeclarations(processor2, state2, null, place);
    }

    @NotNull
    private static PsiSubstitutor createRawSubstitutor(PsiClass containingClass) {
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(containingClass.getProject()).createRawSubstitutor(containingClass);
        if (psiSubstitutor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(16);
        }
        return psiSubstitutor;
    }

    private static boolean processOnDemandTarget(PsiElement target, PsiScopeProcessor processor2, ResolveState substitutor2, PsiElement place) {
        if (target instanceof PsiPackage) {
            if (!PsiJavaFileBaseImpl.processPackageDeclarations(processor2, substitutor2, place, (PsiPackage)target)) {
                return false;
            }
        } else if (target instanceof PsiClass) {
            PsiClass[] inners = ((PsiClass)target).getInnerClasses();
            if (((PsiClass)target).hasTypeParameters()) {
                substitutor2 = substitutor2.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor((PsiClass)target));
            }
            for (PsiClass inner : inners) {
                if (processor2.execute(inner, substitutor2)) continue;
                return false;
            }
        } else {
            LOG.error(target);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(17);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitJavaFile(this);
        } else {
            visitor2.visitFile(this);
        }
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(18);
        }
        return javaLanguage;
    }

    @Override
    public boolean importClass(PsiClass aClass2) {
        return JavaCodeStyleManager.getInstance(this.getProject()).addImport(this, aClass2);
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = LANGUAGE_LEVEL_KEY.getValue(this);
        if (languageLevel == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(19);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        return null;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.putUserData(LANGUAGE_LEVEL_KEY, null);
    }

    @Override
    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(20);
        }
        super.setOriginalFile(originalFile);
        this.clearCaches();
    }

    private LanguageLevel getLanguageLevelInner() {
        if (this.myOriginalFile instanceof PsiJavaFile) {
            return ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
        }
        LanguageLevel forcedLanguageLevel = this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
        if (forcedLanguageLevel != null) {
            return forcedLanguageLevel;
        }
        VirtualFile virtualFile2 = this.getVirtualFile();
        if (virtualFile2 == null) {
            virtualFile2 = this.getUserData(IndexingDataKeys.VIRTUAL_FILE);
        }
        Project project = this.getProject();
        if (virtualFile2 == null) {
            PsiFile originalFile = this.getOriginalFile();
            if (originalFile instanceof PsiJavaFile && originalFile != this) {
                return ((PsiJavaFile)originalFile).getLanguageLevel();
            }
            return LanguageLevel.HIGHEST;
        }
        return JavaPsiImplementationHelper.getInstance(project).getEffectiveLanguageLevel(virtualFile2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnDemandImports";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleClassImports";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackages";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackageReferences";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawSubstitutor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarationsNoGuess";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDeclarations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        public MyResolveCacheProcessor(PsiScopeProcessor processor2, ResolveState state2) {
            this.myProcessor = processor2;
            this.myState = state2;
        }

        @Override
        public boolean process(SymbolCollectingProcessor.ResultWithContext result2) {
            PsiClass containingClass;
            PsiElement context = result2.getFileContext();
            this.myProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, context);
            PsiNamedElement element = result2.getElement();
            if (element instanceof PsiClass && context instanceof PsiImportStatement && (containingClass = ((PsiClass)element).getContainingClass()) != null && containingClass.hasTypeParameters()) {
                return this.myProcessor.execute(element, this.myState.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)));
            }
            return this.myProcessor.execute(element, this.myState);
        }
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        private final PsiJavaFileBaseImpl myFile;

        public MyCacheBuilder(PsiJavaFileBaseImpl file2) {
            this.myFile = file2;
        }

        @Override
        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p = new SymbolCollectingProcessor();
            this.myFile.processDeclarationsNoGuess(p, ResolveState.initial(), this.myFile, this.myFile);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p.getResults();
            return CachedValueProvider.Result.create(results, PsiModificationTracker.MODIFICATION_COUNT, this.myFile);
        }
    }

    private static class StaticImportFilteringProcessor
    implements PsiScopeProcessor {
        private final PsiScopeProcessor myDelegate;
        private boolean myIsProcessingOnDemand;
        private final Collection<String> myHiddenFieldNames = new HashSet<String>();
        private final Collection<String> myHiddenMethodNames = new HashSet<String>();
        private final Collection<String> myHiddenTypeNames = new HashSet<String>();
        private final Collection<PsiElement> myCollectedElements = new HashSet<PsiElement>();

        public StaticImportFilteringProcessor(PsiScopeProcessor delegate2) {
            this.myDelegate = delegate2;
        }

        @Override
        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(0);
            }
            return this.myDelegate.getHint(hintKey);
        }

        @Override
        public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
            if (event == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(1);
            }
            if (JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT.equals(event) && associated instanceof PsiImportStaticStatement) {
                PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)associated;
                this.myIsProcessingOnDemand = importStaticStatement.isOnDemand();
            }
            this.myDelegate.handleEvent(event, associated);
        }

        private void registerSingleStaticImportHiding(JavaResolveResult result2, String referenceName) {
            this.getHiddenMembers(result2.getElement()).add(referenceName);
        }

        private Collection<String> getHiddenMembers(PsiElement element) {
            if (element instanceof PsiField) {
                return this.myHiddenFieldNames;
            }
            return element instanceof PsiClass ? this.myHiddenTypeNames : this.myHiddenMethodNames;
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state2) {
            if (element == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(2);
            }
            if (state2 == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                if (element instanceof PsiNamedElement && this.myIsProcessingOnDemand) {
                    String name2 = ((PsiNamedElement)element).getName();
                    if (this.getHiddenMembers(element).contains(name2)) {
                        return true;
                    }
                }
                if (this.myCollectedElements.add(element)) {
                    return this.myDelegate.execute(element, state2);
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleEvent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

