/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.Key;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubSerializationUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectStubTree<T extends Stub> {
    protected static final Key<ObjectStubTree> STUB_TO_TREE_REFERENCE = Key.create("stub to tree reference");
    public static final Key<Integer> LAST_STUB_TREE_HASH = Key.create("LAST_STUB_TREE_HASH");
    protected final ObjectStubBase myRoot;
    private String myDebugInfo;
    protected final List<T> myPlainList;

    public ObjectStubTree(@NotNull ObjectStubBase root2, boolean withBackReference) {
        if (root2 == null) {
            ObjectStubTree.$$$reportNull$$$0(0);
        }
        this.myPlainList = new ArrayList<T>();
        this.myRoot = root2;
        ObjectStubTree.enumerateStubs(root2, this.myPlainList);
        if (withBackReference) {
            this.myRoot.putUserData(STUB_TO_TREE_REFERENCE, this);
        }
    }

    @NotNull
    public Stub getRoot() {
        ObjectStubBase objectStubBase = this.myRoot;
        if (objectStubBase == null) {
            ObjectStubTree.$$$reportNull$$$0(1);
        }
        return objectStubBase;
    }

    @NotNull
    public List<T> getPlainList() {
        List<T> list2 = this.myPlainList;
        if (list2 == null) {
            ObjectStubTree.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public List<T> getPlainListFromAllRoots() {
        List<T> list2 = this.getPlainList();
        if (list2 == null) {
            ObjectStubTree.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public Map<StubIndexKey, Map<Object, int[]>> indexStubTree() {
        StubIndexSink sink = new StubIndexSink();
        List<T> plainList = this.getPlainListFromAllRoots();
        int plainListSize = plainList.size();
        for (int i = 0; i < plainListSize; ++i) {
            Stub stub = (Stub)plainList.get(i);
            sink.myStubIdx = i;
            StubSerializationUtil.getSerializer(stub).indexStub(stub, sink);
        }
        Map<StubIndexKey, Map<Object, int[]>> map2 = sink.getResult();
        if (map2 == null) {
            ObjectStubTree.$$$reportNull$$$0(4);
        }
        return map2;
    }

    private static void enumerateStubs(@NotNull Stub root2, @NotNull List<Stub> result2) {
        if (root2 == null) {
            ObjectStubTree.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            ObjectStubTree.$$$reportNull$$$0(6);
        }
        ((ObjectStubBase)root2).id = result2.size();
        result2.add(root2);
        List<? extends Stub> childrenStubs = root2.getChildrenStubs();
        for (int i = 0; i < childrenStubs.size(); ++i) {
            Stub child = childrenStubs.get(i);
            ObjectStubTree.enumerateStubs(child, result2);
        }
    }

    public void setDebugInfo(String info) {
        ObjectStubTree ref = ObjectStubTree.getStubTree(this.myRoot);
        if (ref != null) {
            assert (ref == this);
            info = info + "; with backReference";
        }
        this.myDebugInfo = info;
    }

    @Nullable
    public static ObjectStubTree getStubTree(@NotNull ObjectStubBase root2) {
        if (root2 == null) {
            ObjectStubTree.$$$reportNull$$$0(7);
        }
        return root2.getUserData(STUB_TO_TREE_REFERENCE);
    }

    public String getDebugInfo() {
        return this.myDebugInfo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{myDebugInfo='" + this.myDebugInfo + '\'' + ", myRoot=" + this.myRoot + '}' + this.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/ObjectStubTree";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/ObjectStubTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainListFromAllRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "indexStubTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "enumerateStubs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStubTree";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StubIndexSink
    implements IndexSink,
    TObjectObjectProcedure<Object, int[]>,
    TObjectProcedure<Map<Object, int[]>> {
        private final THashMap<StubIndexKey, Map<Object, int[]>> myResult = new THashMap();
        private int myStubIdx;
        private Map<Object, int[]> myProcessingMap;

        private StubIndexSink() {
        }

        public void occurrence(@NotNull StubIndexKey indexKey, @NotNull Object value2) {
            int[] list2;
            Map<Object, int[]> map2;
            if (indexKey == null) {
                StubIndexSink.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                StubIndexSink.$$$reportNull$$$0(1);
            }
            if ((map2 = this.myResult.get(indexKey)) == null) {
                map2 = new THashMap<Object, int[]>();
                this.myResult.put(indexKey, map2);
            }
            if ((list2 = map2.get(value2)) == null) {
                map2.put(value2, new int[]{this.myStubIdx});
            } else {
                int lastZero;
                for (lastZero = list2.length - 1; lastZero >= 0 && list2[lastZero] == 0; --lastZero) {
                }
                if (lastZero >= 0 && list2[lastZero] == this.myStubIdx) {
                    return;
                }
                if (++lastZero == list2.length) {
                    int[] newlist = new int[Math.max(4, list2.length << 1)];
                    System.arraycopy(list2, 0, newlist, 0, list2.length);
                    lastZero = list2.length;
                    list2 = newlist;
                    map2.put(value2, newlist);
                }
                list2[lastZero] = this.myStubIdx;
            }
        }

        public Map<StubIndexKey, Map<Object, int[]>> getResult() {
            this.myResult.forEachValue(this);
            return this.myResult;
        }

        @Override
        public boolean execute(Map<Object, int[]> object) {
            this.myProcessingMap = object;
            ((THashMap)object).forEachEntry(this);
            return true;
        }

        @Override
        public boolean execute(Object a, int[] b) {
            int firstZero;
            if (b.length == 1) {
                return true;
            }
            for (firstZero = 0; firstZero < b.length && b[firstZero] != 0; ++firstZero) {
            }
            if (firstZero != b.length) {
                int[] shorterList = new int[firstZero];
                System.arraycopy(b, 0, shorterList, 0, shorterList.length);
                this.myProcessingMap.put(a, shorterList);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "indexKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/stubs/ObjectStubTree$StubIndexSink";
            objectArray[2] = "occurrence";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

