/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.paint;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import org.jetbrains.annotations.NotNull;

public class LinePainter2D {
    /*
     * WARNING - void declaration
     */
    public static void paint(@NotNull Graphics2D g, double x1, double y1, double d, double d2) {
        void y2;
        void x2;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(0);
        }
        double sw = g.getStroke() instanceof BasicStroke ? (double)((BasicStroke)g.getStroke()).getLineWidth() : 1.0;
        LinePainter2D.paint(g, x1, y1, (double)x2, (double)y2, StrokeType.INSIDE, sw);
    }

    /*
     * WARNING - void declaration
     */
    public static void paint(@NotNull Graphics2D g, double x1, double y1, double x2, double d, @NotNull StrokeType strokeType, double d2) {
        void strokeWidth;
        void strokeType2;
        void y2;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(1);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(2);
        }
        LinePainter2D.paint(g, x1, y1, x2, (double)y2, (StrokeType)strokeType2, (double)strokeWidth, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public static void paint(final @NotNull Graphics2D g, double x1, double y1, double x2, double y2, @NotNull StrokeType strokeType, double d, @NotNull Object object) {
        void valueAA;
        void strokeWidth;
        boolean thickStroke;
        void strokeType2;
        if (g == null) {
            LinePainter2D.$$$reportNull$$$0(7);
        }
        if (strokeType == null) {
            LinePainter2D.$$$reportNull$$$0(8);
        }
        if (object == null) {
            LinePainter2D.$$$reportNull$$$0(9);
        }
        boolean horizontal = y1 == y2;
        boolean vertical = x1 == x2;
        boolean dot = horizontal && vertical;
        boolean straight = horizontal || vertical;
        boolean centered = strokeType2 == StrokeType.CENTERED || strokeType2 == StrokeType.CENTERED_CAPS_SQUARE;
        boolean bl = thickStroke = PaintUtil.devValue((double)strokeWidth, g) > 1.0;
        if (g.getStroke() instanceof BasicStroke && (straight || thickStroke)) {
            double cos;
            double sw = PaintUtil.alignToInt((double)strokeWidth, g);
            double swx_2 = 0.0;
            double swx_1 = 0.0;
            double swy_2 = 0.0;
            double swy_1 = 0.0;
            double capy_1 = 0.0;
            double capy_2 = 0.0;
            double capx_1 = 0.0;
            double capx_2 = 0.0;
            if (dot) {
                y2 += strokeWidth - 1.0;
            }
            double angle = dot ? 0.0 : Math.atan2(y1 - y2, x2 - x1);
            double sin = dot ? 1.0 : Math.sin(angle);
            double d2 = cos = dot ? 0.0 : Math.cos(angle);
            if (straight && !dot) {
                sin = Math.abs(sin);
                cos = Math.abs(cos);
            }
            if (strokeType2 == StrokeType.CENTERED_CAPS_SQUARE) {
                Pair<Double, Double> strokeSplit = LinePainter2D.getStrokeSplit(JBUI.ScaleContext.create(g), (StrokeType)strokeType2, sw, false);
                double cap_1 = (Double)strokeSplit.first;
                double cap_2 = (Double)strokeSplit.second;
                double y_sign = straight ? 1.0 : -1.0;
                capx_1 = (straight || x1 <= x2 ? cap_1 : cap_2) * cos;
                capx_2 = (straight || x1 <= x2 ? cap_2 : cap_1) * cos;
                capy_1 = (straight || y1 <= y2 ? cap_1 : cap_2) * sin * y_sign;
                capy_2 = (straight || y1 <= y2 ? cap_2 : cap_1) * sin * y_sign;
            }
            if (vertical) {
                double y_min = Math.min(y1, y2);
                double y_max = Math.max(y1, y2);
                y1 = PaintUtil.alignToInt(y_min, g);
                y2 = y1 + y_max - y1 + 1.0;
                x1 = x2 = PaintUtil.alignToInt(x2, g);
            } else if (horizontal) {
                double x_min = Math.min(x1, x2);
                double x_max = Math.max(x1, x2);
                x1 = PaintUtil.alignToInt(x_min, g);
                x2 = x1 + x_max - x1 + 1.0;
                y1 = y2 = PaintUtil.alignToInt(y2, g);
            } else {
                x1 = PaintUtil.alignToInt(x1, g);
                x2 = PaintUtil.alignToInt(x2, g);
                y1 = PaintUtil.alignToInt(y1, g);
                y2 = PaintUtil.alignToInt(y2, g);
                if (Math.abs(angle) > 1.5707963267948966) {
                    sin *= -1.0;
                    cos *= -1.0;
                }
            }
            if (strokeType2 == StrokeType.OUTSIDE) {
                swx_1 = sw * sin;
                swy_1 = sw * cos;
            } else if (strokeType2 == StrokeType.INSIDE) {
                swx_2 = sw * sin;
                swy_2 = sw * cos;
            } else if (centered) {
                double sw_2;
                double sw_1;
                if (straight) {
                    Pair<Double, Double> strokeSplit = LinePainter2D.getStrokeSplit(JBUI.ScaleContext.create(g), (StrokeType)strokeType2, sw);
                    sw_1 = (Double)strokeSplit.first;
                    sw_2 = (Double)strokeSplit.second;
                } else {
                    sw_1 = PaintUtil.alignToInt(Math.max(sw / 2.0, 0.0), g);
                    sw_2 = Math.max(sw - sw_1, 0.0);
                }
                swx_1 = sw_1 * sin;
                swx_2 = sw_2 * sin;
                swy_1 = sw_1 * cos;
                swy_2 = sw_2 * cos;
            }
            final Path2D.Double path2 = new Path2D.Double(0);
            ((Path2D)path2).moveTo(x1 - swx_1 - capx_1, y1 - swy_1 - capy_1);
            ((Path2D)path2).lineTo(x2 - swx_1 + capx_2, y2 - swy_1 + capy_2);
            ((Path2D)path2).lineTo(x2 + swx_2 + capx_2, y2 + swy_2 + capy_2);
            ((Path2D)path2).lineTo(x1 + swx_2 - capx_1, y1 + swy_2 - capy_1);
            path2.closePath();
            PaintUtil.paintWithAA(g, valueAA, new Runnable(){

                @Override
                public void run() {
                    g.fill(path2);
                }
            });
        } else {
            final Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
            PaintUtil.paintWithAA(g, valueAA, new Runnable(){

                @Override
                public void run() {
                    g.draw(line);
                }
            });
        }
    }

    static Pair<Double, Double> getStrokeSplit(JBUI.ScaleContext ctx, StrokeType strokeType, double strokeWidth) {
        return LinePainter2D.getStrokeSplit(ctx, strokeType, strokeWidth, true);
    }

    static Pair<Double, Double> getStrokeSplit(JBUI.ScaleContext ctx, StrokeType strokeType, double strokeWidth, boolean includeLinePixel) {
        if (strokeType == StrokeType.OUTSIDE) {
            return Pair.create(strokeWidth, strokeWidth);
        }
        if (strokeType == StrokeType.INSIDE) {
            return Pair.create(0.0, 0.0);
        }
        boolean linePixel = includeLinePixel;
        double _sw = strokeWidth - 1.0;
        double sw_1 = PaintUtil.alignToInt(Math.max(_sw / 2.0, 0.0), ctx, PaintUtil.RoundingMode.ROUND, null);
        double sw_2 = Math.max((double)linePixel + (_sw - sw_1), 0.0);
        return Pair.create(sw_1, sw_2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strokeType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueAA";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "align";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/paint/LinePainter2D";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/paint/LinePainter2D";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "align";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillPolygon";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "paintPolygon";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "align";
                break;
            }
            case 16: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum StrokeType {
        CENTERED,
        CENTERED_CAPS_SQUARE,
        INSIDE,
        OUTSIDE;

    }
}

