/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.FileIconPatcher;
import com.intellij.ide.FileIconProvider;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.FileIconKey;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IconUtil {
    private static final Key<Boolean> PROJECT_WAS_EVER_INITIALIZED = Key.create("iconDeferrer:projectWasEverInitialized");
    private static final NullableFunction<FileIconKey, Icon> ICON_NULLABLE_FUNCTION = key -> {
        VirtualFile file2 = key.getFile();
        int flags = IconUtil.filterFileIconFlags(file2, key.getFlags());
        Project project = key.getProject();
        if (!file2.isValid() || project != null && (project.isDisposed() || !IconUtil.wasEverInitialized(project))) {
            return null;
        }
        Icon providersIcon = IconUtil.getProvidersIcon(file2, flags, project);
        Icon icon = providersIcon == null ? VirtualFilePresentation.getIconImpl(file2) : providersIcon;
        boolean dumb = project != null && DumbService.getInstance(project).isDumb();
        for (FileIconPatcher patcher : IconUtil.getPatchers()) {
            if (dumb && !DumbService.isDumbAware(patcher)) continue;
            icon = patcher.patchIcon(icon, file2, flags & 0xFFFFFFFD, project);
        }
        if (file2.is(VFileProperty.SYMLINK)) {
            icon = new LayeredIcon(icon, PlatformIcons.SYMLINK_ICON);
        }
        if (!(!BitUtil.isSet(flags, 2) || file2.isWritable() && WritingAccessProvider.isPotentiallyWritable(file2, project))) {
            icon = new LayeredIcon(icon, PlatformIcons.LOCKED_ICON);
        }
        Iconable.LastComputedIcon.put(file2, icon, flags);
        return icon;
    };

    private static boolean wasEverInitialized(@NotNull Project project) {
        Boolean was;
        if (project == null) {
            IconUtil.$$$reportNull$$$0(0);
        }
        if ((was = project.getUserData(PROJECT_WAS_EVER_INITIALIZED)) == null) {
            if (project.isInitialized()) {
                was = true;
                project.putUserData(PROJECT_WAS_EVER_INITIALIZED, true);
            } else {
                was = false;
            }
        }
        return was;
    }

    private static int filterFileIconFlags(@NotNull VirtualFile file2, int flags) {
        if (file2 == null) {
            IconUtil.$$$reportNull$$$0(11);
        }
        UserDataHolder fileTypeDataHolder = ObjectUtils.tryCast(file2.getFileType(), UserDataHolder.class);
        int fileTypeFlagIgnoreMask = Iconable.ICON_FLAG_IGNORE_MASK.get(fileTypeDataHolder, 0);
        int flagIgnoreMask = Iconable.ICON_FLAG_IGNORE_MASK.get(file2, fileTypeFlagIgnoreMask);
        return flags & ~flagIgnoreMask;
    }

    public static Icon getIcon(@NotNull VirtualFile file2, int flags, @Nullable Project project) {
        Icon lastIcon;
        if (file2 == null) {
            IconUtil.$$$reportNull$$$0(12);
        }
        Icon base = (lastIcon = Iconable.LastComputedIcon.get(file2, flags)) != null ? lastIcon : VirtualFilePresentation.getIconImpl(file2);
        return IconDeferrer.getInstance().defer(base, new FileIconKey(file2, project, flags), ICON_NULLABLE_FUNCTION);
    }

    @Nullable
    private static Icon getProvidersIcon(@NotNull VirtualFile file2, int flags, Project project) {
        if (file2 == null) {
            IconUtil.$$$reportNull$$$0(13);
        }
        for (FileIconProvider provider : IconUtil.getProviders()) {
            Icon icon = provider.getIcon(file2, flags, project);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    @NotNull
    private static FileIconProvider[] getProviders() {
        FileIconProvider[] fileIconProviderArray = FileIconProviderHolder.myProviders;
        if (fileIconProviderArray == null) {
            IconUtil.$$$reportNull$$$0(18);
        }
        return fileIconProviderArray;
    }

    @NotNull
    private static FileIconPatcher[] getPatchers() {
        FileIconPatcher[] fileIconPatcherArray = FileIconPatcherHolder.ourPatchers;
        if (fileIconPatcherArray == null) {
            IconUtil.$$$reportNull$$$0(19);
        }
        return fileIconPatcherArray;
    }

    @NotNull
    public static Icon getAddIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("add.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(21);
        }
        return icon;
    }

    @NotNull
    public static Icon getRemoveIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("remove.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(22);
        }
        return icon;
    }

    @NotNull
    public static Icon getEditIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("edit.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(25);
        }
        return icon;
    }

    @NotNull
    public static Icon getAnalyzeIcon() {
        Icon icon = IconUtil.getToolbarDecoratorIcon("analyze.png");
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(34);
        }
        return icon;
    }

    @NotNull
    private static Icon getToolbarDecoratorIcon(@NotNull String name2) {
        if (name2 == null) {
            IconUtil.$$$reportNull$$$0(38);
        }
        Icon icon = IconLoader.getIcon(IconUtil.getToolbarDecoratorIconsFolder() + name2);
        if (icon == null) {
            IconUtil.$$$reportNull$$$0(39);
        }
        return icon;
    }

    @NotNull
    private static String getToolbarDecoratorIconsFolder() {
        String string2 = "/toolbarDecorator/" + (SystemInfo.isMac ? "mac/" : "");
        if (string2 == null) {
            IconUtil.$$$reportNull$$$0(40);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 82: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 82: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 20: 
            case 37: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/IconUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIconPath";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 44: 
            case 52: 
            case 55: 
            case 58: 
            case 61: 
            case 64: 
            case 66: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 53: 
            case 56: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "img";
                break;
            }
            case 77: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/IconUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "cropIcon";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "flip";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyIcon";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyIconLike";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatchers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddIcon";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoveIcon";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveUpIcon";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveDownIcon";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditIcon";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddClassIcon";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddPatternIcon";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddJiraPatternIcon";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddYouTrackPatternIcon";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddBlankLineIcon";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddPackageIcon";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddLinkIcon";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddFolderIcon";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyzeIcon";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarDecoratorIcon";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarDecoratorIconsFolder";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualSizedIcons";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "toSize";
                break;
            }
            case 45: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleByFont";
                break;
            }
            case 54: 
            case 57: 
            case 60: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "colorize";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "desaturate";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "brighter";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "darker";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIcon";
                break;
            }
            case 74: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageIcon";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "textToIcon";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "addText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wasEverInitialized";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cropIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 82: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "flip";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterFileIconFlags";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProvidersIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyIconLike";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toImage";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "paintInCenterOf";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getToolbarDecoratorIcon";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getEqualSizedIcons";
                break;
            }
            case 44: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "scale";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "scaleByFont";
                break;
            }
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "colorize";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "desaturate";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "brighter";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "darker";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "filterIcon";
                break;
            }
            case 73: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createImageIcon";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "textToIcon";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 54: 
            case 57: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 79: 
            case 82: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileIconPatcherHolder {
        private static final FileIconPatcher[] ourPatchers = Extensions.getExtensions(FileIconPatcher.EP_NAME);
    }

    private static class FileIconProviderHolder {
        private static final FileIconProvider[] myProviders = Extensions.getExtensions(FileIconProvider.EP_NAME);
    }
}

