/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.framework;

import com.jetbrains.rider.framework.AbstractBuffer;
import com.jetbrains.rider.framework.RdId;
import com.jetbrains.rider.framework.impl.RdSecureString;
import com.jetbrains.rider.util.BitHacksKt;
import com.jetbrains.rider.util.PublicApi;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a.\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0006\b\u0000\u0010\n\u0018\u0001*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0087\b\u00a2\u0006\u0002\u0010\u000e\u001a\r\u0010\u000f\u001a\u00020\u0010*\u00020\u000bH\u0086\b\u001a\u000e\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013*\u00020\u000b\u001a$\u0010\u0014\u001a\u0002H\n\"\u0010\b\u0000\u0010\n\u0018\u0001*\b\u0012\u0004\u0012\u0002H\n0\u0015*\u00020\u000bH\u0086\b\u00a2\u0006\u0002\u0010\u0016\u001a\u000e\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019*\u00020\u000b\u001a'\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\n0\u001b\"\u0004\b\u0000\u0010\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0086\b\u001a,\u0010\u001c\u001a\u0004\u0018\u0001H\n\"\b\b\u0000\u0010\n*\u00020\u001d*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0086\b\u00a2\u0006\u0002\u0010\u001e\u001a\n\u0010\u001f\u001a\u00020 *\u00020\u000b\u001a\n\u0010!\u001a\u00020\"*\u00020\u000b\u001a\u000e\u0010#\u001a\u00060$j\u0002`%*\u00020\u000b\u001a\u000e\u0010&\u001a\u00060\u0018j\u0002`\u0019*\u00020\u000b\u001a\n\u0010'\u001a\u00020(*\u00020\u000b\u001a9\u0010)\u001a\u00020(\"\u0004\b\u0000\u0010\n*\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\n0\t2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020(0,H\u0007\u00a2\u0006\u0002\u0010-\u001a\u0015\u0010.\u001a\u00020(*\u00020\u000b2\u0006\u0010*\u001a\u00020\u0010H\u0086\b\u001a\u0016\u0010/\u001a\u00020(*\u00020\u000b2\n\u0010*\u001a\u00060\u0012j\u0002`\u0013\u001a-\u00100\u001a\u00020(\"\u0010\b\u0000\u0010\n\u0018\u0001*\b\u0012\u0004\u0012\u0002H\n0\u0015*\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\n0\u0015H\u0086\b\u001a\u0016\u00101\u001a\u00020(*\u00020\u000b2\n\u0010*\u001a\u00060\u0018j\u0002`\u0019\u001a5\u00102\u001a\u00020(\"\u0004\b\u0000\u0010\n*\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\n0\u001b2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020(0,H\u0086\b\u001a7\u00103\u001a\u00020(\"\b\b\u0000\u0010\n*\u00020\u001d*\u00020\u000b2\b\u0010*\u001a\u0004\u0018\u0001H\n2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u00020(0,\u00a2\u0006\u0002\u00104\u001a\u0012\u00105\u001a\u00020(*\u00020\u000b2\u0006\u0010*\u001a\u00020 \u001a\u0012\u00106\u001a\u00020(*\u00020\u000b2\u0006\u00107\u001a\u00020\"\u001a\u0016\u00108\u001a\u00020(*\u00020\u000b2\n\u0010*\u001a\u00060$j\u0002`%\u001a\u0016\u00109\u001a\u00020(*\u00020\u000b2\n\u0010*\u001a\u00060\u0018j\u0002`\u0019\u001a\u0017\u0010:\u001a\u00020(*\u00020\u000b2\u0006\u0010;\u001a\u00020(\u00a2\u0006\u0002\u0010<\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"TICKS_AT_EPOCH", "", "TICKS_PER_MILLISECOND", "notRegisteredErrorMessage", "", "transformGuidUuid", "", "data", "readArray", "", "T", "Lcom/jetbrains/rider/framework/AbstractBuffer;", "inner", "Lkotlin/Function0;", "(Lcom/jetbrains/rider/framework/AbstractBuffer;Lkotlin/jvm/functions/Function0;)[Ljava/lang/Object;", "readBool", "", "readDateTime", "Ljava/util/Date;", "Lcom/jetbrains/rider/util/Date;", "readEnum", "", "(Lcom/jetbrains/rider/framework/AbstractBuffer;)Ljava/lang/Enum;", "readGuid", "Ljava/util/UUID;", "Lcom/jetbrains/rider/util/UUID;", "readList", "", "readNullable", "", "(Lcom/jetbrains/rider/framework/AbstractBuffer;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "readRdId", "Lcom/jetbrains/rider/framework/RdId;", "readSecureString", "Lcom/jetbrains/rider/framework/impl/RdSecureString;", "readUri", "Ljava/net/URI;", "Lcom/jetbrains/rider/util/URI;", "readUuid", "readVoid", "", "writeArray", "value", "elemWriter", "Lkotlin/Function1;", "(Lcom/jetbrains/rider/framework/AbstractBuffer;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "writeBool", "writeDateTime", "writeEnum", "writeGuid", "writeList", "writeNullable", "(Lcom/jetbrains/rider/framework/AbstractBuffer;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "writeRdId", "writeSecureString", "string", "writeUri", "writeUuid", "writeVoid", "void", "(Lcom/jetbrains/rider/framework/AbstractBuffer;Lkotlin/Unit;)V", "rd-framework-jvm"})
public final class SerializersKt {
    private static final String notRegisteredErrorMessage = "Maybe you forgot to invoke 'register()' method of corresponding Toplevel. Usually it should be done automagically during 'bind()' invocation but in complex cases you should do it manually.";
    private static final long TICKS_AT_EPOCH = 621355968000000000L;
    private static final long TICKS_PER_MILLISECOND = 10000L;

    private static final byte[] transformGuidUuid(byte[] data2) {
        return new byte[]{data2[3], data2[2], data2[1], data2[0], data2[5], data2[4], data2[7], data2[6], data2[8], data2[9], data2[10], data2[11], data2[12], data2[13], data2[14], data2[15]};
    }

    @NotNull
    public static final UUID readUuid(@NotNull AbstractBuffer $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        byte[] data2 = SerializersKt.transformGuidUuid($receiver.readByteArray());
        boolean bl2 = bl = data2.length == 16;
        if (!bl) {
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return new UUID(BitHacksKt.parseLong(data2, 0), BitHacksKt.parseLong(data2, 8));
    }

    @NotNull
    public static final UUID readGuid(@NotNull AbstractBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return SerializersKt.readUuid($receiver);
    }

    @NotNull
    public static final Date readDateTime(@NotNull AbstractBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        long timeInTicks = $receiver.readLong();
        long timeInMillisecondsSinceEpoch = (timeInTicks - TICKS_AT_EPOCH) / TICKS_PER_MILLISECOND;
        return new Date(timeInMillisecondsSinceEpoch);
    }

    @NotNull
    public static final URI readUri(@NotNull AbstractBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new URI($receiver.readString());
    }

    private static final <T extends Enum<T>> T readEnum(@NotNull AbstractBuffer $receiver) {
        Enum[] enumArray;
        int ordinal = $receiver.readInt();
        Intrinsics.reifiedOperationMarker(5, "T");
        Enum[] values$iv = enumArray = new Enum[0];
        int n = ordinal;
        int n2 = n = 0 <= n && ArraysKt.getLastIndex(values$iv) >= n ? 1 : 0;
        if (n == 0) {
            StringBuilder stringBuilder = new StringBuilder().append('\'').append(ordinal).append("' not in range of ");
            Intrinsics.reifiedOperationMarker(4, "T");
            String string2 = stringBuilder.append(Reflection.getOrCreateKotlinClass(Enum.class).getSimpleName()).append(" values: [0..").append(ArraysKt.getLastIndex(values$iv)).append(']').toString();
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return (T)values$iv[ordinal];
    }

    @NotNull
    public static final RdId readRdId(@NotNull AbstractBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return RdId.Companion.read($receiver);
    }

    @Nullable
    public static final <T> T readNullable(@NotNull AbstractBuffer $receiver, @NotNull Function0<? extends T> inner) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(inner, "inner");
        if (!$receiver.readBoolean()) {
            return null;
        }
        return inner.invoke();
    }

    /*
     * WARNING - void declaration
     */
    @PublicApi
    private static final <T> T[] readArray(@NotNull AbstractBuffer $receiver, Function0<? extends T> inner) {
        int len = $receiver.readInt();
        if (len < 0) {
            throw (Throwable)new NullPointerException("Length of array is negative: " + len);
        }
        Intrinsics.reifiedOperationMarker(0, "T?");
        Object[] result$iv = new Object[len];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            void i$iv;
            void var7_6 = i$iv;
            void var11_8 = i$iv++;
            Object[] objectArray = result$iv;
            T t = inner.invoke();
            objectArray[var11_8] = t;
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> readList(@NotNull AbstractBuffer $receiver, @NotNull Function0<? extends T> inner) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(inner, "inner");
        int len = $receiver.readInt();
        if (len < 0) {
            throw (Throwable)new NullPointerException("Length of array is negative: " + len);
        }
        ArrayList<T> res2 = new ArrayList<T>(len);
        int n = 1;
        int n2 = len;
        if (n <= n2) {
            while (true) {
                void i;
                res2.add(inner.invoke());
                if (i == n2) break;
                ++i;
            }
        }
        return res2;
    }

    public static final void writeUuid(@NotNull AbstractBuffer $receiver, @NotNull UUID value2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        byte[] uuidBytes = new byte[16];
        BitHacksKt.putLong(uuidBytes, value2.getMostSignificantBits(), 0);
        BitHacksKt.putLong(uuidBytes, value2.getLeastSignificantBits(), 8);
        byte[] guidBytes = SerializersKt.transformGuidUuid(uuidBytes);
        $receiver.writeByteArray(guidBytes);
    }

    public static final void writeGuid(@NotNull AbstractBuffer $receiver, @NotNull UUID value2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        SerializersKt.writeUuid($receiver, value2);
    }

    public static final void writeDateTime(@NotNull AbstractBuffer $receiver, @NotNull Date value2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        long timeInTicks = value2.getTime() * TICKS_PER_MILLISECOND + TICKS_AT_EPOCH;
        $receiver.writeLong(timeInTicks);
    }

    public static final void writeUri(@NotNull AbstractBuffer $receiver, @NotNull URI value2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        String string2 = value2.toString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "value.toString()");
        $receiver.writeString(string2);
    }

    public static final <T> void writeNullable(@NotNull AbstractBuffer $receiver, @Nullable T value2, @NotNull Function1<? super T, Unit> elemWriter) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(elemWriter, "elemWriter");
        if (value2 == null) {
            $receiver.writeBoolean(false);
        } else {
            $receiver.writeBoolean(true);
            elemWriter.invoke(value2);
        }
    }

    @PublicApi
    public static final <T> void writeArray(@NotNull AbstractBuffer $receiver, @NotNull T[] value2, @NotNull Function1<? super T, Unit> elemWriter) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        Intrinsics.checkParameterIsNotNull(elemWriter, "elemWriter");
        $receiver.writeInt(value2.length);
        T[] $receiver$iv = value2;
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            T element$iv;
            T it = element$iv = $receiver$iv[i];
            elemWriter.invoke(it);
        }
    }

    public static final <T> void writeList(@NotNull AbstractBuffer $receiver, @NotNull List<? extends T> value2, @NotNull Function1<? super T, Unit> elemWriter) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        Intrinsics.checkParameterIsNotNull(elemWriter, "elemWriter");
        $receiver.writeInt(value2.size());
        Iterable $receiver$iv = value2;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            elemWriter.invoke(it);
        }
    }

    private static final <T extends Enum<T>> void writeEnum(@NotNull AbstractBuffer $receiver, Enum<T> value2) {
        $receiver.writeInt(value2.ordinal());
    }

    public static final void writeRdId(@NotNull AbstractBuffer $receiver, @NotNull RdId value2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        value2.write($receiver);
    }

    public static final void writeBool(@NotNull AbstractBuffer $receiver, boolean value2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        $receiver.writeBoolean(value2);
    }

    public static final boolean readBool(@NotNull AbstractBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.readBoolean();
    }

    public static final void readVoid(@NotNull AbstractBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
    }

    public static final void writeVoid(@NotNull AbstractBuffer $receiver, @NotNull Unit unit) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(unit, "void");
    }

    @NotNull
    public static final RdSecureString readSecureString(@NotNull AbstractBuffer $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new RdSecureString($receiver.readString());
    }

    public static final void writeSecureString(@NotNull AbstractBuffer $receiver, @NotNull RdSecureString string2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(string2, "string");
        $receiver.writeString(string2.getContents());
    }

    static {
        TICKS_AT_EPOCH = 621355968000000000L;
        TICKS_PER_MILLISECOND = 10000L;
    }
}

