/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.generator.nova;

import com.jetbrains.rider.generator.nova.GeneratorException;
import com.jetbrains.rider.generator.nova.IGenerator;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/generator/nova/GeneratorBase;", "Lcom/jetbrains/rider/generator/nova/IGenerator;", "()V", "fail", "", "msg", "", "prepareGenerationFolder", "", "folder", "Ljava/io/File;", "removeIfExists", "", "rd-gen"})
public abstract class GeneratorBase
implements IGenerator {
    @NotNull
    protected final Void fail(@NotNull String msg) {
        Intrinsics.checkParameterIsNotNull(msg, "msg");
        throw (Throwable)new GeneratorException(msg);
    }

    protected final void prepareGenerationFolder(@NotNull File folder, boolean removeIfExists) {
        Intrinsics.checkParameterIsNotNull(folder, "folder");
        Path path2 = folder.toPath();
        Intrinsics.checkExpressionValueIsNotNull(path2, "folder.toPath()");
        if (path2.getNameCount() == 0) {
            Void void_ = this.fail("Can't use root folder '" + folder + "' as output");
            throw null;
        }
        if (removeIfExists && folder.exists() && !FilesKt.deleteRecursively(folder)) {
            Void void_ = this.fail("Can't delete '" + folder + '\'');
            throw null;
        }
        if (folder.exists()) {
            if (!folder.isDirectory()) {
                Void void_ = this.fail("Not a folder: '" + folder + '\'');
                throw null;
            }
        } else if (!folder.mkdirs()) {
            Void void_ = this.fail("Can't create folder '" + folder + '\'');
            throw null;
        }
    }
}

