/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.generator.nova;

import com.jetbrains.rider.generator.nova.Class;
import com.jetbrains.rider.generator.nova.Declaration;
import com.jetbrains.rider.generator.nova.FlowKind;
import com.jetbrains.rider.generator.nova.FlowTransform;
import com.jetbrains.rider.generator.nova.IGenerator;
import com.jetbrains.rider.generator.nova.INonNullable;
import com.jetbrains.rider.generator.nova.INonNullableScalar;
import com.jetbrains.rider.generator.nova.INullable;
import com.jetbrains.rider.generator.nova.IScalar;
import com.jetbrains.rider.generator.nova.IType;
import com.jetbrains.rider.generator.nova.SettingsHolder;
import com.jetbrains.rider.util.hash.IncrementalHash64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u001e\u001f !B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dR\u001c\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u0003\"#$\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/generator/nova/Member;", "Lcom/jetbrains/rider/generator/nova/SettingsHolder;", "name", "", "referencedTypes", "", "Lcom/jetbrains/rider/generator/nova/IType;", "(Ljava/lang/String;Ljava/util/List;)V", "documentation", "getDocumentation", "()Ljava/lang/String;", "setDocumentation", "(Ljava/lang/String;)V", "getName", "owner", "Lcom/jetbrains/rider/generator/nova/Declaration;", "getOwner", "()Lcom/jetbrains/rider/generator/nova/Declaration;", "setOwner", "(Lcom/jetbrains/rider/generator/nova/Declaration;)V", "getReferencedTypes", "()Ljava/util/List;", "serializationHash", "Lcom/jetbrains/rider/util/hash/IncrementalHash64;", "initial", "toString", "validate", "", "errors", "", "EnumConst", "ExtensionDelegate", "Field", "Reactive", "Lcom/jetbrains/rider/generator/nova/Member$EnumConst;", "Lcom/jetbrains/rider/generator/nova/Member$Field;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive;", "rd-gen"})
public abstract class Member
extends SettingsHolder {
    @NotNull
    private final String name;
    @Nullable
    private String documentation;
    @NotNull
    public Declaration owner;
    @NotNull
    private final List<IType> referencedTypes;

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public final String getDocumentation() {
        return this.documentation;
    }

    public final void setDocumentation(@Nullable String string2) {
        this.documentation = string2;
    }

    @NotNull
    public final Declaration getOwner() {
        Declaration declaration = this.owner;
        if (declaration == null) {
            Intrinsics.throwUninitializedPropertyAccessException("owner");
        }
        return declaration;
    }

    public final void setOwner(@NotNull Declaration declaration) {
        Intrinsics.checkParameterIsNotNull(declaration, "<set-?>");
        this.owner = declaration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IncrementalHash64 serializationHash(@NotNull IncrementalHash64 initial) {
        void $receiver$iv;
        IncrementalHash64 initial$iv;
        Intrinsics.checkParameterIsNotNull(initial, "initial");
        Iterable iterable = this.referencedTypes;
        IncrementalHash64 accumulator$iv = initial$iv = initial.mix(this.getName());
        for (Object element$iv : $receiver$iv) {
            void type2;
            IType iType = (IType)element$iv;
            IncrementalHash64 acc = accumulator$iv;
            accumulator$iv = acc.mix(type2.getName());
        }
        return accumulator$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void validate(@NotNull List<String> errors) {
        boolean bl;
        Iterator iterator2;
        Object $receiver$iv;
        String m;
        block17: {
            block19: {
                block18: {
                    boolean bl2;
                    block16: {
                        Intrinsics.checkParameterIsNotNull(errors, "errors");
                        StringBuilder stringBuilder = new StringBuilder().append('\'');
                        Declaration declaration = this.owner;
                        if (declaration == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("owner");
                        }
                        m = stringBuilder.append(declaration.getName()).append('.').append(this.getName()).append('\'').toString();
                        if (StringsKt.isBlank(this.getName())) {
                            errors.add("Member " + m + " is invalid: empty name");
                            return;
                        }
                        char c = this.getName().charAt(0);
                        if (!Character.isLetter(c)) break block18;
                        $receiver$iv = this.getName();
                        iterator2 = $receiver$iv;
                        for (int i = 0; i < iterator2.length(); ++i) {
                            char element$iv = iterator2.charAt(i);
                            char it = element$iv;
                            char c2 = it;
                            if (Character.isLetterOrDigit(c2) || it == '_') continue;
                            bl2 = false;
                            break block16;
                        }
                        bl2 = true;
                    }
                    if (bl2) break block19;
                }
                errors.add("Member " + m + " is invalid: must be [A-Za-z][A-Za-z0-9_]*");
                return;
            }
            String string2 = StringsKt.capitalize(this.getName());
            Declaration declaration = this.owner;
            if (declaration == null) {
                Intrinsics.throwUninitializedPropertyAccessException("owner");
            }
            if (Intrinsics.areEqual(string2, declaration.getName())) {
                errors.add("Member " + m + " is invalid: name cannot be the same as its enclosing declaration");
                return;
            }
            Declaration declaration2 = this.owner;
            if (declaration2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("owner");
            }
            if (($receiver$iv = (Iterable)declaration2.getOwnMembers()) instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    Member it = (Member)element$iv;
                    if (!(Intrinsics.areEqual(it, this) ^ true && Intrinsics.areEqual(it.getName(), this.getName()))) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl) {
            errors.add("Member " + m + " is duplicated");
            return;
        } else {
            Object element$iv;
            Member it;
            Declaration declaration = this.owner;
            if (declaration == null) {
                Intrinsics.throwUninitializedPropertyAccessException("owner");
            }
            if (($receiver$iv = (Iterable)declaration.getMembersOfBaseClasses()) instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                return;
            }
            iterator2 = $receiver$iv.iterator();
            do {
                if (!iterator2.hasNext()) return;
            } while (!Intrinsics.areEqual((it = (Member)(element$iv = iterator2.next())).getName(), this.getName()));
            boolean bl3 = true;
            if (!bl3) return;
            errors.add("Member " + m + " is contained by base class");
        }
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.getName();
    }

    @NotNull
    public final List<IType> getReferencedTypes() {
        return this.referencedTypes;
    }

    private Member(String name2, List<? extends IType> referencedTypes) {
        this.referencedTypes = referencedTypes;
        this.name = StringsKt.decapitalize(name2);
    }

    public /* synthetic */ Member(@NotNull String name2, @NotNull List referencedTypes, DefaultConstructorMarker $constructor_marker) {
        this(name2, referencedTypes);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$EnumConst;", "Lcom/jetbrains/rider/generator/nova/Member;", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "rd-gen"})
    public static final class EnumConst
    extends Member {
        @NotNull
        private final String name;

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        public EnumConst(@NotNull String name2) {
            Intrinsics.checkParameterIsNotNull(name2, "name");
            super(name2, CollectionsKt.emptyList(), null);
            this.name = name2;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$Field;", "Lcom/jetbrains/rider/generator/nova/Member;", "name", "", "type", "Lcom/jetbrains/rider/generator/nova/IType;", "(Ljava/lang/String;Lcom/jetbrains/rider/generator/nova/IType;)V", "defaultValue", "", "getDefaultValue$rd_gen", "()Ljava/lang/Object;", "setDefaultValue$rd_gen", "(Ljava/lang/Object;)V", "emptyCtorSuppressed", "", "getEmptyCtorSuppressed$rd_gen", "()Z", "setEmptyCtorSuppressed$rd_gen", "(Z)V", "isOptional", "isOptional$rd_gen", "setOptional$rd_gen", "getType", "()Lcom/jetbrains/rider/generator/nova/IType;", "rd-gen"})
    public static final class Field
    extends Member {
        private boolean emptyCtorSuppressed;
        private boolean isOptional;
        @Nullable
        private Object defaultValue;
        @NotNull
        private final IType type;

        public final boolean getEmptyCtorSuppressed$rd_gen() {
            return this.emptyCtorSuppressed;
        }

        public final void setEmptyCtorSuppressed$rd_gen(boolean bl) {
            this.emptyCtorSuppressed = bl;
        }

        public final boolean isOptional$rd_gen() {
            return this.isOptional;
        }

        public final void setOptional$rd_gen(boolean bl) {
            this.isOptional = bl;
        }

        @Nullable
        public final Object getDefaultValue$rd_gen() {
            return this.defaultValue;
        }

        public final void setDefaultValue$rd_gen(@Nullable Object object) {
            this.defaultValue = object;
        }

        @NotNull
        public final IType getType() {
            return this.type;
        }

        public Field(@NotNull String name2, @NotNull IType type2) {
            Intrinsics.checkParameterIsNotNull(name2, "name");
            Intrinsics.checkParameterIsNotNull(type2, "type");
            super(name2, CollectionsKt.listOf(type2), null);
            this.type = type2;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$ExtensionDelegate;", "", "klass", "Lkotlin/reflect/KClass;", "Lcom/jetbrains/rider/generator/nova/IGenerator;", "flowTransform", "Lcom/jetbrains/rider/generator/nova/FlowTransform;", "delegateFqn", "", "factoryFqn", "(Lkotlin/reflect/KClass;Lcom/jetbrains/rider/generator/nova/FlowTransform;Ljava/lang/String;Ljava/lang/String;)V", "getDelegateFqn", "()Ljava/lang/String;", "getFactoryFqn", "getFlowTransform", "()Lcom/jetbrains/rider/generator/nova/FlowTransform;", "getKlass", "()Lkotlin/reflect/KClass;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "rd-gen"})
    public static final class ExtensionDelegate {
        @NotNull
        private final KClass<? extends IGenerator> klass;
        @Nullable
        private final FlowTransform flowTransform;
        @NotNull
        private final String delegateFqn;
        @NotNull
        private final String factoryFqn;

        @NotNull
        public final KClass<? extends IGenerator> getKlass() {
            return this.klass;
        }

        @Nullable
        public final FlowTransform getFlowTransform() {
            return this.flowTransform;
        }

        @NotNull
        public final String getDelegateFqn() {
            return this.delegateFqn;
        }

        @NotNull
        public final String getFactoryFqn() {
            return this.factoryFqn;
        }

        public ExtensionDelegate(@NotNull KClass<? extends IGenerator> klass2, @Nullable FlowTransform flowTransform, @NotNull String delegateFqn, @NotNull String factoryFqn) {
            Intrinsics.checkParameterIsNotNull(klass2, "klass");
            Intrinsics.checkParameterIsNotNull(delegateFqn, "delegateFqn");
            Intrinsics.checkParameterIsNotNull(factoryFqn, "factoryFqn");
            this.klass = klass2;
            this.flowTransform = flowTransform;
            this.delegateFqn = delegateFqn;
            this.factoryFqn = factoryFqn;
        }

        public /* synthetic */ ExtensionDelegate(KClass kClass2, FlowTransform flowTransform, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 8) != 0) {
                string3 = string2;
            }
            this(kClass2, flowTransform, string2, string3);
        }

        @NotNull
        public final KClass<? extends IGenerator> component1() {
            return this.klass;
        }

        @Nullable
        public final FlowTransform component2() {
            return this.flowTransform;
        }

        @NotNull
        public final String component3() {
            return this.delegateFqn;
        }

        @NotNull
        public final String component4() {
            return this.factoryFqn;
        }

        @NotNull
        public final ExtensionDelegate copy(@NotNull KClass<? extends IGenerator> klass2, @Nullable FlowTransform flowTransform, @NotNull String delegateFqn, @NotNull String factoryFqn) {
            Intrinsics.checkParameterIsNotNull(klass2, "klass");
            Intrinsics.checkParameterIsNotNull(delegateFqn, "delegateFqn");
            Intrinsics.checkParameterIsNotNull(factoryFqn, "factoryFqn");
            return new ExtensionDelegate(klass2, flowTransform, delegateFqn, factoryFqn);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ExtensionDelegate copy$default(ExtensionDelegate extensionDelegate, KClass kClass2, FlowTransform flowTransform, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                kClass2 = extensionDelegate.klass;
            }
            if ((n & 2) != 0) {
                flowTransform = extensionDelegate.flowTransform;
            }
            if ((n & 4) != 0) {
                string2 = extensionDelegate.delegateFqn;
            }
            if ((n & 8) != 0) {
                string3 = extensionDelegate.factoryFqn;
            }
            return extensionDelegate.copy(kClass2, flowTransform, string2, string3);
        }

        public String toString() {
            return "ExtensionDelegate(klass=" + this.klass + ", flowTransform=" + (Object)((Object)this.flowTransform) + ", delegateFqn=" + this.delegateFqn + ", factoryFqn=" + this.factoryFqn + ")";
        }

        public int hashCode() {
            KClass<? extends IGenerator> kClass2 = this.klass;
            FlowTransform flowTransform = this.flowTransform;
            String string2 = this.delegateFqn;
            String string3 = this.factoryFqn;
            return (((kClass2 != null ? ((Object)kClass2).hashCode() : 0) * 31 + (flowTransform != null ? ((Object)((Object)flowTransform)).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ExtensionDelegate)) break block3;
                    ExtensionDelegate extensionDelegate = (ExtensionDelegate)object;
                    if (!Intrinsics.areEqual(this.klass, extensionDelegate.klass) || !Intrinsics.areEqual((Object)this.flowTransform, (Object)extensionDelegate.flowTransform) || !Intrinsics.areEqual(this.delegateFqn, extensionDelegate.delegateFqn) || !Intrinsics.areEqual(this.factoryFqn, extensionDelegate.factoryFqn)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u0082\u0001\u0003\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$Reactive;", "Lcom/jetbrains/rider/generator/nova/Member;", "name", "", "genericParams", "", "Lcom/jetbrains/rider/generator/nova/IType;", "(Ljava/lang/String;[Lcom/jetbrains/rider/generator/nova/IType;)V", "flow", "Lcom/jetbrains/rider/generator/nova/FlowKind;", "getFlow", "()Lcom/jetbrains/rider/generator/nova/FlowKind;", "setFlow", "(Lcom/jetbrains/rider/generator/nova/FlowKind;)V", "freeThreaded", "", "getFreeThreaded", "()Z", "setFreeThreaded", "(Z)V", "getGenericParams", "()[Lcom/jetbrains/rider/generator/nova/IType;", "[Lcom/jetbrains/rider/generator/nova/IType;", "Signal", "Stateful", "Task", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Task;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Signal;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful;", "rd-gen"})
    public static abstract class Reactive
    extends Member {
        @NotNull
        private FlowKind flow;
        private boolean freeThreaded;
        @NotNull
        private final IType[] genericParams;

        @NotNull
        public final FlowKind getFlow() {
            return this.flow;
        }

        public final void setFlow(@NotNull FlowKind flowKind) {
            Intrinsics.checkParameterIsNotNull((Object)flowKind, "<set-?>");
            this.flow = flowKind;
        }

        public final boolean getFreeThreaded() {
            return this.freeThreaded;
        }

        public final void setFreeThreaded(boolean bl) {
            this.freeThreaded = bl;
        }

        @NotNull
        public final IType[] getGenericParams() {
            return this.genericParams;
        }

        private Reactive(String name2, IType ... genericParams) {
            super(name2, ArraysKt.toList(genericParams), null);
            this.genericParams = genericParams;
            this.flow = FlowKind.Both;
        }

        public /* synthetic */ Reactive(@NotNull String name2, @NotNull IType[] genericParams,  /* corrupt varargs signature?! */ DefaultConstructorMarkerDefaultConstructorMarker $constructor_marker) {
            this(name2, genericParams);
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$Reactive$Task;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive;", "name", "", "paramType", "Lcom/jetbrains/rider/generator/nova/IScalar;", "resultType", "(Ljava/lang/String;Lcom/jetbrains/rider/generator/nova/IScalar;Lcom/jetbrains/rider/generator/nova/IScalar;)V", "rd-gen"})
        public static final class Task
        extends Reactive {
            public Task(@NotNull String name2, @NotNull IScalar paramType, @NotNull IScalar resultType) {
                Intrinsics.checkParameterIsNotNull(name2, "name");
                Intrinsics.checkParameterIsNotNull(paramType, "paramType");
                Intrinsics.checkParameterIsNotNull(resultType, "resultType");
                super(name2, new IType[]{paramType, resultType}, (DefaultConstructorMarker)null);
            }
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$Reactive$Signal;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive;", "name", "", "paramType", "Lcom/jetbrains/rider/generator/nova/IScalar;", "(Ljava/lang/String;Lcom/jetbrains/rider/generator/nova/IScalar;)V", "rd-gen"})
        public static final class Signal
        extends Reactive {
            public Signal(@NotNull String name2, @NotNull IScalar paramType) {
                Intrinsics.checkParameterIsNotNull(name2, "name");
                Intrinsics.checkParameterIsNotNull(paramType, "paramType");
                super(name2, new IType[]{paramType}, (DefaultConstructorMarker)null);
            }
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\b\t\n\u000b\fB#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u0082\u0001\u0005\r\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive;", "name", "", "genericParams", "", "Lcom/jetbrains/rider/generator/nova/IType;", "(Ljava/lang/String;[Lcom/jetbrains/rider/generator/nova/IType;)V", "Extension", "List", "Map", "Property", "Set", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful$Property;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful$List;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful$Set;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful$Map;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful$Extension;", "rd-gen"})
        public static abstract class Stateful
        extends Reactive {
            private Stateful(String name2, IType ... genericParams) {
                super(name2, Arrays.copyOf(genericParams, genericParams.length), (DefaultConstructorMarker)null);
            }

            public /* synthetic */ Stateful(@NotNull String name2, @NotNull IType[] genericParams,  /* corrupt varargs signature?! */ DefaultConstructorMarkerDefaultConstructorMarker $constructor_marker) {
                this(name2, genericParams);
            }

            @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful$Property;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful;", "name", "", "valueType", "Lcom/jetbrains/rider/generator/nova/IType;", "defaultValue", "", "(Ljava/lang/String;Lcom/jetbrains/rider/generator/nova/IType;Ljava/lang/Object;)V", "getDefaultValue", "()Ljava/lang/Object;", "isNullable", "", "()Z", "rd-gen"})
            public static final class Property
            extends Stateful {
                @Nullable
                private final Object defaultValue;

                public final boolean isNullable() {
                    return CollectionsKt.first(this.getReferencedTypes()) instanceof INullable;
                }

                @Nullable
                public final Object getDefaultValue() {
                    return this.defaultValue;
                }

                public Property(@NotNull String name2, @NotNull IType valueType, @Nullable Object defaultValue) {
                    Intrinsics.checkParameterIsNotNull(name2, "name");
                    Intrinsics.checkParameterIsNotNull(valueType, "valueType");
                    super(name2, new IType[]{valueType}, (DefaultConstructorMarker)null);
                    this.defaultValue = defaultValue;
                }

                public /* synthetic */ Property(String string2, IType iType, Object object, int n, DefaultConstructorMarker defaultConstructorMarker2) {
                    if ((n & 4) != 0) {
                        object = null;
                    }
                    this(string2, iType, object);
                }
            }

            @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful$List;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful;", "name", "", "itemType", "Lcom/jetbrains/rider/generator/nova/IType;", "(Ljava/lang/String;Lcom/jetbrains/rider/generator/nova/IType;)V", "rd-gen"})
            public static final class List
            extends Stateful {
                public List(@NotNull String name2, @NotNull IType itemType) {
                    Intrinsics.checkParameterIsNotNull(name2, "name");
                    Intrinsics.checkParameterIsNotNull(itemType, "itemType");
                    super(name2, new IType[]{itemType}, (DefaultConstructorMarker)null);
                }
            }

            @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful$Set;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful;", "name", "", "itemType", "Lcom/jetbrains/rider/generator/nova/INonNullableScalar;", "(Ljava/lang/String;Lcom/jetbrains/rider/generator/nova/INonNullableScalar;)V", "rd-gen"})
            public static final class Set
            extends Stateful {
                public Set(@NotNull String name2, @NotNull INonNullableScalar itemType) {
                    Intrinsics.checkParameterIsNotNull(name2, "name");
                    Intrinsics.checkParameterIsNotNull(itemType, "itemType");
                    super(name2, new IType[]{itemType}, (DefaultConstructorMarker)null);
                }
            }

            @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful$Map;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful;", "name", "", "keyType", "Lcom/jetbrains/rider/generator/nova/INonNullableScalar;", "valueType", "Lcom/jetbrains/rider/generator/nova/INonNullable;", "(Ljava/lang/String;Lcom/jetbrains/rider/generator/nova/INonNullableScalar;Lcom/jetbrains/rider/generator/nova/INonNullable;)V", "rd-gen"})
            public static final class Map
            extends Stateful {
                public Map(@NotNull String name2, @NotNull INonNullableScalar keyType, @NotNull INonNullable valueType) {
                    Intrinsics.checkParameterIsNotNull(name2, "name");
                    Intrinsics.checkParameterIsNotNull(keyType, "keyType");
                    Intrinsics.checkParameterIsNotNull(valueType, "valueType");
                    super(name2, new IType[]{keyType, valueType}, (DefaultConstructorMarker)null);
                }
            }

            @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001BS\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012:\u0010\u0006\u001a\u001e\u0012\u001a\b\u0001\u0012\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00030\b0\u0007\"\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\u000bB)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0007\"\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0007\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful$Extension;", "Lcom/jetbrains/rider/generator/nova/Member$Reactive$Stateful;", "name", "", "delegatedBy", "Lcom/jetbrains/rider/generator/nova/Class;", "_delegateFqn", "", "Lkotlin/Pair;", "Lkotlin/reflect/KClass;", "Lcom/jetbrains/rider/generator/nova/IGenerator;", "(Ljava/lang/String;Lcom/jetbrains/rider/generator/nova/Class;[Lkotlin/Pair;)V", "_delegates", "Lcom/jetbrains/rider/generator/nova/Member$ExtensionDelegate;", "(Ljava/lang/String;Lcom/jetbrains/rider/generator/nova/Class;[Lcom/jetbrains/rider/generator/nova/Member$ExtensionDelegate;)V", "getDelegatedBy", "()Lcom/jetbrains/rider/generator/nova/Class;", "delegates", "getDelegates", "()[Lcom/jetbrains/rider/generator/nova/Member$ExtensionDelegate;", "[Lcom/jetbrains/rider/generator/nova/Member$ExtensionDelegate;", "factoryFqn", "generator", "flowTransform", "Lcom/jetbrains/rider/generator/nova/FlowTransform;", "findDelegate", "fqn", "rd-gen"})
            public static abstract class Extension
            extends Stateful {
                @NotNull
                private final ExtensionDelegate[] delegates;
                @NotNull
                private final Class delegatedBy;

                @NotNull
                public final ExtensionDelegate[] getDelegates() {
                    return this.delegates;
                }

                @NotNull
                public final String fqn(@NotNull IGenerator generator, @NotNull FlowTransform flowTransform) {
                    Intrinsics.checkParameterIsNotNull(generator, "generator");
                    Intrinsics.checkParameterIsNotNull((Object)flowTransform, "flowTransform");
                    Object object = this.findDelegate(generator, flowTransform);
                    if (object == null || (object = ((ExtensionDelegate)object).getDelegateFqn()) == null) {
                        String string2 = this.getClass().getSimpleName();
                        object = string2;
                        Intrinsics.checkExpressionValueIsNotNull(string2, "javaClass.simpleName");
                    }
                    return object;
                }

                @NotNull
                public final String factoryFqn(@NotNull IGenerator generator, @NotNull FlowTransform flowTransform) {
                    Intrinsics.checkParameterIsNotNull(generator, "generator");
                    Intrinsics.checkParameterIsNotNull((Object)flowTransform, "flowTransform");
                    Object object = this.findDelegate(generator, flowTransform);
                    if (object == null || (object = ((ExtensionDelegate)object).getFactoryFqn()) == null) {
                        String string2 = this.getClass().getSimpleName();
                        object = string2;
                        Intrinsics.checkExpressionValueIsNotNull(string2, "javaClass.simpleName");
                    }
                    return object;
                }

                private final ExtensionDelegate findDelegate(IGenerator generator, FlowTransform flowTransform) {
                    ExtensionDelegate extensionDelegate;
                    block1: {
                        for (ExtensionDelegate element$iv : this.delegates) {
                            ExtensionDelegate it = element$iv;
                            if (!(KClasses.safeCast(it.getKlass(), generator) != null && (it.getFlowTransform() == null || it.getFlowTransform() == flowTransform))) continue;
                            extensionDelegate = element$iv;
                            break block1;
                        }
                        extensionDelegate = null;
                    }
                    return extensionDelegate;
                }

                @NotNull
                public final Class getDelegatedBy() {
                    return this.delegatedBy;
                }

                public Extension(@NotNull String name2, @NotNull Class delegatedBy, ExtensionDelegate ... _delegates) {
                    Intrinsics.checkParameterIsNotNull(name2, "name");
                    Intrinsics.checkParameterIsNotNull(delegatedBy, "delegatedBy");
                    Intrinsics.checkParameterIsNotNull(_delegates, "_delegates");
                    super(name2, new IType[0], (DefaultConstructorMarker)null);
                    this.delegatedBy = delegatedBy;
                    this.delegates = _delegates;
                }

                /*
                 * WARNING - void declaration
                 */
                public Extension(@NotNull String name2, @NotNull Class delegatedBy, Pair<? extends KClass<? extends IGenerator>, String> ... _delegateFqn) {
                    ExtensionDelegate[] extensionDelegateArray;
                    void $receiver$iv$iv;
                    Collection $receiver$iv;
                    Intrinsics.checkParameterIsNotNull(name2, "name");
                    Intrinsics.checkParameterIsNotNull(delegatedBy, "delegatedBy");
                    Intrinsics.checkParameterIsNotNull(_delegateFqn, "_delegateFqn");
                    Pair<? extends KClass<? extends IGenerator>, String>[] pairArray = _delegateFqn;
                    Class clazz = delegatedBy;
                    String string2 = name2;
                    Extension extension = this;
                    void var5_8 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
                    int n = ((void)$receiver$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var10_13 = item$iv$iv = $receiver$iv$iv[i];
                        extensionDelegateArray = destination$iv$iv;
                        ExtensionDelegate extensionDelegate = new ExtensionDelegate((KClass)it.getFirst(), null, (String)it.getSecond(), null, 8, null);
                        extensionDelegateArray.add(extensionDelegate);
                    }
                    extensionDelegateArray = (java.util.List)destination$iv$iv;
                    Collection thisCollection$iv = $receiver$iv = (Collection)extensionDelegateArray;
                    ExtensionDelegate[] extensionDelegateArray2 = thisCollection$iv.toArray(new ExtensionDelegate[0]);
                    if (extensionDelegateArray2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    ExtensionDelegate[] extensionDelegateArray3 = extensionDelegateArray = extensionDelegateArray2;
                    extension(string2, clazz, Arrays.copyOf(extensionDelegateArray3, extensionDelegateArray3.length));
                }
            }
        }
    }
}

