/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.log;

import com.jetbrains.rider.util.ConsoleLoggerFactory;
import com.jetbrains.rider.util.ILoggerFactory;
import com.jetbrains.rider.util.LogLevel;
import com.jetbrains.rider.util.Logger;
import com.jetbrains.rider.util.LoggerKt;
import com.jetbrains.rider.util.PlatformDependentKt;
import com.jetbrains.rider.util.log.ErrorAccumulatorLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/util/log/ErrorAccumulatorLoggerFactory;", "Lcom/jetbrains/rider/util/ILoggerFactory;", "()V", "creationThread", "", "getCreationThread", "()Ljava/lang/String;", "errors", "", "getErrors", "()Ljava/util/List;", "warnAsErrors", "", "getWarnAsErrors", "()Z", "setWarnAsErrors", "(Z)V", "getLogger", "Lcom/jetbrains/rider/util/Logger;", "category", "throwAndClear", "", "rd-core-jvm"})
public final class ErrorAccumulatorLoggerFactory
implements ILoggerFactory {
    private static boolean warnAsErrors;
    @NotNull
    private static final List<String> errors;
    @NotNull
    private static final String creationThread;
    public static final ErrorAccumulatorLoggerFactory INSTANCE;

    public final boolean getWarnAsErrors() {
        return warnAsErrors;
    }

    public final void setWarnAsErrors(boolean bl) {
        warnAsErrors = bl;
    }

    @NotNull
    public final List<String> getErrors() {
        return errors;
    }

    @NotNull
    public final String getCreationThread() {
        return creationThread;
    }

    @Override
    @NotNull
    public Logger getLogger(@NotNull String category) {
        Intrinsics.checkParameterIsNotNull(category, "category");
        return new Logger(category){
            static final /* synthetic */ KProperty[] $$delegatedProperties;
            private final Lazy consoleLogger$delegate;
            final /* synthetic */ String $category;

            static {
                $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(getLogger.1.class), "consoleLogger", "getConsoleLogger()Lcom/jetbrains/rider/util/Logger;"))};
            }

            private final Logger getConsoleLogger() {
                Lazy lazy = this.consoleLogger$delegate;
                getLogger.1 var2_2 = this;
                KProperty kProperty = $$delegatedProperties[0];
                return (Logger)lazy.getValue();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void log(@NotNull LogLevel level, @Nullable Object message, @Nullable Throwable throwable) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)level), "level");
                this.getConsoleLogger().log(level, message, throwable);
                if (!this.isEnabled(level)) {
                    return;
                }
                if (Intrinsics.areEqual(PlatformDependentKt.currentThreadName(), ErrorAccumulatorLoggerFactory.INSTANCE.getCreationThread())) {
                    Object object = message;
                    throw (Throwable)new IllegalStateException(object != null ? object.toString() : null, throwable);
                }
                String renderMessage = LoggerKt.defaultLogFormat(this.$category, level, message, throwable);
                getLogger.1 var5_5 = this;
                synchronized (var5_5) {
                    boolean bl = ErrorAccumulatorLoggerFactory.INSTANCE.getErrors().add(renderMessage);
                }
            }

            public boolean isEnabled(@NotNull LogLevel level) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)level), "level");
                return level == LogLevel.Fatal || level == LogLevel.Error || ErrorAccumulatorLoggerFactory.INSTANCE.getWarnAsErrors() && level == LogLevel.Warn;
            }
            {
                this.$category = $captured_local_variable$0;
                this.consoleLogger$delegate = LazyKt.lazy((Function0)new Function0<Logger>(this){
                    final /* synthetic */ getLogger.1 this$0;

                    @NotNull
                    public final Logger invoke() {
                        return ConsoleLoggerFactory.INSTANCE.getLogger(this.this$0.$category);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
        };
    }

    public final void throwAndClear() {
        if (errors.isEmpty()) {
            return;
        }
        String text2 = "There are " + errors.size() + " exceptions:" + PlatformDependentKt.getEol() + CollectionsKt.joinToString$default(errors, PlatformDependentKt.getEol() + PlatformDependentKt.getEol() + " --------------------------- " + PlatformDependentKt.getEol() + PlatformDependentKt.getEol(), null, null, 0, null, null, 62, null);
        errors.clear();
        throw (Throwable)new IllegalStateException(text2);
    }

    private ErrorAccumulatorLoggerFactory() {
    }

    static {
        ErrorAccumulatorLoggerFactory errorAccumulatorLoggerFactory;
        INSTANCE = errorAccumulatorLoggerFactory = new ErrorAccumulatorLoggerFactory();
        errors = new ArrayList();
        creationThread = PlatformDependentKt.currentThreadName();
    }
}

