/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.reactive;

import com.jetbrains.rider.util.reactive.RdFault;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u000b*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002:\u0004\n\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J)\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0000\"\u0004\b\u0001\u0010\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00050\u0007H\u0086\bJ\u000b\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\t\u0082\u0001\u0003\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/util/reactive/TaskResult;", "T", "", "()V", "map", "R", "transform", "Lkotlin/Function1;", "unwrap", "()Ljava/lang/Object;", "Cancelled", "Companion", "Fault", "Success", "Lcom/jetbrains/rider/util/reactive/TaskResult$Success;", "Lcom/jetbrains/rider/util/reactive/TaskResult$Cancelled;", "Lcom/jetbrains/rider/util/reactive/TaskResult$Fault;", "rd-core-jvm"})
public abstract class TaskResult<T> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final <R> TaskResult<R> map(@NotNull Function1<? super T, ? extends R> transform) {
        TaskResult taskResult;
        Intrinsics.checkParameterIsNotNull(transform, "transform");
        TaskResult taskResult2 = this;
        if (taskResult2 instanceof Success) {
            taskResult = new Success<R>(transform.invoke(((Success)this).getValue()));
        } else if (taskResult2 instanceof Cancelled) {
            taskResult = new Cancelled();
        } else if (taskResult2 instanceof Fault) {
            taskResult = new Fault((Throwable)((Fault)this).getFault());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return taskResult;
    }

    public final T unwrap() {
        TaskResult taskResult = this;
        if (!(taskResult instanceof Success)) {
            if (taskResult instanceof Cancelled) {
                throw (Throwable)new CancellationException();
            }
            if (taskResult instanceof Fault) {
                throw (Throwable)((Fault)this).getFault();
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((Success)this).getValue();
    }

    private TaskResult() {
    }

    public /* synthetic */ TaskResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/util/reactive/TaskResult$Success;", "T", "Lcom/jetbrains/rider/util/reactive/TaskResult;", "value", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "rd-core-jvm"})
    public static final class Success<T>
    extends TaskResult<T> {
        private final T value;

        public final T getValue() {
            return this.value;
        }

        public Success(T value2) {
            super(null);
            this.value = value2;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/rider/util/reactive/TaskResult$Cancelled;", "T", "Lcom/jetbrains/rider/util/reactive/TaskResult;", "()V", "rd-core-jvm"})
    public static final class Cancelled<T>
    extends TaskResult<T> {
        public Cancelled() {
            super(null);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/util/reactive/TaskResult$Fault;", "T", "Lcom/jetbrains/rider/util/reactive/TaskResult;", "e", "", "(Ljava/lang/Throwable;)V", "fault", "Lcom/jetbrains/rider/util/reactive/RdFault;", "(Lcom/jetbrains/rider/util/reactive/RdFault;)V", "getFault", "()Lcom/jetbrains/rider/util/reactive/RdFault;", "rd-core-jvm"})
    public static final class Fault<T>
    extends TaskResult<T> {
        @NotNull
        private final RdFault fault;

        @NotNull
        public final RdFault getFault() {
            return this.fault;
        }

        private Fault(RdFault fault) {
            super(null);
            this.fault = fault;
        }

        public Fault(@NotNull Throwable e) {
            RdFault rdFault;
            Intrinsics.checkParameterIsNotNull(e, "e");
            Throwable throwable = e;
            if (!(throwable instanceof RdFault)) {
                throwable = null;
            }
            if ((rdFault = (RdFault)throwable) == null) {
                rdFault = new RdFault(e);
            }
            this(rdFault);
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/util/reactive/TaskResult$Companion;", "", "()V", "from", "Lcom/jetbrains/rider/util/reactive/TaskResult;", "T", "handler", "Lkotlin/Function0;", "rd-core-jvm"})
    public static final class Companion {
        @NotNull
        public final <T> TaskResult<T> from(@NotNull Function0<? extends T> handler2) {
            TaskResult taskResult;
            Intrinsics.checkParameterIsNotNull(handler2, "handler");
            try {
                taskResult = new Success<T>(handler2.invoke());
            }
            catch (CancellationException e) {
                taskResult = new Cancelled();
            }
            catch (Throwable e) {
                taskResult = new Fault(e);
            }
            return taskResult;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

