/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.util.reactive;

import com.jetbrains.rider.util.CollectionExKt;
import com.jetbrains.rider.util.LogLevel;
import com.jetbrains.rider.util.LoggerKt;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.AddRemove;
import com.jetbrains.rider.util.reactive.IMutableViewableMap;
import com.jetbrains.rider.util.reactive.IViewableMap;
import com.jetbrains.rider.util.reactive.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u001e\u0010\u001f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\u0004\u0012\u00020\u001c0 H\u0016J\b\u0010!\u001a\u00020\u001cH\u0016J\u0015\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010%J\u0018\u0010(\u001a\u0004\u0018\u00018\u00012\u0006\u0010$\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020#H\u0016J\u001f\u0010+\u001a\u0004\u0018\u00018\u00012\u0006\u0010$\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010,J\u001e\u0010-\u001a\u00020\u001c2\u0014\u0010.\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010/H\u0016J\u0017\u00100\u001a\u0004\u0018\u00018\u00012\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0011j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lcom/jetbrains/rider/util/reactive/ViewableMap;", "K", "", "V", "Lcom/jetbrains/rider/util/reactive/IMutableViewableMap;", "()V", "change", "Lcom/jetbrains/rider/util/reactive/Signal;", "Lcom/jetbrains/rider/util/reactive/IViewableMap$Event;", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "map", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "advise", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "handler", "Lkotlin/Function1;", "clear", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "remove", "rd-core-jvm"})
public final class ViewableMap<K, V>
implements IMutableViewableMap<K, V> {
    private final LinkedHashMap<K, V> map;
    private final Signal<IViewableMap.Event<K, V>> change;

    @Override
    public void advise(@NotNull Lifetime lifetime, @NotNull Function1<? super IViewableMap.Event<K, V>, Unit> handler2) {
        Map $receiver$iv;
        Intrinsics.checkParameterIsNotNull(lifetime, "lifetime");
        Intrinsics.checkParameterIsNotNull(handler2, "handler");
        this.change.advise(lifetime, handler2);
        Map map2 = $receiver$iv = (Map)this;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            Object comment$iv$iv = null;
            try {
                handler2.invoke(new IViewableMap.Event.Add(it.getKey(), it.getValue()));
            }
            catch (Throwable e$iv$iv) {
                CharSequence charSequence = comment$iv$iv;
                String sfx$iv$iv = "";
                LoggerKt.getLogger("Default-Error-Logger").log(LogLevel.Error, "Catch" + sfx$iv$iv, e$iv$iv);
            }
        }
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Map<K, V> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(from, "from");
        Map<K, V> map2 = $receiver$iv = from;
        Iterator<Map.Entry<K, V>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<? extends K, ? extends V> element$iv;
            Map.Entry<? extends K, ? extends V> it = element$iv = iterator2.next();
            CollectionExKt.put(this, it);
        }
    }

    @Override
    @Nullable
    public V put(@NotNull K key, @NotNull V value2) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        V oldval = this.map.put(key, value2);
        if (oldval != null) {
            if (Intrinsics.areEqual(oldval, value2) ^ true) {
                this.change.fire(new IViewableMap.Event.Update<K, V>(key, oldval, value2));
            }
        } else {
            this.change.fire(new IViewableMap.Event.Add<K, V>(key, value2));
        }
        return oldval;
    }

    @Override
    @Nullable
    public V remove(@NotNull Object key) {
        if (key == null) {
            return null;
        }
        Intrinsics.checkParameterIsNotNull(key, "key");
        Object oldval = this.map.remove(key);
        if (oldval != null) {
            this.change.fire(new IViewableMap.Event.Remove(key, oldval));
        }
        return oldval;
    }

    @Override
    public void clear() {
        ArrayList<IViewableMap.Event.Remove<K, V>> changes = new ArrayList<IViewableMap.Event.Remove<K, V>>();
        Iterator<Map.Entry<K, V>> iterator2 = this.map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<K, V> entry = iterator2.next();
            K k = entry.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, "entry.key");
            V v = entry.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v, "entry.value");
            changes.add(new IViewableMap.Event.Remove<K, V>(k, v));
            iterator2.remove();
        }
        Iterable $receiver$iv = changes;
        for (Object element$iv : $receiver$iv) {
            IViewableMap.Event it = (IViewableMap.Event)element$iv;
            this.change.fire(it);
        }
    }

    @NotNull
    public Set<K> getKeys() {
        Set<K> set2 = this.map.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, "map.keys");
        return set2;
    }

    @NotNull
    public Collection<V> getValues() {
        Collection<V> collection = this.map.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "map.values");
        return collection;
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        Set<Map.Entry<K, V>> set2 = this.map.entrySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, "map.entries");
        return set2;
    }

    public int getSize() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        if (key == null) {
            return false;
        }
        Intrinsics.checkParameterIsNotNull(key, "key");
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(@NotNull Object value2) {
        if (value2 == null) {
            return false;
        }
        Intrinsics.checkParameterIsNotNull(value2, "value");
        return this.map.containsValue(value2);
    }

    @Override
    @Nullable
    public V get(@NotNull Object key) {
        if (key == null) {
            return null;
        }
        Intrinsics.checkParameterIsNotNull(key, "key");
        return this.map.get(key);
    }

    public ViewableMap() {
        ViewableMap viewableMap = this;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        viewableMap.map = linkedHashMap;
        this.change = new Signal();
    }

    @Override
    public void view(@NotNull Lifetime lifetime, @NotNull Function2<? super Lifetime, ? super Map.Entry<? extends K, ? extends V>, Unit> handler2) {
        Intrinsics.checkParameterIsNotNull(lifetime, "lifetime");
        Intrinsics.checkParameterIsNotNull(handler2, "handler");
        IMutableViewableMap.DefaultImpls.view(this, lifetime, handler2);
    }

    @Override
    public void view(@NotNull Lifetime lifetime, @NotNull Function3<? super Lifetime, ? super K, ? super V, Unit> handler2) {
        Intrinsics.checkParameterIsNotNull(lifetime, "lifetime");
        Intrinsics.checkParameterIsNotNull(handler2, "handler");
        IMutableViewableMap.DefaultImpls.view(this, lifetime, handler2);
    }

    @Override
    public void adviseAddRemove(@NotNull Lifetime lifetime, @NotNull Function3<? super AddRemove, ? super K, ? super V, Unit> handler2) {
        Intrinsics.checkParameterIsNotNull(lifetime, "lifetime");
        Intrinsics.checkParameterIsNotNull(handler2, "handler");
        IMutableViewableMap.DefaultImpls.adviseAddRemove(this, lifetime, handler2);
    }
}

