/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javaslang.Value;
import javaslang.collection.AbstractIterator;
import javaslang.collection.Comparators;
import javaslang.collection.Foldable;
import javaslang.collection.Iterator;
import javaslang.collection.Stream;
import javaslang.control.Option;

public interface Traversable<T>
extends Value<T>,
Foldable<T> {
    default public Option<T> find(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (Object a : this) {
            if (!predicate.test(a)) continue;
            return Option.some(a);
        }
        return Option.none();
    }

    default public <U> U foldLeft(U zero, BiFunction<? super U, ? super T, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        U xs = zero;
        for (Object x : this) {
            xs = f.apply(xs, x);
        }
        return xs;
    }

    @Override
    default public T get() {
        return (T)this.iterator().next();
    }

    public T head();

    @Override
    default public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    default public boolean isSingleValued() {
        return false;
    }

    public boolean isTraversableAgain();

    @Override
    default public Iterator<T> iterator() {
        final Traversable that = this;
        return new AbstractIterator<T>(){
            Traversable<T> traversable;
            {
                this.traversable = that;
            }

            @Override
            public boolean hasNext() {
                return !this.traversable.isEmpty();
            }

            @Override
            public T getNext() {
                Object result2 = this.traversable.head();
                this.traversable = this.traversable.tail();
                return result2;
            }
        };
    }

    default public T last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("last of empty Traversable");
        }
        java.util.Iterator it = this.iterator();
        T result2 = null;
        while (it.hasNext()) {
            result2 = (T)it.next();
        }
        return result2;
    }

    public int length();

    default public Option<T> max() {
        Stream ts;
        Stream stream2 = ts = this.isTraversableAgain() ? this : this.toStream();
        if (this.isEmpty()) {
            return Option.none();
        }
        return ts.maxBy(Comparators.naturalComparator());
    }

    default public Option<T> maxBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        if (this.isEmpty()) {
            return Option.none();
        }
        Object value2 = this.reduce((t1, t2) -> comparator.compare(t1, t2) >= 0 ? t1 : t2);
        return Option.some(value2);
    }

    default public String mkString(CharSequence delimiter) {
        return this.mkString("", delimiter, "");
    }

    default public String mkString(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        StringBuilder builder = new StringBuilder(prefix);
        this.iterator().map(String::valueOf).intersperse(String.valueOf(delimiter)).forEach(builder::append);
        return builder.append(suffix).toString();
    }

    @Override
    default public T reduceLeft(BiFunction<? super T, ? super T, ? extends T> op) {
        Objects.requireNonNull(op, "op is null");
        if (this.isEmpty()) {
            throw new NoSuchElementException("reduceLeft on Nil");
        }
        return this.tail().foldLeft(this.head(), op);
    }

    public Traversable<T> tail();
}

