/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

final class JvmTypeFactoryImpl
implements JvmTypeFactory<JvmType> {
    public static final JvmTypeFactoryImpl INSTANCE;

    @Override
    @NotNull
    public JvmType boxType(@NotNull JvmType possiblyPrimitiveType) {
        JvmType jvmType;
        Intrinsics.checkParameterIsNotNull(possiblyPrimitiveType, "possiblyPrimitiveType");
        if (possiblyPrimitiveType instanceof JvmType.Primitive && ((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType() != null) {
            JvmClassName jvmClassName = JvmClassName.byFqNameWithoutInnerClasses(((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType().getWrapperFqName());
            Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byFqNameWit\u2026mitiveType.wrapperFqName)");
            String string2 = jvmClassName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string2, "JvmClassName.byFqNameWit\u2026apperFqName).internalName");
            jvmType = this.createObjectType(string2);
        } else {
            jvmType = possiblyPrimitiveType;
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createFromString(@NotNull String representation) {
        JvmType jvmType;
        String string2;
        Object object;
        char firstChar;
        block8: {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(representation, "representation");
            boolean bl2 = bl = representation.length() > 0;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "empty string as JvmType";
                throw (Throwable)((Object)new AssertionError((Object)string3));
            }
            firstChar = representation.charAt(0);
            for (JvmPrimitiveType element$iv : JvmPrimitiveType.values()) {
                JvmPrimitiveType it = element$iv;
                if (!(it.getDesc().charAt(0) == firstChar)) continue;
                object = element$iv;
                break block8;
            }
            object = null;
        }
        if (object != null) {
            String it = string2 = object;
            return new JvmType.Primitive((JvmPrimitiveType)((Object)it));
        }
        switch (firstChar) {
            case 'V': {
                jvmType = new JvmType.Primitive(null);
                break;
            }
            case '[': {
                string2 = representation;
                int it = 1;
                JvmTypeFactoryImpl jvmTypeFactoryImpl = this;
                String string4 = string2.substring(it);
                Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).substring(startIndex)");
                String string5 = string4;
                JvmType jvmType2 = jvmTypeFactoryImpl.createFromString(string5);
                jvmType = new JvmType.Array(jvmType2);
                break;
            }
            default: {
                String string6;
                boolean bl;
                boolean bl3 = bl = firstChar == 'L' && StringsKt.endsWith$default((CharSequence)representation, ';', false, 2, null);
                if (_Assertions.ENABLED && !bl) {
                    String string7 = "Type that is not primitive nor array should be Object, but '" + representation + "' was found";
                    throw (Throwable)((Object)new AssertionError((Object)string7));
                }
                String string8 = representation;
                int n = 1;
                int n2 = representation.length() - 1;
                String string9 = string8.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull(string9, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string10 = string6 = string9;
                jvmType = new JvmType.Object(string10);
            }
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType.Object createObjectType(@NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull(internalName, "internalName");
        return new JvmType.Object(internalName);
    }

    @Override
    @NotNull
    public String toString(@NotNull JvmType type2) {
        Object object;
        Intrinsics.checkParameterIsNotNull(type2, "type");
        JvmType jvmType = type2;
        if (jvmType instanceof JvmType.Array) {
            object = "[" + this.toString(((JvmType.Array)type2).getElementType());
        } else if (jvmType instanceof JvmType.Primitive) {
            object = ((JvmType.Primitive)type2).getJvmPrimitiveType();
            if (object == null || (object = object.getDesc()) == null) {
                object = "V";
            }
        } else if (jvmType instanceof JvmType.Object) {
            object = "L" + ((JvmType.Object)type2).getInternalName() + ";";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return object;
    }

    @Override
    @NotNull
    public JvmType getJavaLangClassType() {
        return this.createObjectType("java/lang/Class");
    }

    private JvmTypeFactoryImpl() {
    }

    static {
        JvmTypeFactoryImpl jvmTypeFactoryImpl;
        INSTANCE = jvmTypeFactoryImpl = new JvmTypeFactoryImpl();
    }
}

