/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Collection;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.typeEnhancement.TypeEnhancementKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmDescriptorTypeWriter;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.FunctionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeSignatureMappingKt {
    private static final <T> T boxTypeIfNeeded(@NotNull JvmTypeFactory<T> $receiver, T possiblyPrimitiveType, boolean needBoxedType) {
        return needBoxedType ? $receiver.boxType(possiblyPrimitiveType) : possiblyPrimitiveType;
    }

    @NotNull
    public static final <T> T mapType(@NotNull KotlinType kotlinType, @NotNull JvmTypeFactory<T> factory2, @NotNull TypeMappingMode mode, @NotNull TypeMappingConfiguration<? extends T> typeMappingConfiguration, @Nullable JvmDescriptorTypeWriter<T> descriptorTypeWriter, @NotNull Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> writeGenericType) {
        Intrinsics.checkParameterIsNotNull(kotlinType, "kotlinType");
        Intrinsics.checkParameterIsNotNull(factory2, "factory");
        Intrinsics.checkParameterIsNotNull(mode, "mode");
        Intrinsics.checkParameterIsNotNull(typeMappingConfiguration, "typeMappingConfiguration");
        Intrinsics.checkParameterIsNotNull(writeGenericType, "writeGenericType");
        if (FunctionTypesKt.isSuspendFunctionType(kotlinType)) {
            return TypeSignatureMappingKt.mapType(SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType(kotlinType, typeMappingConfiguration.releaseCoroutines()), factory2, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        T t = TypeSignatureMappingKt.mapBuiltInType(kotlinType, factory2, mode);
        if (t != null) {
            T t2;
            T builtInType = t2 = t;
            T jvmType = TypeSignatureMappingKt.boxTypeIfNeeded(factory2, builtInType, mode.getNeedPrimitiveBoxing());
            writeGenericType.invoke(kotlinType, jvmType, mode);
            return jvmType;
        }
        TypeConstructor constructor = kotlinType.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            Collection<KotlinType> collection = ((IntersectionTypeConstructor)constructor).getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection, "constructor.supertypes");
            KotlinType commonSupertype = typeMappingConfiguration.commonSupertype(collection);
            return TypeSignatureMappingKt.mapType(TypeUtilsKt.replaceArgumentsWithStarProjections(commonSupertype), factory2, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        ClassifierDescriptor classifierDescriptor = constructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw (Throwable)new UnsupportedOperationException("no descriptor for type constructor of " + kotlinType);
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        if (ErrorUtils.isError(descriptor2)) {
            T jvmType = factory2.createObjectType("error/NonExistentClass");
            ClassifierDescriptor classifierDescriptor2 = descriptor2;
            if (classifierDescriptor2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            }
            typeMappingConfiguration.processErrorType(kotlinType, (ClassDescriptor)classifierDescriptor2);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter != null) {
                jvmDescriptorTypeWriter.writeClass(jvmType);
            }
            return jvmType;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(kotlinType)) {
            T arrayElementType;
            if (kotlinType.getArguments().size() != 1) {
                throw (Throwable)new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = kotlinType.getArguments().get(0);
            KotlinType memberType = memberProjection.getType();
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = factory2.createObjectType("java/lang/Object");
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter2;
                    JvmDescriptorTypeWriter<Object> $receiver = jvmDescriptorTypeWriter2 = jvmDescriptorTypeWriter;
                    $receiver.writeArrayType();
                    $receiver.writeClass(arrayElementType);
                    $receiver.writeArrayEnd();
                }
            } else {
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    jvmDescriptorTypeWriter.writeArrayType();
                }
                KotlinType kotlinType2 = memberType;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "memberType");
                Variance variance = memberProjection.getProjectionKind();
                Intrinsics.checkExpressionValueIsNotNull((Object)variance, "memberProjection.projectionKind");
                arrayElementType = TypeSignatureMappingKt.mapType(kotlinType2, factory2, mode.toGenericArgumentMode(variance), typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter3 = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter3 != null) {
                    jvmDescriptorTypeWriter3.writeArrayEnd();
                }
            }
            return factory2.createFromString("[" + factory2.toString(arrayElementType));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            T t3;
            KotlinType typeForMapping;
            if (((ClassDescriptor)descriptor2).isInline() && !mode.getNeedInlineClassWrapping() && (typeForMapping = TypeSignatureMappingKt.computeUnderlyingType(kotlinType)) != null) {
                TypeMappingMode newMode = InlineClassesUtilsKt.isInlineClassType(typeForMapping) ? mode : mode.wrapInlineClassesMode();
                return TypeSignatureMappingKt.mapType(typeForMapping, factory2, newMode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
            }
            if (mode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
                t3 = factory2.getJavaLangClassType();
            } else {
                ClassDescriptor classDescriptor = ((ClassDescriptor)descriptor2).getOriginal();
                Intrinsics.checkExpressionValueIsNotNull(classDescriptor, "descriptor.original");
                t3 = typeMappingConfiguration.getPredefinedTypeForClass(classDescriptor);
                if (t3 == null) {
                    ClassDescriptor classDescriptor2;
                    if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                        DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)descriptor2).getContainingDeclaration();
                        if (declarationDescriptor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        }
                        classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                    } else {
                        classDescriptor2 = (ClassDescriptor)descriptor2;
                    }
                    ClassDescriptor enumClassIfEnumEntry = classDescriptor2;
                    ClassDescriptor classDescriptor3 = enumClassIfEnumEntry.getOriginal();
                    Intrinsics.checkExpressionValueIsNotNull(classDescriptor3, "enumClassIfEnumEntry.original");
                    t3 = factory2.createObjectType(TypeSignatureMappingKt.computeInternalName(classDescriptor3, typeMappingConfiguration));
                }
            }
            T jvmType = t3;
            writeGenericType.invoke(kotlinType, jvmType, mode);
            return jvmType;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter = null;
            Function3<Object, Object, Object, Unit> function3 = FunctionsKt.getDO_NOTHING_3();
            Object type2 = TypeSignatureMappingKt.mapType(TypeSignatureMappingKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2), factory2, mode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter4 = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter4 != null) {
                Name name2 = descriptor2.getName();
                Intrinsics.checkExpressionValueIsNotNull(name2, "descriptor.getName()");
                jvmDescriptorTypeWriter4.writeTypeVariable(name2, type2);
            }
            return (T)type2;
        }
        throw (Throwable)new UnsupportedOperationException("Unknown type " + kotlinType);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return TypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasVoidReturnType(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (descriptor2 instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        if (!KotlinBuiltIns.isUnit(kotlinType)) return false;
        KotlinType kotlinType2 = descriptor2.getReturnType();
        if (kotlinType2 == null) {
            Intrinsics.throwNpe();
        }
        if (TypeUtils.isNullableType(kotlinType2)) return false;
        if (descriptor2 instanceof PropertyGetterDescriptor) return false;
        return true;
    }

    private static final String continuationInternalName(boolean releaseCoroutines) {
        FqName fqName2 = releaseCoroutines ? DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME_RELEASE : DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL;
        JvmClassName jvmClassName = JvmClassName.byClassId(ClassId.topLevel(fqName2));
        Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byClassId(ClassId.topLevel(fqName))");
        String string2 = jvmClassName.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string2, "JvmClassName.byClassId(C\u2026vel(fqName)).internalName");
        return string2;
    }

    private static final <T> T mapBuiltInType(KotlinType type2, JvmTypeFactory<T> typeFactory, TypeMappingMode mode) {
        ClassId classId;
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor descriptor2 = classDescriptor;
        if (descriptor2 == SuspendFunctionTypesKt.getFAKE_CONTINUATION_CLASS_DESCRIPTOR_EXPERIMENTAL()) {
            return typeFactory.createObjectType(TypeSignatureMappingKt.continuationInternalName(false));
        }
        if (Intrinsics.areEqual(descriptor2, SuspendFunctionTypesKt.getFAKE_CONTINUATION_CLASS_DESCRIPTOR_RELEASE())) {
            return typeFactory.createObjectType(TypeSignatureMappingKt.continuationInternalName(true));
        }
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveType(descriptor2);
        if (primitiveType != null) {
            JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.get(primitiveType);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmPrimitiveType, "JvmPrimitiveType.get(primitiveType)");
            String string2 = jvmPrimitiveType.getDesc();
            Intrinsics.checkExpressionValueIsNotNull(string2, "JvmPrimitiveType.get(primitiveType).desc");
            T jvmType = typeFactory.createFromString(string2);
            boolean isNullableInJava = TypeUtils.isNullableType(type2) || TypeEnhancementKt.hasEnhancedNullability(type2);
            return TypeSignatureMappingKt.boxTypeIfNeeded(typeFactory, jvmType, isNullableInJava);
        }
        PrimitiveType arrayElementType = KotlinBuiltIns.getPrimitiveArrayType(descriptor2);
        if (arrayElementType != null) {
            StringBuilder stringBuilder = new StringBuilder().append("[");
            JvmPrimitiveType jvmPrimitiveType = JvmPrimitiveType.get(arrayElementType);
            Intrinsics.checkExpressionValueIsNotNull((Object)jvmPrimitiveType, "JvmPrimitiveType.get(arrayElementType)");
            return typeFactory.createFromString(stringBuilder.append(jvmPrimitiveType.getDesc()).toString());
        }
        if (KotlinBuiltIns.isUnderKotlinPackage(descriptor2) && (classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtilsKt.getFqNameUnsafe(descriptor2))) != null) {
            if (!mode.getKotlinCollectionsToJavaCollections()) {
                boolean bl;
                block12: {
                    Iterable $receiver$iv = JavaToKotlinClassMap.INSTANCE.getMutabilityMappings();
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            JavaToKotlinClassMap.PlatformMutabilityMapping it = (JavaToKotlinClassMap.PlatformMutabilityMapping)element$iv;
                            if (!Intrinsics.areEqual(it.getJavaClass(), classId)) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return null;
                }
            }
            JvmClassName jvmClassName = JvmClassName.byClassId(classId);
            Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byClassId(classId)");
            String string3 = jvmClassName.getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string3, "JvmClassName.byClassId(classId).internalName");
            return typeFactory.createObjectType(string3);
        }
        return null;
    }

    private static final KotlinType computeUnderlyingType(KotlinType inlineClassType) {
        if (!TypeSignatureMappingKt.shouldUseUnderlyingType(inlineClassType)) {
            return null;
        }
        Object object = InlineClassesUtilsKt.unsubstitutedUnderlyingType(inlineClassType);
        if (object == null || (object = ((KotlinType)object).getConstructor()) == null || (object = object.getDeclarationDescriptor()) == null) {
            return null;
        }
        Object descriptor2 = object;
        return descriptor2 instanceof TypeParameterDescriptor ? TypeSignatureMappingKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2) : InlineClassesUtilsKt.substitutedUnderlyingType(inlineClassType);
    }

    private static final boolean shouldUseUnderlyingType(KotlinType inlineClassType) {
        KotlinType kotlinType = InlineClassesUtilsKt.unsubstitutedUnderlyingType(inlineClassType);
        if (kotlinType == null) {
            return false;
        }
        KotlinType underlyingType = kotlinType;
        return !inlineClassType.isMarkedNullable() || !TypeUtils.isNullableType(underlyingType) && !KotlinBuiltIns.isPrimitiveType(underlyingType);
    }

    @NotNull
    public static final String computeInternalName(@NotNull ClassDescriptor klass2, @NotNull TypeMappingConfiguration<?> typeMappingConfiguration) {
        Intrinsics.checkParameterIsNotNull(klass2, "klass");
        Intrinsics.checkParameterIsNotNull(typeMappingConfiguration, "typeMappingConfiguration");
        DeclarationDescriptor container2 = klass2.getContainingDeclaration();
        Name name2 = SpecialNames.safeIdentifier(klass2.getName());
        Intrinsics.checkExpressionValueIsNotNull(name2, "SpecialNames.safeIdentifier(klass.name)");
        String name3 = name2.getIdentifier();
        if (container2 instanceof PackageFragmentDescriptor) {
            String string2;
            FqName fqName2 = ((PackageFragmentDescriptor)container2).getFqName();
            if (fqName2.isRoot()) {
                String string3 = name3;
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull(string3, "name");
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = fqName2.asString();
                Intrinsics.checkExpressionValueIsNotNull(string4, "fqName.asString()");
                string2 = stringBuilder.append(StringsKt.replace$default(string4, '.', '/', false, 4, null)).append('/').append(name3).toString();
            }
            return string2;
        }
        DeclarationDescriptor declarationDescriptor = container2;
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            throw (Throwable)new IllegalArgumentException("Unexpected container: " + container2 + " for " + klass2);
        }
        ClassDescriptor containerClass = classDescriptor;
        String string5 = typeMappingConfiguration.getPredefinedInternalNameForClass(containerClass);
        if (string5 == null) {
            string5 = TypeSignatureMappingKt.computeInternalName(containerClass, typeMappingConfiguration);
        }
        String containerInternalName = string5;
        return containerInternalName + "$" + name3;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor, TypeMappingConfiguration typeMappingConfiguration, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration = TypeMappingConfigurationImpl.INSTANCE;
        }
        return TypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration);
    }

    private static final KotlinType getRepresentativeUpperBound(TypeParameterDescriptor descriptor2) {
        KotlinType kotlinType;
        Object v4;
        List<KotlinType> upperBounds2;
        block4: {
            boolean bl;
            upperBounds2 = descriptor2.getUpperBounds();
            boolean bl2 = bl = !upperBounds2.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Upper bounds should not be empty: " + descriptor2;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            List<KotlinType> list2 = upperBounds2;
            Intrinsics.checkExpressionValueIsNotNull(list2, "upperBounds");
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                ClassDescriptor classDescriptor;
                KotlinType it = (KotlinType)element$iv;
                ClassifierDescriptor classifierDescriptor = it.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                boolean bl3 = (ClassDescriptor)classifierDescriptor == null ? false : classDescriptor.getKind() != ClassKind.INTERFACE && classDescriptor.getKind() != ClassKind.ANNOTATION_CLASS;
                if (!bl3) continue;
                v4 = element$iv;
                break block4;
            }
            v4 = null;
        }
        if ((kotlinType = (KotlinType)v4) == null) {
            KotlinType kotlinType2 = CollectionsKt.first(upperBounds2);
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "upperBounds.first()");
            kotlinType = kotlinType2;
        }
        return kotlinType;
    }
}

