/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolverImpl;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmModuleProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.BinaryModuleData;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ModuleMappingKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.PackageParts;
import kotlin.reflect.jvm.internal.impl.protobuf.ProtocolStringList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    @NotNull
    private final BinaryModuleData moduleData;
    private final String debugName;
    @JvmField
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, BinaryModuleData moduleData2, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.moduleData = moduleData2;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.<String, PackageParts>emptyMap(), new BinaryModuleData(CollectionsKt.<String>emptyList()), "EMPTY");
        CORRUPTED = new ModuleMapping(MapsKt.<String, PackageParts>emptyMap(), new BinaryModuleData(CollectionsKt.<String>emptyList()), "CORRUPTED");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull BinaryModuleData moduleData2, @NotNull String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, moduleData2, debugName);
    }

    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping loadModuleMapping(@Nullable byte[] bytes, @NotNull String debugName, @NotNull Function1<? super int[], Boolean> isVersionCompatible, boolean skipMetadataVersionCheck, boolean isJvmPackageNameSupported) {
            int[] size$iv22;
            Object object;
            Intrinsics.checkParameterIsNotNull(debugName, "debugName");
            Intrinsics.checkParameterIsNotNull(isVersionCompatible, "isVersionCompatible");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream2 = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int size$iv22 = stream2.readInt();
                int[] result$iv = new int[size$iv22];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    int n3;
                    void i$iv;
                    void var12_17 = i$iv;
                    void var24_22 = i$iv++;
                    object = result$iv;
                    object[var24_22] = n3 = stream2.readInt();
                }
                size$iv22 = result$iv;
            }
            catch (IOException e) {
                return CORRUPTED;
            }
            int[] versionNumber = size$iv22;
            if (skipMetadataVersionCheck || isVersionCompatible.invoke((int[])versionNumber).booleanValue()) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Object p1;
                Iterable $receiver$iv2;
                Object packageParts;
                JvmModuleProtoBuf.Module module2 = JvmModuleProtoBuf.Module.parseFrom(stream2);
                if (module2 == null) {
                    return EMPTY;
                }
                JvmModuleProtoBuf.Module moduleProto = module2;
                LinkedHashMap result2 = new LinkedHashMap();
                Iterator<JvmModuleProtoBuf.PackageParts> iterator2 = moduleProto.getPackagePartsList().iterator();
                while (iterator2.hasNext()) {
                    int index2;
                    Object object2;
                    String key$iv;
                    void $receiver$iv222;
                    JvmModuleProtoBuf.PackageParts proto;
                    JvmModuleProtoBuf.PackageParts packageParts2 = proto = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull(packageParts2, "proto");
                    String packageFqName = packageParts2.getPackageFqName();
                    Map $i$f$IntArray = result2;
                    Intrinsics.checkExpressionValueIsNotNull(packageFqName, "packageFqName");
                    Object value$iv = $receiver$iv222.get(key$iv);
                    if (value$iv == null) {
                        PackageParts answer$iv = new PackageParts(packageFqName);
                        $receiver$iv222.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    packageParts = (PackageParts)object2;
                    boolean $receiver$iv222 = false;
                    ProtocolStringList protocolStringList = proto.getShortClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull(protocolStringList, "proto.shortClassNameList");
                    for (String partShortName : (Iterable)protocolStringList) {
                        String string2;
                        String facadeShortName;
                        String string3;
                        ProtocolStringList protocolStringList2;
                        Integer multifileFacadeId;
                        List<Integer> list2 = proto.getMultifileFacadeShortNameIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list2, "proto.multifileFacadeShortNameIdList");
                        Integer n = CollectionsKt.getOrNull(list2, index2);
                        Integer n4 = multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
                        if (multifileFacadeId != null) {
                            Integer n5;
                            Intrinsics.checkExpressionValueIsNotNull(proto.getMultifileFacadeShortNameList(), "proto.multifileFacadeShortNameList");
                            int p12 = ((Number)n5).intValue();
                            string3 = (String)CollectionsKt.getOrNull(protocolStringList2, p12);
                        } else {
                            string3 = facadeShortName = null;
                        }
                        if (facadeShortName != null) {
                            ProtocolStringList it = protocolStringList2;
                            string2 = ModuleMappingKt.access$internalNameOf(packageFqName, (String)((Object)it));
                        } else {
                            string2 = null;
                        }
                        String facadeInternalName = string2;
                        String string4 = partShortName;
                        Intrinsics.checkExpressionValueIsNotNull(string4, "partShortName");
                        ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(packageFqName, string4), facadeInternalName);
                        ++index2;
                    }
                    if (!isJvmPackageNameSupported) continue;
                    index2 = 0;
                    ProtocolStringList protocolStringList3 = proto.getClassWithJvmPackageNameShortNameList();
                    Intrinsics.checkExpressionValueIsNotNull(protocolStringList3, "proto.classWithJvmPackageNameShortNameList");
                    for (String partShortName : (Iterable)protocolStringList3) {
                        List<Integer> list3 = proto.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list3, "proto.classWithJvmPackageNamePackageIdList");
                        Integer n = CollectionsKt.getOrNull(list3, index2);
                        if (n == null) {
                            List<Integer> list4 = proto.getClassWithJvmPackageNamePackageIdList();
                            Intrinsics.checkExpressionValueIsNotNull(list4, "proto.classWithJvmPackageNamePackageIdList");
                            n = CollectionsKt.lastOrNull(list4);
                        }
                        if (n == null) {
                        } else {
                            int packageId = n;
                            ProtocolStringList protocolStringList4 = moduleProto.getJvmPackageNameList();
                            Intrinsics.checkExpressionValueIsNotNull(protocolStringList4, "moduleProto.jvmPackageNameList");
                            if ((String)CollectionsKt.getOrNull(protocolStringList4, packageId) == null) {
                            } else {
                                String jvmPackageName;
                                String string5 = partShortName;
                                Intrinsics.checkExpressionValueIsNotNull(string5, "partShortName");
                                ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(jvmPackageName, string5), null);
                            }
                        }
                        ++index2;
                    }
                }
                for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getMetadataPartsList()) {
                    Object object3;
                    packageParts = result2;
                    JvmModuleProtoBuf.PackageParts packageParts3 = proto;
                    Intrinsics.checkExpressionValueIsNotNull(packageParts3, "proto");
                    String string6 = packageParts3.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull(string6, "proto.packageFqName");
                    Object key$iv = string6;
                    Object value$iv = $receiver$iv2.get(key$iv);
                    if (value$iv == null) {
                        String string7 = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull(string7, "proto.packageFqName");
                        PackageParts answer$iv = new PackageParts(string7);
                        $receiver$iv2.put(key$iv, answer$iv);
                        object3 = answer$iv;
                    } else {
                        object3 = value$iv;
                    }
                    PackageParts packageParts4 = (PackageParts)object3;
                    ProtocolStringList protocolStringList = proto.getShortClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull(protocolStringList, "proto.shortClassNameList");
                    $receiver$iv2 = protocolStringList;
                    key$iv = packageParts4;
                    for (Object element$iv : $receiver$iv2) {
                        p1 = (String)element$iv;
                        ((PackageParts)key$iv).addMetadataPart((String)p1);
                    }
                }
                ProtoBuf.StringTable stringTable = moduleProto.getStringTable();
                Intrinsics.checkExpressionValueIsNotNull(stringTable, "moduleProto.stringTable");
                ProtoBuf.QualifiedNameTable qualifiedNameTable = moduleProto.getQualifiedNameTable();
                Intrinsics.checkExpressionValueIsNotNull(qualifiedNameTable, "moduleProto.qualifiedNameTable");
                NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
                List<ProtoBuf.Annotation> list5 = moduleProto.getAnnotationList();
                Intrinsics.checkExpressionValueIsNotNull(list5, "moduleProto.annotationList");
                $receiver$iv2 = $receiver$iv = (Iterable)list5;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void proto;
                    p1 = (ProtoBuf.Annotation)item$iv$iv;
                    object = destination$iv$iv;
                    void v24 = proto;
                    Intrinsics.checkExpressionValueIsNotNull(v24, "proto");
                    String string8 = nameResolver.getQualifiedClassName(v24.getId());
                    object.add(string8);
                }
                List annotations2 = (List)destination$iv$iv;
                return new ModuleMapping(result2, new BinaryModuleData(annotations2), debugName, null);
            }
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

