/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import org.jetbrains.annotations.NotNull;

public enum JvmPrimitiveType {
    BOOLEAN(PrimitiveType.BOOLEAN, "boolean", "Z", "java.lang.Boolean"),
    CHAR(PrimitiveType.CHAR, "char", "C", "java.lang.Character"),
    BYTE(PrimitiveType.BYTE, "byte", "B", "java.lang.Byte"),
    SHORT(PrimitiveType.SHORT, "short", "S", "java.lang.Short"),
    INT(PrimitiveType.INT, "int", "I", "java.lang.Integer"),
    FLOAT(PrimitiveType.FLOAT, "float", "F", "java.lang.Float"),
    LONG(PrimitiveType.LONG, "long", "J", "java.lang.Long"),
    DOUBLE(PrimitiveType.DOUBLE, "double", "D", "java.lang.Double");

    private static final Set<FqName> WRAPPERS_CLASS_NAMES;
    private static final Map<String, JvmPrimitiveType> TYPE_BY_NAME;
    private static final Map<PrimitiveType, JvmPrimitiveType> TYPE_BY_PRIMITIVE_TYPE;
    private final PrimitiveType primitiveType;
    private final String name;
    private final String desc;
    private final FqName wrapperFqName;

    @NotNull
    public static JvmPrimitiveType get(@NotNull String name2) {
        JvmPrimitiveType result2 = TYPE_BY_NAME.get(name2);
        if (result2 == null) {
            throw new AssertionError((Object)("Non-primitive type name passed: " + name2));
        }
        return result2;
    }

    @NotNull
    public static JvmPrimitiveType get(@NotNull PrimitiveType type2) {
        return TYPE_BY_PRIMITIVE_TYPE.get((Object)type2);
    }

    private JvmPrimitiveType(@NotNull PrimitiveType primitiveType, @NotNull String name2, @NotNull String desc, @NotNull String wrapperClassName) {
        this.primitiveType = primitiveType;
        this.name = name2;
        this.desc = desc;
        this.wrapperFqName = new FqName(wrapperClassName);
    }

    @NotNull
    public PrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    @NotNull
    public String getJavaKeywordName() {
        return this.name;
    }

    @NotNull
    public String getDesc() {
        return this.desc;
    }

    @NotNull
    public FqName getWrapperFqName() {
        return this.wrapperFqName;
    }

    static {
        WRAPPERS_CLASS_NAMES = new HashSet<FqName>();
        TYPE_BY_NAME = new HashMap<String, JvmPrimitiveType>();
        TYPE_BY_PRIMITIVE_TYPE = new EnumMap<PrimitiveType, JvmPrimitiveType>(PrimitiveType.class);
        for (JvmPrimitiveType type2 : JvmPrimitiveType.values()) {
            WRAPPERS_CLASS_NAMES.add(type2.getWrapperFqName());
            TYPE_BY_NAME.put(type2.getJavaKeywordName(), type2);
            TYPE_BY_PRIMITIVE_TYPE.put(type2.getPrimitiveType(), type2);
        }
    }
}

