/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.Verifier;

public class Attribute
implements Serializable,
Cloneable {
    protected String name;
    protected transient Namespace namespace;
    protected String value;
    protected int type = 0;
    protected Element parent;

    protected Attribute() {
    }

    public Attribute(String name2, String value2, int type2, Namespace namespace) {
        this.setName(name2);
        this.setValue(value2);
        this.setAttributeType(type2);
        this.setNamespace(namespace);
    }

    public Element getParent() {
        return this.parent;
    }

    protected Attribute setParent(Element parent2) {
        this.parent = parent2;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Attribute setName(String name2) {
        String reason = Verifier.checkAttributeName(name2);
        if (reason != null) {
            throw new IllegalNameException(name2, "attribute", reason);
        }
        this.name = name2;
        return this;
    }

    public String getQualifiedName() {
        String prefix = this.namespace.getPrefix();
        if (prefix == null || "".equals(prefix)) {
            return this.getName();
        }
        return new StringBuffer(prefix).append(':').append(this.getName()).toString();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Attribute setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        if (namespace != Namespace.NO_NAMESPACE && "".equals(namespace.getPrefix())) {
            throw new IllegalNameException("", "attribute namespace", "An attribute namespace without a prefix can only be the NO_NAMESPACE namespace");
        }
        this.namespace = namespace;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public Attribute setValue(String value2) {
        String reason = Verifier.checkCharacterData(value2);
        if (reason != null) {
            throw new IllegalDataException(value2, "attribute", reason);
        }
        this.value = value2;
        return this;
    }

    public int getAttributeType() {
        return this.type;
    }

    public Attribute setAttributeType(int type2) {
        if (type2 < 0 || type2 > 10) {
            throw new IllegalDataException(String.valueOf(type2), "attribute", "Illegal attribute type");
        }
        this.type = type2;
        return this;
    }

    public String toString() {
        return new StringBuffer().append("[Attribute: ").append(this.getQualifiedName()).append("=\"").append(this.value).append("\"").append("]").toString();
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Attribute clone() {
        Attribute attribute = null;
        try {
            attribute = (Attribute)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        attribute.parent = null;
        return attribute;
    }
}

