/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.annotation.AnnotationCollectorConfigurationKeys;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/annotation/AnnotationCollectorCommandLineProcessor;", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "()V", "pluginId", "", "getPluginId", "()Ljava/lang/String;", "pluginOptions", "", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getPluginOptions", "()Ljava/util/Collection;", "processOption", "", "option", "value", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Companion", "cli"})
public final class AnnotationCollectorCommandLineProcessor
implements CommandLineProcessor {
    @NotNull
    private final String pluginId = ANNOTATION_COLLECTOR_COMPILER_PLUGIN_ID;
    @NotNull
    private final Collection<CliOption> pluginOptions = CollectionsKt.listOf(ANNOTATION_FILTER_LIST_OPTION, OUTPUT_FILENAME_OPTION, STUBS_PATH_OPTION, INHERITED_ANNOTATIONS_OPTION);
    @NotNull
    private static final String ANNOTATION_COLLECTOR_COMPILER_PLUGIN_ID = "org.jetbrains.kotlin.kapt";
    @NotNull
    private static final CliOption ANNOTATION_FILTER_LIST_OPTION;
    @NotNull
    private static final CliOption OUTPUT_FILENAME_OPTION;
    @NotNull
    private static final CliOption STUBS_PATH_OPTION;
    @NotNull
    private static final CliOption INHERITED_ANNOTATIONS_OPTION;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @NotNull
    public Collection<CliOption> getPluginOptions() {
        return this.pluginOptions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processOption(@NotNull CliOption option, @NotNull String value2, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull(option, "option");
        Intrinsics.checkParameterIsNotNull(value2, "value");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        CliOption cliOption = option;
        if (Intrinsics.areEqual(cliOption, ANNOTATION_FILTER_LIST_OPTION)) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)value2, new char[]{','}, false, 0, 6, null);
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it = (String)element$iv$iv;
                CharSequence charSequence = it;
                if (!(!(charSequence.length() == 0))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List annotations2 = CollectionsKt.toList((List)destination$iv$iv);
            configuration.put(AnnotationCollectorConfigurationKeys.INSTANCE.getANNOTATION_FILTER_LIST(), annotations2);
        } else if (Intrinsics.areEqual(cliOption, OUTPUT_FILENAME_OPTION)) {
            configuration.put(AnnotationCollectorConfigurationKeys.INSTANCE.getOUTPUT_FILENAME(), value2);
        } else if (Intrinsics.areEqual(cliOption, STUBS_PATH_OPTION)) {
            configuration.put(AnnotationCollectorConfigurationKeys.INSTANCE.getSTUBS_PATH(), value2);
        } else if (Intrinsics.areEqual(cliOption, INHERITED_ANNOTATIONS_OPTION)) {
            configuration.put(AnnotationCollectorConfigurationKeys.INSTANCE.getINHERITED(), value2);
        } else {
            throw (Throwable)new CliOptionProcessingException("Unknown option: " + option.getName(), null, 2, null);
        }
    }

    static {
        Companion = new Companion(null);
        ANNOTATION_COLLECTOR_COMPILER_PLUGIN_ID = ANNOTATION_COLLECTOR_COMPILER_PLUGIN_ID;
        ANNOTATION_FILTER_LIST_OPTION = new CliOption("annotations", "<path>", "Annotation filter regular expressions, separated by commas", false, false, 16, null);
        OUTPUT_FILENAME_OPTION = new CliOption("output", "<path>", "File in which annotated declarations will be placed", false, false, 16, null);
        STUBS_PATH_OPTION = new CliOption("stubs", "<path>", "Output path for stubs", false, false, 16, null);
        INHERITED_ANNOTATIONS_OPTION = new CliOption("inherited", "<true/false>", "True if collecting Kotlin class names for inherited annotations is needed", false, false, 16, null);
    }

    @Override
    public <T> void appendList(@NotNull CompilerConfiguration $receiver, @NotNull CompilerConfigurationKey<List<T>> option, T value2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(option, "option");
        CommandLineProcessor.DefaultImpls.appendList((CommandLineProcessor)this, $receiver, option, value2);
    }

    @Override
    public <T> void appendList(@NotNull CompilerConfiguration $receiver, @NotNull CompilerConfigurationKey<List<T>> option, @NotNull List<? extends T> values2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(option, "option");
        Intrinsics.checkParameterIsNotNull(values2, "values");
        CommandLineProcessor.DefaultImpls.appendList((CommandLineProcessor)this, $receiver, option, values2);
    }

    @Override
    public void applyOptionsFrom(@NotNull CompilerConfiguration $receiver, @NotNull Map<String, ? extends List<String>> map2, @NotNull Collection<CliOption> pluginOptions) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(map2, "map");
        Intrinsics.checkParameterIsNotNull(pluginOptions, "pluginOptions");
        CommandLineProcessor.DefaultImpls.applyOptionsFrom(this, $receiver, map2, pluginOptions);
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/annotation/AnnotationCollectorCommandLineProcessor$Companion;", "", "()V", "ANNOTATION_COLLECTOR_COMPILER_PLUGIN_ID", "", "getANNOTATION_COLLECTOR_COMPILER_PLUGIN_ID", "()Ljava/lang/String;", "ANNOTATION_FILTER_LIST_OPTION", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getANNOTATION_FILTER_LIST_OPTION", "()Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "INHERITED_ANNOTATIONS_OPTION", "getINHERITED_ANNOTATIONS_OPTION", "OUTPUT_FILENAME_OPTION", "getOUTPUT_FILENAME_OPTION", "STUBS_PATH_OPTION", "getSTUBS_PATH_OPTION", "cli"})
    public static final class Companion {
        @NotNull
        public final String getANNOTATION_COLLECTOR_COMPILER_PLUGIN_ID() {
            return ANNOTATION_COLLECTOR_COMPILER_PLUGIN_ID;
        }

        @NotNull
        public final CliOption getANNOTATION_FILTER_LIST_OPTION() {
            return ANNOTATION_FILTER_LIST_OPTION;
        }

        @NotNull
        public final CliOption getOUTPUT_FILENAME_OPTION() {
            return OUTPUT_FILENAME_OPTION;
        }

        @NotNull
        public final CliOption getSTUBS_PATH_OPTION() {
            return STUBS_PATH_OPTION;
        }

        @NotNull
        public final CliOption getINHERITED_ANNOTATIONS_OPTION() {
            return INHERITED_ANNOTATIONS_OPTION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

