/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.AbstractClosureAnnotator;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.Closure;
import org.jetbrains.kotlin.backend.common.DeclarationContainerLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LocalFunctionsLowering;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallWithShallowCopy;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u000b\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalFunctionsLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationContainerLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irDeclarationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "LocalFunctionContext", "LocalFunctionsTransformer", "backend-common"})
public final class LocalFunctionsLowering
implements DeclarationContainerLoweringPass {
    @NotNull
    private final BackendContext context;

    @Override
    public void lower(@NotNull IrDeclarationContainer irDeclarationContainer) {
        Intrinsics.checkParameterIsNotNull(irDeclarationContainer, "irDeclarationContainer");
        List<IrDeclaration> $receiver$iv = irDeclarationContainer.getDeclarations();
        int i$iv = 0;
        while (i$iv < $receiver$iv.size()) {
            List<IrDeclaration> transformed$iv;
            IrDeclaration item$iv = $receiver$iv.get(i$iv);
            IrDeclaration memberDeclaration = item$iv;
            List<IrDeclaration> list2 = transformed$iv = memberDeclaration instanceof IrFunction ? new LocalFunctionsTransformer((IrFunction)memberDeclaration).lowerLocalFunctions() : null;
            if (transformed$iv == null) {
                ++i$iv;
                continue;
            }
            $receiver$iv.addAll(i$iv, (Collection<IrDeclaration>)transformed$iv);
            $receiver$iv.remove(i$iv += transformed$iv.size());
        }
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public LocalFunctionsLowering(@NotNull BackendContext context) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalFunctionsLowering$LocalFunctionContext;", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "closure", "Lorg/jetbrains/kotlin/backend/common/Closure;", "getClosure", "()Lorg/jetbrains/kotlin/backend/common/Closure;", "setClosure", "(Lorg/jetbrains/kotlin/backend/common/Closure;)V", "closureParametersCount", "", "getClosureParametersCount", "()I", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "index", "getIndex", "setIndex", "(I)V", "old2new", "", "Lorg/jetbrains/kotlin/descriptors/ValueDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "getOld2new", "()Ljava/util/Map;", "transformedDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getTransformedDescriptor", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "setTransformedDescriptor", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "toString", "", "backend-common"})
    private static final class LocalFunctionContext {
        @NotNull
        public Closure closure;
        @NotNull
        public FunctionDescriptor transformedDescriptor;
        @NotNull
        private final Map<ValueDescriptor, ParameterDescriptor> old2new;
        private int index;
        @NotNull
        private final IrFunction declaration;

        @NotNull
        public final Closure getClosure() {
            Closure closure = this.closure;
            if (closure == null) {
                Intrinsics.throwUninitializedPropertyAccessException("closure");
            }
            return closure;
        }

        public final void setClosure(@NotNull Closure closure) {
            Intrinsics.checkParameterIsNotNull(closure, "<set-?>");
            this.closure = closure;
        }

        public final int getClosureParametersCount() {
            Closure closure = this.closure;
            if (closure == null) {
                Intrinsics.throwUninitializedPropertyAccessException("closure");
            }
            return closure.getCapturedValues().size();
        }

        @NotNull
        public final FunctionDescriptor getTransformedDescriptor() {
            FunctionDescriptor functionDescriptor = this.transformedDescriptor;
            if (functionDescriptor == null) {
                Intrinsics.throwUninitializedPropertyAccessException("transformedDescriptor");
            }
            return functionDescriptor;
        }

        public final void setTransformedDescriptor(@NotNull FunctionDescriptor functionDescriptor) {
            Intrinsics.checkParameterIsNotNull(functionDescriptor, "<set-?>");
            this.transformedDescriptor = functionDescriptor;
        }

        @NotNull
        public final Map<ValueDescriptor, ParameterDescriptor> getOld2new() {
            return this.old2new;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @NotNull
        public String toString() {
            return "LocalFunctionContext for " + this.declaration.getDescriptor();
        }

        @NotNull
        public final IrFunction getDeclaration() {
            return this.declaration;
        }

        public LocalFunctionContext(@NotNull IrFunction declaration) {
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            this.declaration = declaration;
            this.old2new = new HashMap();
            this.index = -1;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001>B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\bH\u0002J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020#H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0007H\u0002J\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010+J&\u0010,\u001a\u0010\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/\u0018\u00010-2\u0006\u00100\u001a\u0002012\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u00102\u001a\u00020\u0012H\u0002J\u001a\u00103\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020(2\u0006\u0010!\u001a\u00020\u000fH\u0002J\b\u0010:\u001a\u00020\u0012H\u0002J\u001c\u0010;\u001a\u00020\u000e*\u00020\b2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020\u000eH\u0002R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalFunctionsLowering$LocalFunctionsTransformer;", "", "memberFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalFunctionsLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "localFunctions", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalFunctionsLowering$LocalFunctionContext;", "getLocalFunctions", "()Ljava/util/Map;", "getMemberFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "new2old", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ValueDescriptor;", "getNew2old", "collectClosures", "", "collectLocalFunctions", "collectRewrittenDeclarations", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "createNewCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "oldCall", "newCallee", "createTransformedDescriptor", "localFunctionContext", "createUnsubstitutedCapturedValueParameter", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "newParameterOwner", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "valueDescriptor", "index", "", "createUnsubstitutedParameter", "valueParameterDescriptor", "newIndex", "generateNameForLiftedFunction", "Lorg/jetbrains/kotlin/name/Name;", "functionDescriptor", "lowerLocalFunctions", "", "remapTypeArguments", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "oldExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "rewriteBodies", "rewriteFunctionDeclaration", "irFunction", "suggestLocalName", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "suggestNameForCapturedValueParameter", "transformDescriptors", "recordRemapped", "oldDescriptor", "newDescriptor", "FunctionBodiesRewriter", "backend-common"})
    private final class LocalFunctionsTransformer {
        @NotNull
        private final Map<FunctionDescriptor, LocalFunctionContext> localFunctions;
        @NotNull
        private final Map<ParameterDescriptor, ValueDescriptor> new2old;
        @NotNull
        private final IrFunction memberFunction;

        @NotNull
        public final Map<FunctionDescriptor, LocalFunctionContext> getLocalFunctions() {
            return this.localFunctions;
        }

        @NotNull
        public final Map<ParameterDescriptor, ValueDescriptor> getNew2old() {
            return this.new2old;
        }

        @Nullable
        public final List<IrDeclaration> lowerLocalFunctions() {
            this.collectLocalFunctions();
            if (this.localFunctions.isEmpty()) {
                return null;
            }
            this.collectClosures();
            this.transformDescriptors();
            this.rewriteBodies();
            return this.collectRewrittenDeclarations();
        }

        /*
         * WARNING - void declaration
         */
        private final ArrayList<IrDeclaration> collectRewrittenDeclarations() {
            ArrayList<IrDeclaration> arrayList;
            ArrayList<IrDeclaration> $receiver = arrayList = new ArrayList<IrDeclaration>(this.localFunctions.size() + 1);
            $receiver.add(this.memberFunction);
            Iterable $receiver$iv = this.localFunctions.values();
            for (Object item$iv : $receiver$iv) {
                void it;
                LocalFunctionContext localFunctionContext = (LocalFunctionContext)item$iv;
                Collection collection = $receiver;
                IrFunction original = it.getDeclaration();
                IrFunctionImpl irFunctionImpl = new IrFunctionImpl(original.getStartOffset(), original.getEndOffset(), original.getOrigin(), it.getTransformedDescriptor(), original.getBody());
                collection.add(irFunctionImpl);
            }
            return arrayList;
        }

        private final void rewriteFunctionDeclaration(IrFunction irFunction, LocalFunctionContext localFunctionContext) {
            IrElementTransformerVoidKt.transformChildrenVoid(irFunction, new FunctionBodiesRewriter(localFunctionContext));
        }

        private final void rewriteBodies() {
            Iterable $receiver$iv = this.localFunctions.values();
            for (Object element$iv : $receiver$iv) {
                LocalFunctionContext it = (LocalFunctionContext)element$iv;
                this.rewriteFunctionDeclaration(it.getDeclaration(), it);
            }
            this.rewriteFunctionDeclaration(this.memberFunction, null);
        }

        private final IrCall createNewCall(IrCall oldCall, FunctionDescriptor newCallee) {
            IrCall irCall = oldCall;
            return irCall instanceof IrCallWithShallowCopy ? ((IrCallWithShallowCopy)oldCall).shallowCopy(oldCall.getOrigin(), newCallee, oldCall.getSuperQualifier()) : (IrCall)new IrCallImpl(oldCall.getStartOffset(), oldCall.getEndOffset(), newCallee, this.remapTypeArguments(oldCall, newCallee), oldCall.getOrigin(), oldCall.getSuperQualifier());
        }

        /*
         * WARNING - void declaration
         */
        private final Map<TypeParameterDescriptor, KotlinType> remapTypeArguments(IrMemberAccessExpression oldExpression, FunctionDescriptor newCallee) {
            Map map2;
            CallableDescriptor oldCallee = oldExpression.getDescriptor();
            if (oldCallee.getTypeParameters().isEmpty()) {
                map2 = null;
            } else {
                void $receiver$iv$iv;
                CallableDescriptor callableDescriptor = oldCallee.getOriginal();
                Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "oldCallee.original");
                List<TypeParameterDescriptor> list2 = callableDescriptor.getTypeParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, "oldCallee.original.typeParameters");
                Iterable $receiver$iv = list2;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
                Iterable iterable = $receiver$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                for (Object element$iv$iv : $receiver$iv$iv) {
                    KotlinType kotlinType;
                    TypeParameterDescriptor it;
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)element$iv$iv;
                    Map map3 = destination$iv$iv;
                    List<TypeParameterDescriptor> list3 = newCallee.getTypeParameters();
                    void v4 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v4, "it");
                    TypeParameterDescriptor typeParameterDescriptor2 = list3.get(v4.getIndex());
                    Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor2, "newCallee.typeParameters[it.index]");
                    TypeParameterDescriptor typeParameterDescriptor3 = typeParameterDescriptor2;
                    TypeParameterDescriptor typeParameterDescriptor4 = it = (TypeParameterDescriptor)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor4, "it");
                    if (IrMemberAccessExpressionKt.getTypeArgument(oldExpression, typeParameterDescriptor4) == null) {
                        Intrinsics.throwNpe();
                    }
                    map3.put(typeParameterDescriptor3, kotlinType);
                }
                map2 = destination$iv$iv;
            }
            return map2;
        }

        private final void transformDescriptors() {
            Iterable $receiver$iv = this.localFunctions.values();
            for (Object element$iv : $receiver$iv) {
                LocalFunctionContext it = (LocalFunctionContext)element$iv;
                it.setTransformedDescriptor(this.createTransformedDescriptor(it));
            }
        }

        private final String suggestLocalName(DeclarationDescriptor descriptor2) {
            String string2;
            Map<FunctionDescriptor, LocalFunctionContext> map2 = this.localFunctions;
            LocalFunctionContext localFunctionContext = map2.get(descriptor2);
            if (localFunctionContext != null && localFunctionContext.getIndex() >= 0) {
                string2 = "lambda-" + localFunctionContext.getIndex();
            } else {
                String string3 = descriptor2.getName().asString();
                string2 = string3;
                Intrinsics.checkExpressionValueIsNotNull(string3, "descriptor.name.asString()");
            }
            return string2;
        }

        private final Name generateNameForLiftedFunction(FunctionDescriptor functionDescriptor) {
            Name name2 = Name.identifier(CollectionsKt.joinToString$default(CollectionsKt.reversed((Iterable)SequencesKt.toList(SequencesKt.takeWhile(DescriptorUtilsKt.getParentsWithSelf(functionDescriptor), generateNameForLiftedFunction.1.INSTANCE))), "$", null, null, 0, null, new Function1<DeclarationDescriptor, CharSequence>(this){
                final /* synthetic */ LocalFunctionsTransformer this$0;

                @NotNull
                public final CharSequence invoke(@NotNull DeclarationDescriptor it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    return LocalFunctionsTransformer.access$suggestLocalName(this.this$0, it);
                }
                {
                    this.this$0 = localFunctionsTransformer;
                    super(1);
                }
            }, 30, null));
            Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier(\n       \u2026                        )");
            return name2;
        }

        /*
         * WARNING - void declaration
         */
        private final FunctionDescriptor createTransformedDescriptor(LocalFunctionContext localFunctionContext) {
            ValueParameterDescriptor valueParameterDescriptor;
            ValueParameterDescriptor $receiver;
            int i;
            ValueParameterDescriptor capturedValueDescriptor;
            ValueParameterDescriptor valueParameterDescriptor2;
            Collection collection;
            FunctionDescriptor oldDescriptor = localFunctionContext.getDeclaration().getDescriptor();
            DeclarationDescriptor memberOwner = this.memberFunction.getDescriptor().getContainingDeclaration();
            SimpleFunctionDescriptorImpl newDescriptor2 = SimpleFunctionDescriptorImpl.create(memberOwner, oldDescriptor.getAnnotations(), this.generateNameForLiftedFunction(oldDescriptor), CallableMemberDescriptor.Kind.SYNTHESIZED, oldDescriptor.getSource());
            int closureParametersCount = localFunctionContext.getClosureParametersCount();
            int newValueParametersCount = closureParametersCount + oldDescriptor.getValueParameters().size();
            ReceiverParameterDescriptor newDispatchReceiverParameter = memberOwner instanceof ClassDescriptor && oldDescriptor.getDispatchReceiverParameter() != null ? ((ClassDescriptor)memberOwner).getThisAsReceiverParameter() : null;
            List<TypeParameterDescriptor> newTypeParameters = oldDescriptor.getTypeParameters();
            Object object = new ArrayList(newValueParametersCount);
            ArrayList $receiver2 = object;
            Iterable $receiver$iv = localFunctionContext.getClosure().getCapturedValues();
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                int n = index$iv++;
                ValueDescriptor valueDescriptor = (ValueDescriptor)item$iv;
                int n2 = n;
                collection = $receiver2;
                SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = newDescriptor2;
                Intrinsics.checkExpressionValueIsNotNull(simpleFunctionDescriptorImpl, "newDescriptor");
                $receiver = valueParameterDescriptor2 = this.createUnsubstitutedCapturedValueParameter(simpleFunctionDescriptorImpl, capturedValueDescriptor, i);
                this.recordRemapped(localFunctionContext, capturedValueDescriptor, $receiver);
                valueParameterDescriptor = valueParameterDescriptor2;
                collection.add(valueParameterDescriptor);
            }
            List<ValueParameterDescriptor> list2 = oldDescriptor.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, "oldDescriptor.valueParameters");
            $receiver$iv = list2;
            index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void oldValueParameterDescriptor;
                int n = index$iv++;
                capturedValueDescriptor = (ValueParameterDescriptor)item$iv;
                i = n;
                collection = $receiver2;
                SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = newDescriptor2;
                Intrinsics.checkExpressionValueIsNotNull(simpleFunctionDescriptorImpl, "newDescriptor");
                CallableMemberDescriptor callableMemberDescriptor = simpleFunctionDescriptorImpl;
                void v6 = oldValueParameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(v6, "oldValueParameterDescriptor");
                $receiver = valueParameterDescriptor2 = this.createUnsubstitutedParameter(callableMemberDescriptor, (ValueParameterDescriptor)v6, closureParametersCount + i);
                this.recordRemapped(localFunctionContext, (ValueDescriptor)oldValueParameterDescriptor, $receiver);
                valueParameterDescriptor = valueParameterDescriptor2;
                collection.add(valueParameterDescriptor);
            }
            ArrayList newValueParameters = object;
            ReceiverParameterDescriptor receiverParameterDescriptor = oldDescriptor.getExtensionReceiverParameter();
            newDescriptor2.initialize(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null, newDispatchReceiverParameter, newTypeParameters, (List)newValueParameters, oldDescriptor.getReturnType(), Modality.FINAL, Visibilities.PRIVATE);
            ReceiverParameterDescriptor receiverParameterDescriptor2 = oldDescriptor.getExtensionReceiverParameter();
            if (receiverParameterDescriptor2 != null) {
                Object it;
                Object object2 = it = (object = receiverParameterDescriptor2);
                Intrinsics.checkExpressionValueIsNotNull(object2, "it");
                ValueDescriptor valueDescriptor = (ValueDescriptor)object2;
                SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = newDescriptor2;
                Intrinsics.checkExpressionValueIsNotNull(simpleFunctionDescriptorImpl, "newDescriptor");
                ReceiverParameterDescriptor receiverParameterDescriptor3 = simpleFunctionDescriptorImpl.getExtensionReceiverParameter();
                if (receiverParameterDescriptor3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor3, "newDescriptor.extensionReceiverParameter!!");
                this.recordRemapped(localFunctionContext, valueDescriptor, receiverParameterDescriptor3);
            }
            SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = newDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(simpleFunctionDescriptorImpl, "newDescriptor");
            return simpleFunctionDescriptorImpl;
        }

        private final ParameterDescriptor recordRemapped(@NotNull LocalFunctionContext $receiver, ValueDescriptor oldDescriptor, ParameterDescriptor newDescriptor2) {
            Map<ValueDescriptor, ValueDescriptor> map2 = $receiver.getOld2new();
            ValueDescriptor valueDescriptor = newDescriptor2;
            map2.put(oldDescriptor, valueDescriptor);
            map2 = this.new2old;
            valueDescriptor = oldDescriptor;
            map2.put(newDescriptor2, valueDescriptor);
            return newDescriptor2;
        }

        private final Name suggestNameForCapturedValueParameter(ValueDescriptor valueDescriptor) {
            Name name2;
            Name name3 = valueDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull(name3, "valueDescriptor.name");
            if (name3.isSpecial()) {
                String oldNameStr = valueDescriptor.getName().asString();
                StringBuilder stringBuilder = new StringBuilder().append("$");
                String string2 = oldNameStr;
                Intrinsics.checkExpressionValueIsNotNull(string2, "oldNameStr");
                String string3 = string2;
                int n = 1;
                int n2 = oldNameStr.length() - 1;
                StringBuilder stringBuilder2 = stringBuilder;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string6 = string5;
                Name name4 = Name.identifier(stringBuilder2.append(string6).toString());
                name2 = name4;
                Intrinsics.checkExpressionValueIsNotNull(name4, "Name.identifier(\"$\" + ol\u2026, oldNameStr.length - 1))");
            } else {
                Name name5 = valueDescriptor.getName();
                name2 = name5;
                Intrinsics.checkExpressionValueIsNotNull(name5, "valueDescriptor.name");
            }
            return name2;
        }

        private final ValueParameterDescriptor createUnsubstitutedCapturedValueParameter(CallableMemberDescriptor newParameterOwner, ValueDescriptor valueDescriptor, int index2) {
            CallableDescriptor callableDescriptor = newParameterOwner;
            Annotations annotations2 = valueDescriptor.getAnnotations();
            Name name2 = this.suggestNameForCapturedValueParameter(valueDescriptor);
            KotlinType kotlinType = valueDescriptor.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "valueDescriptor.type");
            SourceElement sourceElement = valueDescriptor.getSource();
            Intrinsics.checkExpressionValueIsNotNull(sourceElement, "valueDescriptor.source");
            return new ValueParameterDescriptorImpl(callableDescriptor, null, index2, annotations2, name2, kotlinType, false, false, false, null, sourceElement);
        }

        private final ValueParameterDescriptor createUnsubstitutedParameter(CallableMemberDescriptor newParameterOwner, ValueParameterDescriptor valueParameterDescriptor, int newIndex) {
            CallableDescriptor callableDescriptor = newParameterOwner;
            Name name2 = valueParameterDescriptor.getName();
            Intrinsics.checkExpressionValueIsNotNull(name2, "valueParameterDescriptor.name");
            return valueParameterDescriptor.copy(callableDescriptor, name2, newIndex);
        }

        private final void collectClosures() {
            IrElementVisitorVoidKt.acceptChildrenVoid(this.memberFunction, new AbstractClosureAnnotator(this){
                final /* synthetic */ LocalFunctionsTransformer this$0;

                public void visitClass(@NotNull IrClass declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                }

                protected void recordFunctionClosure(@NotNull FunctionDescriptor functionDescriptor, @NotNull Closure closure) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull(functionDescriptor, "functionDescriptor");
                        Intrinsics.checkParameterIsNotNull(closure, "closure");
                        LocalFunctionContext localFunctionContext = this.this$0.getLocalFunctions().get(functionDescriptor);
                        if (localFunctionContext == null) break block0;
                        localFunctionContext.setClosure(closure);
                    }
                }

                protected void recordClassClosure(@NotNull ClassDescriptor classDescriptor, @NotNull Closure closure) {
                    Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
                    Intrinsics.checkParameterIsNotNull(closure, "closure");
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        private final void collectLocalFunctions() {
            IrElementVisitorVoidKt.acceptChildrenVoid(this.memberFunction, new IrElementVisitorVoid(this){
                private int lambdasCount;
                final /* synthetic */ LocalFunctionsTransformer this$0;

                public final int getLambdasCount() {
                    return this.lambdasCount;
                }

                public final void setLambdasCount(int n) {
                    this.lambdasCount = n;
                }

                public void visitElement(@NotNull IrElement element) {
                    Intrinsics.checkParameterIsNotNull(element, "element");
                    IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
                }

                public void visitFunction(@NotNull IrFunction declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoidKt.acceptChildrenVoid(declaration, this);
                    LocalFunctionContext localFunctionContext = new LocalFunctionContext(declaration);
                    Map<FunctionDescriptor, LocalFunctionContext> map2 = this.this$0.getLocalFunctions();
                    FunctionDescriptor functionDescriptor = declaration.getDescriptor();
                    LocalFunctionContext localFunctionContext2 = localFunctionContext;
                    map2.put(functionDescriptor, localFunctionContext2);
                    Name name2 = declaration.getDescriptor().getName();
                    Intrinsics.checkExpressionValueIsNotNull(name2, "declaration.descriptor.name");
                    if (name2.isSpecial()) {
                        int n = this.lambdasCount;
                        this.lambdasCount = n + 1;
                        localFunctionContext.setIndex(n);
                    }
                }

                public void visitClass(@NotNull IrClass declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                }
                {
                    this.this$0 = $outer;
                }

                public void visitElement(@NotNull IrElement element, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(element, "element");
                    IrElementVisitorVoid.DefaultImpls.visitElement(this, element, data2);
                }

                public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration, data2);
                }

                public void visitClass(@NotNull IrClass declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration, data2);
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration);
                }

                public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
                }

                public void visitBlock(@NotNull IrBlock expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
                }

                public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data2);
                }

                public void visitBlockBody(@NotNull IrBlockBody body) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body);
                }

                public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body, data2);
                }

                public void visitBody(@NotNull IrBody body) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body);
                }

                public void visitBody(@NotNull IrBody body, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitorVoid.DefaultImpls.visitBody(this, body, data2);
                }

                public void visitBranch(@NotNull IrBranch branch) {
                    Intrinsics.checkParameterIsNotNull(branch, "branch");
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
                }

                public void visitBranch(@NotNull IrBranch branch, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(branch, "branch");
                    IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data2);
                }

                public void visitBreak(@NotNull IrBreak jump) {
                    Intrinsics.checkParameterIsNotNull(jump, "jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
                }

                public void visitBreak(@NotNull IrBreak jump, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(jump, "jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data2);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                    Intrinsics.checkParameterIsNotNull(jump, "jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
                }

                public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(jump, "jump");
                    IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data2);
                }

                public void visitCall(@NotNull IrCall expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
                }

                public void visitCall(@NotNull IrCall expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data2);
                }

                public void visitCallableReference(@NotNull IrCallableReference expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
                }

                public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data2);
                }

                public void visitCatch(@NotNull IrCatch aCatch) {
                    Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
                }

                public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(aCatch, "aCatch");
                    IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data2);
                }

                public void visitClassReference(@NotNull IrClassReference expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
                }

                public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data2);
                }

                public void visitComposite(@NotNull IrComposite expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
                }

                public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data2);
                }

                public <T> void visitConst(@NotNull IrConst<T> expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
                }

                public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data2);
                }

                public void visitConstructor(@NotNull IrConstructor declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration);
                }

                public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration, data2);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
                }

                public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data2);
                }

                public void visitContinue(@NotNull IrContinue jump) {
                    Intrinsics.checkParameterIsNotNull(jump, "jump");
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
                }

                public void visitContinue(@NotNull IrContinue jump, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(jump, "jump");
                    IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data2);
                }

                public void visitDeclaration(@NotNull IrDeclaration declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration);
                }

                public void visitDeclaration(@NotNull IrDeclaration declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration, data2);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
                }

                public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data2);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
                }

                public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
                    Intrinsics.checkParameterIsNotNull(loop, "loop");
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
                }

                public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(loop, "loop");
                    IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data2);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch) {
                    Intrinsics.checkParameterIsNotNull(branch, "branch");
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
                }

                public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(branch, "branch");
                    IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data2);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
                }

                public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration);
                }

                public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration, data2);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
                }

                public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration);
                }

                public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
                }

                public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data2);
                }

                public void visitExpression(@NotNull IrExpression expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
                }

                public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data2);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body);
                }

                public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body, data2);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration);
                }

                public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
                }

                public void visitField(@NotNull IrField declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration);
                }

                public void visitField(@NotNull IrField declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitField(this, declaration, data2);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
                }

                public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data2);
                }

                public void visitFile(@NotNull IrFile declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration);
                }

                public void visitFile(@NotNull IrFile declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration, data2);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
                }

                public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data2);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
                }

                public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data2);
                }

                public void visitGetClass(@NotNull IrGetClass expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
                }

                public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data2);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
                }

                public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data2);
                }

                public void visitGetField(@NotNull IrGetField expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
                }

                public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data2);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
                }

                public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data2);
                }

                public void visitGetValue(@NotNull IrGetValue expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
                }

                public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data2);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
                }

                public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration);
                }

                public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
                }

                public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
                }

                public void visitLoop(@NotNull IrLoop loop) {
                    Intrinsics.checkParameterIsNotNull(loop, "loop");
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
                }

                public void visitLoop(@NotNull IrLoop loop, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(loop, "loop");
                    IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data2);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
                }

                public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data2);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration);
                }

                public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration, data2);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration);
                }

                public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration, data2);
                }

                public void visitProperty(@NotNull IrProperty declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration);
                }

                public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration, data2);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
                }

                public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data2);
                }

                public void visitReturn(@NotNull IrReturn expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
                }

                public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data2);
                }

                public void visitSetField(@NotNull IrSetField expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
                }

                public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data2);
                }

                public void visitSetVariable(@NotNull IrSetVariable expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
                }

                public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data2);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration, data2);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
                }

                public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data2);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                    Intrinsics.checkParameterIsNotNull(spread, "spread");
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
                }

                public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(spread, "spread");
                    IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data2);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
                }

                public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data2);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body);
                }

                public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(body, "body");
                    IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body, data2);
                }

                public void visitThrow(@NotNull IrThrow expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
                }

                public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data2);
                }

                public void visitTry(@NotNull IrTry aTry) {
                    Intrinsics.checkParameterIsNotNull(aTry, "aTry");
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
                }

                public void visitTry(@NotNull IrTry aTry, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(aTry, "aTry");
                    IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data2);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration);
                }

                public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration, data2);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
                }

                public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data2);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration);
                }

                public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration, data2);
                }

                public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data2);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration);
                }

                public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration, data2);
                }

                public void visitVararg(@NotNull IrVararg expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
                }

                public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data2);
                }

                public void visitVariable(@NotNull IrVariable declaration) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration);
                }

                public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                    IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration, data2);
                }

                public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
                }

                public void visitWhen(@NotNull IrWhen expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
                }

                public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data2);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop) {
                    Intrinsics.checkParameterIsNotNull(loop, "loop");
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
                }

                public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data2) {
                    Intrinsics.checkParameterIsNotNull(loop, "loop");
                    IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data2);
                }
            });
        }

        @NotNull
        public final IrFunction getMemberFunction() {
            return this.memberFunction;
        }

        public LocalFunctionsTransformer(@NotNull IrFunction memberFunction) {
            Intrinsics.checkParameterIsNotNull(memberFunction, "memberFunction");
            this.memberFunction = memberFunction;
            this.localFunctions = new LinkedHashMap();
            this.new2old = new HashMap();
        }

        @NotNull
        public static final /* synthetic */ String access$suggestLocalName(LocalFunctionsTransformer $this, @NotNull DeclarationDescriptor descriptor2) {
            return $this.suggestLocalName(descriptor2);
        }

        @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0016H\u0016J+\u0010\u0017\u001a\u0002H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u0019*\u0002H\u00182\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001cR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalFunctionsLowering$LocalFunctionsTransformer$FunctionBodiesRewriter;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "localFunctionContext", "Lorg/jetbrains/kotlin/backend/common/lower/LocalFunctionsLowering$LocalFunctionContext;", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalFunctionsLowering$LocalFunctionsTransformer;Lorg/jetbrains/kotlin/backend/common/lower/LocalFunctionsLowering$LocalFunctionContext;)V", "getLocalFunctionContext", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalFunctionsLowering$LocalFunctionContext;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "fillArguments", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "calleeContext", "oldExpression", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lorg/jetbrains/kotlin/backend/common/lower/LocalFunctionsLowering$LocalFunctionContext;Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "backend-common"})
        private final class FunctionBodiesRewriter
        extends IrElementTransformerVoid {
            @Nullable
            private final LocalFunctionContext localFunctionContext;

            @Override
            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration) {
                Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                return declaration;
            }

            @Override
            @NotNull
            public IrStatement visitFunction(@NotNull IrFunction declaration) {
                Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                int n = declaration.getStartOffset();
                int n2 = declaration.getEndOffset();
                SimpleType simpleType2 = LocalFunctionsLowering.this.getContext().getBuiltIns().getUnitType();
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.unitType");
                return new IrCompositeImpl(n, n2, simpleType2, null, 8, null);
            }

            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                ParameterDescriptor parameterDescriptor;
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                LocalFunctionContext localFunctionContext = this.localFunctionContext;
                if (localFunctionContext != null) {
                    LocalFunctionContext localFunctionContext2;
                    LocalFunctionContext it = localFunctionContext2 = localFunctionContext;
                    parameterDescriptor = it.getOld2new().get(expression2.getDescriptor());
                } else {
                    parameterDescriptor = null;
                }
                ParameterDescriptor remapped = parameterDescriptor;
                return remapped == null ? expression2 : (IrGetValue)new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), remapped, expression2.getOrigin());
            }

            @Override
            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                FunctionDescriptor oldCallee = expression2.getDescriptor().getOriginal();
                LocalFunctionContext localFunctionContext = LocalFunctionsTransformer.this.getLocalFunctions().get(oldCallee);
                if (localFunctionContext == null) {
                    return expression2;
                }
                LocalFunctionContext localFunctionData = localFunctionContext;
                FunctionDescriptor newCallee = localFunctionData.getTransformedDescriptor();
                return this.fillArguments((IrMemberAccessExpression)LocalFunctionsTransformer.this.createNewCall(expression2, newCallee), localFunctionData, expression2);
            }

            /*
             * WARNING - void declaration
             */
            private final <T extends IrMemberAccessExpression> T fillArguments(@NotNull T $receiver, LocalFunctionContext calleeContext, IrMemberAccessExpression oldExpression) {
                int closureParametersCount = calleeContext.getClosureParametersCount();
                T $receiver$iv = $receiver;
                List<ValueParameterDescriptor> list2 = $receiver$iv.getDescriptor().getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.valueParameters");
                Iterable $receiver$iv$iv = list2;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    IrExpression irExpression;
                    ValueDescriptor capturedValueDescriptor;
                    void index2;
                    void newValueParameterDescriptor;
                    ValueParameterDescriptor it$iv = (ValueParameterDescriptor)element$iv$iv;
                    int n = it$iv.getIndex();
                    int n2 = it$iv.getIndex();
                    Intrinsics.checkExpressionValueIsNotNull(it$iv, "it");
                    int n3 = n2;
                    int n4 = n;
                    T t = $receiver$iv;
                    if (LocalFunctionsTransformer.this.getNew2old().get(newValueParameterDescriptor) == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("Non-mapped parameter " + newValueParameterDescriptor)));
                    }
                    if (index2 >= closureParametersCount) {
                        ValueDescriptor valueDescriptor = capturedValueDescriptor;
                        if (valueDescriptor == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ValueParameterDescriptor");
                        }
                        irExpression = IrMemberAccessExpressionKt.getValueArgument(oldExpression, (ValueParameterDescriptor)valueDescriptor);
                    } else {
                        ParameterDescriptor parameterDescriptor;
                        if (this.localFunctionContext != null) {
                            LocalFunctionContext localFunctionContext;
                            LocalFunctionContext it = localFunctionContext;
                            parameterDescriptor = it.getOld2new().get(capturedValueDescriptor);
                        } else {
                            parameterDescriptor = null;
                        }
                        ParameterDescriptor remappedValueDescriptor = parameterDescriptor;
                        ParameterDescriptor parameterDescriptor2 = remappedValueDescriptor;
                        irExpression = new IrGetValueImpl(oldExpression.getStartOffset(), oldExpression.getEndOffset(), parameterDescriptor2 != null ? (ValueDescriptor)parameterDescriptor2 : capturedValueDescriptor, null, 8, null);
                    }
                    IrExpression irExpression2 = irExpression;
                    t.putValueArgument(n4, irExpression2);
                }
                $receiver.setDispatchReceiver(oldExpression.getDispatchReceiver());
                $receiver.setExtensionReceiver(oldExpression.getExtensionReceiver());
                return $receiver;
            }

            @Override
            @NotNull
            public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                FunctionDescriptor oldCallee = expression2.getDescriptor().getOriginal();
                LocalFunctionContext localFunctionContext = LocalFunctionsTransformer.this.getLocalFunctions().get(oldCallee);
                if (localFunctionContext == null) {
                    return expression2;
                }
                LocalFunctionContext localFunctionData = localFunctionContext;
                FunctionDescriptor newCallee = localFunctionData.getTransformedDescriptor();
                return this.fillArguments((IrMemberAccessExpression)new IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), newCallee, LocalFunctionsTransformer.this.remapTypeArguments(expression2, newCallee), expression2.getOrigin()), localFunctionData, expression2);
            }

            @Override
            @NotNull
            public IrExpression visitReturn(@NotNull IrReturn expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                FunctionDescriptor oldReturnTarget = expression2.getReturnTarget();
                LocalFunctionContext localFunctionContext = LocalFunctionsTransformer.this.getLocalFunctions().get(oldReturnTarget);
                if (localFunctionContext == null) {
                    return expression2;
                }
                LocalFunctionContext localFunctionData = localFunctionContext;
                FunctionDescriptor newReturnTarget = localFunctionData.getTransformedDescriptor();
                return new IrReturnImpl(expression2.getStartOffset(), expression2.getEndOffset(), newReturnTarget, expression2.getValue());
            }

            @Nullable
            public final LocalFunctionContext getLocalFunctionContext() {
                return this.localFunctionContext;
            }

            public FunctionBodiesRewriter(@Nullable LocalFunctionContext localFunctionContext) {
                this.localFunctionContext = localFunctionContext;
            }
        }
    }
}

