/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.CallableReferenceUtilKt;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.DelegatingResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class FunctionReferenceGenerationStrategy
extends FunctionGenerationStrategy.CodegenBased {
    private final ResolvedCall<?> resolvedCall;
    private final FunctionDescriptor referencedFunction;
    private final FunctionDescriptor functionDescriptor;
    private final Type receiverType;
    private final StackValue receiverValue;
    private final boolean isInliningStrategy;

    public FunctionReferenceGenerationStrategy(@NotNull GenerationState state2, @NotNull FunctionDescriptor functionDescriptor, @NotNull ResolvedCall<?> resolvedCall2, @Nullable Type receiverType, @Nullable StackValue receiverValue, boolean isInliningStrategy) {
        super(state2);
        this.resolvedCall = resolvedCall2;
        this.referencedFunction = (FunctionDescriptor)resolvedCall2.getResultingDescriptor();
        this.functionDescriptor = functionDescriptor;
        this.receiverType = receiverType;
        this.receiverValue = receiverValue;
        this.isInliningStrategy = isInliningStrategy;
        assert (receiverType != null || receiverValue == null) : "A receiver value is provided for unbound function reference. Either this is a bound reference and you forgot to pass receiverType, or you accidentally passed some receiverValue for a reference without receiver";
    }

    @Override
    public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
        StackValue result2;
        int receivers = CallableReferenceUtilKt.computeExpectedNumberOfReceivers(this.referencedFunction, this.receiverType != null);
        KtCallExpression fakeExpression = CodegenUtil.constructFakeFunctionCall(this.state.getProject(), this.functionDescriptor.getValueParameters().size() - receivers);
        final List<KtValueArgument> fakeArguments = fakeExpression.getValueArguments();
        final ReceiverValue dispatchReceiver = this.computeAndSaveReceiver(signature2, codegen, this.referencedFunction.getDispatchReceiverParameter());
        final ReceiverValue extensionReceiver = this.computeAndSaveReceiver(signature2, codegen, this.referencedFunction.getExtensionReceiverParameter());
        this.computeAndSaveArguments(fakeArguments, codegen, receivers);
        DelegatingResolvedCall<CallableDescriptor> fakeResolvedCall2 = new DelegatingResolvedCall<CallableDescriptor>(this.resolvedCall){
            private final Map<ValueParameterDescriptor, ResolvedValueArgument> argumentMap;
            {
                super(arg0);
                this.argumentMap = new LinkedHashMap<ValueParameterDescriptor, ResolvedValueArgument>();
                int index2 = 0;
                List<ValueParameterDescriptor> parameters2 = FunctionReferenceGenerationStrategy.this.referencedFunction.getValueParameters();
                for (ValueArgument argument : fakeArguments) {
                    this.argumentMap.put(parameters2.get(index2), new ExpressionValueArgument(argument));
                    ++index2;
                }
            }

            @Override
            @Nullable
            public ReceiverValue getExtensionReceiver() {
                return extensionReceiver;
            }

            @Override
            @Nullable
            public ReceiverValue getDispatchReceiver() {
                return dispatchReceiver;
            }

            @Override
            @NotNull
            public List<ResolvedValueArgument> getValueArgumentsByIndex() {
                return new ArrayList<ResolvedValueArgument>(this.argumentMap.values());
            }

            @Override
            @NotNull
            public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
                return this.argumentMap;
            }
        };
        Type returnType = codegen.getReturnType();
        if (this.referencedFunction instanceof ConstructorDescriptor) {
            result2 = returnType.getSort() == 9 ? codegen.generateNewArray(fakeExpression, this.referencedFunction.getReturnType(), fakeResolvedCall2) : codegen.generateConstructorCall(fakeResolvedCall2, returnType);
        } else {
            Call call2 = CallMaker.makeCall(fakeExpression, null, null, fakeExpression, fakeArguments);
            result2 = codegen.invokeFunction(call2, fakeResolvedCall2, StackValue.none());
        }
        InstructionAdapter v = codegen.v;
        result2.put(returnType, v);
        v.areturn(returnType);
    }

    private void computeAndSaveArguments(@NotNull List<? extends ValueArgument> fakeArguments, @NotNull ExpressionCodegen codegen, int receivers) {
        List<ValueParameterDescriptor> valueParameters = CollectionsKt.drop(this.functionDescriptor.getValueParameters(), receivers);
        assert (valueParameters.size() == fakeArguments.size()) : this.functionDescriptor + ": " + valueParameters.size() + " != " + fakeArguments.size();
        for (int i = 0; i < valueParameters.size(); ++i) {
            ValueParameterDescriptor parameter = valueParameters.get(i);
            ValueArgument fakeArgument = fakeArguments.get(i);
            Type type2 = this.state.getTypeMapper().mapType(parameter);
            int localIndex = codegen.myFrameMap.getIndex(parameter);
            codegen.tempVariables.put(fakeArgument.getArgumentExpression(), StackValue.local(localIndex, type2));
        }
    }

    @Nullable
    private ReceiverValue computeAndSaveReceiver(@NotNull JvmMethodSignature signature2, @NotNull ExpressionCodegen codegen, @Nullable ReceiverParameterDescriptor receiver) {
        if (receiver == null) {
            return null;
        }
        KtExpression receiverExpression = KtPsiFactoryKt.KtPsiFactory(this.state.getProject(), false).createExpression("callableReferenceFakeReceiver");
        codegen.tempVariables.put(receiverExpression, this.receiverParameterStackValue(signature2, codegen));
        return ExpressionReceiver.Companion.create(receiverExpression, receiver.getType(), BindingContext.EMPTY);
    }

    @NotNull
    private StackValue receiverParameterStackValue(@NotNull JvmMethodSignature signature2, @NotNull ExpressionCodegen codegen) {
        if (this.receiverValue != null) {
            return this.receiverValue;
        }
        if (this.receiverType != null) {
            ClassDescriptor classDescriptor = (ClassDescriptor)codegen.getContext().getParentContext().getContextDescriptor();
            Type asmType = codegen.getState().getTypeMapper().mapClass(classDescriptor);
            return CallableReferenceUtilKt.capturedBoundReferenceReceiver(asmType, this.receiverType, this.isInliningStrategy);
        }
        return StackValue.local(1, signature2.getAsmMethod().getArgumentTypes()[0]);
    }
}

