/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.FieldRemapper;
import org.jetbrains.kotlin.codegen.inline.LocalVarRemapper;
import org.jetbrains.kotlin.codegen.inline.MethodBodyVisitor;
import org.jetbrains.kotlin.codegen.inline.RegeneratedLambdaFieldRemapper;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;

public class RemapVisitor
extends MethodBodyVisitor {
    private final LocalVarRemapper remapper;
    private final FieldRemapper nodeRemapper;
    private final InstructionAdapter instructionAdapter;

    public RemapVisitor(@NotNull MethodVisitor mv, @NotNull LocalVarRemapper remapper2, @NotNull FieldRemapper nodeRemapper, boolean copyAnnotationsAndAttributes) {
        super(mv, copyAnnotationsAndAttributes);
        this.instructionAdapter = new InstructionAdapter(mv);
        this.remapper = remapper2;
        this.nodeRemapper = nodeRemapper;
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.remapper.visitIincInsn(var, increment, this.mv);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.remapper.visitVarInsn(opcode, var, this.instructionAdapter);
    }

    @Override
    public void visitLocalVariable(@NotNull String name2, @NotNull String desc, String signature2, @NotNull Label start, @NotNull Label end, int index2) {
        this.remapper.visitLocalVariable(name2, desc, signature2, start, end, index2, this.mv);
    }

    @Override
    public void visitFieldInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String desc) {
        if (name2.startsWith("$$$") && (this.nodeRemapper instanceof RegeneratedLambdaFieldRemapper || this.nodeRemapper.isRoot())) {
            FieldInsnNode fin = new FieldInsnNode(opcode, owner, name2, desc);
            StackValue inline = this.nodeRemapper.getFieldForInline(fin, null);
            assert (inline != null) : "Captured field should have not null stackValue " + fin;
            if (179 == opcode) {
                inline.store(StackValue.onStack(inline.type), this);
            } else {
                inline.put(inline.type, this);
            }
            return;
        }
        super.visitFieldInsn(opcode, owner, name2, desc);
    }
}

